
Initial setup

  $ . $TESTDIR/_exc-util.sh

=== C.1 Multiple pruned changeset atop each other ===
.. 
.. {{{
..   ⊗ B
..   |
..   ⊗ A
..   |
..   ● O
.. }}}
.. 
.. Marker exist from:
.. 
..  * A (prune)
..  * B (prune)
.. 
.. Command run:
.. 
..  * hg push -r O
..  * hg push
.. 
.. Expected exchange:
.. 
..  * A (prune)
..  * B (prune)

  $ setuprepos C.1
  creating test repo for test case C.1
  - pulldest
  - main
  - pushdest
  cd into `main` and proceed with env setup
  $ cd main
  $ mkcommit A
  $ mkcommit B
  $ hg prune -qd '0 0' .^::.
  $ hg log -G --hidden
  x  f6fbb35d8ac9 (draft): B
  |
  x  f5bc6836db60 (draft): A
  |
  @  a9bdc8b26820 (public): O
  
  $ hg debugobsolete
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  $ cd ..
  $ cd ..

  $ cp -r C.1 C.1.a
  $ cp -r C.1 C.1.b

Actual Test (explicit push)
---------------------------

  $ dotest C.1.a O
  ## Running testcase C.1.a
  # testing echange of "O" (a9bdc8b26820)
  ## initial state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing "O" from main to pushdest
  pushing to pushdest
  searching for changes
  no changes found
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 1 nodes
  OBSEXC: pushing 2 obsolescence markers (177 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  ## pulling "a9bdc8b26820" from main into pulldest
  pulling from main
  no changes found
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (177 bytes)
  OBSEXC: 2 obsolescence markers added
  OBSEXC: DONE
  ## post pull state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}

Actual Test (bare push)
-------------------------------------

  $ dotest C.1.b
  ## Running testcase C.1.b
  ## initial state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing from main to pushdest
  pushing to pushdest
  searching for changes
  no changes found
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 1 nodes
  OBSEXC: pushing 2 obsolescence markers (177 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  ## pulling from main into pulldest
  pulling from main
  searching for changes
  no changes found
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (177 bytes)
  OBSEXC: 2 obsolescence markers added
  OBSEXC: DONE
  ## post pull state
  # obstore: main
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  f5bc6836db60e308a17ba08bf050154ba9c4fad7 0 {'date': '0 0', 'p1': 'a9bdc8b26820b1b87d585b82eb0ceb4a2ecdbc04', 'user': 'test'}
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
