GWpy is a collaboration-driven Python package providing tools for
studying data from ground-based gravitational-wave detectors.

GWpy provides a user-friendly, intuitive interface to the common
time-domain and frequency-domain data produced by the LIGO and Virgo
observatories and their analyses, with easy-to-follow tutorials at each
step.

<https://gwpy.github.io>

# Release status

[![PyPI version](https://badge.fury.io/py/gwpy.svg)](http://badge.fury.io/py/gwpy)
[![Conda version](https://img.shields.io/conda/vn/conda-forge/gwpy.svg)](https://anaconda.org/conda-forge/gwpy/)

[![DOI](https://zenodo.org/badge/9979119.svg)](https://zenodo.org/badge/latestdoi/9979119)
[![License](https://img.shields.io/pypi/l/gwpy.svg)](https://choosealicense.com/licenses/gpl-3.0/)
![Supported Python versions](https://img.shields.io/pypi/pyversions/gwpy.svg)

# Development status

[![Build status](https://github.com/gwpy/gwpy/actions/workflows/build.yml/badge.svg?branch=master)](https://github.com/gwpy/gwpy/actions/workflows/build.yml)
[![Coverage status](https://codecov.io/gh/gwpy/gwpy/branch/master/graph/badge.svg)](https://codecov.io/gh/gwpy/gwpy)
[![Maintainability](https://api.codeclimate.com/v1/badges/2cf14445b3e070133745/maintainability)](https://codeclimate.com/github/gwpy/gwpy/maintainability)

# Installation

To install, you can do:

```
conda install -c conda-forge gwpy
```

or

```
python -m pip install gwpy
```

You can test your installation, and its version by

```
python -c "import gwpy; print(gwpy.__version__)"
```

# License

GWpy is released under the GNU General Public License v3.0 or later, see [here](https://choosealicense.com/licenses/gpl-3.0/) for a description of this license, or see the [LICENSE](https://github.com/gwpy/gwpy/blob/master/LICENSE) file for the full text.
