from __future__ import print_function

import pygsl
import pygsl.errortest
import pygsl.errors as errors
import unittest

error_safe_state = pygsl.errors.error_safe_state



active = pygsl.errortest.set_gsl_error_handler_val


class _ErrorSaveTest(unittest.TestCase):
    _active = None
    def _reset(self):
        error_safe_state.reset()

    def setUp(self):
        assert(self._active != None)
        pygsl.errortest.select_error_handler(self._active)
        self._reset()

    def tearDown(self):
        self._reset()
        
    def testInstalledErrorHandler(self):
        "Is the one installed the active one?"
        val = pygsl.errortest.check_installed_error_handler()
        self.assertEqual(val, self._active)

    def testGet(self):
        error_safe_state = errors.error_safe_state
        
        errno = errors.errno.GSL_EFAILED
        pygsl.errortest.trigger_save_test(errno)        
        t_dict = error_safe_state.get()

        self.assertTrue(t_dict["errno"])
        self.assertTrue(t_dict["reason"])
        self.assertTrue(t_dict["file"])
        self.assertTrue(t_dict["line"])
        
        test = t_dict["errno"]
        self.assertEqual(test, errno)

        test = t_dict["reason"]
        self.assertEqual(test, "Triggered safe test!")

    def testExceptionPyGSL1(self):
        errno = errors.errno.GSL_EFAILED
        self.assertRaises(errors.gsl_GenericError, pygsl.errortest.trigger, errno)


    def _verifyRaisesException(self, t_exception, func, args, ):
        """
        similar to assertRaises but returns the exception
        """
        
        test = -1
        exc_save = None
        
        try:
            func(*args)
            test = 1
        except t_exception as exc:
            test = 0
            exc_save = exc
            
        #exception must have been raised
        self.assertEqual(test, 0, "Exception was not raised")
        self.assertIsNotNone(exc_save)

        return exc_save

    def _extractExceptionText(self, exc):
        text = exc.args[0]
        t_class, t_desc = text.split(':')
        t_class = t_class.strip()
        t_desc = t_desc.strip()
        return t_class, t_desc
        
    def testExceptionPyGSL2(self):
        errno = errors.errno.GSL_EFAILED
        exc = self._verifyRaisesException(errors.gsl_GenericError, pygsl.errortest.trigger_gsl, (errno,))

        assert(exc.errno == errno)

        t_class, t_desc = self._extractExceptionText(exc)
        self._testErrorString(t_desc)
            

    def testExceptionGSL1(self):
        # Only if GSL callback is active?
        errno = errors.errno.GSL_EFAILED
        self.assertRaises(errors.gsl_GenericError, pygsl.errortest.trigger_gsl, errno)

class ErrorTestOff(_ErrorSaveTest):
    _active = 0
    def _testErrorString(self, desc):
        self.assertEqual(desc, "Unknown Reason. It was not set by GSL")
        
class ErrorTestSave(_ErrorSaveTest):
    _active = 1
    def _testErrorString(self, desc):
        self.assertEqual(desc, "Just a test to see what gsl is doing!")
    
del _ErrorSaveTest        

if __name__ == '__main__':
    unittest.main()
