#include "Python.h"
#include <pygsl/error_helpers.h>
#include "math.h"
#include "numpy/ndarraytypes.h"
#include "numpy/ufuncobject.h"
#include "numpy/npy_3kcompat.h"

#if 0
static void
double_add(char *args, npy_intp *dimensions, npy_intp *steps,
   void *extra)
{
    npy_intp i;
    npy_intp is1 = steps[0], is2 = steps[1];
    npy_intp os = steps[2], n = dimensions[0];
    char *i1 = args[0], *i2 = args[1], *op = args[2];
    for (i = 0; i < n; i++) {
        *((double *)op) = *((double *)i1) +
                          *((double *)i2);
        i1 += is1;
        i2 += is2;
        op += os;
     }
}
#endif

/*
 * add_triplet.c
 * This is the C code for creating your own
 * Numpy ufunc for a structured array dtype.
 *
 * Details explaining the Python-C API can be found under
 * 'Extending and Embedding' and 'Python/C API' at
 * docs.python.org .
 */

static PyMethodDef StructUfuncTestMethods[] = {
    {NULL, NULL, 0, NULL}
};

/* The loop definition must precede the PyMODINIT_FUNC. */

static void add_uint64_triplet(char **args, npy_intp *dimensions,
                            npy_intp* steps, void* data)
{
    npy_intp i;
    npy_intp is1=steps[0];
    npy_intp is2=steps[1];
    npy_intp os=steps[2];
    npy_intp n=dimensions[0];
    uint64_t *x, *y, *z;

    char *i1=args[0];
    char *i2=args[1];
    char *op=args[2];

    for (i = 0; i < n; i++) {

        x = (uint64_t*)i1;
        y = (uint64_t*)i2;
        z = (uint64_t*)op;

        z[0] = x[0] + y[0];
        z[1] = x[1] + y[1];
        z[2] = x[2] + y[2];

        i1 += is1;
        i2 += is2;
        op += os;
    }
}

static void add_int64_triplet(char **args, npy_intp *dimensions,
                            npy_intp* steps, void* data)
{
    npy_intp i;
    npy_intp is1=steps[0];
    npy_intp is2=steps[1];
    npy_intp os=steps[2];
    npy_intp n=dimensions[0];
    
int64_t *x, *y, *z;

    char *i1=args[0];
    char *i2=args[1];
    char *op=args[2];

    for (i = 0; i < n; i++) {

        x = (int64_t*)i1;
        y = (int64_t*)i2;
        z = (int64_t*)op;

        z[0] = x[0] + y[0];
        z[1] = x[1] + y[1];
        z[2] = x[2] + y[2];

        i1 += is1;
        i2 += is2;
        op += os;
    }
}

static void add_double_triplet(char **args, npy_intp *dimensions,
                            npy_intp* steps, void* data)
{
    npy_intp i;
    npy_intp is1=steps[0];
    npy_intp is2=steps[1];
    npy_intp os=steps[2];
    npy_intp n=dimensions[0];
    double *x, *y, *z;

    char *i1=args[0];
    char *i2=args[1];
    char *op=args[2];

    for (i = 0; i < n; i++) {

        x = (double*)i1;
        y = (double*)i2;
        z = (double*)op;

	DEBUG_MESS(2, "x[0] = %e y[0] = %e", x[0], y[0]);
        z[0] = x[0] + y[0];
        z[1] = x[1] + y[1];
        z[2] = x[2] + y[2];

        i1 += is1;
        i2 += is2;
        op += os;
    }
}

/* This a pointer to the above function */
//PyUFuncGenericFunction funcs[1] = {&add_uint64_triplet};
PyUFuncGenericFunction funcs[2] = {&add_uint64_triplet, &add_double_triplet};

/* These are the input and return dtypes of add_uint64_triplet. */
//static char types[3] = {NPY_UINT64, NPY_UINT64, NPY_UINT64};
//static char types[3] = {NPY_INT64, NPY_INT64, NPY_INT64};
//static char types[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};

//static void *data[1] = {NULL};

#if defined(NPY_PY3K)
static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "struct_ufunc_test",
    NULL,
    -1,
    StructUfuncTestMethods,
    NULL,
    NULL,
     NULL,
    NULL
};
#endif

static PyArray_Descr *dtypes1[3] = {NULL, NULL, NULL};
static PyArray_Descr *dtypes2[3] = {NULL, NULL, NULL};
static PyObject *dtype_dict1 = NULL;
static PyObject *dtype_dict2 = NULL;
static const char type_str1[] = "d";
static const char type_str2[] = "u8";

#if defined(NPY_PY3K)
PyMODINIT_FUNC PyInit_sftest(void)
#else
PyMODINIT_FUNC initsftest(void)
#endif
{
    PyObject *m = NULL, *add_triplet1 = NULL, *add_triplet2 = NULL, *d = NULL;
    PyArray_Descr *dtype1 = NULL, *dtype2 = NULL;
    int 
flag;



#if defined(NPY_PY3K)
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule("pygsl.testing.sftest", StructUfuncTestMethods);
#endif

    if (m == NULL) {
#if defined(NPY_PY3K)
        return NULL;
#else
        return;
#endif
    }

    import_array();
    import_umath();
    init_pygsl();
    /* Create a new ufunc object */
    add_triplet1 = PyUFunc_FromFuncAndData(NULL, NULL, NULL, 0, 2, 1, PyUFunc_None, "add_triplet1", "add_triplet_docstring", 0);
    
    
    add_triplet2 = PyUFunc_FromFuncAndData(NULL, NULL, NULL, 0, 2, 1, PyUFunc_None, "add_triplet2", "add_triplet_docstring", 0);
    /* 
    dtype_dict = Py_BuildValue("[(s, s), (s, s), (s, s)]",
        "f0", "u8", "f1", "u8", "f2", "u8");
    dtype_dict = Py_BuildValue("[(s, s), (s, s), (s, s)]",
        "f0", "i8", "f1", "i8", "f2", "i8");
    */

  
    DEBUG_MESS(2, "type_str1 '%s'", type_str1);   
    dtype_dict1 = Py_BuildValue("[(s, s), (s, s), (s, s)]",
			       "x", type_str1, "y", type_str1, "z", type_str1);
    DEBUG_MESS(2, "type_str2 '%s'", type_str2);   
    dtype_dict2 = Py_BuildValue("[(s, s), (s, s), (s, s)]",
			       "x", type_str2, "y", type_str2, "z", type_str2);

    PyArray_DescrConverter(dtype_dict1, &dtype1);
    DEBUG_MESS(2, "dtype_dict = %p", (void *) dtype_dict1);
    Py_DECREF(dtype_dict1);

    PyArray_DescrConverter(dtype_dict2, &dtype2);
    DEBUG_MESS(2, "dtype_dict2 = %p",(void *) dtype_dict2);
    Py_DECREF(dtype_dict2);

    dtypes1[0] = dtype1;
    dtypes1[1] = dtype1;
    dtypes1[2] = dtype1;

    dtypes2[0] = dtype2;
    dtypes2[1] = dtype2;
    dtypes2[2] = dtype2;

    d = PyModule_GetDict(m);

    /* Register ufunc for structured dtype */
    flag = PyUFunc_RegisterLoopForDescr(add_triplet1, dtype1, add_double_triplet, dtypes1, NULL);
    DEBUG_MESS(2, "flag = %d", flag);

    flag = PyUFunc_RegisterLoopForDescr(add_triplet2, dtype2, add_uint64_triplet, dtypes2, NULL);
    DEBUG_MESS(2, "flag = %d", flag);
    	    
    PyDict_SetItemString(d, "add_triplet1", add_triplet1);
    Py_DECREF(add_triplet1);

    PyDict_SetItemString(d, "add_triplet2", add_triplet2);
    Py_DECREF(add_triplet2);

#if defined(NPY_PY3K)
    return m;
#endif
}
