"""utilities for interactive testing and running unit tests"""
from __future__ import generators
import sys
try:
	import readline
except:
	pass
	
def commands(prompt_text='query> '):
	"""Prompt for console commands."""
	print
	print "ready"
	print
	while True:
		try:
			q = raw_input(prompt_text).strip()
			if q:
				yield q
		except KeyboardInterrupt:
			print "...interrupted"
			break
		except EOFError:
			print
			break


def prompt(pop, env):
	"""Prompt for GraphPath expressions and execute them
	against the given population in the given environment."""
	for q in commands():
		try:
			for x in pop >> eval( q, env ):
				print x
		except Exception, e:
			print e


coverage = {}

def line_trace(frame, event, arg):
	name, line = frame.f_code.co_filename, frame.f_lineno
	try:
		coverage[name][line] = 1
	except KeyError:
		coverage[name] = { line : 1 }
	return line_trace

def main_trace(frame, event, arg):
	if event == 'call':
		return line_trace
	else:
		return None

def trace(func, *args, **kwargs):
	sys.settrace( main_trace )
	try:
		func(*args, **kwargs)
	finally:
		sys.settrace( None )

def iter_coverage():
	names = coverage.keys()
	names.sort()
	for name in names:
		lines = coverage[name].keys()
		lines.sort()
		yield (name, iter(lines))

def print_coverage():
	for name, lines in iter_coverage():
		print name
		for line in lines:
			print "    ", line

def write_covered():
	for name, lines in iter_coverage():
		try:
			source = file( name )
			current = 0
			try:
				output = file( name + ".coverage", "w" )
				try:
					for line in lines:
						while current < line:
							text = source.readline()
							current += 1
						output.write(text)
				finally:
					output.close()
			finally:
				source.close()
		except IOError, ex:
			print ex


def write_coverage():
	for name, lines in iter_coverage():
		try:
			source = file( name )
			try:
				text = source.readline()
				current = 1
				output = file( name + ".coverage", "w" )
				try:
					try:
						line = lines.next()
						while text:
							if current < line:
								output.write("##"+text)
								text = source.readline()
								current += 1
							else:
								assert current == line
								output.write("  "+text)
								text = source.readline()
								current += 1
								line = lines.next()
					except StopIteration:
						while text:
							output.write("##"+text)
							text = source.readline()
							current += 1
				finally:
					output.close()
			finally:
				source.close()
		except IOError, ex:
			print ex, name





def run(tests):
	"""Execute every callable in the tests dictionary whose key starts with
	'test' in alphanumeric order.
	"""
	names=[	item for item in tests.keys()
			if item.startswith("test")
				and callable( tests.get(item) )]
	names.sort()
	passes = failures = 0
	for name in names:
		test = tests.get(name)
		try:
			trace(test)
		except AssertionError:
			print name, "failed"
			failures += 1
		else:
			passes += 1
	print "%d/%d tests passed" % (passes, passes+failures)
