"""test data and unit tests for graphpath. run these via test.py.
"""
from graphpath.util.anyrdf import Population, Namespace, resource, uriref
from graphpath.util.testrunner import run
from graphpath.expr import *
from graphpath.entail import Sandbox, RuleBase

ex = Namespace("#")
samples = Population()
rules = RuleBase()

def add(set, prop, *values):
	for member in set:
		for value in values:
			samples.add(member, prop, value)

girls = Set([ex.pauline, ex.annette, ex.lisa, ex.julie, ex.nalda, ex.lillian, ex.rene])
boys  = Set([ex.arnold, ex.john, ex.jack, ex.george])
child_of_nalda_john=Set([ex.arnold,ex.pauline, ex.annette, ex.lisa, ex.julie])
child_of_lil_geo=Set([ex.nalda])
child_of_rene_jack=Set([ex.john])
nalda_john=Set([ex.john, ex.nalda])
grandparents=Set([ex.rene,ex.jack,ex.lillian,ex.george])
add(girls, samples.rdf_type, ex.Female)
add(boys, samples.rdf_type, ex.Male)
add(child_of_nalda_john, ex.parent, *nalda_john)
add(child_of_lil_geo, ex.parent, ex.lillian, ex.george)
add(child_of_rene_jack, ex.parent, ex.rene, ex.jack)
for person in girls|boys:
	samples.add(person, ex.name, uriref(person)[1:])
	samples.add(person, ex.initial, uriref(person)[1])
samples.add(ex.bindi, samples.rdf_type, ex.Dog)
samples.add(ex.annette, ex.pet, ex.bindi)
relation = Set([(uriref(person)[1],uriref(person)[1:]) for person in child_of_nalda_john])

rules[Class(ex.Person)] = Class(ex.Male)|Class(ex.Female)
rules[Property(ex.child)] = ~Property( ex.parent )
rules[Property(ex.hasMother)] = Property( ex.parent )[Class(ex.Female)]
rules[Property(ex.descendant)] = Property( ex.child )| \
					Property( ex.descendant )/Property( ex.descendant )
rules[Property(ex.family)] = Self()|Property( ex.child )/Property( ex.family )| \
					Property( ex.parent )/Property( ex.family )
def test01():
	assert Set(samples >> Class(ex.Female)) == girls

def test02():
	assert Set(samples >> Node(ex.julie)/Property(ex.parent)) == nalda_john

def test03():
	assert Set(samples >> Node(ex.nalda)/~Property(ex.parent)) == child_of_nalda_john

def test04():
	assert Set(samples >> Node(ex.nalda)/(~Property(ex.parent))[Class(ex.Male)]) == Set([ex.arnold])

def test05():
	assert Set(samples >> (Node(ex.nalda)/~Property(ex.parent)&Class(ex.Male))) == Set([ex.arnold])

def test06():
	assert Set(samples >> Nodes(boys)[Property(ex.parent)]) == Set([ex.arnold,ex.john])

def test07():
	assert Set(samples >> Class(ex.Female)[Property(ex.parent)/Node(ex.john)]) == girls&child_of_nalda_john

def test08():
	assert Set(samples >> Node(ex.pauline)//Property(ex.parent)) == nalda_john|grandparents

def test09():
	assert Set(samples >> (Node(ex.lillian)//~Property(ex.parent))[Class(ex.Male)]) == Set([ex.arnold])

def test10():
	assert samples << (Node(ex.nalda)/~Property(ex.parent)&Class(ex.Male)) == ex.arnold

def test11():
	assert Set(samples >> Node(ex.nalda)/~Property(ex.parent)/Property(ex.none)) == Set()

def test12():
	assert Set(samples >> Node(ex.nalda)/~Property(ex.parent) % Property(ex.none)) == Set([None])

def test13():
	assert Set(samples >> Node(ex.nalda)/~Property(ex.parent) % Property(ex.initial)) == Set('ajlp')

def test14():
	assert Set(samples >> Node(ex.nalda)/~Property(ex.parent) % (Property(ex.initial), Property(ex.name))) == relation

def test15():
	assert Set(samples >> (Class(ex.Male)|Class(ex.Female))[
		Property(ex.initial)/Node('a')
		|Property(ex.initial)/Node('j')&Property(ex.parent)/Node(ex.jack)]) == Set([
			ex.annette, ex.arnold, ex.john ])

def test16():
	assert Set(samples >> (Class(ex.Male)|Class(ex.Female))[
		Property(ex.initial)/Node('a')
		|Property(ex.initial)/Node('j')&Self()//Property(ex.parent)/Node(ex.jack)]) == Set([
			ex.annette, ex.arnold, ex.john, ex.julie ])

def test17():
	assert Set(samples >> Class(ex.Male)[HasNo( Property( ex.parent )) & Property(ex.initial)/Node('j') ]) == Set([ex.jack])

def test18():
	assert Set(Sandbox( samples, rules )>>Class( ex.Person )) == girls|boys

def test19():
	assert Set(Sandbox( samples, rules )>>Node( ex.john )/Property( ex.child )) ==\
		child_of_nalda_john

def test20():
	assert Set(Sandbox( samples, rules )>>Node( ex.john )/Property( ex.hasMother )) ==\
		Set([ex.rene])

def test21():
	assert Set(Sandbox( samples, rules )>>Node( ex.jack )/Property( ex.descendant )) ==\
		child_of_nalda_john | Set([ex.john])

def test22():
	assert Set(Sandbox( samples, rules )>>Node( ex.john )/Property( ex.family )) ==\
		girls | boys

def test23():
	assert Set(Sandbox(samples,rules) >> Node(ex.jack)/Property(ex.child)/Property(ex.child)[Property(ex.initial)/Nodes('lj')]) ==\
		Set([ex.lisa,ex.julie])

def test24():
	assert Set(Map(Sandbox(samples,rules) >> Subject()/Property(ex.hasMother)/Subject())) ==\
		child_of_nalda_john|nalda_john

def test25():
	assert Map(Sandbox(samples,rules) >> Subject()/Property(ex.hasMother)/Subject())[ex.john] ==\
		Set([ex.rene])

if __name__ == "__main__":
	run(globals())

