"""adapt redland RDF API for use in expressions and inference.

essential methods for expressions are Population.match and Population.values.
some extra features are adapted for completeness
"""

from __future__ import generators
#import sys
#sys.path.append("/home/projects/redland-0.9.15/python/build/lib.linux-i686-2.2")

import RDF
from graphpath.expr import adapters, StrategyError
from util.anysets import Set, ImmutableSet
from cPickle import loads, dumps

empty_set = ImmutableSet()
rdf_type = RDF.Node(uri_string="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")

def node(maybe_value):
	if isinstance(maybe_value, RDF.Node):
		return maybe_value
	else:
		return RDF.Node( literal=str(maybe_value) )

def value(maybe_literal):
	assert isinstance(maybe_literal, RDF.Node)
	if maybe_literal.is_literal():
		return str(maybe_literal)
	else:
		return maybe_literal

class Population:
	def __init__(self, model):
		if not isinstance( model, RDF.Model ):
			raise StrategyError
		self.rdf_type = rdf_type
		self._model = model

        def match( self, prop, value ):
		if isinstance(prop, RDF.Node):
			return Set( self._model.sources(prop, node(value)))
		else:
			return empty_set

        def values( self, subj, prop):
		def items():
			for node in self._model.targets(subj, prop):
				yield value(node)

		if isinstance(subj, RDF.Node) and isinstance(prop, RDF.Node):
			return Set(items())
		else:
			return empty_set

	def add( self, subj, prop, value):
		assert isinstance(subj, RDF.Node)
		assert isinstance(prop, RDF.Node)
		self._model.append( RDF.Statement(subj, prop, node(value)))

	def update( self, other ):
		if isinstance(other, Population):
			self._model.add_statements(other._model.as_stream() )
		else:
			for subj in other:
				for prop, value in other[subj]:
					self.add(subj, prop, value)

	def __contains__(self, subj):
		if isinstance(subj, RDF.Node):
			for s in self._model.find_statements(RDF.Statement(subj, None, None)):
				return True
		return False

	def __iter__(self):
		def items():
			for s in self._model:
				yield s.subject
		return iter(Set(items()))

	def __getitem__(self, subj):
		def items():
			for s in self._model.find_statements(RDF.Statement(subj, None, None)):
				yield s.predicate, value(s.object)

		if isinstance(subj, RDF.Node):
			return Set(items())
		else:
			return empty_set

	def __eq__(self, other):
		return self.__class__ == other.__class__ and \
			self._model == other._model

	def __repr__(self):
		return "Population(%r)" % self._model
	__str__=__repr__

# register me
adapters.append( Population )
