// graph-tool -- a general graph modification and manipulation thingy
//
// Copyright (C) 2006-2021 Tiago de Paula Peixoto <tiago@skewed.de>
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <boost/python.hpp>

using namespace boost;

void export_betweenness();
void export_closeness();
void export_eigentrust();
void export_eigenvector();
void export_hits();
void export_katz();
void export_trust_transitivity();
void export_pagerank();

BOOST_PYTHON_MODULE(libgraph_tool_centrality)
{
    python::docstring_options dopt(true, false);
    export_betweenness();
    export_closeness();
    export_eigentrust();
    export_eigenvector();
    export_hits();
    export_katz();
    export_trust_transitivity();
    export_pagerank();
}
