# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
# sys.path.insert(0, os.path.abspath('.'))
sys.path.append(os.path.abspath("./_ext"))
import gmic
from pathlib import Path



# -- Project information -----------------------------------------------------

project = 'gmic-py'
copyright = '2020, Jonathan-David Schröder'
author = 'Jonathan-David Schröder'

# The full version, including alpha/beta/rc tags
release = Path('../VERSION').read_text()
print(release)
input()
master_doc = 'index' # Per https://stackoverflow.com/a/56448499/420684


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx_rtd_theme', 'recommonmark', 'gmic_sphinx', 'sphinx.ext.autodoc', 'sphinx.ext.napoleon', 'pyquickhelper.sphinxext.sphinx_autosignature', 'sphinx.ext.autosectionlabel', 'sphinx_execute_code']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
#html_theme = 'alabaster'
html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_css_files = [
    'css/custom.css',
]

html_logo = "_static/images/gmicky_outercolor_small.png"
