import graph


class Sieve( graph.Graph ):
    def __init__( self ):
        graph.Graph.__init__( self )
        return

    def _one_level( self , chain , neighbor_grabber ):
        cur = set()
        for u in chain:
            for v in neighbor_grabber( u ):
                cur.add( v )
        return iter( cur )

    def _recursive( self , chain , neighbor_grabber ):
        cur = set()
        S = set()
        for u in chain:
            S.add( u )

        while S:
            u = S.pop()
            cur.add( u )
            for v in neighbor_grabber( u ):
                S.add( v )

        return cur


    def cone( self , chain ):
        return self._one_level( chain , \
                                lambda u: [ e.source for e in u.getInEdges() ] )
    def support( self , chain ):
        return self._one_level( chain , \
                                lambda u: [ e.target for e in u.getOutEdges() ] )

    def closure( self , chain ):
        return self._recursive( chain , \
                                lambda u: [ e.source for e in u.getInEdges() ] )

    def star( self , chain ):
        return self._recursive( chain , \
                                lambda u: [ e.target for e in u.getOutEdges() ] )

    

