#!/usr/bin/env python

# -----------------------------------------------------------------------------
# exprparse.py
#
# Simple parser for PDE Expressions
# -----------------------------------------------------------------------------
import user
import importer

import yacc
import exprlex
import sys

# Get the token map
tokens = exprlex.tokens

# Parsing rules
precedence = (
    ('left','PLUS','MINUS'),
    ('left','TIMES','DIVIDE'),
    ('left','CARET'),
    ('left','PERIOD'),
    ('right','UMINUS')
    )

class Exp(object):
  def getGraph(self):
    if not hasattr(self, '_graph') or self._graph is None:
      from graph import Graph

      self._graph = Graph()
      self._graph.setEdgeType('expression.Edge')
    return self._graph

  def setGraph(self, graph):
    self._graph = graph
    return
  graph = property(getGraph, setGraph)

  def getNumbers(self):
    if not hasattr(self, '_numbers') or self._numbers is None:
      self._numbers = {}
    return self._numbers

  def setNumbers(self,numbers):
    self._numbers = numbers
    return
  numbers = property(getNumbers, setNumbers)

  def getVariables(self):
    if not hasattr(self, '_variables') or self._variables is None:
      self._variables = {}
    return self._variables

  def setVariables(self, variables):
    self._variables = variables
    return
  variables = property(getVariables, setVariables)
e = Exp()

# The expression graph
def p_graph(t):
  'graph : expression'
  t[0] = e.graph
  e.graph     = None
  e.numbers   = {}
  e.variables = {}

# Unary expressions
def p_expression_abs(t):
  'expression : VERT expression VERT'
  from expression import AbsoluteValue

  abs = AbsoluteValue()
  e.graph.addEdges(abs, [], [t[2]])
  t[0] = abs

def p_expression_uminus(t):
  'expression : MINUS expression %prec UMINUS'
  from expression import Negation

  neg = Negation()
  e.graph.addEdges(neg, [], [t[2]])
  t[0] = neg

def p_expression_cosine(t):
  'expression : COS LPAREN expression RPAREN'
  from expression import Cosine

  cos = Cosine()
  e.graph.addEdges(cos, [], [t[3]])
  t[0] = cos

def p_expression_sine(t):
  'expression : SIN LPAREN expression RPAREN'
  from expression import Sine

  sin = Sine()
  e.graph.addEdges(sin, [], [t[3]])
  t[0] = sin

def p_expression_transpose(t):
  'expression : TRANS LPAREN expression RPAREN'
  from expression import Transpose

  trans = Transpose()
  e.graph.addEdges(trans, [], [t[3]])
  t[0] = trans

def p_expression_determinant(t):
  'expression : DET LPAREN expression RPAREN'
  from expression import Determinant

  det = Determinant()
  e.graph.addEdges(set, [], [t[3]])
  t[0] = set

def p_expression_inverse(t):
  'expression : INV LPAREN expression RPAREN'
  from expression import Inverse

  inv = Inverse()
  e.graph.addEdges(inv, [], [t[3]])
  t[0] = inv

def p_expression_gradient(t):
  'expression : GRAD expression'
  from expression import Gradient

  grad = Gradient()
  e.graph.addEdges(grad, [], [t[2]])
  t[0] = grad

def p_expression_divergence(t):
  'expression : DIV expression'
  from expression import Divergence

  div = Divergence()
  e.graph.addEdges(div, [], [t[2]])
  t[0] = div

def p_expression_curl(t):
  'expression : CURL expression'
  from expression import Curl

  curl = Curl()
  e.graph.addEdges(curl, [], [t[2]])
  t[0] = curl

def p_expression_list(t):
  'expression : LBRACE expressionlist RBRACE'
  from expression import List

  list = List()
  e.graph.addEdges(list, [], t[2])
  t[0] = list

def p_expression_group(t):
  'expression : LPAREN expression RPAREN'
  t[0] = t[2]

def p_expression_variable(t):
  'expression : variable'
  t[0] = t[1]

def p_expression_constant(t):
  'expression : constant'
  t[0] = t[1]

# Binary expressions
def p_expression_exp(t):
  'expression : expression CARET expression'
  from expression import Exponential

  exp = Exponential()
  e.graph.addEdges(exp, [], [t[1], t[3]])
  t[0] = exp

def p_expression_exp(t):
  'expression : expression PERIOD expression'
  from expression import InnerProduct

  exp = InnerProduct()
  e.graph.addEdges(exp, [], [t[1], t[3]])
  t[0] = exp

def p_expression_addition(t):
  'expression : expression PLUS expression'
  from expression import Addition

  add = Addition()
  e.graph.addEdges(add, [], [t[1], t[3]])
  t[0] = add

def p_expression_subtraction(t):
  'expression : expression MINUS expression'
  from expression import Subtraction

  sub = Subtraction()
  e.graph.addEdges(sub, [], [t[1], t[3]])
  t[0] = sub

def p_expression_multiplication(t):
  'expression : expression TIMES expression'
  from expression import Multiplication

  mult = Multiplication()
  e.graph.addEdges(mult, [], [t[1], t[3]])
  t[0] = mult

def p_expression_division(t):
  'expression : expression DIVIDE expression'
  from expression import Division

  div = Division()
  e.graph.addEdges(div, [], [t[1], t[3]])
  t[0] = div

def p_expression_bracket(t):
  'expression : LT expression COMMA expression GT'
  from expression import Bracket

  bracket = Bracket()
  e.graph.addEdges(bracket, [], [t[2], t[4]])
  t[0] = bracket

def p_expression_subscript(t):
  'expression : expression LBRACKET expression RBRACKET'
  from expression import Subscript

  sub = Subscript()
  e.graph.addEdges(sub, [], [t[1], t[3]])
  t[0] = sub

# Expression lists
def p_expressionlist_1(t):
  'expressionlist : expression COMMA expressionlist'
  t[0] = [t[1]]+t[3]

def p_expressionlist_2(t):
  'expressionlist : expression'
  t[0] = [t[1]]

# Variables
def p_variable_1(t):
  'variable : VAR'
  if not t[1] in e.variables:
    from expression import Variable

    var = Variable()
    var.setIdentifier(t[1])
    e.variables[t[1]] = var
  e.graph.addVertex(e.variables[t[1]])
  t[0] = e.variables[t[1]]

def p_variable_2(t):
  'variable : VEC VAR'
  if not t[2] in e.variables:
    from expression import Variable

    var = Variable()
    var.setIdentifier(t[2])
    var.setRank(1)
    e.variables[t[2]] = var
  e.graph.addVertex(e.variables[t[2]])
  t[0] = e.variables[t[2]]

# Constants
def p_constant_1(t):
  'constant : ICONST'
  if not t[1] in e.numbers:
    from expression import Constant

    const = Constant()
    const.setValue_int([int(t[1])])
    e.numbers[t[1]] = const
  e.graph.addVertex(e.numbers[t[1]])
  t[0] = e.numbers[t[1]]

def p_constant_2(t):
  'constant : FCONST'
  if not t[1] in e.numbers:
    from expression import Constant

    const = Constant()
    const.setValue_double([float(t[1])])
    e.numbers[t[1]] = const
  e.graph.addVertex(e.numbers[t[1]])
  t[0] = e.numbers[t[1]]

# Parse error
def p_error(t):
  print "Error: %s " % t

# Driver
def setup(debug = 0):
  global parser

  parser = yacc.yacc(debug = debug)
  return parser

if __name__ == '__main__':
  from expression import Printer
  import ASE.BaseException

  #import profile
  # Build the grammar
  #profile.run("yacc.yacc()")

  setup()

  try:
    for i in range(1, len(sys.argv)):
      print "About to parse %s" % sys.argv[i]
      f = open(sys.argv[i],"r")
      s = f.read()
      f.close()
      # print "Contents of %s: %s" % (sys.argv[i], s)
      graph   = parser.parse(s)
      printer = expression.Printer()
      printer.setGraph(graph)
      printer.searchGraph()
      print
  except ASE.BaseException.Exception, e:
    print 'ERROR',e.getMessage()
