#include <TestChars_impl.h>

#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#include <iostream>
#include <fstream>

#include <Utils.h>

using namespace CORBA;

int
run(ORB_ptr orb, int argc, char** argv)
{
    CORBA::Object_var poaObj = orb->resolve_initial_references("RootPOA");
    PortableServer::POA_var poa = PortableServer::POA::_narrow(poaObj);
	    
    PortableServer::POAManager_var manager = poa->the_POAManager();
    manager->activate();
    
    TestChars_impl impl;
    TestChars_var testChars = impl._this();

    String_var s = orb->object_to_string(testChars);

    const char* refFile = "Server.ref";
    std::ofstream out(refFile);
    if (out.fail()) {
	std::cerr << argv[0] << ": can't open `" << refFile << "': "
	          << strerror(errno) << std::endl;
	return 1;
    }

    out << s << std::endl;
    out.close();

    orb -> run();

    return 0;
}

int
main(int argc, char* argv[])
{
    int status = EXIT_SUCCESS;
    ORB_var orb;

    try {

        orb = ORB_init(argc, argv);
	status = run(orb, argc, argv);

    } catch (const Exception& ex) {
	write_ex(std::cerr, ex);
        status = EXIT_SUCCESS;
    }

    return status;
}
