# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lexicon', 'lexicon.providers', 'lexicon.tests']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4',
 'cryptography>=2',
 'pyyaml>=3',
 'requests>=2',
 'tldextract>=2']

extras_require = \
{'ddns': ['dnspython>=2'],
 'full': ['boto3>=1', 'localzone>=0.9.8', 'softlayer>=5', 'zeep>=3', 'oci>=2'],
 'gransy': ['zeep>=3'],
 'localzone': ['localzone>=0.9.8'],
 'oci': ['oci>=2'],
 'route53': ['boto3>=1'],
 'softlayer': ['softlayer>=5']}

entry_points = \
{'console_scripts': ['lexicon = lexicon.cli:main']}

setup_kwargs = {
    'name': 'dns-lexicon',
    'version': '3.10.0',
    'description': 'Manipulate DNS records on various DNS providers in a standardized/agnostic way',
    'long_description': '============\n|logo_named|\n============\n\nManipulate DNS records on various DNS providers in a standardized/agnostic way.\n\n|build_status| |coverage_status| |docker_pulls| |pypy_version| |pypy_python_support| |github_license|\n\n.. |logo_named| image:: https://raw.githubusercontent.com/AnalogJ/lexicon/master/docs/images/logo_named.svg\n    :alt: Lexicon\n\n.. |build_status| image:: https://dev.azure.com/AnalogJ/lexicon/_apis/build/status/AnalogJ.lexicon?branchName=master\n    :target: https://dev.azure.com/AnalogJ/lexicon/_build/latest?definitionId=1&branchName=master\n\n.. |coverage_status| image:: https://coveralls.io/repos/github/AnalogJ/lexicon/badge.svg\n    :target: https://coveralls.io/github/AnalogJ/lexicon?branch=master\n\n.. |docker_pulls| image:: https://img.shields.io/docker/pulls/analogj/lexicon.svg\n    :target: https://hub.docker.com/r/analogj/lexicon\n\n.. |pypy_version| image:: https://img.shields.io/pypi/v/dns-lexicon.svg\n    :target: https://pypi.python.org/pypi/dns-lexicon\n\n.. |pypy_python_support| image:: https://img.shields.io/pypi/pyversions/dns-lexicon.svg\n    :target: https://pypi.python.org/pypi/dns-lexicon\n\n.. |github_license| image:: https://img.shields.io/github/license/AnalogJ/lexicon.svg\n    :target: https://github.com/AnalogJ/lexicon/blob/master/LICENSE\n\n.. contents:: Table of Contents\n   :local:\n\n.. tag: intro-begin\n\nWhy using Lexicon?\n==================\n\nLexicon provides a way to manipulate DNS records on multiple DNS providers in a standardized way.\n\nLexicon can be used as:\n\n- a CLI tool:\n\n.. code-block:: bash\n\n    # Create a TXT entry in domain.net zone hosted by CloudFlare\n    lexicon cloudflare create domain.net TXT --name foo --content bar\n\n- or a Python library:\n\n.. code-block:: python\n\n    # Create a TXT entry in domain.net zone hosted by CloudFlare\n    from lexicon.client import Client\n    from lexicon.config import ConfigResolver\n\n    action = {\n        "provider_name" : "cloudflare",\n        "action": "create",\n        "domain": "domain.net",\n        "type": "TXT",\n        "name": "foo",\n        "content": "bar",\n    }\n    config = ConfigResolver().with_env().with_dict(action)\n    Client(config).execute()\n\nLexicon was designed to be used in automation, specifically letsencrypt.\n\n* `Generating Intranet & Private Network SSL Certificates using Lets Encrypt & Lexicon <http://blog.thesparktree.com/post/138999997429/generating-intranet-and-private-network-ssl>`_\n\nSupported providers\n===================\n\nOnly DNS providers who have an API can be supported by `lexicon`.\n\nThe current supported providers are:\n\n..\n  This section is autogenerated and should not been modified directly.\n  However you should add a reference to the provider API in the list below,\n  using the following syntax: .. _provider: URL_API\n\n.. tag: providers-table-begin\n\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| aliyun_         | aurora_         | azure_          | cloudflare_     | cloudns_        |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| cloudxns_       | conoha_         | constellix_     | ddns_           | digitalocean_   |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| dinahosting_    | directadmin_    | dnsimple_       | dnsmadeeasy_    | dnspark_        |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| dnspod_         | dreamhost_      | dynu_           | easydns_        | easyname_       |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| euserv_         | exoscale_       | gandi_          | gehirn_         | glesys_         |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| godaddy_        | googleclouddns_ | gransy_         | gratisdns_      | henet_          |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| hetzner_        | hostingde_      | hover_          | infoblox_       | infomaniak_     |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| internetbs_     | inwx_           | joker_          | linode_         | linode4_        |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| localzone_      | luadns_         | memset_         | misaka_         | mythicbeasts_   |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| namecheap_      | namesilo_       | netcup_         | nfsn_           | njalla_         |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| nsone_          | oci_            | onapp_          | online_         | ovh_            |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| plesk_          | pointhq_        | powerdns_       | rackspace_      | rage4_          |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| rcodezero_      | route53_        | safedns_        | sakuracloud_    | softlayer_      |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| transip_        | ultradns_       | valuedomain_    | vercel_         | vultr_          |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| webgo_          | yandex_         | yandexcloud_    | zeit_           | zilore_         |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n| zonomi_         |                 |                 |                 |                 |\n+-----------------+-----------------+-----------------+-----------------+-----------------+\n\n.. tag: providers-table-end\n\n.. _aliyun: https://help.aliyun.com/document_detail/29739.html\n.. _aurora: https://www.pcextreme.com/aurora/dns\n.. _azure: https://docs.microsoft.com/en-us/rest/api/dns/\n.. _cloudflare: https://api.cloudflare.com/#endpoints\n.. _cloudns: https://www.cloudns.net/wiki/article/56/\n.. _cloudxns: https://www.cloudxns.net/support/lists/cid/17.html\n.. _conoha: https://www.conoha.jp/docs/\n.. _constellix: https://api-docs.constellix.com/?version=latest\n.. _ddns:\n.. _digitalocean: https://developers.digitalocean.com/documentation/v2/#create-a-new-domain\n.. _dinahosting: https://en.dinahosting.com/api\n.. _directadmin: https://www.directadmin.com/features.php?id=504\n.. _dnsimple: https://developer.dnsimple.com/v2/\n.. _dnsmadeeasy: https://api-docs.dnsmadeeasy.com/?version=latest\n.. _dnspark: https://dnspark.zendesk.com/entries/31210577-rest-api-dns-documentation\n.. _dnspod: https://support.dnspod.cn/support/api\n.. _dreamhost: https://help.dreamhost.com/hc/en-us/articles/217560167-api_overview\n.. _dynu: https://www.dynu.com/support/api\n.. _easydns: http://docs.sandbox.rest.easydns.net/\n.. _easyname: https://www.easyname.com/en\n.. _euserv: https://support.euserv.com/api-doc/\n.. _exoscale: https://community.exoscale.com/documentation/dns/api/\n.. _gandi: http://doc.livedns.gandi.net/\n.. _gehirn: https://support.gehirn.jp/apidocs/gis/dns/index.html\n.. _glesys: https://github.com/glesys/api/wiki/\n.. _godaddy: https://developer.godaddy.com/getstarted#access\n.. _googleclouddns: https://cloud.google.com/dns/api/v1/\n.. _gransy: https://subreg.cz/manual/\n.. _gratisdns:\n.. _henet: https://dns.he.net/\n.. _hetzner: https://dns.hetzner.com/api-docs/\n.. _hostingde:\n.. _hover: https://hoverapi.docs.apiary.io/\n.. _infoblox: https://docs.infoblox.com/display/ilp/infoblox+documentation+portal\n.. _infomaniak: https://www.infomaniak.com\n.. _internetbs: https://internetbs.net/resellerregistrardomainnameapi\n.. _inwx: https://www.inwx.de/en/offer/api\n.. _joker: https://joker.com/faq/index.php?action=show&cat=39\n.. _linode: https://www.linode.com/api/dns\n.. _linode4: https://developers.linode.com/api/docs/v4#tag/domains\n.. _localzone:\n.. _luadns: http://www.luadns.com/api.html\n.. _memset: https://www.memset.com/apidocs/methods_dns.html\n.. _misaka: https://misaka.io/dns/\n.. _mythicbeasts: https://www.mythic-beasts.com/support/api/dnsv2\n.. _namecheap: https://www.namecheap.com/support/api/methods.aspx\n.. _namesilo: https://www.namesilo.com/api_reference.php\n.. _netcup: https://ccp.netcup.net/run/webservice/servers/endpoint.php\n.. _nfsn:\n.. _njalla: https://njal.la/api/\n.. _nsone: https://ns1.com/api/\n.. _oci:\n.. _onapp: https://docs.onapp.com/display/55api/onapp+5.5+api+guide\n.. _online:\n.. _ovh: https://api.ovh.com/\n.. _plesk: https://docs.plesk.com/en-us/onyx/api-rpc/about-xml-api.28709/\n.. _pointhq: https://pointhq.com/api/docs\n.. _powerdns: https://doc.powerdns.com/md/httpapi/api_spec/\n.. _rackspace: https://developer.rackspace.com/docs/cloud-dns/v1/developer-guide/\n.. _rage4: https://gbshouse.uservoice.com/knowledgebase/articles/109834-rage4-dns-developers-api\n.. _rcodezero: https://my.rcodezero.at/api-doc\n.. _rfc2136: https://en.wikipedia.org/wiki/dynamic_dns\n.. _route53: https://docs.aws.amazon.com/route53/latest/apireference/welcome.html\n.. _safedns: https://developers.ukfast.io/documentation/safedns\n.. _sakuracloud: https://developer.sakura.ad.jp/cloud/api/1.1/\n.. _softlayer: https://sldn.softlayer.com/article/rest#http_request_types\n.. _transip: https://api.transip.nl/rest/docs.html\n.. _ultradns: https://ultra-portalstatic.ultradns.com/static/docs/rest-api_user_guide.pdf\n.. _valuedomain: https://www.value-domain.com/service/api/\n.. _vercel: https://vercel.com/docs/api#endpoints/dns\n.. _vultr: https://www.vultr.com/api/#tag/dns\n.. _webgo: https://www.webgo.de/\n.. _yandex: https://yandex.com/dev/domain/doc/reference/dns-add.html\n.. _yandexcloud: https://cloud.yandex.com/en/docs/dns/api-ref/DnsZone/\n.. _zeit:\n.. _zilore: https://zilore.com/en/help/api\n.. _zonomi: http://zonomi.com/app/dns/dyndns.jsp\n\n.. tag: intro-end\n\nDocumentation\n=============\n\nOnline documentation (user guide, configuration reference) is available in the `Lexicon documentation`_.\n\nFor a quick start, please have a look in particular at the `User guide`_.\n\n.. _Lexicon documentation: https://dns-lexicon.readthedocs.io\n.. _User guide: https://dns-lexicon.readthedocs.io/en/latest/user_guide.html\n\nContributing\n============\n\nIf you want to help in the Lexicon development, you are welcome!\n\nPlease have a look at the `Developer guide`_ page to know how to start.\n\n.. _Developer guide: https://dns-lexicon.readthedocs.io/en/latest/developer_guide.html\n\nLicensing\n=========\n\n- MIT\n- Logo_: transform by Mike Rowe from the Noun Project\n\n.. _Logo: https://thenounproject.com/term/transform/397964\n',
    'author': 'Jason Kulatunga',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/AnalogJ/lexicon',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
