from . import config
import dask
from dask.config import config
from .actor import Actor, ActorFuture
from .core import connect, rpc, Status
from .deploy import LocalCluster, Adaptive, SpecCluster, SSHCluster
from .diagnostics.progressbar import progress
from .diagnostics.plugin import WorkerPlugin, SchedulerPlugin, PipInstall
from .client import (
    Client,
    Executor,
    CompatibleExecutor,
    wait,
    as_completed,
    default_client,
    fire_and_forget,
    Future,
    futures_of,
    get_task_stream,
    performance_report,
    get_task_metadata,
)
from .lock import Lock
from .nanny import Nanny
from .pubsub import Pub, Sub
from .queues import Queue
from .security import Security
from .semaphore import Semaphore
from .event import Event
from .scheduler import Scheduler
from .threadpoolexecutor import rejoin
from .utils import sync, TimeoutError, CancelledError
from .variable import Variable
from .worker import Worker, get_worker, get_client, secede, Reschedule
from .worker_client import local_client, worker_client

from ._version import get_versions

versions = get_versions()
__version__ = versions["version"]
__git_revision__ = versions["full-revisionid"]
del get_versions, versions

if dask.config.get("distributed.admin.event-loop") in ("asyncio", "tornado"):
    pass
elif dask.config.get("distributed.admin.event-loop") == "uvloop":
    import uvloop

    uvloop.install()
else:
    raise ValueError(
        "Expected distributed.admin.event-loop to be in ('asyncio', 'tornado', 'uvloop'), got %s"
        % dask.config.get("distributed.admin.event-loop")
    )
