# setup.py

long_description = """Read, write, and manipulate 3DS files.

Dice3DS is a package to to read, write, and manipulate 3D Studio
format files in Python.  Includes example code to convert 3DS files
into OpenGL display lists, and utilities to view 3DS models and to
dump the contents of the 3DS file as formatted text.

"""

from distutils.core import setup

dist = setup(name = "Dice3DS",
	     version = "0.13",
	     description = "Read, write, and manipulate 3DS files.",
	     long_description = long_description,
	     author = "Carl Banks",
	     url = "http://blog.aerojockey.com/post/dice3ds",
	     license = "BSD Style",
	     platforms = "Platform independent.",
	     packages = [ 'Dice3DS', 'Dice3DS.example' ],
	     scripts = [ 'dump3ds', 'view3ds' ])

