# Report Issues on GitHub

Aside from contributing to code and documentation, another good way to help the package is to report issues. An Issue could be about a feature request, a bug report, or any of your cool suggestions.

We use GitHub to keep track of the issues. You can see all past and present (open) issues, by simply heading to [this page](https://github.com/pydap/pydap/issues).

Before you report a new issue, make sure you follow these two simple steps:

1. Read through relevant sections in the documentation;
2. Use the search bar to see if the issue has already been reported.

If you cannot find any past issue or discussion relevant to your problem, consider opening a new issue. By reporting an issue, you also help others who are in the same situation. If you spend enough effort working on the problem and still cannot figure it out, there must be something confusing or wrong about the code or the documentation. We will really appreciate it if you point that out.

Lastly, we highly recommend to follow common practices when describing the issue,

- be concise.
- be polite. Why this matters in the Open-source community? Read Jacom Tomlinson's [BlogPost](https://jacobtomlinson.dev/posts/2022/dont-be-that-open-source-user-dont-be-me/).
- include a `minimal reproducible example` that recreates the problem.
- describe an expected or new desired behavior.
