#!/usr/bin/env python
#
# Distutils setup script for Munkres
#
# $Id: setup.py 7253 2008-02-22 15:20:36Z bmc $
# ---------------------------------------------------------------------------

from distutils.core import setup
import re, daemon

VERSION = str(daemon.__version__)
(AUTHOR, EMAIL) = re.match('^(.*),\s*(.*)$', daemon.__author__).groups()
URL = daemon.__url__
LICENSE = daemon.__license__

setup(
    name="daemon",
    version=VERSION,
    description="Module to daemonize the calling process",
    url=URL,
    license=LICENSE,
    author=AUTHOR,
    author_email=EMAIL,
    py_modules=["daemon"],
    classifiers = [
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: BSD License',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
