# -*- coding: utf-8 -*-
"""
Defines unit tests for :mod:`colour.colorimetry.blackbody` module.
"""

from __future__ import division, unicode_literals

import numpy as np
import unittest
from itertools import permutations

from colour.colorimetry import (SpectralShape, planck_law, sd_blackbody)
from colour.utilities import ignore_numpy_errors

__author__ = 'Colour Developers'
__copyright__ = 'Copyright (C) 2013-2019 - Colour Developers'
__license__ = 'New BSD License - https://opensource.org/licenses/BSD-3-Clause'
__maintainer__ = 'Colour Developers'
__email__ = 'colour-science@googlegroups.com'
__status__ = 'Production'

__all__ = [
    'PLANCK_LAW_DATA', 'BLACKBODY_SD_DATA', 'TestPlanckLaw', 'TestSdBlackbody'
]

PLANCK_LAW_DATA = {
    1667: {
        10: 0.000000000000000,
        20: 0.000000000000000,
        30: 0.000000000000000,
        40: 0.000000000000000,
        50: 0.000000000000000,
        60: 0.000000000000000,
        70: 0.000000000000000,
        80: 0.000000000000000,
        90: 0.000000000000000,
        100: 0.000000000000000,
        110: 0.000000000000002,
        120: 0.000000000000278,
        130: 0.000000000047006,
        140: 0.000000003722232,
        150: 0.000000160676706,
        160: 0.000004242815848,
        170: 0.000074835543030,
        180: 0.000943987783859,
        190: 0.008986537508369,
        200: 0.067396720520167,
        210: 0.412263664414216,
        220: 2.115953500760159,
        230: 9.327737920336361,
        240: 36.009931827856363,
        250: 123.741796637484015,
        260: 383.734554453010105,
        270: 1086.532921126978863,
        280: 2837.235112943416425,
        290: 6891.670775622277688,
        300: 15687.798375507614765,
        310: 33683.448442749082460,
        320: 68602.638967311169836,
        330: 133194.337010365445167,
        340: 247596.979009923117701,
        350: 442378.111991246347316,
        360: 762281.907435712986626,
        370: 1270670.618355158250779,
        380: 2054593.363812708063051,
        390: 3230361.862517226021737,
        400: 4949462.988632170483470,
        410: 7404596.883354958146811,
        420: 10835600.410377722233534,
        430: 15535001.251538790762424,
        440: 21852948.726484376937151,
        450: 30201282.954720582813025,
        460: 41056532.584353178739548,
        470: 54961670.469085946679115,
        480: 72526503.351112380623817,
        490: 94426622.578291922807693,
        500: 121400895.012963056564331,
        510: 154247523.746847808361053,
        520: 193818754.649298161268234,
        530: 241014345.315222352743149,
        540: 296773946.385241985321045,
        550: 362068570.775709986686707,
        560: 437891343.868859589099884,
        570: 525247737.383690953254700,
        580: 625145492.020611643791199,
        590: 738584429.837095022201538,
        600: 866546347.617280840873718,
        610: 1009985168.279581546783447,
        620: 1169817509.676422595977783,
        630: 1346913810.000562429428101,
        640: 1542090127.373159408569336,
        650: 1756100708.902090549468994,
        660: 1989631402.301429748535156,
        670: 2243293961.669390678405762,
        680: 2517621278.723494052886963,
        690: 2813063552.061536788940430,
        700: 3129985390.118350982666016,
        710: 3468663828.588368892669678,
        720: 3829287230.262294292449951,
        730: 4211955024.492659091949463,
        740: 4616678234.808919906616211,
        750: 5043380736.452318191528320,
        760: 5491901180.664997100830078,
        770: 5961995519.294449806213379,
        780: 6453340061.493020057678223,
        790: 6965534993.828248023986816,
        800: 7498108295.795781135559082,
        810: 8050519984.367113113403320,
        820: 8622166623.644691467285156,
        830: 9212386038.779451370239258,
        840: 9820462176.886133193969727,
        850: 10445630061.640813827514648,
        860: 11087080792.442424774169922,
        870: 11743966543.367158889770508,
        880: 12415405521.548801422119141,
        890: 13100486849.005540847778320,
        900: 13798275336.239715576171875,
        910: 14507816120.112028121948242,
        920: 15228139142.490661621093750,
        930: 15958263449.970767974853516,
        940: 16697201298.524448394775391,
        950: 17443962050.261108398437500,
        960: 18197555852.542789459228516,
        970: 18956997092.503765106201172,
        980: 19721307622.570709228515625,
        990: 20489519754.869235992431641,
        1000: 21260679024.447570800781250,
        1010: 22033846723.050220489501953,
        1020: 22808102206.753955841064453,
        1030: 23582544982.139328002929688,
        1040: 24356296576.834621429443359,
        1050: 25128502201.242084503173828,
        1060: 25898332209.061492919921875,
        1070: 26664983364.869365692138672,
        1080: 27427679927.513755798339844,
        1090: 28185674558.457286834716797,
        1100: 28938249064.453468322753906,
        1110: 29684714984.095752716064453,
        1120: 30424414027.835208892822266,
        1130: 31156718381.043312072753906,
        1140: 31881030879.605392456054688,
        1150: 32596785067.378364562988281,
        1160: 33303445144.645103454589844,
        1170: 34000505816.452465057373047,
        1180: 34687492049.439544677734375,
        1190: 35363958745.455039978027344,
        1200: 36029490339.929389953613281,
        1210: 36683700332.622062683105469,
        1220: 37326230758.002471923828125,
        1230: 37956751602.155235290527344,
        1240: 38574960172.731185913085938,
        1250: 39180580428.090705871582031,
        1260: 39773362271.417213439941406,
        1270: 40353080815.215209960937500,
        1280: 40919535621.245407104492188,
        1290: 41472549920.603485107421875,
        1300: 42011969818.306449890136719,
        1310: 42537663486.422920227050781,
        1320: 43049520349.467788696289062,
        1330: 43547450265.475952148437500,
        1340: 44031382705.880584716796875,
        1350: 44501265937.043678283691406,
        1360: 44957066206.023368835449219,
        1370: 45398766932.912322998046875,
        1380: 45826367911.846313476562500,
        1390: 46239884522.559860229492188,
        1400: 46639346954.155967712402344,
        1410: 47024799442.562164306640625,
        1420: 47396299522.962165832519531,
        1430: 47753917298.319282531738281,
        1440: 48097734724.953651428222656,
        1450: 48427844915.982139587402344,
        1460: 48744351463.298889160156250,
        1470: 49047367778.644355773925781,
        1480: 49337016454.198120117187500,
        1490: 49613428643.021575927734375,
        1500: 49876743459.581878662109375,
        1510: 50127107400.498550415039062,
        1520: 50364673785.572845458984375,
        1530: 50589602219.088500976562500,
        1540: 50802058071.305679321289062,
        1550: 51002211980.009536743164062,
        1560: 51190239371.924697875976562,
        1570: 51366320003.756256103515625,
        1580: 51530637522.579055786132812,
        1590: 51683379045.258270263671875,
        1600: 51824734756.553298950195312,
        1610: 51954897525.528915405273438,
        1620: 52074062539.874114990234375,
        1630: 52182426957.708602905273438,
        1640: 52280189576.440544128417969,
        1650: 52367550518.226364135742188,
        1660: 52444710931.570213317871094,
        1670: 52511872708.596328735351562,
        1680: 52569238217.518684387207031,
        1690: 52617010049.829719543457031,
        1700: 52655390781.729248046875000,
        1710: 52684582749.312789916992188,
        1720: 52704787837.042449951171875,
        1730: 52716207279.024795532226562,
        1740: 52719041472.625160217285156,
        1750: 52713489803.953521728515625,
        1760: 52699750484.763427734375000,
        1770: 52678020400.311569213867188,
        1780: 52648494967.736068725585938,
        1790: 52611368004.517494201660156,
        1800: 52566831606.597862243652344,
        1810: 52515076035.741600036621094,
        1820: 52456289615.732574462890625,
        1830: 52390658637.011695861816406,
        1840: 52318367269.371055603027344,
        1850: 52239597482.329780578613281,
        1860: 52154528972.828773498535156,
        1870: 52063339099.892768859863281,
        1880: 51966202825.917854309082031,
        1890: 51863292664.255493164062500,
        1900: 51754778632.772895812988281,
        1910: 51640828213.082901000976562,
        1920: 51521606315.144821166992188,
        1930: 51397275246.951049804687500,
        1940: 51267994689.022102355957031,
        1950: 51133921673.445259094238281,
        1960: 50995210567.201057434082031,
        1970: 50852013059.532310485839844,
        1980: 50704478153.119400024414062,
        1990: 50552752158.836791992187500,
        2000: 50396978693.872505187988281,
        2010: 50237298683.004051208496094,
        2020: 50073850362.831382751464844,
        2030: 49906769288.776611328125000,
        2040: 49736188344.668571472167969,
        2050: 49562237754.738853454589844,
        2060: 49385045097.862838745117188,
        2070: 49204735323.887321472167969,
        2080: 49021430771.894523620605469,
        2090: 48835251190.258049011230469,
        2100: 48646313758.353942871093750,
        2110: 48454733109.796394348144531,
        2120: 48260621357.074645996093750,
        2130: 48064088117.472877502441406,
        2140: 47865240540.161270141601562,
        2150: 47664183334.352470397949219,
        2160: 47461018798.422607421875000,
        2170: 47255846849.901321411132812,
        2180: 47048765056.241020202636719,
        2190: 46839868666.279495239257812,
        2200: 46629250642.315414428710938,
        2210: 46417001692.720344543457031,
        2220: 46203210305.015228271484375,
        2230: 45987962779.343559265136719,
        2240: 45771343262.277023315429688,
        2250: 45553433780.893943786621094,
        2260: 45334314277.073143005371094,
        2270: 45114062641.950584411621094,
        2280: 44892754750.488761901855469,
        2290: 44670464496.111640930175781,
        2300: 44447263825.361953735351562,
        2310: 44223222772.539192199707031,
        2320: 43998409494.280563354492188,
        2330: 43772890304.048881530761719,
        2340: 43546729706.493988037109375,
        2350: 43319990431.657279968261719,
        2360: 43092733468.990013122558594,
        2370: 42865018101.159515380859375,
        2380: 42636901937.617492675781250,
        2390: 42408440947.909286499023438,
        2400: 42179689494.701835632324219,
        2410: 41950700366.511840820312500,
        2420: 41721524810.116363525390625,
        2430: 41492212562.629768371582031,
        2440: 41262811883.232337951660156,
        2450: 41033369584.537757873535156,
        2460: 40803931063.586822509765625,
        2470: 40574540332.457305908203125,
        2480: 40345240048.480270385742188,
        2490: 40116071544.053787231445312,
        2500: 39887074856.047760009765625,
        2510: 39658288754.792297363281250,
        2520: 39429750772.644714355468750,
        2530: 39201497232.130371093750000,
        2540: 38973563273.653091430664062,
        2550: 38745982882.772743225097656,
        2560: 38518788917.046676635742188,
        2570: 38292013132.434211730957031,
        2580: 38065686209.262077331542969,
        2590: 37839837777.751213073730469,
        2600: 37614496443.104011535644531,
        2610: 37389689810.153137207031250,
        2620: 37165444507.572822570800781,
        2630: 36941786211.653656005859375,
        2640: 36718739669.643074035644531,
        2650: 36496328722.653663635253906,
        2660: 36274576328.141662597656250,
        2670: 36053504581.958915710449219,
        2680: 35833134739.980758666992188,
        2690: 35613487239.314109802246094,
        2700: 35394581719.088928222656250,
        2710: 35176437040.837036132812500,
        2720: 34959071308.462654113769531,
        2730: 34742501887.808639526367188,
        2740: 34526745425.823303222656250,
        2750: 34311817869.332248687744141,
        2760: 34097734483.420047760009766,
        2770: 33884509869.426662445068359,
        2780: 33672157982.563716888427734,
        2790: 33460692149.155818939208984,
        2800: 33250125083.511863708496094,
        2810: 33040468904.431907653808594,
        2820: 32831735151.354934692382812,
        2830: 32623934800.152610778808594,
        2840: 32417078278.574890136718750,
        2850: 32211175481.352672576904297,
        2860: 32006235784.963108062744141,
        2870: 31802268062.063140869140625,
        2880: 31599280695.596488952636719,
        2890: 31397281592.580181121826172,
        2900: 31196278197.575496673583984,
        2910: 30996277505.849323272705078,
        2920: 30797286076.231147766113281,
        2930: 30599310043.671329498291016,
        2940: 30402355131.506050109863281,
        2950: 30206426663.434055328369141,
        2960: 30011529575.211128234863281,
        2970: 29817668426.067226409912109,
        2980: 29624847409.851634979248047,
        2990: 29433070365.911415100097656,
        3000: 29242340789.708496093750000,
        3010: 29052661843.180267333984375,
        3020: 28864036364.848945617675781,
        3030: 28676466879.684867858886719,
        3040: 28489955608.728294372558594,
        3050: 28304504478.475124359130859,
        3060: 28120115130.031036376953125,
        3070: 27936788928.038925170898438,
        3080: 27754526969.384502410888672,
        3090: 27573330091.684413909912109,
        3100: 27393198881.561981201171875,
        3110: 27214133682.714500427246094,
        3120: 27036134603.776943206787109,
        3130: 26859201525.986412048339844,
        3140: 26683334110.651618957519531,
        3150: 26508531806.431407928466797,
        3160: 26334793856.427181243896484,
        3170: 26162119305.092437744140625,
        3180: 25990507004.964263916015625,
        3190: 25819955623.220275878906250,
        3200: 25650463648.065193176269531,
        3210: 25482029394.950561523437500,
        3220: 25314651012.631835937500000,
        3230: 25148326489.066196441650391,
        3240: 24983053657.154758453369141,
        3250: 24818830200.332965850830078,
        3260: 24655653658.012355804443359,
        3270: 24493521430.877418518066406,
        3280: 24332430786.040733337402344,
        3290: 24172378862.059841156005859,
        3300: 24013362673.818763732910156,
        3310: 23855379117.277862548828125,
        3320: 23698424974.094684600830078,
        3330: 23542496916.119117736816406,
        3340: 23387591509.765674591064453,
        3350: 23233705220.265979766845703,
        3360: 23080834415.804214477539062,
        3370: 22928975371.538394927978516,
        3380: 22778124273.510196685791016,
        3390: 22628277222.446071624755859,
        3400: 22479430237.452110290527344,
        3410: 22331579259.605606079101562,
        3420: 22184720155.445377349853516,
        3430: 22038848720.363704681396484,
        3440: 21893960681.902065277099609,
        3450: 21750051702.953144073486328,
        3460: 21607117384.871376037597656,
        3470: 21465153270.494354248046875,
        3480: 21324154847.077175140380859,
        3490: 21184117549.142086029052734,
        3500: 21045036761.245326995849609,
        3510: 20906907820.663524627685547,
        3520: 20769726020.001209259033203,
        3530: 20633486609.721977233886719,
        3540: 20498184800.604793548583984,
        3550: 20363815766.127571105957031,
        3560: 20230374644.779708862304688,
        3570: 20097856542.305557250976562,
        3580: 19966256533.880424499511719,
        3590: 19835569666.220882415771484,
        3600: 19705790959.631195068359375,
        3610: 19576915409.987216949462891,
        3620: 19448937990.659660339355469,
        3630: 19321853654.378177642822266,
        3640: 19195657335.037658691406250,
        3650: 19070343949.448543548583984,
        3660: 18945908399.032257080078125,
        3670: 18822345571.463489532470703,
        3680: 18699650342.260528564453125,
        3690: 18577817576.325027465820312,
        3700: 18456842129.432571411132812,
        3710: 18336718849.675418853759766,
        3720: 18217442578.858440399169922,
        3730: 18099008153.849739074707031,
        3740: 17981410407.886978149414062,
        3750: 17864644171.840679168701172,
        3760: 17748704275.435646057128906,
        3770: 17633585548.431594848632812,
        3780: 17519282821.763969421386719,
        3790: 17405790928.646301269531250,
        3800: 17293104705.634849548339844,
        3810: 17181218993.656661987304688,
        3820: 17070128639.002058029174805,
        3830: 16959828494.282493591308594,
        3840: 16850313419.354669570922852,
        3850: 16741578282.211908340454102,
        3860: 16633617959.843605041503906,
        3870: 16526427339.063655853271484,
        3880: 16420001317.308755874633789,
        3890: 16314334803.407329559326172,
        3900: 16209422718.319889068603516,
        3910: 16105259995.851728439331055,
        3920: 16001841583.338558197021484,
        3930: 15899162442.305976867675781,
        3940: 15797217549.103363037109375,
        3950: 15696001895.513036727905273,
        3960: 15595510489.335338592529297,
        3970: 15495738354.950218200683594,
        3980: 15396680533.856140136718750,
        3990: 15298332085.186805725097656,
        4000: 15200688086.206378936767578,
        4010: 15103743632.783977508544922,
        4020: 15007493839.847599029541016,
        4030: 14911933841.818628311157227,
        4040: 14817058793.026969909667969,
        4050: 14722863868.107772827148438,
        4060: 14629344262.379924774169922,
        4070: 14536495192.207136154174805,
        4080: 14444311895.341962814331055,
        4090: 14352789631.253242492675781,
        4100: 14261923681.437620162963867,
        4110: 14171709349.715284347534180,
        4120: 14082141962.510757446289062,
        4130: 13993216869.118989944458008,
        4140: 13904929441.957130432128906,
        4150: 13817275076.802543640136719,
        4160: 13730249193.017465591430664,
        4170: 13643847233.760520935058594,
        4180: 13558064666.185781478881836,
        4190: 13472896981.629543304443359,
        4200: 13388339695.785169601440430,
        4210: 13304388348.866556167602539,
        4220: 13221038505.760393142700195,
        4230: 13138285756.167613983154297,
        4240: 13056125714.734388351440430,
        4250: 12974554021.173030853271484,
        4260: 12893566340.372951507568359,
        4270: 12813158362.502214431762695,
        4280: 12733325803.099805831909180,
        4290: 12654064403.159000396728516,
        4300: 12575369929.202068328857422,
        4310: 12497238173.346614837646484,
        4320: 12419664953.363830566406250,
        4330: 12342646112.728895187377930,
        4340: 12266177520.663810729980469,
        4350: 12190255072.172859191894531,
        4360: 12114874688.071022033691406,
        4370: 12040032315.005512237548828,
        4380: 11965723925.470645904541016,
        4390: 11891945517.816345214843750,
        4400: 11818693116.250448226928711,
        4410: 11745962770.834995269775391,
        4420: 11673750557.476772308349609,
        4430: 11602052577.912267684936523,
        4440: 11530864959.687213897705078,
        4450: 11460183856.130996704101562,
        4460: 11390005446.325933456420898,
        4470: 11320325935.071846008300781,
        4480: 11251141552.845882415771484,
        4490: 11182448555.757854461669922,
        4500: 11114243225.501272201538086,
        4510: 11046521869.300163269042969,
        4520: 10979280819.851903915405273,
        4530: 10912516435.266170501708984,
        4540: 10846225099.000160217285156,
        4550: 10780403219.790243148803711,
        4560: 10715047231.580146789550781,
        4570: 10650153593.445867538452148,
        4580: 10585718789.517366409301758,
        4590: 10521739328.897249221801758,
        4600: 10458211745.576465606689453,
        4610: 10395132598.347265243530273,
        4620: 10332498470.713397979736328,
        4630: 10270305970.797773361206055,
        4640: 10208551731.247625350952148,
        4650: 10147232409.137331008911133,
        4660: 10086344685.868944168090820,
        4670: 10025885267.070592880249023,
        4680: 9965850882.492807388305664,
        4690: 9906238285.902851104736328,
        4700: 9847044254.977210998535156,
        4710: 9788265591.192287445068359,
        4720: 9729899119.713386535644531,
        4730: 9671941689.282068252563477,
        4740: 9614390172.101978302001953,
        4750: 9557241463.723253250122070,
        4760: 9500492482.925477981567383,
        4770: 9444140171.599407196044922,
        4780: 9388181494.627407073974609,
        4790: 9332613439.762735366821289,
        4800: 9277433017.507757186889648,
        4810: 9222637260.991117477416992,
        4820: 9168223225.843908309936523,
        4830: 9114187990.075008392333984,
        4840: 9060528653.945503234863281,
        4850: 9007242339.842372894287109,
        4860: 8954326192.151430130004883,
        4870: 8901777377.129566192626953,
        4880: 8849593082.776409149169922,
        4890: 8797770518.705404281616211,
        4900: 8746306916.014339447021484,
        4910: 8695199527.155441284179688,
        4920: 8644445625.805023193359375,
        4930: 8594042506.732753753662109,
        4940: 8543987485.670582771301270,
        4950: 8494277899.181411743164062,
        4960: 8444911104.527424812316895,
        4970: 8395884479.538291931152344,
        4980: 8347195422.479163169860840,
        4990: 8298841351.918492317199707,
        5000: 8250819706.595800399780273,
        5010: 8203127945.289359092712402,
        5020: 8155763546.683814048767090,
        5030: 8108724009.237831115722656,
        5040: 8062006851.051759719848633,
        5050: 8015609609.735344886779785,
        5060: 7969529842.275537490844727,
        5070: 7923765124.904409408569336,
        5080: 7878313052.967226028442383,
        5090: 7833171240.790650367736816,
        5100: 7788337321.551185607910156,
        5110: 7743808947.143786430358887,
        5120: 7699583788.050758361816406,
        5130: 7655659533.210872650146484,
        5140: 7612033889.888801574707031,
        5150: 7568704583.544821739196777,
        5160: 7525669357.704905509948730,
        5170: 7482925973.831057548522949,
        5180: 7440472211.192110061645508,
        5190: 7398305866.734847068786621,
        5200: 7356424754.955523490905762,
        5210: 7314826707.771835327148438,
        5220: 7273509574.395282745361328,
        5230: 7232471221.203981399536133,
        5240: 7191709531.615959167480469,
        5250: 7151222405.962903022766113,
        5260: 7111007761.364387512207031,
        5270: 7071063531.602622985839844,
        5280: 7031387666.997709274291992,
        5290: 6991978134.283395767211914,
        5300: 6952832916.483397483825684,
        5310: 6913950012.788244247436523,
        5320: 6875327438.432680130004883,
        5330: 6836963224.573657035827637,
        5340: 6798855418.168842315673828,
        5350: 6761002081.855780601501465,
        5360: 6723401293.831593513488770,
        5370: 6686051147.733297348022461,
        5380: 6648949752.518733978271484,
        5390: 6612095232.348100662231445,
        5400: 6575485726.466108322143555,
        5410: 6539119389.084757804870605,
        5420: 6502994389.266766548156738,
        5430: 6467108910.809609413146973,
        5440: 6431461152.130216598510742,
        5450: 6396049326.150313377380371,
        5460: 6360871660.182422637939453,
        5470: 6325926395.816512107849121,
        5480: 6291211788.807308197021484,
        5490: 6256726108.962269783020020,
        5500: 6222467640.030232429504395,
        5510: 6188434679.590736389160156,
        5520: 6154625538.943997383117676,
        5530: 6121038543.001583099365234,
        5540: 6087672030.177756309509277,
        5550: 6054524352.281495094299316,
        5560: 6021593874.409210205078125,
        5570: 5988878974.838122367858887,
        5580: 5956378044.920355796813965,
        5590: 5924089488.977686882019043,
        5600: 5892011724.197017669677734,
        5610: 5860143180.526486396789551,
        5620: 5828482300.572332382202148,
        5630: 5797027539.496386528015137,
        5640: 5765777364.914301872253418,
        5650: 5734730256.794444084167480,
        5660: 5703884707.357479095458984,
        5670: 5673239220.976666450500488,
        5680: 5642792314.078818321228027,
        5690: 5612542515.045952796936035,
        5700: 5582488364.117654800415039,
        5710: 5552628413.294096946716309,
        5720: 5522961226.239769935607910,
        5730: 5493485378.187878608703613,
        5740: 5464199455.845434188842773,
        5750: 5435102057.299023628234863,
        5760: 5406191791.921267509460449,
        5770: 5377467280.277956962585449,
        5780: 5348927154.035840988159180,
        5790: 5320570055.871142387390137,
        5800: 5292394639.378693580627441,
        5810: 5264399568.981787681579590,
        5820: 5236583519.842663764953613,
        5830: 5208945177.773694992065430,
        5840: 5181483239.149209976196289,
        5850: 5154196410.818001747131348,
        5860: 5127083410.016494750976562,
        5870: 5100142964.282542228698730,
        5880: 5073373811.369918823242188,
        5890: 5046774699.163447380065918,
        5900: 5020344385.594768524169922,
        5910: 4994081638.558780670166016,
        5920: 4967985235.830699920654297,
        5930: 4942053964.983787536621094,
        5940: 4916286623.307682037353516,
        5950: 4890682017.727416038513184,
        5960: 4865238964.723015785217285,
        5970: 4839956290.249767303466797,
        5980: 4814832829.659088134765625,
        5990: 4789867427.620042800903320,
        6000: 4765058938.041453361511230,
        6010: 4740406223.994654655456543,
        6020: 4715908157.636839866638184,
        6030: 4691563620.135028839111328,
        6040: 4667371501.590660095214844,
        6050: 4643330700.964741706848145,
        6060: 4619440126.003652572631836,
        6070: 4595698693.165505409240723,
        6080: 4572105327.547136306762695,
        6090: 4548658962.811637878417969,
        6100: 4525358541.116539001464844,
        6110: 4502203013.042508125305176,
        6120: 4479191337.522690773010254,
        6130: 4456322481.772575378417969,
        6140: 4433595421.220464706420898,
        6150: 4411009139.438508987426758,
        6160: 4388562628.074290275573730,
        6170: 4366254886.782989501953125,
        6180: 4344084923.160103797912598,
        6190: 4322051752.674703598022461,
        6200: 4300154398.603272438049316,
        6210: 4278391891.964068412780762,
        6220: 4256763271.452026367187500,
        6230: 4235267583.374231815338135,
        6240: 4213903881.585897445678711,
        6250: 4192671227.426893234252930,
        6260: 4171568689.658786773681641,
        6270: 4150595344.402445316314697,
        6280: 4129750275.076105594635010,
        6290: 4109032572.334009647369385,
        6300: 4088441334.005549430847168,
        6310: 4067975665.034879684448242,
        6320: 4047634677.421091556549072,
        6330: 4027417490.158865451812744,
        6340: 4007323229.179624557495117,
        6350: 3987351027.293179035186768,
        6360: 3967500024.129887580871582,
        6370: 3947769366.083271980285645,
        6380: 3928158206.253151893615723,
        6390: 3908665704.389244079589844,
        6400: 3889291026.835232734680176,
        6410: 3870033346.473336696624756,
        6420: 3850891842.669329643249512,
        6430: 3831865701.218036174774170,
        6440: 3812954114.289291381835938,
        6450: 3794156280.374360084533691,
        6460: 3775471404.232811450958252,
        6470: 3756898696.839848518371582,
        6480: 3738437375.334095954895020,
        6490: 3720086662.965817928314209,
        6500: 3701845789.045594692230225,
        6510: 3683713988.893426418304443,
        6520: 3665690503.788291454315186,
        6530: 3647774580.918110847473145,
        6540: 3629965473.330170631408691,
        6550: 3612262439.881945610046387,
        6560: 3594664745.192370891571045,
        6570: 3577171659.593506813049316,
        6580: 3559782459.082633018493652,
        6590: 3542496425.274762630462646,
        6600: 3525312845.355553150177002,
        6610: 3508231012.034624099731445,
        6620: 3491250223.499289512634277,
        6630: 3474369783.368673801422119,
        6640: 3457589000.648233890533447,
        6650: 3440907189.684679985046387,
        6660: 3424323670.121267795562744,
        6670: 3407837766.853491783142090,
        6680: 3391448809.985163211822510,
        6690: 3375156134.784857749938965,
        6700: 3358959081.642747879028320,
        6710: 3342856996.027810096740723,
        6720: 3326849228.445397377014160,
        6730: 3310935134.395184040069580,
        6740: 3295114074.329480171203613,
        6750: 3279385413.611890316009521,
        6760: 3263748522.476350784301758,
        6770: 3248202775.986517906188965,
        6780: 3232747553.995494365692139,
        6790: 3217382241.105926513671875,
        6800: 3202106226.630435466766357,
        6810: 3186918904.552398204803467,
        6820: 3171819673.487058162689209,
        6830: 3156807936.642998695373535,
        6840: 3141883101.783920764923096,
        6850: 3127044581.190777301788330,
        6860: 3112291791.624224662780762,
        6870: 3097624154.287404060363770,
        6880: 3083041094.789050102233887,
        6890: 3068542043.106917858123779,
        6900: 3054126433.551525115966797,
        6910: 3039793704.730217456817627,
        6920: 3025543299.511539936065674,
        6930: 3011374664.989924907684326,
        6940: 2997287252.450680255889893,
        6950: 2983280517.335290431976318,
        6960: 2969353919.207015991210938,
        6970: 2955506921.716792583465576,
        6980: 2941738992.569427013397217,
        6990: 2928049603.490088939666748,
        7000: 2914438230.191099166870117,
        7010: 2900904352.338996887207031,
        7020: 2887447453.521899223327637,
        7030: 2874067021.217151641845703,
        7040: 2860762546.759247303009033,
        7050: 2847533525.308043479919434,
        7060: 2834379455.817233085632324,
        7070: 2821299841.003110885620117,
        7080: 2808294187.313599109649658,
        7090: 2795362004.897554874420166,
        7100: 2782502807.574327945709229,
        7110: 2769716112.803599834442139,
        7120: 2757001441.655478477478027,
        7130: 2744358318.780856132507324,
        7140: 2731786272.382020473480225,
        7150: 2719284834.183528423309326,
        7160: 2706853539.403329372406006,
        7170: 2694491926.724141120910645,
        7180: 2682199538.265073776245117,
        7190: 2669975919.553505420684814,
        7200: 2657820619.497194766998291,
        7210: 2645733190.356643676757812,
        7220: 2633713187.717698097229004,
        7230: 2621760170.464383602142334,
        7240: 2609873700.751985073089600,
        7250: 2598053343.980352878570557,
        7260: 2586298668.767445564270020,
        7270: 2574609246.923100948333740,
        7280: 2562984653.423036098480225,
        7290: 2551424466.383074283599854,
        7300: 2539928267.033591270446777,
        7310: 2528495639.694191455841064,
        7320: 2517126171.748596191406250,
        7330: 2505819453.619756698608398,
        7340: 2494575078.745174407958984,
        7350: 2483392643.552453041076660,
        7360: 2472271747.435034751892090,
        7370: 2461211992.728177070617676,
        7380: 2450212984.685116291046143,
        7390: 2439274331.453448295593262,
        7400: 2428395644.051713466644287,
        7410: 2417576536.346179485321045,
        7420: 2406816625.027827739715576,
        7430: 2396115529.589543342590332,
        7440: 2385472872.303500175476074,
        7450: 2374888278.198735237121582,
        7460: 2364361375.038922786712646,
        7470: 2353891793.300351619720459,
        7480: 2343479166.150064468383789,
        7490: 2333123129.424220085144043,
        7500: 2322823321.606617450714111,
        7510: 2312579383.807414531707764,
        7520: 2302390959.742033958435059,
        7530: 2292257695.710248947143555,
        7540: 2282179240.575443267822266,
        7550: 2272155245.744057178497314,
        7560: 2262185365.145211219787598,
        7570: 2252269255.210504055023193,
        7580: 2242406574.853980541229248,
        7590: 2232596985.452279090881348,
        7600: 2222840150.824943065643311,
        7610: 2213135737.214911937713623,
        7620: 2203483413.269168376922607,
        7630: 2193882850.019559860229492,
        7640: 2184333720.863781452178955,
        7650: 2174835701.546526908874512,
        7660: 2165388470.140799045562744,
        7670: 2155991707.029373168945312,
        7680: 2146645094.886435508728027,
        7690: 2137348318.659365415573120,
        7700: 2128101065.550680637359619,
        7710: 2118903025.000137567520142,
        7720: 2109753888.666980504989624,
        7730: 2100653350.412349462509155,
        7740: 2091601106.281831741333008,
        7750: 2082596854.488169670104980,
        7760: 2073640295.394109964370728,
        7770: 2064731131.495408773422241,
        7780: 2055869067.403970479965210,
        7790: 2047053809.831137895584106,
        7800: 2038285067.571128845214844,
        7810: 2029562551.484601974487305,
        7820: 2020885974.482378959655762,
        7830: 2012255051.509286880493164,
        7840: 2003669499.528160572052002,
        7850: 1995129037.503959417343140,
        7860: 1986633386.388033390045166,
        7870: 1978182269.102521181106567,
        7880: 1969775410.524878025054932,
        7890: 1961412537.472533226013184,
        7900: 1953093378.687688350677490,
        7910: 1944817664.822232007980347,
        7920: 1936585128.422792196273804,
        7930: 1928395503.915910005569458,
        7940: 1920248527.593343019485474,
        7950: 1912143937.597492456436157,
        7960: 1904081473.906951427459717,
        7970: 1896060878.322178840637207,
        7980: 1888081894.451292037963867,
        7990: 1880144267.695983886718750,
        8000: 1872247745.237555742263794,
        8010: 1864392076.023070812225342,
        8020: 1856577010.751617431640625,
        8030: 1848802301.860700130462646,
        8040: 1841067703.512738227844238,
        8050: 1833372971.581681728363037,
        8060: 1825717863.639733791351318,
        8070: 1818102138.944194793701172,
        8080: 1810525558.424409151077271,
        8090: 1802987884.668830871582031,
        8100: 1795488881.912184953689575,
        8110: 1788028316.022750377655029,
        8120: 1780605954.489743709564209,
        8130: 1773221566.410805940628052,
        8140: 1765874922.479604244232178,
        8150: 1758565794.973525285720825,
        8160: 1751293957.741483449935913,
        8170: 1744059186.191821336746216,
        8180: 1736861257.280321121215820,
        8190: 1729699949.498312950134277,
        8200: 1722575042.860875368118286,
        8210: 1715486318.895145893096924,
        8220: 1708433560.628725290298462,
        8230: 1701416552.578175306320190,
        8240: 1694435080.737620115280151,
        8250: 1687488932.567433118820190,
        8260: 1680577896.983026504516602,
        8270: 1673701764.343731641769409,
        8280: 1666860326.441772699356079,
        8290: 1660053376.491327524185181,
        8300: 1653280709.117689609527588,
        8310: 1646542120.346508741378784,
        8320: 1639837407.593128919601440,
        8330: 1633166369.652017116546631,
        8340: 1626528806.686267852783203,
        8350: 1619924520.217209815979004,
        8360: 1613353313.114086151123047,
        8370: 1606814989.583834409713745,
        8380: 1600309355.160931110382080,
        8390: 1593836216.697342872619629,
        8400: 1587395382.352544069290161,
        8410: 1580986661.583626747131348,
        8420: 1574609865.135485649108887,
        8430: 1568264805.031092643737793,
        8440: 1561951294.561839818954468,
        8450: 1555669148.277976989746094,
        8460: 1549418181.979114294052124,
        8470: 1543198212.704810857772827,
        8480: 1537009058.725240230560303,
        8490: 1530850539.531933069229126,
        8500: 1524722475.828592538833618,
        8510: 1518624689.521988391876221,
        8520: 1512557003.712924480438232,
        8530: 1506519242.687284708023071,
        8540: 1500511231.907146215438843,
        8550: 1494532798.001967906951904,
        8560: 1488583768.759855985641479,
        8570: 1482663973.118891239166260,
        8580: 1476773241.158538341522217,
        8590: 1470911404.091118097305298,
        8600: 1465078294.253351926803589,
        8610: 1459273745.097976446151733,
        8620: 1453497591.185422658920288,
        8630: 1447749668.175572395324707,
        8640: 1442029812.819567918777466,
        8650: 1436337862.951701879501343,
        8660: 1430673657.481366634368896,
        8670: 1425037036.385068893432617,
        8680: 1419427840.698511838912964,
        8690: 1413845912.508741140365601,
        8700: 1408291094.946354389190674,
        8710: 1402763232.177772521972656,
        8720: 1397262169.397579431533813,
        8730: 1391787752.820914983749390,
        8740: 1386339829.675938606262207,
        8750: 1380918248.196346759796143,
        8760: 1375522857.613959074020386,
        8770: 1370153508.151353597640991,
        8780: 1364810051.014575004577637,
        8790: 1359492338.385888338088989,
        8800: 1354200223.416604280471802,
        8810: 1348933560.219948530197144,
        8820: 1343692203.864002704620361,
        8830: 1338476010.364691734313965,
        8840: 1333284836.678833961486816,
        8850: 1328118540.697244167327881,
        8860: 1322976981.237891674041748,
        8870: 1317860018.039118528366089,
        8880: 1312767511.752904176712036,
        8890: 1307699323.938193798065186,
        8900: 1302655317.054270029067993,
        8910: 1297635354.454185009002686,
        8920: 1292639300.378247261047363,
        8930: 1287667019.947549581527710,
        8940: 1282718379.157561540603638,
        8950: 1277793244.871764421463013,
        8960: 1272891484.815343379974365,
        8970: 1268012967.568925619125366,
        8980: 1263157562.562368392944336,
        8990: 1258325140.068601846694946,
        9000: 1253515571.197514772415161,
        9010: 1248728727.889893293380737,
        9020: 1243964482.911406278610229,
        9030: 1239222709.846638679504395,
        9040: 1234503283.093172073364258,
        9050: 1229806077.855714797973633,
        9060: 1225130970.140273571014404,
        9070: 1220477836.748378515243530,
        9080: 1215846555.271347761154175,
        9090: 1211237004.084600448608398,
        9100: 1206649062.342013597488403,
        9110: 1202082609.970326662063599,
        9120: 1197537527.663587093353271,
        9130: 1193013696.877640008926392,
        9140: 1188510999.824665546417236,
        9150: 1184029319.467752218246460,
        9160: 1179568539.515519857406616,
        9170: 1175128544.416784048080444,
        9180: 1170709219.355257272720337,
        9190: 1166310450.244297266006470,
        9200: 1161932123.721696376800537,
        9210: 1157574127.144509077072144,
        9220: 1153236348.583922624588013,
        9230: 1148918676.820166826248169,
        9240: 1144621001.337464809417725,
        9250: 1140343212.319022178649902,
        9260: 1136085200.642056703567505,
        9270: 1131846857.872865676879883,
        9280: 1127628076.261934280395508,
        9290: 1123428748.739079475402832,
        9300: 1119248768.908633708953857,
        9310: 1115088031.044664621353149,
        9320: 1110946430.086236000061035,
        9330: 1106823861.632699251174927,
        9340: 1102720221.939029932022095,
        9350: 1098635407.911191463470459,
        9360: 1094569317.101542711257935,
        9370: 1090521847.704276800155640,
        9380: 1086492898.550899267196655,
        9390: 1082482369.105735540390015,
        9400: 1078490159.461479663848877,
        9410: 1074516170.334773302078247,
        9420: 1070560303.061823606491089,
        9430: 1066622459.594046831130981,
        9440: 1062702542.493755459785461,
        9450: 1058800454.929873585700989,
        9460: 1054916100.673683047294617,
        9470: 1051049384.094610810279846,
        9480: 1047200210.156038761138916,
        9490: 1043368484.411155223846436,
        9500: 1039554112.998830318450928,
        9510: 1035757002.639529466629028,
        9520: 1031977060.631256103515625,
        9530: 1028214194.845523953437805,
        9540: 1024468313.723362445831299,
        9550: 1020739326.271354436874390,
        9560: 1017027142.057698011398315,
        9570: 1013331671.208307385444641,
        9580: 1009652824.402937054634094,
        9590: 1005990512.871336698532104,
        9600: 1002344648.389441251754761,
        9610: 998715143.275580048561096,
        9620: 995101910.386725068092346,
        9630: 991504863.114760518074036,
        9640: 987923915.382786870002747,
        9650: 984358981.641447663307190,
        9660: 980809976.865288734436035,
        9670: 977276816.549142360687256,
        9680: 973759416.704541444778442,
        9690: 970257693.856157660484314,
        9700: 966771565.038271069526672,
        9710: 963300947.791262984275818,
        9720: 959845760.158137679100037,
        9730: 956405920.681068181991577,
        9740: 952981348.397972822189331,
        9750: 949571962.839111804962158,
        9760: 946177684.023714184761047,
        9770: 942798432.456629991531372,
        9780: 939434129.125003695487976,
        9790: 936084695.494978904724121,
        9800: 932750053.508423089981079,
        9810: 929430125.579678535461426,
        9820: 926124834.592340946197510,
        9830: 922834103.896056413650513,
        9840: 919557857.303347587585449,
        9850: 916296019.086462140083313,
        9860: 913048513.974244236946106,
        9870: 909815267.149029374122620,
        9880: 906596204.243566870689392,
        9890: 903391251.337957620620728,
        9900: 900200334.956621885299683,
        9910: 897023382.065286517143250,
        9920: 893860320.067996621131897,
        9930: 890711076.804147481918335,
        9940: 887575580.545538902282715,
        9950: 884453759.993456840515137,
        9960: 881345544.275766253471375,
        9970: 878250862.944037556648254,
        9980: 875169645.970686674118042,
        9990: 872101823.746138095855713,
    },
    5000: {
        10: 0.000000000000000,
        20: 0.000000000000000,
        30: 0.000000000000000,
        40: 0.000000000066449,
        50: 0.000038597687701,
        60: 0.227199686637138,
        70: 99.359958540366620,
        80: 8687.701348124925062,
        90: 262344.854222321824636,
        100: 3790262.780185453128070,
        110: 32197359.716756682842970,
        120: 184348422.564414411783218,
        130: 781511147.779812335968018,
        140: 2622251176.819740295410156,
        150: 7310813379.301067352294922,
        160: 17560673506.944808959960938,
        170: 37355495596.313049316406250,
        180: 71885904020.192413330078125,
        190: 127249248362.554016113281250,
        200: 209965815507.533386230468750,
        210: 326404472526.703796386718750,
        220: 482217548459.913269042968750,
        230: 681866434701.742553710937500,
        240: 928288522250.585937500000000,
        250: 1222724003873.015625000000000,
        260: 1564694926272.392089843750000,
        270: 1952111619606.520263671875000,
        280: 2381473138872.071289062500000,
        290: 2848126857131.949707031250000,
        300: 3346555559183.134277343750000,
        310: 3870666158905.361816406250000,
        320: 4414060841196.302734375000000,
        330: 4970277890013.341796875000000,
        340: 5532995066240.420898437500000,
        350: 6096192864406.664062500000000,
        360: 6654278270641.816406250000000,
        370: 7202171873625.862304687500000,
        380: 7735362522399.223632812500000,
        390: 8249934375727.927734375000000,
        400: 8742571332991.204101562500000,
        410: 9210543636689.166015625000000,
        420: 9651681021262.902343750000000,
        430: 10064336251055.019531250000000,
        440: 10447342313778.720703125000000,
        450: 10799965964060.962890625000000,
        460: 11121859775912.460937500000000,
        470: 11413014381374.892578125000000,
        480: 11673712153465.964843750000000,
        490: 11904483236613.302734375000000,
        500: 12106064534472.861328125000000,
        510: 12279362028244.257812500000000,
        520: 12425416611891.378906250000000,
        530: 12545373487161.810546875000000,
        540: 12640455054190.626953125000000,
        550: 12711937156432.800781250000000,
        560: 12761128485989.890625000000000,
        570: 12789352922088.681640625000000,
        580: 12797934557260.468750000000000,
        590: 12788185159078.791015625000000,
        600: 12761393817184.904296875000000,
        610: 12718818533367.134765625000000,
        620: 12661679524746.468750000000000,
        630: 12591154025150.177734375000000,
        640: 12508372386361.767578125000000,
        650: 12414415298238.335937500000000,
        660: 12310311964027.224609375000000,
        670: 12197039084123.230468750000000,
        680: 12075520517657.367187500000000,
        690: 11946627506484.298828125000000,
        700: 11811179360210.417968750000000,
        710: 11669944513816.888671875000000,
        720: 11523641881168.228515625000000,
        730: 11372942438278.482421875000000,
        740: 11218470979680.794921875000000,
        750: 11060807999673.421875000000000,
        760: 10900491657668.412109375000000,
        770: 10738019793425.453125000000000,
        780: 10573851963691.009765625000000,
        790: 10408411476759.814453125000000,
        800: 10242087405806.607421875000000,
        810: 10075236565571.937500000000000,
        820: 9908185440192.857421875000000,
        830: 9741232052709.107421875000000,
        840: 9574647769103.142578125000000,
        850: 9408679031700.015625000000000,
        860: 9243549018405.449218750000000,
        870: 9079459225639.513671875000000,
        880: 8916590973964.724609375000000,
        890: 8755106836345.098632812500000,
        900: 8595151989733.469726562500000,
        910: 8436855491295.577148437500000,
        920: 8280331481061.893554687500000,
        930: 8125680313171.293945312500000,
        940: 7972989618152.376953125000000,
        950: 7822335298891.998046875000000,
        960: 7673782463079.693359375000000,
        970: 7527386295002.166992187500000,
        980: 7383192869602.831054687500000,
        990: 7241239911726.183593750000000,
        1000: 7101557503441.966796875000000,
        1010: 6964168742295.949218750000000,
        1020: 6829090353267.201171875000000,
        1030: 6696333257130.915039062500000,
        1040: 6565903097833.765625000000000,
        1050: 6437800731389.404296875000000,
        1060: 6312022678696.727539062500000,
        1070: 6188561544575.374023437500000,
        1080: 6067406405203.459960937500000,
        1090: 5948543166032.417968750000000,
        1100: 5831954892145.250976562500000,
        1110: 5717622112917.178710937500000,
        1120: 5605523102733.317382812500000,
        1130: 5495634139416.432617187500000,
        1140: 5387929741919.918945312500000,
        1150: 5282382888746.809570312500000,
        1160: 5178965218465.418945312500000,
        1170: 5077647213605.944335937500000,
        1180: 4978398369140.238281250000000,
        1190: 4881187346669.045898437500000,
        1200: 4785982115367.064453125000000,
        1210: 4692750080666.376953125000000,
        1220: 4601458201592.761718750000000,
        1230: 4512073097607.391601562500000,
        1240: 4424561145747.845703125000000,
        1250: 4338888568807.477050781250000,
        1260: 4255021515240.621093750000000,
        1270: 4172926131432.841308593750000,
        1280: 4092568626930.066894531250000,
        1290: 4013915333178.263671875000000,
        1300: 3936932756285.639160156250000,
        1310: 3861587624282.447753906250000,
        1320: 3787846929318.995117187500000,
        1330: 3715677965210.260253906250000,
        1340: 3645048360705.616210937500000,
        1350: 3575926108834.145019531250000,
        1360: 3508279592650.156250000000000,
        1370: 3442077607679.249023437500000,
        1380: 3377289381342.780761718750000,
        1390: 3313884589617.787109375000000,
        1400: 3251833371169.827636718750000,
        1410: 3191106339178.350585937500000,
        1420: 3131674591057.282714843750000,
        1430: 3073509716258.088378906250000,
        1440: 3016583802328.099609375000000,
        1450: 2960869439383.516113281250000,
        1460: 2906339723144.103027343750000,
        1470: 2852968256665.091308593750000,
        1480: 2800729150891.164550781250000,
        1490: 2749597024147.481933593750000,
        1500: 2699547000673.642089843750000,
        1510: 2650554708297.928222656250000,
        1520: 2602596275341.413574218750000,
        1530: 2555648326834.230468750000000,
        1540: 2509687980119.585937500000000,
        1550: 2464692839914.930175781250000,
        1560: 2420640992893.939453125000000,
        1570: 2377511001847.645019531250000,
        1580: 2335281899478.196777343750000,
        1590: 2293933181874.166992187500000,
        1600: 2253444801712.138671875000000,
        1610: 2213797161225.486816406250000,
        1620: 2174971104977.636230468750000,
        1630: 2136947912473.859863281250000,
        1640: 2099709290642.586914062500000,
        1650: 2063237366214.448242187500000,
        1660: 2027514678024.622070312500000,
        1670: 1992524169261.780029296875000,
        1680: 1958249179684.635742187500000,
        1690: 1924673437825.132812500000000,
        1700: 1891781053195.466552734375000,
        1710: 1859556508514.357666015625000,
        1720: 1827984651966.523925781250000,
        1730: 1797050689507.733398437500000,
        1740: 1766740177226.613769531250000,
        1750: 1737039013773.071289062500000,
        1760: 1707933432862.133544921875000,
        1770: 1679409995860.938720703125000,
        1780: 1651455584465.710449218750000,
        1790: 1624057393474.647460937500000,
        1800: 1597202923661.908691406250000,
        1810: 1570879974757.123535156250000,
        1820: 1545076638534.215332031250000,
        1830: 1519781292012.720458984375000,
        1840: 1494982590774.227783203125000,
        1850: 1470669462396.089599609375000,
        1860: 1446831100004.062255859375000,
        1870: 1423456955945.166015625000000,
        1880: 1400536735581.633544921875000,
        1890: 1378060391206.527587890625000,
        1900: 1356018116081.239990234375000,
        1910: 1334400338594.879882812500000,
        1920: 1313197716545.245849609375000,
        1930: 1292401131540.888916015625000,
        1940: 1272001683523.556640625000000,
        1950: 1251990685410.151611328125000,
        1960: 1232359657853.137695312500000,
        1970: 1213100324118.239257812500000,
        1980: 1194204605078.088623046875000,
        1990: 1175664614320.442871093750000,
        2000: 1157472653369.423339843750000,
        2010: 1139621207018.199951171875000,
        2020: 1122102938771.434326171875000,
        2030: 1104910686395.765869140625000,
        2040: 1088037457576.552246093750000,
        2050: 1071476425679.036987304687500,
        2060: 1055220925612.089477539062500,
        2070: 1039264449792.628662109375000,
        2080: 1023600644208.823974609375000,
        2090: 1008223304580.152343750000000,
        2100: 993126372612.384521484375000,
        2110: 978303932345.556884765625000,
        2120: 963750206593.005493164062500,
        2130: 949459553469.525390625000000,
        2140: 935426463006.738525390625000,
        2150: 921645553853.755859375000000,
        2160: 908111570061.239135742187500,
        2170: 894819377946.984008789062500,
        2180: 881763963041.161865234375000,
        2190: 868940427109.385986328125000,
        2200: 856343985251.773803710937500,
        2210: 843969963076.227783203125000,
        2220: 831813793944.158691406250000,
        2230: 819871016286.913452148437500,
        2240: 808137270991.193847656250000,
        2250: 796608298851.790527343750000,
        2260: 785279938089.966186523437500,
        2270: 774148121935.875122070312500,
        2280: 763208876273.417236328125000,
        2290: 752458317345.967041015625000,
        2300: 741892649521.445312500000000,
        2310: 731508163115.229614257812500,
        2320: 721301232269.439697265625000,
        2330: 711268312887.146728515625000,
        2340: 701405940620.111572265625000,
        2350: 691710728908.666503906250000,
        2360: 682179367072.394287109375000,
        2370: 672808618450.295166015625000,
        2380: 663595318589.141967773437500,
        2390: 654536373478.783081054687500,
        2400: 645628757833.156127929687500,
        2410: 636869513415.818847656250000,
        2420: 628255747408.823730468750000,
        2430: 619784630823.804931640625000,
        2440: 611453396954.155029296875000,
        2450: 603259339867.213500976562500,
        2460: 595199812935.404418945312500,
        2470: 587272227405.293579101562500,
        2480: 579474051003.560668945312500,
        2490: 571802806578.902099609375000,
        2500: 564256070778.915283203125000,
        2510: 556831472761.027099609375000,
        2520: 549526692936.565673828125000,
        2530: 542339461747.090209960937500,
        2540: 535267558472.116455078125000,
        2550: 528308810067.404663085937500,
        2560: 521461090032.990295410156250,
        2570: 514722317310.167175292968750,
        2580: 508090455206.646728515625000,
        2590: 501563510349.143371582031250,
        2600: 495139531662.650573730468750,
        2610: 488816609375.698547363281250,
        2620: 482592874050.895629882812500,
        2630: 476466495640.083618164062500,
        2640: 470435682563.440734863281250,
        2650: 464498680811.905395507812500,
        2660: 458653773072.285949707031250,
        2670: 452899277874.462951660156250,
        2680: 447233548760.084289550781250,
        2690: 441654973472.188232421875000,
        2700: 436161973165.194396972656250,
        2710: 430753001634.719543457031250,
        2720: 425426544566.693115234375000,
        2730: 420181118805.255676269531250,
        2740: 415015271638.947387695312500,
        2750: 409927580104.695617675781250,
        2760: 404916650309.132141113281250,
        2770: 399981116766.781127929687500,
        2780: 395119641754.669555664062500,
        2790: 390330914682.928283691406250,
        2800: 385613651480.959472656250000,
        2810: 380966593998.759765625000000,
        2820: 376388509422.999511718750000,
        2830: 371878189707.472229003906250,
        2840: 367434451017.529907226562500,
        2850: 363056133188.144653320312500,
        2860: 358742099195.232421875000000,
        2870: 354491234639.894897460937500,
        2880: 350302447245.239257812500000,
        2890: 346174666365.450195312500000,
        2900: 342106842506.788330078125000,
        2910: 338097946860.209899902343750,
        2920: 334146970845.302551269531250,
        2930: 330252925665.241149902343750,
        2940: 326414841872.482116699218750,
        2950: 322631768944.910522460937500,
        2960: 318902774872.177307128906250,
        2970: 315226945751.956176757812500,
        2980: 311603385395.869140625000000,
        2990: 308031214944.826660156250000,
        3000: 304509572493.543701171875000,
        3010: 301037612723.993652343750000,
        3020: 297614506547.571594238281250,
        3030: 294239440755.742980957031250,
        3040: 290911617678.960144042968750,
        3050: 287630254853.637390136718750,
        3060: 284394584696.975524902343750,
        3070: 281203854189.440124511718750,
        3080: 278057324564.694519042968750,
        3090: 274954271006.801025390625000,
        3100: 271893982354.505584716796875,
        3110: 268875760812.426605224609375,
        3120: 265898921668.970764160156250,
        3130: 262962793020.811798095703125,
        3140: 260066715503.761016845703125,
        3150: 257210042029.872039794921875,
        3160: 254392137530.623687744140625,
        3170: 251612378706.025451660156250,
        3180: 248870153779.501464843750000,
        3190: 246164862258.405120849609375,
        3200: 243495914700.027465820312500,
        3210: 240862732482.957946777343750,
        3220: 238264747583.669555664062500,
        3230: 235701402358.195556640625000,
        3240: 233172149328.772155761718750,
        3250: 230676450975.326354980468750,
        3260: 228213779531.685974121093750,
        3270: 225783616786.398681640625000,
        3280: 223385453888.045806884765625,
        3290: 221018791154.939910888671875,
        3300: 218683137889.098358154296875,
        3310: 216378012194.390747070312500,
        3320: 214102940798.755645751953125,
        3330: 211857458880.389007568359375,
        3340: 209641109897.806884765625000,
        3350: 207453445423.688995361328125,
        3360: 205294024982.410980224609375,
        3370: 203162415891.176757812500000,
        3380: 201058193104.664062500000000,
        3390: 198980939063.096282958984375,
        3400: 196930243543.662536621093750,
        3410: 194905703515.201232910156250,
        3420: 192906922996.072174072265625,
        3430: 190933512915.138000488281250,
        3440: 188985090975.783325195312500,
        3450: 187061281522.898010253906250,
        3460: 185161715412.753662109375000,
        3470: 183286029885.705566406250000,
        3480: 181433868441.652160644531250,
        3490: 179604880718.188049316406250,
        3500: 177798722371.385620117187500,
        3510: 176015054959.144317626953125,
        3520: 174253545827.046020507812500,
        3530: 172513867996.659790039062500,
        3540: 170795700056.235717773437500,
        3550: 169098726053.734710693359375,
        3560: 167422635392.137878417968750,
        3570: 165767122726.982879638671875,
        3580: 164131887866.075897216796875,
        3590: 162516635671.328613281250000,
        3600: 160921075962.669830322265625,
        3610: 159344923423.985595703125000,
        3620: 157787897511.039245605468750,
        3630: 156249722361.327392578125000,
        3640: 154730126705.825683593750000,
        3650: 153228843782.582458496093750,
        3660: 151745611252.116638183593750,
        3670: 150280171114.579925537109375,
        3680: 148832269628.641754150390625,
        3690: 147401657232.058654785156250,
        3700: 145988088463.889648437500000,
        3710: 144591321888.319335937500000,
        3720: 143211120020.053863525390625,
        3730: 141847249251.253417968750000,
        3740: 140499479779.965515136718750,
        3750: 139167585540.027069091796875,
        3760: 137851344132.401916503906250,
        3770: 136550536757.920196533203125,
        3780: 135264948151.389373779296875,
        3790: 133994366517.046630859375000,
        3800: 132738583465.321090698242188,
        3810: 131497393950.878768920898438,
        3820: 130270596211.919891357421875,
        3830: 129057991710.701492309570312,
        3840: 127859385075.259323120117188,
        3850: 126674584042.300231933593750,
        3860: 125503399401.241027832031250,
        3870: 124345644939.368347167968750,
        3880: 123201137388.093795776367188,
        3890: 122069696370.282104492187500,
        3900: 120951144348.626922607421875,
        3910: 119845306575.052551269531250,
        3920: 118752011041.119445800781250,
        3930: 117671088429.410629272460938,
        3940: 116602372065.878280639648438,
        3950: 115545697873.129547119140625,
        3960: 114500904324.632003784179688,
        3970: 113467832399.817367553710938,
        3980: 112446325540.065475463867188,
        3990: 111436229605.548782348632812,
        4000: 110437392832.919525146484375,
        4010: 109449665793.820846557617188,
        4020: 108472901354.204498291015625,
        4030: 107506954634.438247680664062,
        4040: 106551682970.185653686523438,
        4050: 105606945874.041687011718750,
        4060: 104672604997.909164428710938,
        4070: 103748524096.098617553710938,
        4080: 102834568989.138122558593750,
        4090: 101930607528.276306152343750,
        4100: 101036509560.665878295898438,
        4110: 100152146895.210906982421875,
        4120: 99277393269.066543579101562,
        4130: 98412124314.775634765625000,
        4140: 97556217528.029617309570312,
        4150: 96709552236.040740966796875,
        4160: 95872009566.512283325195312,
        4170: 95043472417.195251464843750,
        4180: 94223825426.018280029296875,
        4190: 93412954941.780364990234375,
        4200: 92610748995.392593383789062,
        4210: 91817097271.659667968750000,
        4220: 91031891081.589141845703125,
        4230: 90255023335.217300415039062,
        4240: 89486388514.941406250000000,
        4250: 88725882649.348144531250000,
        4260: 87973403287.527526855468750,
        4270: 87228849473.862915039062500,
        4280: 86492121723.287155151367188,
        4290: 85763121996.995025634765625,
        4300: 85041753678.603713989257812,
        4310: 84327921550.751129150390625,
        4320: 83621531772.123886108398438,
        4330: 82922491854.906005859375000,
        4340: 82230710642.639968872070312,
        4350: 81546098288.491653442382812,
        4360: 80868566233.911163330078125,
        4370: 80198027187.682083129882812,
        4380: 79534395105.349822998046875,
        4390: 78877585169.023635864257812,
        4400: 78227513767.543273925781250,
        4410: 77584098477.003540039062500,
        4420: 76947258041.629760742187500,
        4430: 76316912354.996826171875000,
        4440: 75692982441.585433959960938,
        4450: 75075390438.668762207031250,
        4460: 74464059578.522567749023438,
        4470: 73858914170.953033447265625,
        4480: 73259879586.135879516601562,
        4490: 72666882237.760391235351562,
        4500: 72079849566.472640991210938,
        4510: 71498710023.611801147460938,
        4520: 70923393055.234436035156250,
        4530: 70353829086.420333862304688,
        4540: 69789949505.854904174804688,
        4550: 69231686650.682891845703125,
        4560: 68678973791.627487182617188,
        4570: 68131745118.370613098144531,
        4580: 67589935725.188560485839844,
        4590: 67053481596.838523864746094,
        4600: 66522319594.690963745117188,
        4610: 65996387443.103134155273438,
        4620: 65475623716.029304504394531,
        4630: 64959967823.863052368164062,
        4640: 64449360000.506698608398438,
        4650: 63943741290.664772033691406,
        4660: 63443053537.355766296386719,
        4670: 62947239369.639244079589844,
        4680: 62456242190.553489685058594,
        4690: 61970006165.259925842285156,
        4700: 61488476209.390556335449219,
        4710: 61011597977.594261169433594,
        4720: 60539317852.278701782226562,
        4730: 60071582932.543380737304688,
        4740: 59608341023.301185607910156,
        4750: 59149540624.584114074707031,
        4760: 58695130921.030364990234375,
        4770: 58245061771.548706054687500,
        4780: 57799283699.157546997070312,
        4790: 57357747880.994964599609375,
        4800: 56920406138.496643066406250,
        4810: 56487210927.738845825195312,
        4820: 56058115329.942756652832031,
        4830: 55633073042.138015747070312,
        4840: 55212038367.981925964355469,
        4850: 54794966208.731529235839844,
        4860: 54381812054.366104125976562,
        4870: 53972531974.856872558593750,
        4880: 53567082611.581459045410156,
        4890: 53165421168.880554199218750,
        4900: 52767505405.753784179687500,
        4910: 52373293627.692817687988281,
        4920: 51982744678.648544311523438,
        4930: 51595817933.130683898925781,
        4940: 51212473288.436553955078125,
        4950: 50832671157.007492065429688,
        4960: 50456372458.909843444824219,
        4970: 50083538614.439018249511719,
        4980: 49714131536.843811035156250,
        4990: 49348113625.168983459472656,
        5000: 48985447757.214271545410156,
        5010: 48626097282.607421875000000,
        5020: 48270026015.989128112792969,
        5030: 47917198230.308357238769531,
        5040: 47567578650.225433349609375,
        5050: 47221132445.621673583984375,
        5060: 46877825225.212951660156250,
        5070: 46537623030.266044616699219,
        5080: 46200492328.415313720703125,
        5090: 45866400007.578506469726562,
        5100: 45535313369.969482421875000,
        5110: 45207200126.206375122070312,
        5120: 44882028389.513565063476562,
        5130: 44559766670.015563964843750,
        5140: 44240383869.121498107910156,
        5150: 43923849273.998390197753906,
        5160: 43610132552.131912231445312,
        5170: 43299203745.972526550292969,
        5180: 42991033267.666511535644531,
        5190: 42685591893.869285583496094,
        5200: 42382850760.640525817871094,
        5210: 42082781358.419021606445312,
        5220: 41785355527.076293945312500,
        5230: 41490545451.047264099121094,
        5240: 41198323654.537162780761719,
        5250: 40908662996.802604675292969,
        5260: 40621536667.506393432617188,
        5270: 40336918182.144050598144531,
        5280: 40054781377.541572570800781,
        5290: 39775100407.422355651855469,
        5300: 39497849738.042808532714844,
        5310: 39223004143.895294189453125,
        5320: 38950538703.476844787597656,
        5330: 38680428795.123451232910156,
        5340: 38412650092.907455444335938,
        5350: 38147178562.598510742187500,
        5360: 37883990457.685791015625000,
        5370: 37623062315.461105346679688,
        5380: 37364370953.161643981933594,
        5390: 37107893464.171401977539062,
        5400: 36853607214.280265808105469,
        5410: 36601489837.999877929687500,
        5420: 36351519234.935203552246094,
        5430: 36103673566.210952758789062,
        5440: 35857931250.951896667480469,
        5450: 35614270962.816345214843750,
        5460: 35372671626.581512451171875,
        5470: 35133112414.780372619628906,
        5480: 34895572744.388870239257812,
        5490: 34660032273.562622070312500,
        5500: 34426470898.422515869140625,
        5510: 34194868749.888248443603516,
        5520: 33965206190.558883666992188,
        5530: 33737463811.640010833740234,
        5540: 33511622429.916404724121094,
        5550: 33287663084.769580841064453,
        5560: 33065567035.239509582519531,
        5570: 32845315757.129791259765625,
        5580: 32626890940.155479431152344,
        5590: 32410274485.132884979248047,
        5600: 32195448501.210941314697266,
        5610: 31982395303.142818450927734,
        5620: 31771097408.598041534423828,
        5630: 31561537535.513439178466797,
        5640: 31353698599.483280181884766,
        5650: 31147563711.187175750732422,
        5660: 30943116173.855545043945312,
        5670: 30740339480.772041320800781,
        5680: 30539217312.812202453613281,
        5690: 30339733536.017623901367188,
        5700: 30141872199.205562591552734,
        5710: 29945617531.612918853759766,
        5720: 29750953940.574195861816406,
        5730: 29557866009.233051300048828,
        5740: 29366338494.286666870117188,
        5750: 29176356323.762573242187500,
        5760: 28987904594.827381134033203,
        5770: 28800968571.626926422119141,
        5780: 28615533683.157146453857422,
        5790: 28431585521.165615081787109,
        5800: 28249109838.082710266113281,
        5810: 28068092544.982513427734375,
        5820: 27888519709.572456359863281,
        5830: 27710377554.211685180664062,
        5840: 27533652453.957344055175781,
        5850: 27358330934.638614654541016,
        5860: 27184399670.957958221435547,
        5870: 27011845484.619091033935547,
        5880: 26840655342.481281280517578,
        5890: 26670816354.739784240722656,
        5900: 26502315773.131649017333984,
        5910: 26335140989.166763305664062,
        5920: 26169279532.383605957031250,
        5930: 26004719068.629497528076172,
        5940: 25841447398.364692687988281,
        5950: 25679452454.990303039550781,
        5960: 25518722303.199249267578125,
        5970: 25359245137.350345611572266,
        5980: 25201009279.864810943603516,
        5990: 25044003179.645061492919922,
        6000: 24888215410.515327453613281,
        6010: 24733634669.683845520019531,
        6020: 24580249776.226245880126953,
        6030: 24428049669.589763641357422,
        6040: 24277023408.118217468261719,
        6050: 24127160167.596931457519531,
        6060: 23978449239.817882537841797,
        6070: 23830880031.164344787597656,
        6080: 23684442061.214923858642578,
        6090: 23539124961.366668701171875,
        6100: 23394918473.476844787597656,
        6110: 23251812448.523353576660156,
        6120: 23109796845.283222198486328,
        6130: 22968861729.029071807861328,
        6140: 22828997270.243255615234375,
        6150: 22690193743.349380493164062,
        6160: 22552441525.460987091064453,
        6170: 22415731095.147060394287109,
        6180: 22280053031.214237213134766,
        6190: 22145398011.505363464355469,
        6200: 22011756811.714111328125000,
        6210: 21879120304.215694427490234,
        6220: 21747479456.912990570068359,
        6230: 21616825332.098289489746094,
        6240: 21487149085.330150604248047,
        6250: 21358441964.325263977050781,
        6260: 21230695307.865047454833984,
        6270: 21103900544.716823577880859,
        6280: 20978049192.569236755371094,
        6290: 20853132856.981872558593750,
        6300: 20729143230.348800659179688,
        6310: 20606072090.875644683837891,
        6320: 20483911301.570369720458984,
        6330: 20362652809.247257232666016,
        6340: 20242288643.544006347656250,
        6350: 20122810915.951782226562500,
        6360: 20004211818.857975006103516,
        6370: 19886483624.601467132568359,
        6380: 19769618684.540355682373047,
        6390: 19653609428.131820678710938,
        6400: 19538448362.023925781250000,
        6410: 19424128069.159404754638672,
        6420: 19310641207.890937805175781,
        6430: 19197980511.108100891113281,
        6440: 19086138785.375534057617188,
        6450: 18975108910.082290649414062,
        6460: 18864883836.602226257324219,
        6470: 18755456587.465206146240234,
        6480: 18646820255.539100646972656,
        6490: 18538968003.222133636474609,
        6500: 18431893061.645832061767578,
        6510: 18325588729.888092041015625,
        6520: 18220048374.196361541748047,
        6530: 18115265427.220836639404297,
        6540: 18011233387.257415771484375,
        6550: 17907945817.500297546386719,
        6560: 17805396345.304286956787109,
        6570: 17703578661.456222534179688,
        6580: 17602486519.455936431884766,
        6590: 17502113734.806224822998047,
        6600: 17402454184.311866760253906,
        6610: 17303501805.387496948242188,
        6620: 17205250595.374267578125000,
        6630: 17107694610.865137100219727,
        6640: 17010827967.038686752319336,
        6650: 16914644837.001316070556641,
        6660: 16819139451.137744903564453,
        6670: 16724306096.469625473022461,
        6680: 16630139116.022264480590820,
        6690: 16536632908.199291229248047,
        6700: 16443781926.165086746215820,
        6710: 16351580677.234981536865234,
        6720: 16260023722.273082733154297,
        6730: 16169105675.097549438476562,
        6740: 16078821201.893365859985352,
        6750: 15989165020.632305145263672,
        6760: 15900131900.500169754028320,
        6770: 15811716661.331138610839844,
        6780: 15723914173.049060821533203,
        6790: 15636719355.115730285644531,
        6800: 15550127175.985933303833008,
        6810: 15464132652.569210052490234,
        6820: 15378730849.698270797729492,
        6830: 15293916879.603967666625977,
        6840: 15209685901.396633148193359,
        6850: 15126033120.553920745849609,
        6860: 15042953788.414762496948242,
        6870: 14960443201.679636001586914,
        6880: 14878496701.916913986206055,
        6890: 14797109675.075181961059570,
        6900: 14716277551.001571655273438,
        6910: 14635995802.965919494628906,
        6920: 14556259947.190710067749023,
        6930: 14477065542.386730194091797,
        6940: 14398408189.294363021850586,
        6950: 14320283530.230419158935547,
        6960: 14242687248.640449523925781,
        6970: 14165615068.656476974487305,
        6980: 14089062754.660060882568359,
        6990: 14013026110.850576400756836,
        7000: 13937500980.818801879882812,
        7010: 13862483247.125474929809570,
        7020: 13787968830.885017395019531,
        7030: 13713953691.354204177856445,
        7040: 13640433825.525787353515625,
        7050: 13567405267.726915359497070,
        7060: 13494864089.222393035888672,
        7070: 13422806397.822673797607422,
        7080: 13351228337.496467590332031,
        7090: 13280126087.988023757934570,
        7100: 13209495864.438899993896484,
        7110: 13139333917.014244079589844,
        7120: 13069636530.533468246459961,
        7130: 13000400024.105392456054688,
        7140: 12931620750.767528533935547,
        7150: 12863295097.129770278930664,
        7160: 12795419483.022211074829102,
        7170: 12727990361.147121429443359,
        7180: 12661004216.734992980957031,
        7190: 12594457567.204673767089844,
        7200: 12528346961.827413558959961,
        7210: 12462668981.394893646240234,
        7220: 12397420237.891138076782227,
        7230: 12332597374.168220520019531,
        7240: 12268197063.625782012939453,
        7250: 12204216009.894275665283203,
        7260: 12140650946.521881103515625,
        7270: 12077498636.665075302124023,
        7280: 12014755872.782787322998047,
        7290: 11952419476.334083557128906,
        7300: 11890486297.479362487792969,
        7310: 11828953214.785018920898438,
        7320: 11767817134.931489944458008,
        7330: 11707074992.424673080444336,
        7340: 11646723749.310667037963867,
        7350: 11586760394.893836975097656,
        7360: 11527181945.458024978637695,
        7370: 11467985443.991048812866211,
        7380: 11409167959.912309646606445,
        7390: 11350726588.803518295288086,
        7400: 11292658452.142520904541016,
        7410: 11234960697.040155410766602,
        7420: 11177630495.980079650878906,
        7430: 11120665046.561586380004883,
        7440: 11064061571.245389938354492,
        7450: 11007817317.102167129516602,
        7460: 10951929555.564102172851562,
        7470: 10896395582.179149627685547,
        7480: 10841212716.368103027343750,
        7490: 10786378301.184419631958008,
        7500: 10731889703.076753616333008,
        7510: 10677744311.654159545898438,
        7520: 10623939539.453908920288086,
        7530: 10570472821.712017059326172,
        7540: 10517341616.136217117309570,
        7550: 10464543402.681568145751953,
        7560: 10412075683.328552246093750,
        7570: 10359935981.863660812377930,
        7580: 10308121843.662422180175781,
        7590: 10256630835.474843978881836,
        7600: 10205460545.213298797607422,
        7610: 10154608581.742679595947266,
        7620: 10104072574.673000335693359,
        7630: 10053850174.154211044311523,
        7640: 10003939050.673299789428711,
        7650: 9954336894.853719711303711,
        7660: 9905041417.256961822509766,
        7670: 9856050348.186315536499023,
        7680: 9807361437.492849349975586,
        7690: 9758972454.383487701416016,
        7700: 9710881187.231241226196289,
        7710: 9663085443.387472152709961,
        7720: 9615583048.996273040771484,
        7730: 9568371848.810850143432617,
        7740: 9521449706.011945724487305,
        7750: 9474814502.028217315673828,
        7760: 9428464136.358602523803711,
        7770: 9382396526.396633148193359,
        7780: 9336609607.256629943847656,
        7790: 9291101331.601842880249023,
        7800: 9245869669.474397659301758,
        7810: 9200912608.127157211303711,
        7820: 9156228151.857362747192383,
        7830: 9111814321.842090606689453,
        7840: 9067669155.975517272949219,
        7850: 9023790708.707895278930664,
        7860: 8980177050.886306762695312,
        7870: 8936826269.597143173217773,
        7880: 8893736468.010225296020508,
        7890: 8850905765.224687576293945,
        7900: 8808332296.116455078125000,
        7910: 8766014211.187364578247070,
        7920: 8723949676.415956497192383,
        7930: 8682136873.109786987304688,
        7940: 8640573997.759382247924805,
        7950: 8599259261.893756866455078,
        7960: 8558190891.937401771545410,
        7970: 8517367129.068894386291504,
        7980: 8476786229.080954551696777,
        7990: 8436446462.242001533508301,
        8000: 8396346113.159188270568848,
        8010: 8356483480.642905235290527,
        8020: 8316856877.572673797607422,
        8030: 8277464630.764513015747070,
        8040: 8238305080.839688301086426,
        8050: 8199376582.094842910766602,
        8060: 8160677502.373481750488281,
        8070: 8122206222.938879966735840,
        8080: 8083961138.348246574401855,
        8090: 8045940656.328252792358398,
        8100: 8008143197.651885032653809,
        8110: 7970567196.016539573669434,
        8120: 7933211097.923447608947754,
        8130: 7896073362.558329582214355,
        8140: 7859152461.673320770263672,
        8150: 7822446879.470093727111816,
        8160: 7785955112.484259605407715,
        8170: 7749675669.470907211303711,
        8180: 7713607071.291379928588867,
        8190: 7677747850.801237106323242,
        8200: 7642096552.739324569702148,
        8210: 7606651733.618051528930664,
        8220: 7571411961.614769935607910,
        8230: 7536375816.464317321777344,
        8240: 7501541889.352614402770996,
        8250: 7466908782.811420440673828,
        8260: 7432475110.614134788513184,
        8270: 7398239497.672683715820312,
        8280: 7364200579.935472488403320,
        8290: 7330357004.286390304565430,
        8300: 7296707428.444833755493164,
        8310: 7263250520.866788864135742,
        8320: 7229984960.646872520446777,
        8330: 7196909437.421459197998047,
        8340: 7164022651.272708892822266,
        8350: 7131323312.633633613586426,
        8360: 7098810142.194111824035645,
        8370: 7066481870.807879447937012,
        8380: 7034337239.400420188903809,
        8390: 7002374998.877865791320801,
        8400: 6970593910.036728858947754,
        8410: 6938992743.474656105041504,
        8420: 6907570279.502004623413086,
        8430: 6876325308.054340362548828,
        8440: 6845256628.605838775634766,
        8450: 6814363050.083530426025391,
        8460: 6783643390.782423973083496,
        8470: 6753096478.281497955322266,
        8480: 6722721149.360525131225586,
        8490: 6692516249.917719841003418,
        8500: 6662480634.888250350952148,
        8510: 6632613168.163516998291016,
        8520: 6602912722.511300086975098,
        8530: 6573378179.496648788452148,
        8540: 6544008429.403609275817871,
        8550: 6514802371.157695770263672,
        8560: 6485758912.249164581298828,
        8570: 6456876968.657032966613770,
        8580: 6428155464.773865699768066,
        8590: 6399593333.331313133239746,
        8600: 6371189515.326376914978027,
        8610: 6342942959.948405265808105,
        8620: 6314852624.506840705871582,
        8630: 6286917474.359643936157227,
        8640: 6259136482.842451095581055,
        8650: 6231508631.198427200317383,
        8660: 6204032908.508806228637695,
        8670: 6176708311.624116897583008,
        8680: 6149533845.096093177795410,
        8690: 6122508521.110248565673828,
        8700: 6095631359.419104576110840,
        8710: 6068901387.276098251342773,
        8720: 6042317639.370120048522949,
        8730: 6015879157.760692596435547,
        8740: 5989584991.813780784606934,
        8750: 5963434198.138259887695312,
        8760: 5937425840.522954940795898,
        8770: 5911558989.874333381652832,
        8780: 5885832724.154793739318848,
        8790: 5860246128.321540832519531,
        8800: 5834798294.266083717346191,
        8810: 5809488320.754289627075195,
        8820: 5784315313.367035865783691,
        8830: 5759278384.441451072692871,
        8840: 5734376653.012693405151367,
        8850: 5709609244.756312370300293,
        8860: 5684975291.931167602539062,
        8870: 5660473933.322893142700195,
        8880: 5636104314.187894821166992,
        8890: 5611865586.197937011718750,
        8900: 5587756907.385184288024902,
        8910: 5563777442.087822914123535,
        8920: 5539926360.896215438842773,
        8930: 5516202840.599521636962891,
        8940: 5492606064.132887840270996,
        8950: 5469135220.525092124938965,
        8960: 5445789504.846707344055176,
        8970: 5422568118.158786773681641,
        8980: 5399470267.461996078491211,
        8990: 5376495165.646263122558594,
        9000: 5353642031.440869331359863,
        9010: 5330910089.365070343017578,
        9020: 5308298569.679136276245117,
        9030: 5285806708.335879325866699,
        9040: 5263433746.932641029357910,
        9050: 5241178932.663722038269043,
        9060: 5219041518.273275375366211,
        9070: 5197020762.008649826049805,
        9080: 5175115927.574141502380371,
        9090: 5153326284.085216522216797,
        9100: 5131651106.023159980773926,
        9110: 5110089673.190124511718750,
        9120: 5088641270.664634704589844,
        9130: 5067305188.757496833801270,
        9140: 5046080722.968109130859375,
        9150: 5024967173.941204071044922,
        9160: 5003963847.423976898193359,
        9170: 4983070054.223635673522949,
        9180: 4962285110.165319442749023,
        9190: 4941608336.050436973571777,
        9200: 4921039057.615379333496094,
        9210: 4900576605.490610122680664,
        9220: 4880220315.160168647766113,
        9230: 4859969526.921500205993652,
        9240: 4839823585.845711708068848,
        9250: 4819781841.738147735595703,
        9260: 4799843649.099372863769531,
        9270: 4780008367.086484909057617,
        9280: 4760275359.474804878234863,
        9290: 4740643994.619910240173340,
        9300: 4721113645.420030593872070,
        9310: 4701683689.278768539428711,
        9320: 4682353508.068187713623047,
        9330: 4663122488.092228889465332,
        9340: 4643990020.050465583801270,
        9350: 4624955499.002175331115723,
        9360: 4606018324.330780982971191,
        9370: 4587177899.708575248718262,
        9380: 4568433633.061781883239746,
        9390: 4549784936.535959243774414,
        9400: 4531231226.461684226989746,
        9410: 4512771923.320571899414062,
        9420: 4494406451.711605072021484,
        9430: 4476134240.317752838134766,
        9440: 4457954721.872909545898438,
        9450: 4439867333.129134178161621,
        9460: 4421871514.824179649353027,
        9470: 4403966711.649314880371094,
        9480: 4386152372.217458724975586,
        9490: 4368427949.031561851501465,
        9500: 4350792898.453322410583496,
        9510: 4333246680.672157287597656,
        9520: 4315788759.674445152282715,
        9530: 4298418603.213074684143066,
        9540: 4281135682.777252197265625,
        9550: 4263939473.562564849853516,
        9560: 4246829454.441349506378174,
        9570: 4229805107.933292388916016,
        9580: 4212865920.176319122314453,
        9590: 4196011380.897724151611328,
        9600: 4179240983.385584354400635,
        9610: 4162554224.460392951965332,
        9620: 4145950604.446979999542236,
        9630: 4129429627.146672725677490,
        9640: 4112990799.809691429138184,
        9650: 4096633633.107814788818359,
        9660: 4080357641.107264041900635,
        9670: 4064162341.241852283477783,
        9680: 4048047254.286355018615723,
        9690: 4032011904.330115795135498,
        9700: 4016055818.750909328460693,
        9710: 4000178528.189000606536865,
        9720: 3984379566.521465301513672,
        9730: 3968658470.836721897125244,
        9740: 3953014781.409294605255127,
        9750: 3937448041.674784183502197,
        9760: 3921957798.205081939697266,
        9770: 3906543600.683794975280762,
        9780: 3891205001.881875038146973,
        9790: 3875941557.633469104766846,
        9800: 3860752826.811988830566406,
        9810: 3845638371.306396007537842,
        9820: 3830597755.997655391693115,
        9830: 3815630548.735455036163330,
        9840: 3800736320.315077304840088,
        9850: 3785914644.454504966735840,
        9860: 3771165097.771702766418457,
        9870: 3756487259.762126922607422,
        9880: 3741880712.776394844055176,
        9890: 3727345041.998191833496094,
        9900: 3712879835.422315120697021,
        9910: 3698484683.832966804504395,
        9920: 3684159180.782196521759033,
        9930: 3669902922.568545341491699,
        9940: 3655715508.215864181518555,
        9950: 3641596539.452342510223389,
        9960: 3627545620.689677238464355,
        9970: 3613562359.002460479736328,
        9980: 3599646364.107719421386719,
        9990: 3585797248.344646453857422,
    },
    10000: {
        10: 0.000000000000000,
        20: 0.000000002126338,
        30: 7.270389972388427,
        40: 278006.443139997601975,
        50: 121288408.965934500098228,
        60: 5899149522.061261177062988,
        70: 83912037658.231689453125000,
        80: 561941552222.233886718750000,
        90: 2300348928646.157226562500000,
        100: 6718906096241.068359375000000,
        110: 15430961550717.224609375000000,
        120: 29705232712018.750000000000000,
        130: 50070237640716.546875000000000,
        140: 76207140443906.281250000000000,
        150: 107089777893860.296875000000000,
        160: 141249946918281.687500000000000,
        170: 177055842119693.468750000000000,
        180: 212936904660538.125000000000000,
        190: 247531600716775.156250000000000,
        200: 279762282655718.531250000000000,
        210: 308853792680412.875000000000000,
        220: 334314954040919.062500000000000,
        230: 355899512829198.750000000000000,
        240: 373558788910910.875000000000000,
        250: 387394065103131.562500000000000,
        260: 397613331580524.125000000000000,
        270: 404494561734100.062500000000000,
        280: 408356111551676.500000000000000,
        290: 409533905832335.000000000000000,
        300: 408364602149916.937500000000000,
        310: 405173744791887.000000000000000,
        320: 400267916363576.562500000000000,
        330: 393929982848871.187500000000000,
        340: 386416656565035.750000000000000,
        350: 377957739526733.375000000000000,
        360: 368756540197383.312500000000000,
        370: 358991071349785.437500000000000,
        380: 348815733045389.187500000000000,
        390: 338363262838112.312500000000000,
        400: 327746796985811.437500000000000,
        410: 317061934086171.437500000000000,
        420: 306388728611300.562500000000000,
        430: 295793568588974.375000000000000,
        440: 285330911166871.187500000000000,
        450: 275044863671471.031250000000000,
        460: 264970607393980.593750000000000,
        470: 255135667780876.062500000000000,
        480: 245561038818550.187500000000000,
        490: 236262171827290.593750000000000,
        500: 227249840110142.937500000000000,
        510: 218530891304550.437500000000000,
        520: 210108899130680.500000000000000,
        530: 201984725718295.281250000000000,
        540: 194157004966510.718750000000000,
        550: 186622556548648.031250000000000,
        560: 179376739287466.156250000000000,
        570: 172413751741437.406250000000000,
        580: 165726886990893.406250000000000,
        590: 159308747812487.625000000000000,
        600: 153151427691746.062500000000000,
        610: 147246662450968.375000000000000,
        620: 141585956663931.062500000000000,
        630: 136160688487699.875000000000000,
        640: 130962196061762.140625000000000,
        650: 125981848201140.453125000000000,
        660: 121211101738207.843750000000000,
        670: 116641547542579.718750000000000,
        680: 112264946964805.000000000000000,
        690: 108073260202968.984375000000000,
        700: 104058667877434.484375000000000,
        710: 100213586913833.046875000000000,
        720: 96530681674499.187500000000000,
        730: 93002871140611.296875000000000,
        740: 89623332828517.265625000000000,
        750: 86385504021556.546875000000000,
        760: 83283080810925.234375000000000,
        770: 80310015363826.750000000000000,
        780: 77460511772606.062500000000000,
        790: 74729020783302.296875000000000,
        800: 72110233654788.437500000000000,
        810: 69599075359284.359375000000000,
        820: 67190697300562.781250000000000,
        830: 64880469696787.906250000000000,
        840: 62663973749908.343750000000000,
        850: 60536993702254.929687500000000,
        860: 58495508862928.765625000000000,
        870: 56535685671251.640625000000000,
        880: 54653869851588.273437500000000,
        890: 52846578702902.734375000000000,
        900: 51110493557181.078125000000000,
        910: 49442452433094.890625000000000,
        920: 47839442904775.289062500000000,
        930: 46298595200129.992187500000000,
        940: 44817175538612.273437500000000,
        950: 43392579714599.679687500000000,
        960: 42022326929447.867187500000000,
        970: 40704053872753.812500000000000,
        980: 39435509051300.406250000000000,
        990: 38214547362498.835937500000000,
        1000: 37039124907821.546875000000000,
        1010: 35907294040685.898437500000000,
        1020: 34817198642449.671875000000000,
        1030: 33767069619586.863281250000000,
        1040: 32755220614682.367187500000000,
        1050: 31780043923596.304687500000000,
        1060: 30840006610976.175781250000000,
        1070: 29933646816215.632812500000000,
        1080: 29059570241959.652343750000000,
        1090: 28216446817317.179687500000000,
        1100: 27403007528056.761718750000000,
        1110: 26618041406213.078125000000000,
        1120: 25860392671718.203125000000000,
        1130: 25128958018878.917968750000000,
        1140: 24422684040749.351562500000000,
        1150: 23740564784686.250000000000000,
        1160: 23081639432622.070312500000000,
        1170: 22444990099843.570312500000000,
        1180: 21829739746316.617187500000000,
        1190: 21235050194852.542968750000000,
        1200: 20660120250660.996093750000000,
        1210: 20104183917082.359375000000000,
        1220: 19566508702532.960937500000000,
        1230: 19046394013932.941406250000000,
        1240: 18543169632113.941406250000000,
        1250: 18056194264925.289062500000000,
        1260: 17584854173970.101562500000000,
        1270: 17128561871107.726562500000000,
        1280: 16686754881055.689453125000000,
        1290: 16258894566612.695312500000000,
        1300: 15844465013204.818359375000000,
        1310: 15442971969628.660156250000000,
        1320: 15053941842030.103515625000000,
        1330: 14676920738313.150390625000000,
        1340: 14311473560322.697265625000000,
        1350: 13957183141286.220703125000000,
        1360: 13613649426134.179687500000000,
        1370: 13280488692446.316406250000000,
        1380: 12957332809892.228515625000000,
        1390: 12643828536149.425781250000000,
        1400: 12339636847390.703125000000000,
        1410: 12044432301535.984375000000000,
        1420: 11757902432560.957031250000000,
        1430: 11479747174247.437500000000000,
        1440: 11209678311847.656250000000000,
        1450: 10947418960217.226562500000000,
        1460: 10692703067049.681640625000000,
        1470: 10445274939919.427734375000000,
        1480: 10204888795909.673828125000000,
        1490: 9971308332667.812500000000000,
        1500: 9744306319793.398437500000000,
        1510: 9523664209522.291015625000000,
        1520: 9309171765726.724609375000000,
        1530: 9100626710303.216796875000000,
        1540: 8897834386070.224609375000000,
        1550: 8700607435344.178710937500000,
        1560: 8508765493407.064453125000000,
        1570: 8322134896120.352539062500000,
        1580: 8140548400979.958007812500000,
        1590: 7963844920944.046875000000000,
        1600: 7791869270400.878906250000000,
        1610: 7624471922677.425781250000000,
        1620: 7461508778520.708984375000000,
        1630: 7302840945013.951171875000000,
        1640: 7148334524417.465820312500000,
        1650: 6997860412451.147460937500000,
        1660: 6851294105560.180664062500000,
        1670: 6708515516729.820312500000000,
        1680: 6569408799437.151367187500000,
        1690: 6433862179349.250000000000000,
        1700: 6301767793397.201171875000000,
        1710: 6173021535874.309570312500000,
        1720: 6047522911225.066406250000000,
        1730: 5925174893208.117187500000000,
        1740: 5805883790132.869140625000000,
        1750: 5689559115884.339843750000000,
        1760: 5576113466465.472656250000000,
        1770: 5465462401799.542968750000000,
        1780: 5357524332548.412109375000000,
        1790: 5252220411714.428710937500000,
        1800: 5149474430805.434570312500000,
        1810: 5049212720353.255859375000000,
        1820: 4951364054586.421875000000000,
        1830: 4855859560067.732421875000000,
        1840: 4762632628116.536132812500000,
        1850: 4671618830844.468750000000000,
        1860: 4582755840641.723632812500000,
        1870: 4495983352958.896484375000000,
        1880: 4411243012236.861328125000000,
        1890: 4328478340844.459960937500000,
        1900: 4247634670890.274902343750000,
        1910: 4168659078781.436523437500000,
        1920: 4091500322408.298339843750000,
        1930: 4016108780839.712890625000000,
        1940: 3942436396419.001464843750000,
        1950: 3870436619156.061523437500000,
        1960: 3800064353315.822265625000000,
        1970: 3731275906108.104980468750000,
        1980: 3664028938388.224121093750000,
        1990: 3598282417282.095214843750000,
        2000: 3533996570653.424804687500000,
        2010: 3471132843334.543945312500000,
        2020: 3409653855045.940917968750000,
        2030: 3349523359933.093261718750000,
        2040: 3290706207652.419921875000000,
        2050: 3233168305941.308105468750000,
        2060: 3176876584610.129394531250000,
        2070: 3121798960896.947753906250000,
        2080: 3067904306128.393066406250000,
        2090: 3015162413632.584960937500000,
        2100: 2963543967852.562988281250000,
        2110: 2913020514610.852539062500000,
        2120: 2863564432478.125000000000000,
        2130: 2815148905200.880859375000000,
        2140: 2767747895145.188964843750000,
        2150: 2721336117715.318847656250000,
        2160: 2675889016707.964355468750000,
        2170: 2631382740564.479003906250000,
        2180: 2587794119485.157226562500000,
        2190: 2545100643371.194335937500000,
        2200: 2503280440561.384765625000000,
        2210: 2462312257332.152343750000000,
        2220: 2422175438130.733886718750000,
        2230: 2382849906512.722167968750000,
        2240: 2344316146756.348144531250000,
        2250: 2306555186127.124511718750000,
        2260: 2269548577767.501953125000000,
        2270: 2233278384187.356933593750000,
        2280: 2197727161332.079589843750000,
        2290: 2162877943206.033935546875000,
        2300: 2128714227030.110839843750000,
        2310: 2095219958912.937744140625000,
        2320: 2062379520016.214355468750000,
        2330: 2030177713195.384521484375000,
        2340: 1998599750097.711669921875000,
        2350: 1967631238700.497802734375000,
        2360: 1937258171272.918457031250000,
        2370: 1907466912745.637939453125000,
        2380: 1878244189472.971679687500000,
        2390: 1849577078373.041503906250000,
        2400: 1821452996431.892578125000000,
        2410: 1793859690558.168212890625000,
        2420: 1766785227775.421630859375000,
        2430: 1740217985739.715332031250000,
        2440: 1714146643570.606689453125000,
        2450: 1688560172984.121093750000000,
        2460: 1663447829716.753417968750000,
        2470: 1638799145229.969726562500000,
        2480: 1614603918685.114990234375000,
        2490: 1590852209179.001953125000000,
        2500: 1567534328230.856689453125000,
        2510: 1544640832511.652099609375000,
        2520: 1522162516807.213867187500000,
        2530: 1500090407206.814453125000000,
        2540: 1478415754509.290039062500000,
        2550: 1457130027839.023437500000000,
        2560: 1436224908464.434082031250000,
        2570: 1415692283811.887939453125000,
        2580: 1395524241668.221191406250000,
        2590: 1375713064565.328369140625000,
        2600: 1356251224340.496826171875000,
        2610: 1337131376866.441406250000000,
        2620: 1318346356945.189208984375000,
        2630: 1299889173360.204589843750000,
        2640: 1281753004081.330322265625000,
        2650: 1263931191617.369873046875000,
        2660: 1246417238511.259033203125000,
        2670: 1229204802973.038574218750000,
        2680: 1212287694645.945312500000000,
        2690: 1195659870501.172607421875000,
        2700: 1179315430856.968505859375000,
        2710: 1163248615517.926513671875000,
        2720: 1147453800030.460693359375000,
        2730: 1131925492050.608398437500000,
        2740: 1116658327820.443847656250000,
        2750: 1101647068749.520507812500000,
        2760: 1086886598097.884277343750000,
        2770: 1072371917757.324951171875000,
        2780: 1058098145127.664306640625000,
        2790: 1044060510084.975341796875000,
        2800: 1030254352038.750122070312500,
        2810: 1016675117075.137329101562500,
        2820: 1003318355183.464965820312500,
        2830: 990179717563.377441406250000,
        2840: 977254954009.990478515625000,
        2850: 964539910374.578002929687500,
        2860: 952030526098.374267578125000,
        2870: 939722831817.173339843750000,
        2880: 927612947034.476196289062500,
        2890: 915697077861.028686523437500,
        2900: 903971514818.646728515625000,
        2910: 892432630706.318603515625000,
        2920: 881076878526.635009765625000,
        2930: 869900789470.654663085937500,
        2940: 858900970959.401000976562500,
        2950: 848074104740.212768554687500,
        2960: 837416945036.275390625000000,
        2970: 826926316747.670166015625000,
        2980: 816599113702.375976562500000,
        2990: 806432296955.673950195312500,
        3000: 796422893136.490478515625000,
        3010: 786567992839.239868164062500,
        3020: 776864749059.782958984375000,
        3030: 767310375674.172241210937500,
        3040: 757902145958.877563476562500,
        3050: 748637391151.259033203125000,
        3060: 739513499049.063110351562500,
        3070: 730527912647.784179687500000,
        3080: 721678128814.751586914062500,
        3090: 712961696998.855590820312500,
        3100: 704376217974.851562500000000,
        3110: 695919342621.215698242187500,
        3120: 687588770730.564819335937500,
        3130: 679382249851.681518554687500,
        3140: 671297574162.215576171875000,
        3150: 663332583371.161621093750000,
        3160: 655485161650.251831054687500,
        3170: 647753236593.408203125000000,
        3180: 640134778203.455200195312500,
        3190: 632627797905.291381835937500,
        3200: 625230347584.765625000000000,
        3210: 617940518652.510009765625000,
        3220: 610756441132.017089843750000,
        3230: 603676282771.271240234375000,
        3240: 596698248177.251220703125000,
        3250: 589820577972.666625976562500,
        3260: 583041547974.283569335937500,
        3270: 576359468392.237304687500000,
        3280: 569772683049.737182617187500,
        3290: 563279568622.589965820312500,
        3300: 556878533897.979736328125000,
        3310: 550568019051.976562500000000,
        3320: 544346494945.237976074218750,
        3330: 538212462436.407836914062500,
        3340: 532164451712.712463378906250,
        3350: 526201021637.282775878906250,
        3360: 520320759112.738647460937500,
        3370: 514522278460.587707519531250,
        3380: 508804220816.005432128906250,
        3390: 503165253537.569946289062500,
        3400: 497604069631.549865722656250,
        3410: 492119387190.344665527343750,
        3420: 486709948844.692260742187500,
        3430: 481374521229.272399902343750,
        3440: 476111894461.341247558593750,
        3450: 470920881632.050292968750000,
        3460: 465800318310.102722167968750,
        3470: 460749062057.419616699218750,
        3480: 455765991956.494384765625000,
        3490: 450850008149.121948242187500,
        3500: 446000031386.201660156250000,
        3510: 441215002588.320556640625000,
        3520: 436493882416.825195312500000,
        3530: 431835650855.116577148437500,
        3540: 427239306799.886962890625000,
        3550: 422703867662.044799804687500,
        3560: 418228368977.070983886718750,
        3570: 413811864024.560913085937500,
        3580: 409453423456.710754394531250,
        3590: 405152134935.519775390625000,
        3600: 400907102778.477233886718750,
        3610: 396717447612.516418457031250,
        3620: 392582306036.025024414062500,
        3630: 388500830288.700195312500000,
        3640: 384472187929.049194335937500,
        3650: 380495561519.339599609375000,
        3660: 376570148317.807678222656250,
        3670: 372695159977.941345214843750,
        3680: 368869822254.656799316406250,
        3690: 365093374717.193908691406250,
        3700: 361365070468.560668945312500,
        3710: 357684175871.362548828125000,
        3720: 354049970279.852478027343750,
        3730: 350461745778.051269531250000,
        3740: 346918806923.779296875000000,
        3750: 343420470498.456115722656250,
        3760: 339966065262.525085449218750,
        3770: 336554931716.358947753906250,
        3780: 333186421866.513671875000000,
        3790: 329859898997.197509765625000,
        3800: 326574737446.825561523437500,
        3810: 323330322389.536010742187500,
        3820: 320126049621.545593261718750,
        3830: 316961325352.222778320312500,
        3840: 313835565999.771179199218750,
        3850: 310748197991.399719238281250,
        3860: 307698657567.880737304687500,
        3870: 304686390592.382263183593750,
        3880: 301710852363.475280761718750,
        3890: 298771507432.212158203125000,
        3900: 295867829423.180725097656250,
        3910: 292999300859.435607910156250,
        3920: 290165412991.216552734375000,
        3930: 287365665628.361816406250000,
        3940: 284599566976.327209472656250,
        3950: 281866633475.726562500000000,
        3960: 279166389645.310607910156250,
        3970: 276498367928.300231933593750,
        3980: 273862108541.996856689453125,
        3990: 271257159330.590545654296875,
        4000: 268683075621.094024658203125,
        4010: 266139420082.325561523437500,
        4020: 263625762586.870025634765625,
        4030: 261141680075.951416015625000,
        4040: 258686756427.143890380859375,
        4050: 256260582324.860321044921875,
        4060: 253862755133.550323486328125,
        4070: 251492878773.546264648437500,
        4080: 249150563599.496307373046875,
        4090: 246835426281.324157714843750,
        4100: 244547089687.658386230468750,
        4110: 242285182771.672637939453125,
        4120: 240049340459.283660888671875,
        4130: 237839203539.652313232421875,
        4140: 235654418557.935119628906250,
        4150: 233494637710.234680175781250,
        4160: 231359518740.699920654296875,
        4170: 229248724840.726684570312500,
        4180: 227161924550.211578369140625,
        4190: 225098791660.813446044921875,
        4200: 223059005121.175323486328125,
        4210: 221042248944.064147949218750,
        4220: 219048212115.386840820312500,
        4230: 217076588505.037567138671875,
        4240: 215127076779.536804199218750,
        4250: 213199380316.424011230468750,
        4260: 211293207120.361602783203125,
        4270: 209408269740.915496826171875,
        4280: 207544285191.973266601562500,
        4290: 205700974872.763702392578125,
        4300: 203878064490.444061279296875,
        4310: 202075283984.218902587890625,
        4320: 200292367450.958435058593750,
        4330: 198529053072.281799316406250,
        4340: 196785083043.074981689453125,
        4350: 195060203501.411346435546875,
        4360: 193354164459.843841552734375,
        4370: 191666719738.040985107421875,
        4380: 189997626896.734558105468750,
        4390: 188346647172.953399658203125,
        4400: 186713545416.514678955078125,
        4410: 185098090027.745147705078125,
        4420: 183500052896.406188964843750,
        4430: 181919209341.797363281250000,
        4440: 180355338054.012634277343750,
        4450: 178808221036.325897216796875,
        4460: 177277643548.678894042968750,
        4470: 175763394052.252410888671875,
        4480: 174265264155.094635009765625,
        4490: 172783048558.783874511718750,
        4500: 171316545006.107818603515625,
        4510: 169865554229.732360839843750,
        4520: 168429879901.844512939453125,
        4530: 167009328584.744812011718750,
        4540: 165603709682.372528076171875,
        4550: 164212835392.741119384765625,
        4560: 162836520661.268310546875000,
        4570: 161474583134.979492187500000,
        4580: 160126843117.567260742187500,
        4590: 158793123525.290222167968750,
        4600: 157473249843.692138671875000,
        4610: 156167050085.125396728515625,
        4620: 154874354747.062774658203125,
        4630: 153594996771.179931640625000,
        4640: 152328811503.193756103515625,
        4650: 151075636653.440979003906250,
        4660: 149835312258.182006835937500,
        4670: 148607680641.614898681640625,
        4680: 147392586378.584991455078125,
        4690: 146189876257.977020263671875,
        4700: 144999399246.773895263671875,
        4710: 143821006454.771362304687500,
        4720: 142654551099.933105468750000,
        4730: 141499888474.373748779296875,
        4740: 140356875910.958679199218750,
        4750: 139225372750.506317138671875,
        4760: 138105240309.582244873046875,
        4770: 136996341848.872070312500000,
        4780: 135898542542.123184204101562,
        4790: 134811709445.642211914062500,
        4800: 133735711468.338699340820312,
        4810: 132670419342.303359985351562,
        4820: 131615705593.910125732421875,
        4830: 130571444515.432449340820312,
        4840: 129537512137.163360595703125,
        4850: 128513786200.029098510742188,
        4860: 127500146128.686889648437500,
        4870: 126496473005.097427368164062,
        4880: 125502649542.562622070312500,
        4890: 124518560060.220001220703125,
        4900: 123544090457.983642578125000,
        4910: 122579128191.924972534179688,
        4920: 121623562250.082473754882812,
        4930: 120677283128.694488525390625,
        4940: 119740182808.844635009765625,
        4950: 118812154733.514083862304688,
        4960: 117893093785.030288696289062,
        4970: 116982896262.907653808593750,
        4980: 116081459862.069671630859375,
        4990: 115188683651.447021484375000,
        5000: 114304468052.944046020507812,
        5010: 113428714820.766387939453125,
        5020: 112561327021.103103637695312,
        5030: 111702209012.156005859375000,
        5040: 110851266424.510711669921875,
        5050: 110008406141.841995239257812,
        5060: 109173536281.947204589843750,
        5070: 108346566178.102142333984375,
        5080: 107527406360.732955932617188,
        5090: 106715968539.397628784179688,
        5100: 105912165585.072692871093750,
        5110: 105115911512.737503051757812,
        5120: 104327121464.252151489257812,
        5130: 103545711691.523056030273438,
        5140: 102771599539.950088500976562,
        5150: 102004703432.151123046875000,
        5160: 101244942851.958786010742188,
        5170: 100492238328.682861328125000,
        5180: 99746511421.635803222656250,
        5190: 99007684704.914260864257812,
        5200: 98275681752.433731079101562,
        5210: 97550427123.210388183593750,
        5220: 96831846346.886108398437500,
        5230: 96119865909.492095947265625,
        5240: 95414413239.447525024414062,
        5250: 94715416693.786727905273438,
        5260: 94022805544.613861083984375,
        5270: 93336509965.778137207031250,
        5280: 92656461019.767807006835938,
        5290: 91982590644.816543579101562,
        5300: 91314831642.221160888671875,
        5310: 90653117663.864761352539062,
        5320: 89997383199.941864013671875,
        5330: 89347563566.883636474609375,
        5340: 88703594895.476852416992188,
        5350: 88065414119.175369262695312,
        5360: 87432958962.599822998046875,
        5370: 86806167930.222167968750000,
        5380: 86184980295.231628417968750,
        5390: 85569336088.579498291015625,
        5400: 84959176088.198577880859375,
        5410: 84354441808.395217895507812,
        5420: 83755075489.410476684570312,
        5430: 83161020087.146545410156250,
        5440: 82572219263.057556152343750,
        5450: 81988617374.199676513671875,
        5460: 81410159463.439147949218750,
        5470: 80836791249.814880371093750,
        5480: 80268459119.053131103515625,
        5490: 79705110114.231491088867188,
        5500: 79146691926.589279174804688,
        5510: 78593152886.482986450195312,
        5520: 78044441954.482284545898438,
        5530: 77500508712.606033325195312,
        5540: 76961303355.694778442382812,
        5550: 76426776682.917572021484375,
        5560: 75896880089.411331176757812,
        5570: 75371565558.049514770507812,
        5580: 74850785651.338760375976562,
        5590: 74334493503.440597534179688,
        5600: 73822642812.316879272460938,
        5610: 73315187831.995864868164062,
        5620: 72812083364.957748413085938,
        5630: 72313284754.636703491210938,
        5640: 71818747878.038787841796875,
        5650: 71328429138.472167968750000,
        5660: 70842285458.388961791992188,
        5670: 70360274272.336105346679688,
        5680: 69882353520.013854980468750,
        5690: 69408481639.439727783203125,
        5700: 68938617560.216445922851562,
        5710: 68472720696.901733398437500,
        5720: 68010750942.478790283203125,
        5730: 67552668661.925247192382812,
        5740: 67098434685.879257202148438,
        5750: 66648010304.400650024414062,
        5760: 66201357260.826667785644531,
        5770: 65758437745.719047546386719,
        5780: 65319214390.902534484863281,
        5790: 64883650263.592208862304688,
        5800: 64451708860.608512878417969,
        5810: 64023354102.679039001464844,
        5820: 63598550328.824485778808594,
        5830: 63177262290.828613281250000,
        5840: 62759455147.790031433105469,
        5850: 62345094460.754600524902344,
        5860: 61934146187.427604675292969,
        5870: 61526576676.963584899902344,
        5880: 61122352664.833259582519531,
        5890: 60721441267.766036987304688,
        5900: 60323809978.766532897949219,
        5910: 59929426662.204650878906250,
        5920: 59538259548.977302551269531,
        5930: 59150277231.740913391113281,
        5940: 58765448660.213577270507812,
        5950: 58383743136.545791625976562,
        5960: 58005130310.758331298828125,
        5970: 57629580176.246757507324219,
        5980: 57257063065.350746154785156,
        5990: 56887549644.987876892089844,
        6000: 56521010912.350563049316406,
        6010: 56157418190.664978027343750,
        6020: 55796743125.011177062988281,
        6030: 55438957678.203239440917969,
        6040: 55084034126.729064941406250,
        6050: 54731945056.747802734375000,
        6060: 54382663360.145080566406250,
        6070: 54036162230.644279479980469,
        6080: 53692415159.973930358886719,
        6090: 53351395934.088958740234375,
        6100: 53013078629.446334838867188,
        6110: 52677437609.333351135253906,
        6120: 52344447520.248146057128906,
        6130: 52014083288.331443786621094,
        6140: 51686320115.848594665527344,
        6150: 51361133477.721839904785156,
        6160: 51038499118.110588073730469,
        6170: 50718393047.040924072265625,
        6180: 50400791537.081443786621094,
        6190: 50085671120.066513061523438,
        6200: 49773008583.865036010742188,
        6210: 49462780969.194755554199219,
        6220: 49154965566.480499267578125,
        6230: 48849539912.756965637207031,
        6240: 48546481788.614028930664062,
        6250: 48245769215.185050964355469,
        6260: 47947380451.176467895507812,
        6270: 47651293989.939094543457031,
        6280: 47357488556.579368591308594,
        6290: 47065943105.111221313476562,
        6300: 46776636815.646720886230469,
        6310: 46489549091.625534057617188,
        6320: 46204659557.082565307617188,
        6330: 45921948053.953269958496094,
        6340: 45641394639.415657043457031,
        6350: 45362979583.268775939941406,
        6360: 45086683365.347282409667969,
        6370: 44812486672.970901489257812,
        6380: 44540370398.428970336914062,
        6390: 44270315636.499252319335938,
        6400: 44002303682.000122070312500,
        6410: 43736316027.376411437988281,
        6420: 43472334360.317565917968750,
        6430: 43210340561.408348083496094,
        6440: 42950316701.811302185058594,
        6450: 42692245040.980049133300781,
        6460: 42436108024.403831481933594,
        6470: 42181888281.382286071777344,
        6480: 41929568622.830024719238281,
        6490: 41679132039.110671997070312,
        6500: 41430561697.899932861328125,
        6510: 41183840942.077247619628906,
        6520: 40938953287.645606994628906,
        6530: 40695882421.679016113281250,
        6540: 40454612200.297409057617188,
        6550: 40215126646.668251037597656,
        6560: 39977409949.035118103027344,
        6570: 39741446458.771835327148438,
        6580: 39507220688.462707519531250,
        6590: 39274717310.008201599121094,
        6600: 39043921152.755348205566406,
        6610: 38814817201.652832031250000,
        6620: 38587390595.430709838867188,
        6630: 38361626624.803421020507812,
        6640: 38137510730.697036743164062,
        6650: 37915028502.499168395996094,
        6660: 37694165676.332206726074219,
        6670: 37474908133.348739624023438,
        6680: 37257241898.049530029296875,
        6690: 37041153136.623176574707031,
        6700: 36826628155.307533264160156,
        6710: 36613653398.772193908691406,
        6720: 36402215448.522201538085938,
        6730: 36192301021.322265625000000,
        6740: 35983896967.641464233398438,
        6750: 35776990270.117881774902344,
        6760: 35571568042.043060302734375,
        6770: 35367617525.866256713867188,
        6780: 35165126091.717544555664062,
        6790: 34964081235.950096130371094,
        6800: 34764470579.701126098632812,
        6810: 34566281867.471153259277344,
        6820: 34369502965.721519470214844,
        6830: 34174121861.489944458007812,
        6840: 33980126661.023387908935547,
        6850: 33787505588.428726196289062,
        6860: 33596246984.340106964111328,
        6870: 33406339304.603748321533203,
        6880: 33217771118.979007720947266,
        6890: 33030531109.856079101562500,
        6900: 32844608070.989818572998047,
        6910: 32659990906.249698638916016,
        6920: 32476668628.385269165039062,
        6930: 32294630357.807468414306641,
        6940: 32113865321.384937286376953,
        6950: 31934362851.255714416503906,
        6960: 31756112383.653675079345703,
        6970: 31579103457.749694824218750,
        6980: 31403325714.507381439208984,
        6990: 31228768895.552856445312500,
        7000: 31055422842.058971405029297,
        7010: 30883277493.643146514892578,
        7020: 30712322887.278984069824219,
        7030: 30542549156.221477508544922,
        7040: 30373946528.945415496826172,
        7050: 30206505328.097076416015625,
        7060: 30040215969.458633422851562,
        7070: 29875068960.925846099853516,
        7080: 29711054901.497585296630859,
        7090: 29548164480.278697967529297,
        7100: 29386388475.494361877441406,
        7110: 29225717753.517005920410156,
        7120: 29066143267.905006408691406,
        7130: 28907656058.453121185302734,
        7140: 28750247250.254730224609375,
        7150: 28593908052.775222778320312,
        7160: 28438629758.936950683593750,
        7170: 28284403744.215263366699219,
        7180: 28131221465.745422363281250,
        7190: 27979074461.440567016601562,
        7200: 27827954349.120094299316406,
        7210: 27677852825.648986816406250,
        7220: 27528761666.087207794189453,
        7230: 27380672722.849544525146484,
        7240: 27233577924.875492095947266,
        7250: 27087469276.809360504150391,
        7260: 26942338858.189964294433594,
        7270: 26798178822.650138854980469,
        7280: 26654981397.126106262207031,
        7290: 26512738881.075874328613281,
        7300: 26371443645.707447052001953,
        7310: 26231088133.215938568115234,
        7320: 26091664856.029869079589844,
        7330: 25953166396.066684722900391,
        7340: 25815585403.996696472167969,
        7350: 25678914598.516231536865234,
        7360: 25543146765.629112243652344,
        7370: 25408274757.936710357666016,
        7380: 25274291493.936584472656250,
        7390: 25141189957.329196929931641,
        7400: 25008963196.332939147949219,
        7410: 24877604323.007202148437500,
        7420: 24747106512.583480834960938,
        7430: 24617463002.804168701171875,
        7440: 24488667093.269485473632812,
        7450: 24360712144.791622161865234,
        7460: 24233591578.756793975830078,
        7470: 24107298876.494667053222656,
        7480: 23981827578.655006408691406,
        7490: 23857171284.591957092285156,
        7500: 23733323651.755050659179688,
        7510: 23610278395.087677001953125,
        7520: 23488029286.432399749755859,
        7530: 23366570153.943210601806641,
        7540: 23245894881.504478454589844,
        7550: 23125997408.156883239746094,
        7560: 23006871727.529739379882812,
        7570: 22888511887.280117034912109,
        7580: 22770911988.538169860839844,
        7590: 22654066185.359096527099609,
        7600: 22537968684.181282043457031,
        7610: 22422613743.290729522705078,
        7620: 22307995672.291591644287109,
        7630: 22194108831.582801818847656,
        7640: 22080947631.840702056884766,
        7650: 21968506533.507614135742188,
        7660: 21856780046.286186218261719,
        7670: 21745762728.639568328857422,
        7680: 21635449187.297286987304688,
        7690: 21525834076.766696929931641,
        7700: 21416912098.850028991699219,
        7710: 21308678002.166877746582031,
        7720: 21201126581.682212829589844,
        7730: 21094252678.239559173583984,
        7740: 20988051178.099643707275391,
        7750: 20882517012.484119415283203,
        7760: 20777645157.124431610107422,
        7770: 20673430631.815979003906250,
        7780: 20569868499.976936340332031,
        7790: 20466953868.212448120117188,
        7800: 20364681885.883281707763672,
        7810: 20263047744.679702758789062,
        7820: 20162046678.199916839599609,
        7830: 20061673961.533226013183594,
        7840: 19961924910.847930908203125,
        7850: 19862794882.983768463134766,
        7860: 19764279275.048866271972656,
        7870: 19666373524.021331787109375,
        7880: 19569073106.355014801025391,
        7890: 19472373537.589939117431641,
        7900: 19376270371.966846466064453,
        7910: 19280759202.045993804931641,
        7920: 19185835658.330448150634766,
        7930: 19091495408.893115997314453,
        7940: 18997734159.008266448974609,
        7950: 18904547650.786945343017578,
        7960: 18811931662.816360473632812,
        7970: 18719882009.803337097167969,
        7980: 18628394542.221618652343750,
        7990: 18537465145.963123321533203,
        8000: 18447089741.992843627929688,
        8010: 18357264286.007812500000000,
        8020: 18267984768.099472045898438,
        8030: 18179247212.419883728027344,
        8040: 18091047676.851665496826172,
        8050: 18003382252.681388854980469,
        8060: 17916247064.276493072509766,
        8070: 17829638268.765918731689453,
        8080: 17743552055.723915100097656,
        8090: 17657984646.857620239257812,
        8100: 17572932295.697628021240234,
        8110: 17488391287.292259216308594,
        8120: 17404357937.904903411865234,
        8130: 17320828594.714698791503906,
        8140: 17237799635.520484924316406,
        8150: 17155267468.447874069213867,
        8160: 17073228531.659461975097656,
        8170: 16991679293.068180084228516,
        8180: 16910616250.053773880004883,
        8190: 16830035929.182212829589844,
        8200: 16749934885.928112030029297,
        8210: 16670309704.400278091430664,
        8220: 16591156997.069936752319336,
        8230: 16512473404.502027511596680,
        8240: 16434255595.089334487915039,
        8250: 16356500264.789386749267578,
        8260: 16279204136.864246368408203,
        8270: 16202363961.622905731201172,
        8280: 16125976516.166597366333008,
        8290: 16050038604.136644363403320,
        8300: 15974547055.465087890625000,
        8310: 15899498726.127872467041016,
        8320: 15824890497.900648117065430,
        8330: 15750719278.117183685302734,
        8340: 15676981999.430309295654297,
        8350: 15603675619.575298309326172,
        8360: 15530797121.135885238647461,
        8370: 15458343511.312524795532227,
        8380: 15386311821.693294525146484,
        8390: 15314699108.027078628540039,
        8400: 15243502449.999076843261719,
        8410: 15172718951.008781433105469,
        8420: 15102345737.950181961059570,
        8430: 15032379960.994300842285156,
        8440: 14962818793.373895645141602,
        8450: 14893659431.170612335205078,
        8460: 14824899093.104040145874023,
        8470: 14756535020.323259353637695,
        8480: 14688564476.200317382812500,
        8490: 14620984746.126007080078125,
        8500: 14553793137.307584762573242,
        8510: 14486986978.568735122680664,
        8520: 14420563620.151533126831055,
        8530: 14354520433.520355224609375,
        8540: 14288854811.168041229248047,
        8550: 14223564166.423725128173828,
        8560: 14158645933.262971878051758,
        8570: 14094097566.119548797607422,
        8580: 14029916539.699409484863281,
        8590: 13966100348.796321868896484,
        8600: 13902646508.109571456909180,
        8610: 13839552552.063461303710938,
        8620: 13776816034.628536224365234,
        8630: 13714434529.144876480102539,
        8640: 13652405628.146951675415039,
        8650: 13590726943.190326690673828,
        8660: 13529396104.680225372314453,
        8670: 13468410761.701677322387695,
        8680: 13407768581.851438522338867,
        8690: 13347467251.071725845336914,
        8700: 13287504473.485435485839844,
        8710: 13227877971.233127593994141,
        8720: 13168585484.311689376831055,
        8730: 13109624770.414571762084961,
        8740: 13050993604.773561477661133,
        8750: 12992689780.002317428588867,
        8760: 12934711105.941305160522461,
        8770: 12877055409.504379272460938,
        8780: 12819720534.526872634887695,
        8790: 12762704341.615249633789062,
        8800: 12706004707.998149871826172,
        8810: 12649619527.378993988037109,
        8820: 12593546709.790130615234375,
        8830: 12537784181.448253631591797,
        8840: 12482329884.611446380615234,
        8850: 12427181777.437486648559570,
        8860: 12372337833.843683242797852,
        8870: 12317796043.367982864379883,
        8880: 12263554411.031562805175781,
        8890: 12209610957.202779769897461,
        8900: 12155963717.462285995483398,
        8910: 12102610742.469726562500000,
        8920: 12049550097.831550598144531,
        8930: 11996779863.970285415649414,
        8940: 11944298135.994909286499023,
        8950: 11892103023.572706222534180,
        8960: 11840192650.802204132080078,
        8970: 11788565156.087467193603516,
        8980: 11737218692.013526916503906,
        8990: 11686151425.223176956176758,
        9000: 11635361536.294767379760742,
        9010: 11584847219.621408462524414,
        9020: 11534606683.291145324707031,
        9030: 11484638148.968494415283203,
        9040: 11434939851.776971817016602,
        9050: 11385510040.182846069335938,
        9060: 11336346975.880033493041992,
        9070: 11287448933.676048278808594,
        9080: 11238814201.379062652587891,
        9090: 11190441079.686155319213867,
        9100: 11142327882.072502136230469,
        9110: 11094472934.681724548339844,
        9120: 11046874576.217290878295898,
        9130: 10999531157.834945678710938,
        9140: 10952441043.036144256591797,
        9150: 10905602607.562568664550781,
        9160: 10859014239.291610717773438,
        9170: 10812674338.132940292358398,
        9180: 10766581315.925888061523438,
        9190: 10720733596.338031768798828,
        9200: 10675129614.764596939086914,
        9210: 10629767818.228870391845703,
        9220: 10584646665.283548355102539,
        9230: 10539764625.913074493408203,
        9240: 10495120181.436811447143555,
        9250: 10450711824.413274765014648,
        9260: 10406538058.545101165771484,
        9270: 10362597398.585046768188477,
        9280: 10318888370.242897033691406,
        9290: 10275409510.093105316162109,
        9300: 10232159365.483470916748047,
        9310: 10189136494.444608688354492,
        9320: 10146339465.600206375122070,
        9330: 10103766858.078302383422852,
        9340: 10061417261.423219680786133,
        9350: 10019289275.508430480957031,
        9360: 9977381510.450212478637695,
        9370: 9935692586.522121429443359,
        9380: 9894221134.070220947265625,
        9390: 9852965793.429252624511719,
        9400: 9811925214.839365005493164,
        9410: 9771098058.363811492919922,
        9420: 9730482993.807329177856445,
        9430: 9690078700.635307312011719,
        9440: 9649883867.893711090087891,
        9450: 9609897194.129695892333984,
        9460: 9570117387.313077926635742,
        9470: 9530543164.758384704589844,
        9480: 9491173253.047763824462891,
        9490: 9452006387.954532623291016,
        9500: 9413041314.367454528808594,
        9510: 9374276786.215711593627930,
        9520: 9335711566.394573211669922,
        9530: 9297344426.691776275634766,
        9540: 9259174147.714525222778320,
        9550: 9221199518.817226409912109,
        9560: 9183419338.029861450195312,
        9570: 9145832411.987039566040039,
        9580: 9108437555.857624053955078,
        9590: 9071233593.275129318237305,
        9600: 9034219356.268672943115234,
        9610: 8997393685.194557189941406,
        9620: 8960755428.668531417846680,
        9630: 8924303443.498617172241211,
        9640: 8888036594.618572235107422,
        9650: 8851953755.021991729736328,
        9660: 8816053805.696960449218750,
        9670: 8780335635.561288833618164,
        9680: 8744798141.398412704467773,
        9690: 8709440227.793813705444336,
        9700: 8674260807.072034835815430,
        9710: 8639258799.234298706054688,
        9720: 8604433131.896572113037109,
        9730: 8569782740.228380203247070,
        9740: 8535306566.892041206359863,
        9750: 8501003561.982424736022949,
        9760: 8466872682.967408180236816,
        9770: 8432912894.628675460815430,
        9780: 8399123169.003227233886719,
        9790: 8365502485.325300216674805,
        9800: 8332049829.968810081481934,
        9810: 8298764196.390439987182617,
        9820: 8265644585.073038101196289,
        9830: 8232690003.469712257385254,
        9840: 8199899465.948283195495605,
        9850: 8167271993.736355781555176,
        9860: 8134806614.866777420043945,
        9870: 8102502364.123612403869629,
        9880: 8070358282.988652229309082,
        9890: 8038373419.588364601135254,
        9900: 8006546828.641256332397461,
        9910: 7974877571.405799865722656,
        9920: 7943364715.628804206848145,
        9930: 7912007335.494174957275391,
        9940: 7880804511.572180747985840,
        9950: 7849755330.769227027893066,
        9960: 7818858886.277912139892578,
        9970: 7788114277.527709007263184,
        9980: 7757520610.135956764221191,
        9990: 7727076995.859315872192383
    },
    100000: {
        10: 671890609624107008.000000000000000,
        20: 27976228265571860480.000000000000000,
        30: 40836460214991683584.000000000000000,
        40: 32774679698581155840.000000000000000,
        50: 22724984011014295552.000000000000000,
        60: 15315142769174601728.000000000000000,
        70: 10405866787743447040.000000000000000,
        80: 7211023365478845440.000000000000000,
        90: 5111049355718106112.000000000000000,
        100: 3703912490782155776.000000000000000,
        110: 2740300752805675520.000000000000000,
        120: 2066012025066099200.000000000000000,
        130: 1584446501320482560.000000000000000,
        140: 1233963684739070208.000000000000000,
        150: 974430631979339520.000000000000000,
        160: 779186927040088064.000000000000000,
        170: 630176779339719936.000000000000000,
        180: 514947443080543360.000000000000000,
        190: 424763467089027456.000000000000000,
        200: 353399657065342592.000000000000000,
        210: 296354396785256512.000000000000000,
        220: 250328044056138400.000000000000000,
        230: 212871422703010976.000000000000000,
        240: 182145299643189216.000000000000000,
        250: 156753432823085600.000000000000000,
        260: 135625122434049728.000000000000000,
        270: 117931543085696848.000000000000000,
        280: 103025435203875008.000000000000000,
        290: 90397151481864672.000000000000000,
        300: 79642289313649024.000000000000000,
        310: 70437621797485176.000000000000000,
        320: 62523034758476584.000000000000000,
        330: 55687853389797976.000000000000000,
        340: 49760406963154968.000000000000000,
        350: 44600003138620168.000000000000000,
        360: 40090710277847712.000000000000000,
        370: 36136507046856072.000000000000000,
        380: 32657473744682548.000000000000000,
        390: 29586782942318064.000000000000000,
        400: 26868307562109412.000000000000000,
        410: 24454708968765844.000000000000000,
        420: 22305900512117548.000000000000000,
        430: 20387806449044408.000000000000000,
        440: 18671354541651464.000000000000000,
        450: 17131654500610778.000000000000000,
        460: 15747324984369202.000000000000000,
        470: 14499939924677388.000000000000000,
        480: 13373571146833868.000000000000000,
        490: 12354409045798368.000000000000000,
        500: 11430446805294400.000000000000000,
        510: 10591216558507274.000000000000000,
        520: 9827568175243378.000000000000000,
        530: 9131483164222116.000000000000000,
        540: 8495917608819857.000000000000000,
        550: 7914669192658926.000000000000000,
        560: 7382264281231687.000000000000000,
        570: 6893861756021644.000000000000000,
        580: 6445170886060851.000000000000000,
        590: 6032380997876651.000000000000000,
        600: 5652101091235055.000000000000000,
        610: 5301307862944630.000000000000000,
        620: 4977300858386507.000000000000000,
        630: 4677663681564674.000000000000000,
        640: 4400230368200013.500000000000000,
        650: 4143056169789993.500000000000000,
        660: 3904392115275535.000000000000000,
        670: 3682662815530752.500000000000000,
        680: 3476447057970112.000000000000000,
        690: 3284460807098982.500000000000000,
        700: 3105542284205897.500000000000000,
        710: 2938638847549436.500000000000000,
        720: 2782795434912008.500000000000000,
        730: 2637144364570745.500000000000000,
        740: 2500896319633294.500000000000000,
        750: 2373332365175505.000000000000000,
        760: 2253796868418128.000000000000000,
        770: 2141691209885001.500000000000000,
        780: 2036468188588327.500000000000000,
        790: 1937627037196684.500000000000000,
        800: 1844708974199285.000000000000000,
        810: 1757293229569762.250000000000000,
        820: 1674993488592811.500000000000000,
        830: 1597454705546508.250000000000000,
        840: 1524350244999908.750000000000000,
        850: 1455379313730758.250000000000000,
        860: 1390264650810957.250000000000000,
        870: 1328750447348543.250000000000000,
        880: 1270600470799814.750000000000000,
        890: 1215596371746229.000000000000000,
        900: 1163536153629476.500000000000000,
        910: 1114232788207250.250000000000000,
        920: 1067512961476458.875000000000000,
        930: 1023215936548347.000000000000000,
        940: 981192521483935.875000000000000,
        950: 941304131436745.625000000000000,
        960: 903421935626867.125000000000000,
        970: 867426080707203.500000000000000,
        980: 833204982996880.875000000000000,
        990: 800654682864125.500000000000000,
        1000: 769678255254570.875000000000000,
        1010: 740185270992819.250000000000000,
        1020: 712091304044972.000000000000000,
        1030: 685317480426837.750000000000000,
        1040: 659790064883927.875000000000000,
        1050: 635440081862038.750000000000000,
        1060: 612202967636844.750000000000000,
        1070: 590018250782637.375000000000000,
        1080: 568829258438471.125000000000000,
        1090: 548582846078490.687500000000000,
        1100: 529229148715441.812500000000000,
        1110: 510721351665287.312500000000000,
        1120: 493015479179173.687500000000000,
        1130: 476070199408861.937500000000000,
        1140: 459846644315378.125000000000000,
        1150: 444308243259650.375000000000000,
        1160: 429420569130013.062500000000000,
        1170: 415151195966009.812500000000000,
        1180: 401469567132094.937500000000000,
        1190: 388346873179877.875000000000000,
        1200: 375755938614218.250000000000000,
        1210: 363671116847872.062500000000000,
        1220: 352068192692043.312500000000000,
        1230: 340924291786989.000000000000000,
        1240: 330217796428213.937500000000000,
        1250: 319928267290413.375000000000000,
        1260: 310036370593628.937500000000000,
        1270: 300523810294453.187500000000000,
        1280: 291373264920060.000000000000000,
        1290: 282568328694544.375000000000000,
        1300: 274093456635951.843750000000000,
        1310: 265933913328697.125000000000000,
        1320: 258075725100025.437500000000000,
        1330: 250505635351068.781250000000000,
        1340: 243211062812984.281250000000000,
        1350: 236180062516913.906250000000000,
        1360: 229401289283154.187500000000000,
        1370: 222863963550173.218750000000000,
        1380: 216557839378051.375000000000000,
        1390: 210473174473705.562500000000000,
        1400: 204600702096948.843750000000000,
        1410: 198931604717174.312500000000000,
        1420: 193457489300308.625000000000000,
        1430: 188170364114697.187500000000000,
        1440: 183062616952917.625000000000000,
        1450: 178126994674123.968750000000000,
        1460: 173356583978561.656250000000000,
        1470: 168744793332348.125000000000000,
        1480: 164285335966562.468750000000000,
        1490: 159972213880169.875000000000000,
        1500: 155799702781354.781250000000000,
        1510: 151762337906502.343750000000000,
        1520: 147854900660362.093750000000000,
        1530: 144072406024899.218750000000000,
        1540: 140410090688010.015625000000000,
        1550: 136863401846659.265625000000000,
        1560: 133427986642146.109375000000000,
        1570: 130099682188085.906250000000000,
        1580: 126874506154399.218750000000000,
        1590: 123748647873075.968750000000000,
        1600: 120718459933782.015625000000000,
        1610: 117780450239525.531250000000000,
        1620: 114931274494564.593750000000000,
        1630: 112167729098590.000000000000000,
        1640: 109486744422913.468750000000000,
        1650: 106885378445982.078125000000000,
        1660: 104360810727006.109375000000000,
        1670: 101910336697867.828125000000000,
        1680: 99531362254735.453125000000000,
        1690: 97221398632005.796875000000000,
        1700: 94978057542294.843750000000000,
        1710: 92799046567218.812500000000000,
        1720: 90682164784674.859375000000000,
        1730: 88625298619210.625000000000000,
        1740: 86626417902912.671875000000000,
        1750: 84683572135008.531250000000000,
        1760: 82794886929115.218750000000000,
        1770: 80958560637723.765625000000000,
        1780: 79172861144158.468750000000000,
        1790: 77436122812823.781250000000000,
        1800: 75746743589112.812500000000000,
        1810: 74103182240857.906250000000000,
        1820: 72503955733693.562500000000000,
        1830: 70947636733144.140625000000000,
        1840: 69432851226677.515625000000000,
        1850: 67958276259354.382812500000000,
        1860: 66522637777079.523437500000000,
        1870: 65124708571798.992187500000000,
        1880: 63763306323322.687500000000000,
        1890: 62437291732745.804687500000000,
        1900: 61145566742734.914062500000000,
        1910: 59887072840211.578125000000000,
        1920: 58660789437213.765625000000000,
        1930: 57465732325957.929687500000000,
        1940: 56300952204339.914062500000000,
        1950: 55165533268327.421875000000000,
        1960: 54058591867886.570312500000000,
        1970: 52979275223273.523437500000000,
        1980: 51926760198695.382812500000000,
        1990: 50900252130501.710937500000000,
        2000: 49898983707231.640625000000000,
        2010: 48922213898973.976562500000000,
        2020: 47969226933642.460937500000000,
        2030: 47039331317893.484375000000000,
        2040: 46131858900531.851562500000000,
        2050: 45246163976367.156250000000000,
        2060: 44381622428588.453125000000000,
        2070: 43537630907826.914062500000000,
        2080: 42713606046171.054687500000000,
        2090: 41908983704487.054687500000000,
        2100: 41123218251487.203125000000000,
        2110: 40355781873061.015625000000000,
        2120: 39606163910468.414062500000000,
        2130: 38873870226058.000000000000000,
        2140: 38158422595245.757812500000000,
        2150: 37459358123551.375000000000000,
        2160: 36776228687550.398437500000000,
        2170: 36108600398656.421875000000000,
        2180: 35456053088702.921875000000000,
        2190: 34818179816343.460937500000000,
        2200: 34194586393339.230468750000000,
        2210: 33584890929847.593750000000000,
        2220: 32988723397867.968750000000000,
        2230: 32405725212043.500000000000000,
        2240: 31835548827055.089843750000000,
        2250: 31277857350881.332031250000000,
        2260: 30732324173233.140625000000000,
        2270: 30198632608502.992187500000000,
        2280: 29676475552603.671875000000000,
        2290: 29165555153096.800781250000000,
        2300: 28665582492042.460937500000000,
        2310: 28176277281028.160156250000000,
        2320: 27697367567857.785156250000000,
        2330: 27228589454408.882812500000000,
        2340: 26769686825187.335937500000000,
        2350: 26320411086130.000000000000000,
        2360: 25880520913228.371093750000000,
        2370: 25449782010563.703125000000000,
        2380: 25027966877364.523437500000000,
        2390: 24614854583713.492187500000000,
        2400: 24210230554549.097656250000000,
        2410: 23813886361621.605468750000000,
        2420: 23425619523080.679687500000000,
        2430: 23045233310383.167968750000000,
        2440: 22672536562226.796875000000000,
        2450: 22307343505225.531250000000000,
        2460: 21949473581057.371093750000000,
        2470: 21598751279824.894531250000000,
        2480: 21255005979383.035156250000000,
        2490: 20918071790395.664062500000000,
        2500: 20587787406896.773437500000000,
        2510: 20263995962138.527343750000000,
        2520: 19946544889519.617187500000000,
        2530: 19635285788396.281250000000000,
        2540: 19330074294585.210937500000000,
        2550: 19030769955377.640625000000000,
        2560: 18737236108890.097656250000000,
        2570: 18449339767586.339843750000000,
        2580: 18166951505808.753906250000000,
        2590: 17889945351169.265625000000000,
        2600: 17618198679650.585937500000000,
        2610: 17351592114278.847656250000000,
        2620: 17090009427233.361328125000000,
        2630: 16833337445262.886718750000000,
        2640: 16581465958286.595703125000000,
        2650: 16334287631059.765625000000000,
        2660: 16091697917790.964843750000000,
        2670: 15853594979601.480468750000000,
        2680: 15619879604722.279296875000000,
        2690: 15390455131327.828125000000000,
        2700: 15165227372910.802734375000000,
        2710: 14944104546104.138671875000000,
        2720: 14726997200862.775390625000000,
        2730: 14513818152918.560546875000000,
        2740: 14304482418427.208984375000000,
        2750: 14098907150728.072265625000000,
        2760: 13897011579141.205078125000000,
        2770: 13698716949729.546875000000000,
        2780: 13503946467955.089843750000000,
        2790: 13312625243163.746093750000000,
        2800: 13124680234832.917968750000000,
        2810: 12940040200520.382812500000000,
        2820: 12758635645454.869140625000000,
        2830: 12580398773710.945312500000000,
        2840: 12405263440913.037109375000000,
        2850: 12233165108415.677734375000000,
        2860: 12064040798908.714843750000000,
        2870: 11897829053398.726562500000000,
        2880: 11734469889519.128906250000000,
        2890: 11573904761123.845703125000000,
        2900: 11416076519120.523437500000000,
        2910: 11260929373500.970703125000000,
        2920: 11108408856529.130859375000000,
        2930: 10958461787046.505859375000000,
        2940: 10811036235858.013671875000000,
        2950: 10666081492162.441406250000000,
        2960: 10523548030991.246093750000000,
        2970: 10383387481623.851562500000000,
        2980: 10245552596945.958984375000000,
        2990: 10109997223719.628906250000000,
        3000: 9976676273735.705078125000000,
        3010: 9845545695819.326171875000000,
        3020: 9716562448660.236328125000000,
        3030: 9589684474441.564453125000000,
        3040: 9464870673240.574218750000000,
        3050: 9342080878176.779296875000000,
        3060: 9221275831282.849609375000000,
        3070: 9102417160075.427734375000000,
        3080: 8985467354803.007812500000000,
        3090: 8870389746349.591796875000000,
        3100: 8757148484772.743164062500000,
        3110: 8645708518456.250976562500000,
        3120: 8536035573857.646484375000000,
        3130: 8428096135832.139648437500000,
        3140: 8321857428514.056640625000000,
        3150: 8217287396739.326171875000000,
        3160: 8114354687991.163085937500000,
        3170: 8013028634853.088867187500000,
        3180: 7913279237953.237304687500000,
        3190: 7815077149385.129882812500000,
        3200: 7718393656589.584960937500000,
        3210: 7623200666684.125976562500000,
        3220: 7529470691225.600585937500000,
        3230: 7437176831393.412109375000000,
        3240: 7346292763579.575195312500000,
        3250: 7256792725374.211914062500000,
        3260: 7168651501933.775390625000000,
        3270: 7081844412720.704101562500000,
        3280: 6996347298603.179687500000000,
        3290: 6912136509304.377929687500000,
        3300: 6829188891190.437500000000000,
        3310: 6747481775387.057617187500000,
        3320: 6666992966215.409179687500000,
        3330: 6587700729936.908203125000000,
        3340: 6509583783798.747070312500000,
        3350: 6432621285370.584960937500000,
        3360: 6356792822163.951171875000000,
        3370: 6282078401526.432617187500000,
        3380: 6208458440802.091796875000000,
        3390: 6135913757750.541992187500000,
        3400: 6064425561217.242187500000000,
        3410: 5993975442047.647460937500000,
        3420: 5924545364238.199218750000000,
        3430: 5856117656316.931640625000000,
        3440: 5788675002947.847656250000000,
        3450: 5722200436751.911132812500000,
        3460: 5656677330338.943359375000000,
        3470: 5592089388543.883789062500000,
        3480: 5528420640862.424804687500000,
        3490: 5465655434079.360351562500000,
        3500: 5403778425085.023437500000000,
        3510: 5342774573874.017578125000000,
        3520: 5282629136721.348632812500000,
        3530: 5223327659530.821289062500000,
        3540: 5164855971351.128906250000000,
        3550: 5107200178054.551757812500000,
        3560: 5050346656174.054687500000000,
        3570: 4994282046894.507812500000000,
        3580: 4938993250193.272460937500000,
        3590: 4884467419126.501953125000000,
        3600: 4830691954256.869140625000000,
        3610: 4777654498219.096679687500000,
        3620: 4725342930419.064453125000000,
        3630: 4673745361863.555664062500000,
        3640: 4622850130116.290039062500000,
        3650: 4572645794377.416015625000000,
        3660: 4523121130682.809570312500000,
        3670: 4474265127220.076171875000000,
        3680: 4426066979758.170898437500000,
        3690: 4378516087187.196777343750000,
        3700: 4331602047166.062500000000000,
        3710: 4285314651874.602050781250000,
        3720: 4239643883867.494628906250000,
        3730: 4194579912027.524902343750000,
        3740: 4150113087615.192382812500000,
        3750: 4106233940412.317871093750000,
        3760: 4062933174957.280273437500000,
        3770: 4020201666869.129394531250000,
        3780: 3978030459258.574707031250000,
        3790: 3936410759223.487792968750000,
        3800: 3895333934426.615234375000000,
        3810: 3854791509753.378417968750000,
        3820: 3814775164047.901855468750000,
        3830: 3775276726924.840332031250000,
        3840: 3736288175655.537597656250000,
        3850: 3697801632126.229003906250000,
        3860: 3659809359866.398437500000000,
        3870: 3622303761146.023925781250000,
        3880: 3585277374139.207031250000000,
        3890: 3548722870153.067382812500000,
        3900: 3512633050920.036621093750000,
        3910: 3477000845951.869140625000000,
        3920: 3441819309953.889648437500000,
        3930: 3407081620298.156250000000000,
        3940: 3372781074553.465332031250000,
        3950: 3338911088071.613769531250000,
        3960: 3305465191627.692382812500000,
        3970: 3272437029113.641113281250000,
        3980: 3239820355283.478027343750000,
        3990: 3207609033548.875976562500000,
        4000: 3175797033824.082519531250000,
        4010: 3144378430418.616699218750000,
        4020: 3113347399977.013183593750000,
        4030: 3082698219463.904296875000000,
        4040: 3052425264193.846679687500000,
        4050: 3022523005904.450683593750000,
        4060: 2992986010871.985351562500000,
        4070: 2963808938068.105468750000000,
        4080: 2934986537357.166503906250000,
        4090: 2906513647732.755859375000000,
        4100: 2878385195592.524902343750000,
        4110: 2850596193050.724121093750000,
        4120: 2823141736287.099609375000000,
        4130: 2796017003931.607421875000000,
        4140: 2769217255483.850585937500000,
        4150: 2742737829766.679199218750000,
        4160: 2716574143412.784667968750000,
        4170: 2690721689383.833007812500000,
        4180: 2665176035521.238281250000000,
        4190: 2639932823127.702636718750000,
        4200: 2614987765579.017089843750000,
        4210: 2590336646965.294921875000000,
        4220: 2565975320760.875488281250000,
        4230: 2541899708522.411621093750000,
        4240: 2518105798614.316406250000000,
        4250: 2494589644960.966308593750000,
        4260: 2471347365825.144531250000000,
        4270: 2448375142611.956542968750000,
        4280: 2425669218697.741210937500000,
        4290: 2403225898283.323730468750000,
        4300: 2381041545271.119140625000000,
        4310: 2359112582165.524414062500000,
        4320: 2337435488995.963867187500000,
        4330: 2316006802262.227050781250000,
        4340: 2294823113901.466308593750000,
        4350: 2273881070276.423339843750000,
        4360: 2253177371184.375000000000000,
        4370: 2232708768886.348144531250000,
        4380: 2212472067156.084472656250000,
        4390: 2192464120348.431640625000000,
        4400: 2172681832486.568115234375000,
        4410: 2153122156367.768554687500000,
        4420: 2133782092687.269531250000000,
        4430: 2114658689179.676513671875000,
        4440: 2095749039777.755126953125000,
        4450: 2077050283788.137939453125000,
        4460: 2058559605083.393310546875000,
        4470: 2040274231310.416015625000000,
        4480: 2022191433114.404052734375000,
        4490: 2004308523378.546142578125000,
        4500: 1986622856478.504150390625000,
        4510: 1969131827551.874511718750000,
        4520: 1951832871782.029052734375000,
        4530: 1934723463696.016357421875000,
        4540: 1917801116476.408691406250000,
        4550: 1901063381286.532714843750000,
        4560: 1884507846608.979492187500000,
        4570: 1868132137597.093505859375000,
        4580: 1851933915439.008056640625000,
        4590: 1835910876734.125976562500000,
        4600: 1820060752881.735107421875000,
        4610: 1804381309481.422607421875000,
        4620: 1788870345745.081542968750000,
        4630: 1773525693920.321289062500000,
        4640: 1758345218724.942138671875000,
        4650: 1743326816792.258300781250000,
        4660: 1728468416127.122070312500000,
        4670: 1713767975572.291503906250000,
        4680: 1699223484285.010498046875000,
        4690: 1684832961223.588623046875000,
        4700: 1670594454643.706542968750000,
        4710: 1656506041604.285888671875000,
        4720: 1642565827482.759277343750000,
        4730: 1628771945499.382568359375000,
        4740: 1615122556250.694580078125000,
        4750: 1601615847251.562011718750000,
        4760: 1588250032485.995849609375000,
        4770: 1575023351966.225585937500000,
        4780: 1561934071300.169677734375000,
        4790: 1548980481266.856201171875000,
        4800: 1536160897399.816162109375000,
        4810: 1523473659578.187744140625000,
        4820: 1510917131625.423095703125000,
        4830: 1498489700915.400146484375000,
        4840: 1486189777985.852050781250000,
        4850: 1474015796158.821533203125000,
        4860: 1461966211168.262207031250000,
        4870: 1450039500794.283935546875000,
        4880: 1438234164504.248779296875000,
        4890: 1426548723100.341308593750000,
        4900: 1414981718373.625976562500000,
        4910: 1403531712764.352050781250000,
        4920: 1392197289028.423095703125000,
        4930: 1380977049910.032958984375000,
        4940: 1369869617820.037353515625000,
        4950: 1358873634520.282714843750000,
        4960: 1347987760813.592773437500000,
        4970: 1337210676239.276855468750000,
        4980: 1326541078774.147705078125000,
        4990: 1315977684538.914794921875000,
        5000: 1305519227509.781494140625000,
        5010: 1295164459235.205078125000000,
        5020: 1284912148557.733642578125000,
        5030: 1274761081340.743164062500000,
        5040: 1264710060200.014404296875000,
        5050: 1254757904240.148681640625000,
        5060: 1244903448795.513183593750000,
        5070: 1235145545175.879882812500000,
        5080: 1225483060416.419677734375000,
        5090: 1215914877032.217529296875000,
        5100: 1206439892776.969482421875000,
        5110: 1197057020405.999023437500000,
        5120: 1187765187443.352050781250000,
        5130: 1178563335952.971191406250000,
        5140: 1169450422313.841308593750000,
        5150: 1160425416999.070312500000000,
        5160: 1151487304358.762451171875000,
        5170: 1142635082406.678466796875000,
        5180: 1133867762610.525878906250000,
        5190: 1125184369685.943359375000000,
        5200: 1116583941393.923828125000000,
        5210: 1108065528341.855957031250000,
        5220: 1099628193787.800292968750000,
        5230: 1091271013448.294189453125000,
        5240: 1082993075309.266723632812500,
        5250: 1074793479440.311645507812500,
        5260: 1066671337812.023437500000000,
        5270: 1058625774116.509155273437500,
        5280: 1050655923590.856201171875000,
        5290: 1042760932843.681396484375000,
        5300: 1034939959684.503417968750000,
        5310: 1027192172956.083496093750000,
        5320: 1019516752369.539184570312500,
        5330: 1011912888342.207031250000000,
        5340: 1004379781838.254760742187500,
        5350: 996916644211.954956054687500,
        5360: 989522697053.553100585937500,
        5370: 982197172037.737182617187500,
        5380: 974939310774.563842773437500,
        5390: 967748364662.954833984375000,
        5400: 960623594746.507080078125000,
        5410: 953564271571.798217773437500,
        5420: 946569675048.928710937500000,
        5430: 939639094314.464843750000000,
        5440: 932771827596.529296875000000,
        5450: 925967182082.164672851562500,
        5460: 919224473786.896484375000000,
        5470: 912543027426.375610351562500,
        5480: 905922176290.110351562500000,
        5490: 899361262117.330078125000000,
        5500: 892859634974.778808593750000,
        5510: 886416653136.546752929687500,
        5520: 880031682965.858520507812500,
        5530: 873704098798.709838867187500,
        5540: 867433282829.448486328125000,
        5550: 861218624998.180175781250000,
        5560: 855059522879.973754882812500,
        5570: 848955381575.839233398437500,
        5580: 842905613605.513183593750000,
        5590: 836909638801.859375000000000,
        5600: 830966884207.053466796875000,
        5610: 825076783970.359741210937500,
        5620: 819238779247.577880859375000,
        5630: 813452318102.047119140625000,
        5640: 807716855407.265258789062500,
        5650: 802031852750.985351562500000,
        5660: 796396778340.921997070312500,
        5670: 790811106911.852416992187500,
        5680: 785274319634.252197265625000,
        5690: 779785904024.295410156250000,
        5700: 774345353855.351684570312500,
        5710: 768952169070.804321289062500,
        5720: 763605855698.257080078125000,
        5730: 758305925765.098144531250000,
        5740: 753051897215.318725585937500,
        5750: 747843293827.725830078125000,
        5760: 742679645135.309082031250000,
        5770: 737560486345.974487304687500,
        5780: 732485358264.397949218750000,
        5790: 727453807215.164428710937500,
        5800: 722465384967.071166992187500,
        5810: 717519648658.570556640625000,
        5820: 712616160724.385131835937500,
        5830: 707754488823.251953125000000,
        5840: 702934205766.769531250000000,
        5850: 698154889449.314453125000000,
        5860: 693416122779.052124023437500,
        5870: 688717493609.982421875000000,
        5880: 684058594675.056762695312500,
        5890: 679439023520.229858398437500,
        5900: 674858382439.628784179687500,
        5910: 670316278411.577514648437500,
        5920: 665812323035.702636718750000,
        5930: 661346132470.893920898437500,
        5940: 656917327374.275268554687500,
        5950: 652525532841.044555664062500,
        5960: 648170378345.220703125000000,
        5970: 643851497681.322265625000000,
        5980: 639568528906.860839843750000,
        5990: 635321114285.730590820312500,
        6000: 631108900232.432617187500000,
        6010: 626931537257.133300781250000,
        6020: 622788679911.523437500000000,
        6030: 618679986735.504516601562500,
        6040: 614605120204.653930664062500,
        6050: 610563746678.455688476562500,
        6060: 606555536349.328125000000000,
        6070: 602580163192.358398437500000,
        6080: 598637304915.822998046875000,
        6090: 594726642912.391845703125000,
        6100: 590847862211.093872070312500,
        6110: 587000651429.943359375000000,
        6120: 583184702729.297973632812500,
        6130: 579399711765.859252929687500,
        6140: 575645377647.362548828125000,
        6150: 571921402887.958496093750000,
        6160: 568227493364.160644531250000,
        6170: 564563358271.532714843750000,
        6180: 560928710081.914062500000000,
        6190: 557323264501.335327148437500,
        6200: 553746740428.481689453125000,
        6210: 550198859913.805297851562500,
        6220: 546679348119.184265136718750,
        6230: 543187933278.196533203125000,
        6240: 539724346656.930480957031250,
        6250: 536288322515.403564453125000,
        6260: 532879598069.468078613281250,
        6270: 529497913453.316040039062500,
        6280: 526143011682.501403808593750,
        6290: 522814638617.473449707031250,
        6300: 519512542927.640319824218750,
        6310: 516236476055.969055175781250,
        6320: 512986192184.024719238281250,
        6330: 509761448197.552612304687500,
        6340: 506562003652.561523437500000,
        6350: 503387620741.804931640625000,
        6360: 500238064261.836853027343750,
        6370: 497113101580.453369140625000,
        6380: 494012502604.617980957031250,
        6390: 490936039748.865722656250000,
        6400: 487883487904.071166992187500,
        6410: 484854624406.747802734375000,
        6420: 481849229008.702514648437500,
        6430: 478867083847.157531738281250,
        6440: 475907973415.253601074218750,
        6450: 472971684532.988220214843750,
        6460: 470058006318.552246093750000,
        6470: 467166730160.034606933593750,
        6480: 464297649687.581115722656250,
        6490: 461450560745.869262695312500,
        6500: 458625261366.989562988281250,
        6510: 455821551743.720092773437500,
        6520: 453039234203.138000488281250,
        6530: 450278113180.600952148437500,
        6540: 447537995194.099853515625000,
        6550: 444818688818.937255859375000,
        6560: 442120004662.777709960937500,
        6570: 439441755341.015625000000000,
        6580: 436783755452.486022949218750,
        6590: 434145821555.522033691406250,
        6600: 431527772144.301025390625000,
        6610: 428929427625.551452636718750,
        6620: 426350610295.543273925781250,
        6630: 423791144317.410522460937500,
        6640: 421250855698.766357421875000,
        6650: 418729572269.621032714843750,
        6660: 416227123660.609375000000000,
        6670: 413743341281.492492675781250,
        6680: 411278058299.954467773437500,
        6690: 408831109620.703125000000000,
        6700: 406402331864.798828125000000,
        6710: 403991563349.330871582031250,
        6720: 401598644067.296142578125000,
        6730: 399223415667.782470703125000,
        6740: 396865721436.420410156250000,
        6750: 394525406276.069274902343750,
        6760: 392202316687.778198242187500,
        6770: 389896300751.984741210937500,
        6780: 387607208109.980651855468750,
        6790: 385334889945.601928710937500,
        6800: 383079198967.183105468750000,
        6810: 380839989389.715026855468750,
        6820: 378617116917.276611328125000,
        6830: 376410438725.665283203125000,
        6840: 374219813445.266418457031250,
        6850: 372045101144.165100097656250,
        6860: 369886163311.435607910156250,
        6870: 367742862840.687744140625000,
        6880: 365615064013.810974121093750,
        6890: 363502632484.942993164062500,
        6900: 361405435264.615417480468750,
        6910: 359323340704.138671875000000,
        6920: 357256218480.170532226562500,
        6930: 355203939579.496887207031250,
        6940: 353166376283.994140625000000,
        6950: 351143402155.789306640625000,
        6960: 349134892022.624084472656250,
        6970: 347140721963.394775390625000,
        6980: 345160769293.879882812500000,
        6990: 343194912552.634704589843750,
        7000: 341243031487.120788574218750,
        7010: 339305007039.928894042968750,
        7020: 337380721335.265869140625000,
        7030: 335470057665.531372070312500,
        7040: 333572900478.143615722656250,
        7050: 331689135362.462951660156250,
        7060: 329818649036.929321289062500,
        7070: 327961329336.351806640625000,
        7080: 326117065199.323669433593750,
        7090: 324285746655.864624023437500,
        7100: 322467264815.151306152343750,
        7110: 320661511853.444885253906250,
        7120: 318868381002.150634765625000,
        7130: 317087766536.043884277343750,
        7140: 315319563761.617248535156250,
        7150: 313563669005.604125976562500,
        7160: 311819979603.632812500000000,
        7170: 310088393889.008178710937500,
        7180: 308368811181.655029296875000,
        7190: 306661131777.200683593750000,
        7200: 304965256936.165100097656250,
        7210: 303281088873.310729980468750,
        7220: 301608530747.126037597656250,
        7230: 299947486649.417236328125000,
        7240: 298297861595.054809570312500,
        7250: 296659561511.826660156250000,
        7260: 295032493230.426635742187500,
        7270: 293416564474.564025878906250,
        7280: 291811683851.192016601562500,
        7290: 290217760840.869323730468750,
        7300: 288634705788.210571289062500,
        7310: 287062429892.492675781250000,
        7320: 285500845198.343811035156250,
        7330: 283949864586.571228027343750,
        7340: 282409401765.066101074218750,
        7350: 280879371259.870727539062500,
        7360: 279359688406.301513671875000,
        7370: 277850269340.216552734375000,
        7380: 276351030989.372131347656250,
        7390: 274861891064.890197753906250,
        7400: 273382768052.829620361328125,
        7410: 271913581205.851104736328125,
        7420: 270454250534.988403320312500,
        7430: 269004696801.530456542968750,
        7440: 267564841508.974304199218750,
        7450: 266134606895.103668212890625,
        7460: 264713915924.144927978515625,
        7470: 263302692279.011596679687500,
        7480: 261900860353.672424316406250,
        7490: 260508345245.573822021484375,
        7500: 259125072748.171447753906250,
        7510: 257750969343.555084228515625,
        7520: 256385962195.147399902343750,
        7530: 255029979140.506652832031250,
        7540: 253682948684.196228027343750,
        7550: 252344799990.747802734375000,
        7560: 251015462877.719573974609375,
        7570: 249694867808.809020996093750,
        7580: 248382945887.073913574218750,
        7590: 247079628848.228698730468750,
        7600: 245784849053.989349365234375,
        7610: 244498539485.552062988281250,
        7620: 243220633737.095611572265625,
        7630: 241951066009.391357421875000,
        7640: 240689771103.472839355468750,
        7650: 239436684414.397918701171875,
        7660: 238191741925.053161621093750,
        7670: 236954880200.070343017578125,
        7680: 235726036379.773956298828125,
        7690: 234505148174.230316162109375,
        7700: 233292153857.344482421875000,
        7710: 232086992261.040771484375000,
        7720: 230889602769.508636474609375,
        7730: 229699925313.499938964843750,
        7740: 228517900364.714630126953125,
        7750: 227343468930.230926513671875,
        7760: 226176572547.021423339843750,
        7770: 225017153276.510009765625000,
        7780: 223865153699.204986572265625,
        7790: 222720516909.397674560546875,
        7800: 221583186509.904052734375000,
        7810: 220453106606.880523681640625,
        7820: 219330221804.708312988281250,
        7830: 218214477200.904602050781250,
        7840: 217105818381.131378173828125,
        7850: 216004191414.224487304687500,
        7860: 214909542847.312347412109375,
        7870: 213821819700.960327148437500,
        7880: 212740969464.394927978515625,
        7890: 211666940090.767364501953125,
        7900: 210599679992.474212646484375,
        7910: 209539138036.531555175781250,
        7920: 208485263540.005096435546875,
        7930: 207438006265.491943359375000,
        7940: 206397316416.641967773437500,
        7950: 205363144633.742675781250000,
        7960: 204335441989.344329833984375,
        7970: 203314159983.954956054687500,
        7980: 202299250541.739532470703125,
        7990: 201290666006.329986572265625,
        8000: 200288359136.613342285156250,
        8010: 199292283102.630218505859375,
        8020: 198302391481.473358154296875,
        8030: 197318638253.254547119140625,
        8040: 196340977797.110565185546875,
        8050: 195369364887.254974365234375,
        8060: 194403754689.069000244140625,
        8070: 193444102755.244201660156250,
        8080: 192490365021.962951660156250,
        8090: 191542497805.115417480468750,
        8100: 190600457796.579498291015625,
        8110: 189664202060.502868652343750,
        8120: 188733688029.680389404296875,
        8130: 187808873501.910919189453125,
        8140: 186889716636.446716308593750,
        8150: 185976175950.453460693359375,
        8160: 185068210315.510620117187500,
        8170: 184165778954.161743164062500,
        8180: 183268841436.486755371093750,
        8190: 182377357676.734100341796875,
        8200: 181491287929.969543457031250,
        8210: 180610592788.759887695312500,
        8220: 179735233179.921356201171875,
        8230: 178865170361.265930175781250,
        8240: 178000365918.406005859375000,
        8250: 177140781761.594024658203125,
        8260: 176286380122.583740234375000,
        8270: 175437123551.534362792968750,
        8280: 174592974913.949249267578125,
        8290: 173753897387.640960693359375,
        8300: 172919854459.738525390625000,
        8310: 172090809923.714416503906250,
        8320: 171266727876.454345703125000,
        8330: 170447572715.357574462890625,
        8340: 169633309135.461578369140625,
        8350: 168823902126.600616455078125,
        8360: 168019316970.601074218750000,
        8370: 167219519238.497619628906250,
        8380: 166424474787.788421630859375,
        8390: 165634149759.702545166015625,
        8400: 164848510576.521423339843750,
        8410: 164067523938.910675048828125,
        8420: 163291156823.284545898437500,
        8430: 162519376479.201080322265625,
        8440: 161752150426.780975341796875,
        8450: 160989446454.156433105468750,
        8460: 160231232614.951080322265625,
        8470: 159477477225.777313232421875,
        8480: 158728148863.765930175781250,
        8490: 157983216364.120391845703125,
        8500: 157242648817.701446533203125,
        8510: 156506415568.628906250000000,
        8520: 155774486211.911529541015625,
        8530: 155046830591.107879638671875,
        8540: 154323418796.004364013671875,
        8550: 153604221160.318969726562500,
        8560: 152889208259.432708740234375,
        8570: 152178350908.144012451171875,
        8580: 151471620158.439392089843750,
        8590: 150768987297.297760009765625,
        8600: 150070423844.511260986328125,
        8610: 149375901550.528106689453125,
        8620: 148685392394.325012207031250,
        8630: 147998868581.293060302734375,
        8640: 147316302541.152984619140625,
        8650: 146637666925.880920410156250,
        8660: 145962934607.671478271484375,
        8670: 145292078676.912139892578125,
        8680: 144625072440.169708251953125,
        8690: 143961889418.226135253906250,
        8700: 143302503344.096984863281250,
        8710: 142646888161.104248046875000,
        8720: 141995018020.945678710937500,
        8730: 141346867281.797760009765625,
        8740: 140702410506.424621582031250,
        8750: 140061622460.326629638671875,
        8760: 139424478109.885894775390625,
        8770: 138790952620.547546386718750,
        8780: 138161021355.005371093750000,
        8790: 137534659871.420410156250000,
        8800: 136911843921.647476196289062,
        8810: 136292549449.483032226562500,
        8820: 135676752588.931625366210938,
        8830: 135064429662.488082885742188,
        8840: 134455557179.437210083007812,
        8850: 133850111834.173126220703125,
        8860: 133248070504.535369873046875,
        8870: 132649410250.158752441406250,
        8880: 132054108310.839874267578125,
        8890: 131462142104.926361083984375,
        8900: 130873489227.712142944335938,
        8910: 130288127449.861236572265625,
        8920: 129706034715.834609985351562,
        8930: 129127189142.343353271484375,
        8940: 128551569016.811080932617188,
        8950: 127979152795.853042602539062,
        8960: 127409919103.774902343750000,
        8970: 126843846731.073760986328125,
        8980: 126280914632.975662231445312,
        8990: 125721101927.963470458984375,
        9000: 125164387896.338638305664062,
        9010: 124610751978.786941528320312,
        9020: 124060173774.957366943359375,
        9030: 123512633042.068481445312500,
        9040: 122968109693.512069702148438,
        9050: 122426583797.475692749023438,
        9060: 121888035575.585968017578125,
        9070: 121352445401.562194824218750,
        9080: 120819793799.871139526367188,
        9090: 120290061444.415786743164062,
        9100: 119763229157.218856811523438,
        9110: 119239277907.134262084960938,
        9120: 118718188808.554656982421875,
        9130: 118199943120.147109985351562,
        9140: 117684522243.594436645507812,
        9150: 117171907722.348983764648438,
        9160: 116662081240.394241333007812,
        9170: 116155024621.032958984375000,
        9180: 115650719825.664627075195312,
        9190: 115149148952.599609375000000,
        9200: 114650294235.866775512695312,
        9210: 114154138044.041168212890625,
        9220: 113660662879.075347900390625,
        9230: 113169851375.157791137695312,
        9240: 112681686297.559295654296875,
        9250: 112196150541.516647338867188,
        9260: 111713227131.101516723632812,
        9270: 111232899218.123184204101562,
        9280: 110755150081.023712158203125,
        9290: 110279963123.791336059570312,
        9300: 109807321874.894256591796875,
        9310: 109337209986.200942993164062,
        9320: 108869611231.933273315429688,
        9330: 108404509507.620025634765625,
        9340: 107941888829.061096191406250,
        9350: 107481733331.299713134765625,
        9360: 107024027267.608001708984375,
        9370: 106568755008.485412597656250,
        9380: 106115901040.656021118164062,
        9390: 105665449966.084838867187500,
        9400: 105217386501.002014160156250,
        9410: 104771695474.930221557617188,
        9420: 104328361829.734115600585938,
        9430: 103887370618.656921386718750,
        9440: 103448707005.397048950195312,
        9450: 103012356263.160537719726562,
        9460: 102578303773.750625610351562,
        9470: 102146535026.642623901367188,
        9480: 101717035618.088165283203125,
        9490: 101289791250.211822509765625,
        9500: 100864787730.126861572265625,
        9510: 100442010969.048751831054688,
        9520: 100021446981.432312011718750,
        9530: 99603081884.101867675781250,
        9540: 99186901895.394653320312500,
        9550: 98772893334.320663452148438,
        9560: 98361042619.716125488281250,
        9570: 97951336269.413696289062500,
        9580: 97543760899.419174194335938,
        9590: 97138303223.098510742187500,
        9600: 96734950050.360336303710938,
        9610: 96333688286.868118286132812,
        9620: 95934504933.232070922851562,
        9630: 95537387084.235244750976562,
        9640: 95142321928.050109863281250,
        9650: 94749296745.460998535156250,
        9660: 94358298909.112167358398438,
        9670: 93969315882.740478515625000,
        9680: 93582335220.426589965820312,
        9690: 93197344565.859863281250000,
        9700: 92814331651.586746215820312,
        9710: 92433284298.296722412109375,
        9720: 92054190414.088363647460938,
        9730: 91677037993.759170532226562,
        9740: 91301815118.094863891601562,
        9750: 90928509953.161254882812500,
        9760: 90557110749.613769531250000,
        9770: 90187605842.007949829101562,
        9780: 89819983648.107666015625000,
        9790: 89454232668.214202880859375,
        9800: 89090341484.492767333984375,
        9810: 88728298760.306793212890625,
        9820: 88368093239.559768676757812,
        9830: 88009713746.043197631835938,
        9840: 87653149182.781036376953125,
        9850: 87298388531.401718139648438,
        9860: 86945420851.491790771484375,
        9870: 86594235279.970443725585938,
        9880: 86244821030.464126586914062,
        9890: 85897167392.690994262695312,
        9900: 85551263731.843322753906250,
        9910: 85207099487.984375000000000,
        9920: 84864664175.443206787109375,
        9930: 84523947382.224227905273438,
        9940: 84184938769.408706665039062,
        9950: 83847628070.574142456054688,
        9960: 83512005091.210250854492188,
        9970: 83178059708.148803710937500,
        9980: 82845781868.989334106445312,
        9990: 82515161591.536300659179688
    }
}

BLACKBODY_SD_DATA = (
    6654278270641.816406250000000,
    6709605279251.824218750000000,
    6764825121520.021484375000000,
    6819933078643.318359375000000,
    6874924489829.658203125000000,
    6929794752622.360351562500000,
    6984539323198.423828125000000,
    7039153716641.197265625000000,
    7093633507187.919921875000000,
    7147974328452.790039062500000,
    7202171873625.862304687500000,
    7256221895648.417968750000000,
    7310120207365.277343750000000,
    7363862681654.514648437500000,
    7417445251535.198242187500000,
    7470863910253.427734375000000,
    7524114711347.416015625000000,
    7577193768691.916015625000000,
    7630097256522.627929687500000,
    7682821409440.859375000000000,
    7735362522399.223632812500000,
    7787716950668.553710937500000,
    7839881109786.629882812500000,
    7891851475489.291015625000000,
    7943624583624.192382812500000,
    7995197030047.749023437500000,
    8046565470505.862304687500000,
    8097726620498.582031250000000,
    8148677255129.426757812500000,
    8199414208939.659179687500000,
    8249934375727.927734375000000,
    8300234708355.858398437500000,
    8350312218539.783203125000000,
    8400163976629.247070312500000,
    8449787111372.560546875000000,
    8499178809669.856445312500000,
    8548336316314.085937500000000,
    8597256933720.230468750000000,
    8645938021643.253906250000000,
    8694376996885.131835937500000,
    8742571332991.204101562500000,
    8790518559936.536132812500000,
    8838216263802.244140625000000,
    8885662086442.513671875000000,
    8932853725142.396484375000000,
    8979788932266.947265625000000,
    9026465514901.832031250000000,
    9072881334485.917968750000000,
    9119034306436.068359375000000,
    9164922399764.525390625000000,
    9210543636689.166015625000000,
    9255896092236.906250000000000,
    9300977893840.705078125000000,
    9345787220930.265625000000000,
    9390322304516.886718750000000,
    9434581426772.675781250000000,
    9478562920604.419921875000000,
    9522265169222.408203125000000,
    9565686605704.517578125000000,
    9608825712555.613281250000000,
    9651681021262.902343750000000,
    9694251111847.093750000000000,
    9736534612409.925781250000000,
    9778530198678.093750000000000,
    9820236593543.974609375000000,
    9861652566603.218750000000000,
    9902776933689.582031250000000,
    9943608556407.177734375000000,
    9984146341660.271484375000000,
    10024389241180.996093750000000,
    10064336251055.019531250000000,
    10103986411245.570312500000000,
    10143338805115.728515625000000,
    10182392558949.537109375000000,
    10221146841471.769531250000000,
    10259600863366.845703125000000,
    10297753876796.675781250000000,
    10335605174918.224609375000000,
    10373154091400.220703125000000,
    10410399999939.767578125000000,
    10447342313778.720703125000000,
    10483980485220.085937500000000,
    10520314005144.519531250000000,
    10556342402527.148437500000000,
    10592065243954.837890625000000,
    10627482133143.962890625000000,
    10662592710459.015625000000000,
    10697396652431.820312500000000,
    10731893671281.994140625000000,
    10766083514438.222656250000000,
    10799965964060.962890625000000,
    10833540836566.228515625000000,
    10866807982151.029296875000000,
    10899767284320.166015625000000,
    10932418659414.785156250000000,
    10964762056142.583984375000000,
    10996797455109.843750000000000,
    11028524868355.517578125000000,
    11059944338887.140625000000000,
    11091055940219.013671875000000,
    11121859775912.460937500000000,
    11152355979118.445312500000000,
    11182544712122.427734375000000,
    11212426165891.753906250000000,
    11242000559625.406250000000000,
    11271268140306.480468750000000,
    11300229182257.111328125000000,
    11328883986696.255859375000000,
    11357232881300.062500000000000,
    11385276219765.179687500000000,
    11413014381374.892578125000000,
    11440447770568.144531250000000,
    11467576816511.492187500000000,
    11494401972674.251953125000000,
    11520923716406.490234375000000,
    11547142548520.236328125000000,
    11573058992873.833984375000000,
    11598673595959.460937500000000,
    11623986926493.828125000000000,
    11648999575012.269531250000000,
    11673712153465.964843750000000,
    11698125294822.560546875000000,
    11722239652670.162109375000000,
    11746055900824.623046875000000,
    11769574732940.322265625000000,
    11792796862124.296875000000000,
    11815723020553.906250000000000,
    11838353959097.839843750000000,
    11860690446940.724609375000000,
    11882733271211.160156250000000,
    11904483236613.302734375000000,
    11925941165062.001953125000000,
    11947107895321.388671875000000,
    11967984282647.136718750000000,
    11988571198432.212890625000000,
    12008869529856.134765625000000,
    12028880179537.986328125000000,
    12048604065192.845703125000000,
    12068042119291.859375000000000,
    12087195288725.925781250000000,
    12106064534472.861328125000000,
    12124650831268.345703125000000,
    12142955167280.287109375000000,
    12160978543786.837890625000000,
    12178721974857.982421875000000,
    12196186487040.689453125000000,
    12213373119047.705078125000000,
    12230282921449.855468750000000,
    12246916956371.861328125000000,
    12263276297191.845703125000000,
    12279362028244.257812500000000,
    12295175244526.406250000000000,
    12310717051408.449218750000000,
    12325988564347.025390625000000,
    12340990908602.222656250000000,
    12355725218958.162109375000000,
    12370192639447.005859375000000,
    12384394323076.429687500000000,
    12398331431560.562500000000000,
    12412005135054.371093750000000,
    12425416611891.378906250000000,
    12438567048324.935546875000000,
    12451457638272.658203125000000,
    12464089583064.539062500000000,
    12476464091194.037109375000000,
    12488582378072.853515625000000,
    12500445665788.748046875000000,
    12512055182866.818359375000000,
    12523412164033.970703125000000,
    12534517849986.644531250000000,
    12545373487161.810546875000000,
    12555980327511.164062500000000,
    12566339628278.517578125000000,
    12576452651780.255859375000000,
    12586320665189.134765625000000,
    12595944940321.068359375000000,
    12605326753425.015625000000000,
    12614467384975.994140625000000,
    12623368119471.160156250000000,
    12632030245228.828125000000000,
    12640455054190.626953125000000,
    12648643841726.587890625000000,
    12656597906443.111328125000000,
    12664318549994.041015625000000,
    12671807076894.480468750000000,
    12679064794337.593750000000000,
    12686093012014.308593750000000,
    12692893041935.687500000000000,
    12699466198258.367187500000000,
    12705813797112.535156250000000,
    12711937156432.800781250000000,
    12717837595791.857421875000000,
    12723516436236.710937500000000,
    12728975000127.753906250000000,
    12734214610980.357421875000000,
    12739236593309.203125000000000,
    12744042272475.173828125000000,
    12748632974534.929687500000000,
    12753010026092.843750000000000,
    12757174754155.734375000000000,
    12761128485989.890625000000000,
    12764872548980.687500000000000,
    12768408270494.654296875000000,
    12771736977743.972656250000000,
    12774859997653.355468750000000,
    12777778656729.365234375000000,
    12780494280932.046875000000000,
    12783008195548.845703125000000,
    12785321725071.000000000000000,
    12787436193072.056640625000000,
    12789352922088.681640625000000,
    12791073233503.761718750000000,
    12792598447431.654296875000000,
    12793929882605.611328125000000,
    12795068856267.462890625000000,
    12796016684059.291015625000000,
    12796774679917.308593750000000,
    12797344155967.820312500000000,
    12797726422425.179687500000000,
    12797922787491.859375000000000,
    12797934557260.468750000000000,
    12797763035617.822265625000000,
    12797409524150.900390625000000,
    12796875322054.816406250000000,
    12796161726042.638671875000000,
    12795270030257.166015625000000,
    12794201526184.548828125000000,
    12792957502569.716796875000000,
    12791539245333.675781250000000,
    12789948037492.640625000000000,
    12788185159078.791015625000000,
    12786251887063.007812500000000,
    12784149495279.119140625000000,
    12781879254350.060546875000000,
    12779442431615.486328125000000,
    12776840291061.330078125000000,
    12774074093250.712890625000000,
    12771145095256.708984375000000,
    12768054550596.617187500000000,
    12764803709167.744140625000000,
    12761393817184.904296875000000,
    12757826117119.259765625000000,
    12754101847638.871093750000000,
    12750222243550.609375000000000,
    12746188535743.562500000000000,
    12742001951133.974609375000000,
    12737663712611.490234375000000,
    12733175038986.910156250000000,
    12728537144941.330078125000000,
    12723751240976.582031250000000,
    12718818533367.134765625000000,
    12713740224113.177734375000000,
    12708517510895.238281250000000,
    12703151587029.873046875000000,
    12697643641426.753906250000000,
    12691994858547.029296875000000,
    12686206418362.818359375000000,
    12680279496318.066406250000000,
    12674215263290.443359375000000,
    12668014885554.613281250000000,
    12661679524746.468750000000000,
    12655210337828.740234375000000,
    12648608477057.458984375000000,
    12641875089949.822265625000000,
    12635011319252.974609375000000,
    12628018302913.916015625000000,
    12620897174050.449218750000000,
    12613649060923.275390625000000,
    12606275086908.966796875000000,
    12598776370474.070312500000000,
    12591154025150.177734375000000,
    12583409159509.970703125000000,
    12575542877144.205078125000000,
    12567556276639.730468750000000,
    12559450451558.285156250000000,
    12551226490416.474609375000000,
    12542885476666.349609375000000,
    12534428488677.109375000000000,
    12525856599717.566406250000000,
    12517170877939.468750000000000,
    12508372386361.767578125000000,
    12499462182855.589843750000000,
    12490441320130.119140625000000,
    12481310845719.218750000000000,
    12472071801968.931640625000000,
    12462725226025.638671875000000,
    12453272149825.078125000000000,
    12443713600082.099609375000000,
    12434050598281.087890625000000,
    12424284160667.234375000000000,
    12414415298238.335937500000000,
    12404445016737.533203125000000,
    12394374316646.484375000000000,
    12384204193179.453125000000000,
    12373935636277.810546875000000,
    12363569630605.447265625000000,
    12353107155544.566406250000000,
    12342549185192.320312500000000,
    12331896688357.947265625000000,
    12321150628560.488281250000000,
    12310311964027.224609375000000,
    12299381647692.541015625000000,
    12288360627197.451171875000000,
    12277249844889.679687500000000,
    12266050237824.259765625000000,
    12254762737764.673828125000000,
    12243388271184.570312500000000,
    12231927759269.892578125000000,
    12220382117921.642578125000000,
    12208752257759.042968750000000,
    12197039084123.230468750000000,
    12185243497081.410156250000000,
    12173366391431.496093750000000,
    12161408656707.199218750000000,
    12149371177183.517578125000000,
    12137254831882.794921875000000,
    12125060494581.031250000000000,
    12112789033814.806640625000000,
    12100441312888.402343750000000,
    12088018189881.537109375000000,
    12075520517657.367187500000000,
    12062949143870.912109375000000,
    12050304910977.828125000000000,
    12037588656243.650390625000000,
    12024801211753.224609375000000,
    12011943404420.666015625000000,
    11999016055999.574218750000000,
    11986019983093.574218750000000,
    11972955997167.261718750000000,
    11959824904557.355468750000000,
    11946627506484.298828125000000,
    11933364599064.089843750000000,
    11920036973320.384765625000000,
    11906645415196.972656250000000,
    11893190705570.496093750000000,
    11879673620263.431640625000000,
    11866094930057.384765625000000,
    11852455400706.646484375000000,
    11838755792951.931640625000000,
    11824996862534.492187500000000,
    11811179360210.417968750000000,
    11797304031765.101562500000000,
    11783371618028.107421875000000,
    11769382854888.080078125000000,
    11755338473308.052734375000000,
    11741239199340.796875000000000,
    11727085754144.552734375000000,
    11712878853998.804687500000000,
    11698619210320.353515625000000,
    11684307529679.597656250000000,
    11669944513816.888671875000000,
    11655530859659.210937500000000,
    11641067259336.898437500000000,
    11626554400200.638671875000000,
    11611992964838.582031250000000,
    11597383631093.628906250000000,
    11582727072080.847656250000000,
    11568023956205.076171875000000,
    11553274947178.664062500000000,
    11538480704039.337890625000000,
    11523641881168.228515625000000,
    11508759128307.998046875000000,
    11493833090581.142578125000000,
    11478864408508.326171875000000,
    11463853718026.964843750000000,
    11448801650509.822265625000000,
    11433708832783.753906250000000,
    11418575887148.539062500000000,
    11403403431395.851562500000000,
    11388192078828.281250000000000,
    11372942438278.482421875000000,
    11357655114128.410156250000000,
    11342330706328.626953125000000,
    11326969810417.693359375000000,
    11311573017541.658203125000000,
    11296140914473.591796875000000,
    11280674083633.222656250000000,
    11265173103106.638671875000000,
    11249638546666.001953125000000,
    11234070983789.425781250000000,
    11218470979680.794921875000000,
    11202839095289.714843750000000,
    11187175887331.517578125000000,
    11171481908307.240234375000000,
    11155757706523.761718750000000,
    11140003826113.857421875000000,
    11124220807056.410156250000000,
    11108409185196.574218750000000,
    11092569492266.005859375000000,
    11076702255903.128906250000000,
    11060807999673.421875000000000,
    11044887243089.707031250000000,
    11028940501632.523437500000000,
    11012968286770.445312500000000,
    10996971105980.474609375000000,
    10980949462768.435546875000000,
    10964903856689.341796875000000,
    10948834783367.830078125000000,
    10932742734518.595703125000000,
    10916628197966.777343750000000,
    10900491657668.412109375000000,
    10884333593730.849609375000000,
    10868154482433.187500000000000,
    10851954796246.691406250000000,
    10835735003855.212890625000000,
    10819495570175.609375000000000,
    10803236956378.148437500000000,
    10786959619906.878906250000000,
    10770664014500.017578125000000,
    10754350590210.328125000000000,
    10738019793425.453125000000000,
    10721672066888.240234375000000,
    10705307849717.056640625000000,
    10688927577426.070312500000000,
    10672531681945.503906250000000,
    10656120591641.878906250000000,
    10639694731338.240234375000000,
    10623254522334.294921875000000,
    10606800382426.603515625000000,
    10590332725928.654296875000000,
    10573851963691.009765625000000,
    10557358503121.294921875000000,
    10540852748204.236328125000000,
    10524335099521.660156250000000,
    10507805954272.380859375000000,
    10491265706292.148437500000000,
    10474714746073.468750000000000,
    10458153460785.447265625000000,
    10441582234293.515625000000000,
    10425001447179.210937500000000,
    10408411476759.814453125000000,
    10391812697108.000000000000000,
    10375205479071.404296875000000,
    10358590190292.175781250000000,
    10341967195226.443359375000000,
    10325336855163.761718750000000,
    10308699528246.460937500000000,
    10292055569489.031250000000000,
    10275405330797.310546875000000,
    10258749160987.755859375000000,
    10242087405806.607421875000000,
    10225420407948.955078125000000,
    10208748507077.794921875000000,
    10192072039843.021484375000000,
    10175391339900.339843750000000,
    10158706737930.152343750000000,
    10142018561656.332031250000000,
    10125327135864.982421875000000,
    10108632782423.103515625000000,
    10091935820297.220703125000000,
    10075236565571.937500000000000,
    10058535331468.398437500000000,
    10041832428362.728515625000000,
    10025128163804.373046875000000,
    10008422842534.433593750000000,
    9991716766503.810546875000000,
    9975010234891.400390625000000,
    9958303544122.207031250000000,
    9941596987885.318359375000000,
    9924890857151.849609375000000,
    9908185440192.857421875000000,
    9891481022597.105468750000000,
    9874777887288.841796875000000,
    9858076314545.429687500000000,
    9841376582014.964843750000000,
    9824678964733.791015625000000,
    9807983735143.947265625000000,
    9791291163110.535156250000000,
    9774601515939.068359375000000,
    9757915058392.632812500000000,
    9741232052709.107421875000000)  # yapf: disable


class TestPlanckLaw(unittest.TestCase):
    """
    Defines :func:`colour.colorimetry.blackbody.planck_law` definition units
    tests methods.
    """

    def test_planck_law(self):
        """
        Tests :func:`colour.colorimetry.blackbody.planck_law` definition.
        """

        for temperature, wavelengths in sorted(PLANCK_LAW_DATA.items()):
            for wavelength, radiance in sorted(wavelengths.items()):
                np.testing.assert_allclose(
                    planck_law(wavelength * 1e-9, temperature),
                    radiance,
                    rtol=0.0000001,
                    atol=0.0000001,
                    verbose=False)

    def test_n_dimensional_planck_law(self):
        """
        Tests :func:`colour.colorimetry.blackbody.planck_law` definition
        n-dimensional arrays support.
        """

        wl = 500 * 1e-9
        p = planck_law(wl, 5500)

        wl = np.tile(wl, 6)
        p = np.tile(p, 6)
        np.testing.assert_almost_equal(planck_law(wl, 5500), p)

        wl = np.reshape(wl, (2, 3))
        p = np.reshape(p, (2, 3))
        np.testing.assert_almost_equal(planck_law(wl, 5500), p)

        wl = np.reshape(wl, (2, 3, 1))
        p = np.reshape(p, (2, 3, 1))
        np.testing.assert_almost_equal(planck_law(wl, 5500), p)

    @ignore_numpy_errors
    def test_nan_planck_law(self):
        """
        Tests :func:`colour.colorimetry.blackbody.planck_law` definition
        nan support.
        """

        cases = [-1.0, 0.0, 1.0, -np.inf, np.inf, np.nan]
        cases = set(permutations(cases * 3, r=3))
        for case in cases:
            planck_law(case, case),


class TestSdBlackbody(unittest.TestCase):
    """
    Defines :func:`colour.colorimetry.blackbody.sd_blackbody` definition unit
    tests methods.
    """

    def test_sd_blackbody(self):
        """
        Tests :func:`colour.colorimetry.blackbody.sd_blackbody` definition.
        """

        np.testing.assert_allclose(
            sd_blackbody(5000, SpectralShape(360, 830, 1)).values,
            BLACKBODY_SD_DATA,
            rtol=0.0000001,
            atol=0.0000001)


if __name__ == '__main__':
    unittest.main()
