! This file was generated by: python weno.py
module weno
contains

subroutine weno5(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
omega1, &
omega5, &
omega0, &
omega4, &
omega3, &
omega2, &
fr1, &
fr5, &
fr0, &
fr4, &
fr3, &
fr2, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 3.3333333333333333333333333333333333d0*q(m,i+0)**2 - &
      10.333333333333333333333333333333333d0*q(m,i+0)*q(m,i+1) + &
      3.6666666666666666666666666666666667d0*q(m,i+0)*q(m,i+2) + &
      8.3333333333333333333333333333333333d0*q(m,i+1)**2 - &
      6.3333333333333333333333333333333333d0*q(m,i+1)*q(m,i+2) + &
      1.3333333333333333333333333333333333d0*q(m,i+2)**2
sigma1 = 4.3333333333333333333333333333333333d0*q(m,i+0)**2 - &
      4.3333333333333333333333333333333333d0*q(m,i+0)*q(m,i+1) - &
      4.3333333333333333333333333333333333d0*q(m,i+0)*q(m,i-1) + &
      1.3333333333333333333333333333333333d0*q(m,i+1)**2 + &
      1.6666666666666666666666666666666667d0*q(m,i+1)*q(m,i-1) + &
      1.3333333333333333333333333333333333d0*q(m,i-1)**2
sigma2 = 3.3333333333333333333333333333333333d0*q(m,i+0)**2 - &
      10.333333333333333333333333333333333d0*q(m,i+0)*q(m,i-1) + &
      3.6666666666666666666666666666666667d0*q(m,i+0)*q(m,i-2) + &
      8.3333333333333333333333333333333333d0*q(m,i-1)**2 - &
      6.3333333333333333333333333333333333d0*q(m,i-1)*q(m,i-2) + &
      1.3333333333333333333333333333333333d0*q(m,i-2)**2
omega0 = 0.1d0/(1.0e-36 + sigma0)**2
omega1 = 0.6d0/(1.0e-36 + sigma1)**2
omega2 = 0.3d0/(1.0e-36 + sigma2)**2
omega3 = 0.3d0/(1.0e-36 + sigma0)**2
omega4 = 0.6d0/(1.0e-36 + sigma1)**2
omega5 = 0.1d0/(1.0e-36 + sigma2)**2
fr0 = 1.8333333333333333333333333333333333d0*q(m,i+0) - &
      1.1666666666666666666666666666666667d0*q(m,i+1) + &
      0.33333333333333333333333333333333333d0*q(m,i+2)
fr1 = 0.83333333333333333333333333333333333d0*q(m,i+0) - &
      0.16666666666666666666666666666666667d0*q(m,i+1) + &
      0.33333333333333333333333333333333333d0*q(m,i-1)
fr2 = 0.33333333333333333333333333333333333d0*q(m,i+0) + &
      0.83333333333333333333333333333333333d0*q(m,i-1) - &
      0.16666666666666666666666666666666667d0*q(m,i-2)
fr3 = 0.33333333333333333333333333333333333d0*q(m,i+0) + &
      0.83333333333333333333333333333333333d0*q(m,i+1) - &
      0.16666666666666666666666666666666667d0*q(m,i+2)
fr4 = 0.83333333333333333333333333333333333d0*q(m,i+0) + &
      0.33333333333333333333333333333333333d0*q(m,i+1) - &
      0.16666666666666666666666666666666667d0*q(m,i-1)
fr5 = 1.8333333333333333333333333333333333d0*q(m,i+0) - &
      1.1666666666666666666666666666666667d0*q(m,i-1) + &
      0.33333333333333333333333333333333333d0*q(m,i-2)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2)/(omega0 + omega1 + omega2)
fs1 = (fr3*omega3 + fr4*omega4 + fr5*omega5)/(omega3 + omega4 + omega5)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno7(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
omega1, &
omega6, &
omega0, &
omega2, &
omega7, &
omega4, &
omega3, &
omega5, &
fr1, &
fr6, &
fr0, &
fr2, &
fr7, &
fr4, &
fr3, &
fr5, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 8.7791666666666666666666666666666667d0*q(m,i+0)**2 - 39.175d0*q(m,i+0)*q &
      (m,i+1) + 29.341666666666666666666666666666667d0*q(m,i+0)*q(m,i+2 &
      ) - 7.725d0*q(m,i+0)*q(m,i+3) + &
      45.845833333333333333333333333333333d0*q(m,i+1)**2 - &
      71.858333333333333333333333333333333d0*q(m,i+1)*q(m,i+2) + &
      19.341666666666666666666666666666667d0*q(m,i+1)*q(m,i+3) + &
      29.345833333333333333333333333333333d0*q(m,i+2)**2 - 16.175d0*q(m &
      ,i+2)*q(m,i+3) + 2.2791666666666666666666666666666667d0*q(m,i+3) &
      **2
sigma1 = 14.345833333333333333333333333333333d0*q(m,i+0)**2 - &
      24.858333333333333333333333333333333d0*q(m,i+0)*q(m,i+1) + &
      6.675d0*q(m,i+0)*q(m,i+2) - &
      10.508333333333333333333333333333333d0*q(m,i+0)*q(m,i-1) + &
      11.845833333333333333333333333333333d0*q(m,i+1)**2 - &
      6.8416666666666666666666666666666667d0*q(m,i+1)*q(m,i+2) + &
      8.0083333333333333333333333333333333d0*q(m,i+1)*q(m,i-1) + &
      1.1125d0*q(m,i+2)**2 - 2.0583333333333333333333333333333333d0*q(m &
      ,i+2)*q(m,i-1) + 2.2791666666666666666666666666666667d0*q(m,i-1) &
      **2
sigma2 = 14.345833333333333333333333333333333d0*q(m,i+0)**2 - &
      10.508333333333333333333333333333333d0*q(m,i+0)*q(m,i+1) - &
      24.858333333333333333333333333333333d0*q(m,i+0)*q(m,i-1) + &
      6.675d0*q(m,i+0)*q(m,i-2) + &
      2.2791666666666666666666666666666667d0*q(m,i+1)**2 + &
      8.0083333333333333333333333333333333d0*q(m,i+1)*q(m,i-1) - &
      2.0583333333333333333333333333333333d0*q(m,i+1)*q(m,i-2) + &
      11.845833333333333333333333333333333d0*q(m,i-1)**2 - &
      6.8416666666666666666666666666666667d0*q(m,i-1)*q(m,i-2) + &
      1.1125d0*q(m,i-2)**2
sigma3 = 8.7791666666666666666666666666666667d0*q(m,i+0)**2 - 39.175d0*q(m,i+0)*q &
      (m,i-1) + 29.341666666666666666666666666666667d0*q(m,i+0)*q(m,i-2 &
      ) - 7.725d0*q(m,i+0)*q(m,i-3) + &
      45.845833333333333333333333333333333d0*q(m,i-1)**2 - &
      71.858333333333333333333333333333333d0*q(m,i-1)*q(m,i-2) + &
      19.341666666666666666666666666666667d0*q(m,i-1)*q(m,i-3) + &
      29.345833333333333333333333333333333d0*q(m,i-2)**2 - 16.175d0*q(m &
      ,i-2)*q(m,i-3) + 2.2791666666666666666666666666666667d0*q(m,i-3) &
      **2
omega0 = 0.028571428571428571428571428571428571d0/(1.0e-36 + sigma0)**2
omega1 = 0.34285714285714285714285714285714286d0/(1.0e-36 + sigma1)**2
omega2 = 0.51428571428571428571428571428571429d0/(1.0e-36 + sigma2)**2
omega3 = 0.11428571428571428571428571428571429d0/(1.0e-36 + sigma3)**2
omega4 = 0.11428571428571428571428571428571429d0/(1.0e-36 + sigma0)**2
omega5 = 0.51428571428571428571428571428571429d0/(1.0e-36 + sigma1)**2
omega6 = 0.34285714285714285714285714285714286d0/(1.0e-36 + sigma2)**2
omega7 = 0.028571428571428571428571428571428571d0/(1.0e-36 + sigma3)**2
fr0 = 2.0833333333333333333333333333333333d0*q(m,i+0) - &
      1.9166666666666666666666666666666667d0*q(m,i+1) + &
      1.0833333333333333333333333333333333d0*q(m,i+2) - 0.25d0*q(m,i+3)
fr1 = 1.0833333333333333333333333333333333d0*q(m,i+0) - &
      0.41666666666666666666666666666666667d0*q(m,i+1) + &
      0.083333333333333333333333333333333333d0*q(m,i+2) + 0.25d0*q(m, &
      i-1)
fr2 = 0.58333333333333333333333333333333333d0*q(m,i+0) - &
      0.083333333333333333333333333333333333d0*q(m,i+1) + &
      0.58333333333333333333333333333333333d0*q(m,i-1) - &
      0.083333333333333333333333333333333333d0*q(m,i-2)
fr3 = 0.25d0*q(m,i+0) + 1.0833333333333333333333333333333333d0*q(m,i-1) - &
      0.41666666666666666666666666666666667d0*q(m,i-2) + &
      0.083333333333333333333333333333333333d0*q(m,i-3)
fr4 = 0.25d0*q(m,i+0) + 1.0833333333333333333333333333333333d0*q(m,i+1) - &
      0.41666666666666666666666666666666667d0*q(m,i+2) + &
      0.083333333333333333333333333333333333d0*q(m,i+3)
fr5 = 0.58333333333333333333333333333333333d0*q(m,i+0) + &
      0.58333333333333333333333333333333333d0*q(m,i+1) - &
      0.083333333333333333333333333333333333d0*q(m,i+2) - &
      0.083333333333333333333333333333333333d0*q(m,i-1)
fr6 = 1.0833333333333333333333333333333333d0*q(m,i+0) + 0.25d0*q(m,i+1) - &
      0.41666666666666666666666666666666667d0*q(m,i-1) + &
      0.083333333333333333333333333333333333d0*q(m,i-2)
fr7 = 2.0833333333333333333333333333333333d0*q(m,i+0) - &
      1.9166666666666666666666666666666667d0*q(m,i-1) + &
      1.0833333333333333333333333333333333d0*q(m,i-2) - 0.25d0*q(m,i-3)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3)/(omega0 + omega1 + &
      omega2 + omega3)
fs1 = (fr4*omega4 + fr5*omega5 + fr6*omega6 + fr7*omega7)/(omega4 + omega5 + &
      omega6 + omega7)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno9(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
sigma4, &
omega1, &
omega7, &
omega0, &
omega6, &
omega9, &
omega2, &
omega8, &
omega4, &
omega3, &
omega5, &
fr1, &
fr7, &
fr0, &
fr6, &
fr9, &
fr2, &
fr8, &
fr4, &
fr3, &
fr5, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 21.412301587301587301587301587301587d0*q(m,i+0)**2 - &
      128.86924603174603174603174603174603d0*q(m,i+0)*q(m,i+1) + &
      150.56011904761904761904761904761905d0*q(m,i+0)*q(m,i+2) - &
      81.644246031746031746031746031746032d0*q(m,i+0)*q(m,i+3) + &
      17.128769841269841269841269841269841d0*q(m,i+0)*q(m,i+4) + &
      202.49265873015873015873015873015873d0*q(m,i+1)**2 - &
      488.50714285714285714285714285714286d0*q(m,i+1)*q(m,i+2) + &
      269.53531746031746031746031746031746d0*q(m,i+1)*q(m,i+3) - &
      57.144246031746031746031746031746032d0*q(m,i+1)*q(m,i+4) + &
      301.86369047619047619047619047619048d0*q(m,i+2)**2 - &
      338.17380952380952380952380952380952d0*q(m,i+2)*q(m,i+3) + &
      72.393452380952380952380952380952381d0*q(m,i+2)*q(m,i+4) + &
      95.825992063492063492063492063492063d0*q(m,i+3)**2 - &
      41.369246031746031746031746031746032d0*q(m,i+3)*q(m,i+4) + &
      4.4956349206349206349206349206349206d0*q(m,i+4)**2
sigma1 = 48.159325396825396825396825396825397d0*q(m,i+0)**2 - &
      121.42380952380952380952380952380952d0*q(m,i+0)*q(m,i+1) + &
      66.868650793650793650793650793650794d0*q(m,i+0)*q(m,i+2) - &
      13.935912698412698412698412698412698d0*q(m,i+0)*q(m,i+3) - &
      27.827579365079365079365079365079365d0*q(m,i+0)*q(m,i-1) + &
      80.613690476190476190476190476190476d0*q(m,i+1)**2 - &
      92.257142857142857142857142857142857d0*q(m,i+1)*q(m,i+2) + &
      19.685119047619047619047619047619048d0*q(m,i+1)*q(m,i+3) + &
      32.768452380952380952380952380952381d0*q(m,i+1)*q(m,i-1) + &
      27.49265873015873015873015873015873d0*q(m,i+2)**2 - &
      12.077579365079365079365079365079365d0*q(m,i+2)*q(m,i+3) - &
      17.519246031746031746031746031746032d0*q(m,i+2)*q(m,i-1) + &
      1.3706349206349206349206349206349206d0*q(m,i+3)**2 + &
      3.5871031746031746031746031746031746d0*q(m,i+3)*q(m,i-1) + &
      4.4956349206349206349206349206349206d0*q(m,i-1)**2
sigma2 = 45.863690476190476190476190476190476d0*q(m,i+0)**2 - &
      59.34047619047619047619047619047619d0*q(m,i+0)*q(m,i+1) + &
      13.476785714285714285714285714285714d0*q(m,i+0)*q(m,i+2) - &
      59.34047619047619047619047619047619d0*q(m,i+0)*q(m,i-1) + &
      13.476785714285714285714285714285714d0*q(m,i+0)*q(m,i-2) + &
      20.825992063492063492063492063492063d0*q(m,i+1)**2 - &
      10.119246031746031746031746031746032d0*q(m,i+1)*q(m,i+2) + &
      35.53531746031746031746031746031746d0*q(m,i+1)*q(m,i-1) - &
      7.7275793650793650793650793650793651d0*q(m,i+1)*q(m,i-2) + &
      1.3706349206349206349206349206349206d0*q(m,i+2)**2 - &
      7.7275793650793650793650793650793651d0*q(m,i+2)*q(m,i-1) + &
      1.6287698412698412698412698412698413d0*q(m,i+2)*q(m,i-2) + &
      20.825992063492063492063492063492063d0*q(m,i-1)**2 - &
      10.119246031746031746031746031746032d0*q(m,i-1)*q(m,i-2) + &
      1.3706349206349206349206349206349206d0*q(m,i-2)**2
sigma3 = 48.159325396825396825396825396825397d0*q(m,i+0)**2 - &
      27.827579365079365079365079365079365d0*q(m,i+0)*q(m,i+1) - &
      121.42380952380952380952380952380952d0*q(m,i+0)*q(m,i-1) + &
      66.868650793650793650793650793650794d0*q(m,i+0)*q(m,i-2) - &
      13.935912698412698412698412698412698d0*q(m,i+0)*q(m,i-3) + &
      4.4956349206349206349206349206349206d0*q(m,i+1)**2 + &
      32.768452380952380952380952380952381d0*q(m,i+1)*q(m,i-1) - &
      17.519246031746031746031746031746032d0*q(m,i+1)*q(m,i-2) + &
      3.5871031746031746031746031746031746d0*q(m,i+1)*q(m,i-3) + &
      80.613690476190476190476190476190476d0*q(m,i-1)**2 - &
      92.257142857142857142857142857142857d0*q(m,i-1)*q(m,i-2) + &
      19.685119047619047619047619047619048d0*q(m,i-1)*q(m,i-3) + &
      27.49265873015873015873015873015873d0*q(m,i-2)**2 - &
      12.077579365079365079365079365079365d0*q(m,i-2)*q(m,i-3) + &
      1.3706349206349206349206349206349206d0*q(m,i-3)**2
sigma4 = 21.412301587301587301587301587301587d0*q(m,i+0)**2 - &
      128.86924603174603174603174603174603d0*q(m,i+0)*q(m,i-1) + &
      150.56011904761904761904761904761905d0*q(m,i+0)*q(m,i-2) - &
      81.644246031746031746031746031746032d0*q(m,i+0)*q(m,i-3) + &
      17.128769841269841269841269841269841d0*q(m,i+0)*q(m,i-4) + &
      202.49265873015873015873015873015873d0*q(m,i-1)**2 - &
      488.50714285714285714285714285714286d0*q(m,i-1)*q(m,i-2) + &
      269.53531746031746031746031746031746d0*q(m,i-1)*q(m,i-3) - &
      57.144246031746031746031746031746032d0*q(m,i-1)*q(m,i-4) + &
      301.86369047619047619047619047619048d0*q(m,i-2)**2 - &
      338.17380952380952380952380952380952d0*q(m,i-2)*q(m,i-3) + &
      72.393452380952380952380952380952381d0*q(m,i-2)*q(m,i-4) + &
      95.825992063492063492063492063492063d0*q(m,i-3)**2 - &
      41.369246031746031746031746031746032d0*q(m,i-3)*q(m,i-4) + &
      4.4956349206349206349206349206349206d0*q(m,i-4)**2
omega0 = 0.0079365079365079365079365079365079365d0/(1.0e-36 + sigma0)**2
omega1 = 0.15873015873015873015873015873015873d0/(1.0e-36 + sigma1)**2
omega2 = 0.47619047619047619047619047619047619d0/(1.0e-36 + sigma2)**2
omega3 = 0.31746031746031746031746031746031746d0/(1.0e-36 + sigma3)**2
omega4 = 0.039682539682539682539682539682539683d0/(1.0e-36 + sigma4)**2
omega5 = 0.039682539682539682539682539682539683d0/(1.0e-36 + sigma0)**2
omega6 = 0.31746031746031746031746031746031746d0/(1.0e-36 + sigma1)**2
omega7 = 0.47619047619047619047619047619047619d0/(1.0e-36 + sigma2)**2
omega8 = 0.15873015873015873015873015873015873d0/(1.0e-36 + sigma3)**2
omega9 = 0.0079365079365079365079365079365079365d0/(1.0e-36 + sigma4)**2
fr0 = 2.2833333333333333333333333333333333d0*q(m,i+0) - &
      2.7166666666666666666666666666666667d0*q(m,i+1) + &
      2.2833333333333333333333333333333333d0*q(m,i+2) - 1.05d0*q(m,i+3 &
      ) + 0.2d0*q(m,i+4)
fr1 = 1.2833333333333333333333333333333333d0*q(m,i+0) - &
      0.71666666666666666666666666666666667d0*q(m,i+1) + &
      0.28333333333333333333333333333333333d0*q(m,i+2) - 0.05d0*q(m,i+3 &
      ) + 0.2d0*q(m,i-1)
fr2 = 0.78333333333333333333333333333333333d0*q(m,i+0) - &
      0.21666666666666666666666666666666667d0*q(m,i+1) + &
      0.033333333333333333333333333333333333d0*q(m,i+2) + 0.45d0*q(m, &
      i-1) - 0.05d0*q(m,i-2)
fr3 = 0.45d0*q(m,i+0) - 0.05d0*q(m,i+1) + &
      0.78333333333333333333333333333333333d0*q(m,i-1) - &
      0.21666666666666666666666666666666667d0*q(m,i-2) + &
      0.033333333333333333333333333333333333d0*q(m,i-3)
fr4 = 0.2d0*q(m,i+0) + 1.2833333333333333333333333333333333d0*q(m,i-1) - &
      0.71666666666666666666666666666666667d0*q(m,i-2) + &
      0.28333333333333333333333333333333333d0*q(m,i-3) - 0.05d0*q(m,i-4 &
      )
fr5 = 0.2d0*q(m,i+0) + 1.2833333333333333333333333333333333d0*q(m,i+1) - &
      0.71666666666666666666666666666666667d0*q(m,i+2) + &
      0.28333333333333333333333333333333333d0*q(m,i+3) - 0.05d0*q(m,i+4 &
      )
fr6 = 0.45d0*q(m,i+0) + 0.78333333333333333333333333333333333d0*q(m,i+1) - &
      0.21666666666666666666666666666666667d0*q(m,i+2) + &
      0.033333333333333333333333333333333333d0*q(m,i+3) - 0.05d0*q(m, &
      i-1)
fr7 = 0.78333333333333333333333333333333333d0*q(m,i+0) + 0.45d0*q(m,i+1) - &
      0.05d0*q(m,i+2) - 0.21666666666666666666666666666666667d0*q(m,i-1 &
      ) + 0.033333333333333333333333333333333333d0*q(m,i-2)
fr8 = 1.2833333333333333333333333333333333d0*q(m,i+0) + 0.2d0*q(m,i+1) - &
      0.71666666666666666666666666666666667d0*q(m,i-1) + &
      0.28333333333333333333333333333333333d0*q(m,i-2) - 0.05d0*q(m,i-3 &
      )
fr9 = 2.2833333333333333333333333333333333d0*q(m,i+0) - &
      2.7166666666666666666666666666666667d0*q(m,i-1) + &
      2.2833333333333333333333333333333333d0*q(m,i-2) - 1.05d0*q(m,i-3 &
      ) + 0.2d0*q(m,i-4)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3 + fr4*omega4)/(omega0 &
      + omega1 + omega2 + omega3 + omega4)
fs1 = (fr5*omega5 + fr6*omega6 + fr7*omega7 + fr8*omega8 + fr9*omega9)/(omega5 &
      + omega6 + omega7 + omega8 + omega9)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno11(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
sigma4, &
sigma5, &
omega1, &
omega8, &
omega0, &
omega10, &
omega7, &
omega11, &
omega9, &
omega5, &
omega4, &
omega6, &
omega3, &
omega2, &
fr1, &
fr8, &
fr0, &
fr10, &
fr7, &
fr11, &
fr9, &
fr5, &
fr4, &
fr6, &
fr3, &
fr2, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 50.844998346560846560846560846560847d0*q(m,i+0)**2 - &
      392.36494708994708994708994708994709d0*q(m,i+0)*q(m,i+1) + &
      630.01600529100529100529100529100529d0*q(m,i+0)*q(m,i+2) - &
      524.0916335978835978835978835978836d0*q(m,i+0)*q(m,i+3) + &
      223.71172288359788359788359788359788d0*q(m,i+0)*q(m,i+4) - &
      38.96114417989417989417989417989418d0*q(m,i+0)*q(m,i+5) + &
      784.15374503968253968253968253968254d0*q(m,i+1)**2 - &
      2577.4739087301587301587301587301587d0*q(m,i+1)*q(m,i+2) + &
      2173.4595899470899470899470899470899d0*q(m,i+1)*q(m,i+3) - &
      935.90267857142857142857142857142857d0*q(m,i+1)*q(m,i+4) + &
      163.97445436507936507936507936507937d0*q(m,i+1)*q(m,i+5) + &
      2153.152876984126984126984126984127d0*q(m,i+2)**2 - &
      3670.6671957671957671957671957671958d0*q(m,i+2)*q(m,i+3) + &
      1592.2327380952380952380952380952381d0*q(m,i+2)*q(m,i+4) - &
      280.41339285714285714285714285714286d0*q(m,i+2)*q(m,i+5) + &
      1577.0301917989417989417989417989418d0*q(m,i+3)**2 - &
      1376.1660383597883597883597883597884d0*q(m,i+3)*q(m,i+4) + &
      243.40489417989417989417989417989418d0*q(m,i+3)*q(m,i+5) + &
      301.59298115079365079365079365079365d0*q(m,i+4)**2 - &
      107.06170634920634920634920634920635d0*q(m,i+4)*q(m,i+5) + &
      9.5284474206349206349206349206349206d0*q(m,i+5)**2
sigma1 = 160.10224041005291005291005291005291d0*q(m,i+0)**2 - &
      539.22159391534391534391534391534392d0*q(m,i+0)*q(m,i+1) + &
      455.1401455026455026455026455026455d0*q(m,i+0)*q(m,i+2) - &
      194.36564153439153439153439153439153d0*q(m,i+0)*q(m,i+3) + &
      33.622833994708994708994708994708995d0*q(m,i+0)*q(m,i+4) - &
      75.380224867724867724867724867724868d0*q(m,i+0)*q(m,i-1) + &
      468.43759920634920634920634920634921d0*q(m,i+1)**2 - &
      808.85238095238095238095238095238095d0*q(m,i+1)*q(m,i+2) + &
      350.57070105820105820105820105820106d0*q(m,i+1)*q(m,i+3) - &
      61.250892857142857142857142857142857d0*q(m,i+1)*q(m,i+4) + &
      121.87896825396825396825396825396825d0*q(m,i+1)*q(m,i-1) + &
      356.2639880952380952380952380952381d0*q(m,i+2)**2 - &
      313.43687169312169312169312169312169d0*q(m,i+2)*q(m,i+3) + &
      55.345634920634920634920634920634921d0*q(m,i+2)*q(m,i+4) - &
      100.72450396825396825396825396825397d0*q(m,i+2)*q(m,i-1) + &
      69.857448743386243386243386243386243d0*q(m,i+3)**2 - &
      24.931613756613756613756613756613757d0*q(m,i+3)*q(m,i+4) + &
      42.448528439153439153439153439153439d0*q(m,i+3)*q(m,i-1) + &
      2.2468501984126984126984126984126984d0*q(m,i+4)**2 - &
      7.2796626984126984126984126984126984d0*q(m,i+4)*q(m,i-1) + &
      9.5284474206349206349206349206349206d0*q(m,i-1)**2
sigma2 = 161.30102513227513227513227513227513d0*q(m,i+0)**2 - &
      296.11164021164021164021164021164021d0*q(m,i+0)*q(m,i+1) + &
      131.69570105820105820105820105820106d0*q(m,i+0)*q(m,i+2) - &
      23.087466931216931216931216931216931d0*q(m,i+0)*q(m,i+3) - &
      168.88131613756613756613756613756614d0*q(m,i+0)*q(m,i-1) + &
      33.782671957671957671957671957671958d0*q(m,i+0)*q(m,i-2) + &
      142.15982142857142857142857142857143d0*q(m,i+1)**2 - &
      131.28640873015873015873015873015873d0*q(m,i+1)*q(m,i+2) + &
      23.677116402116402116402116402116402d0*q(m,i+1)*q(m,i+3) + &
      148.02440476190476190476190476190476d0*q(m,i+1)*q(m,i-1) - &
      28.623115079365079365079365079365079d0*q(m,i+1)*q(m,i-2) + &
      31.620758928571428571428571428571429d0*q(m,i+2)**2 - &
      11.821891534391534391534391534391534d0*q(m,i+2)*q(m,i+3) - &
      63.888789682539682539682539682539683d0*q(m,i+2)*q(m,i-1) + &
      12.059871031746031746031746031746032d0*q(m,i+2)*q(m,i-2) + &
      1.1543733465608465608465608465608466d0*q(m,i+3)**2 + &
      10.954083994708994708994708994708995d0*q(m,i+3)*q(m,i-1) - &
      2.0305886243386243386243386243386243d0*q(m,i+3)*q(m,i-2) + &
      46.737078373015873015873015873015873d0*q(m,i-1)**2 - &
      19.682539682539682539682539682539683d0*q(m,i-1)*q(m,i-2) + &
      2.2468501984126984126984126984126984d0*q(m,i-2)**2
sigma3 = 161.30102513227513227513227513227513d0*q(m,i+0)**2 - &
      168.88131613756613756613756613756614d0*q(m,i+0)*q(m,i+1) + &
      33.782671957671957671957671957671958d0*q(m,i+0)*q(m,i+2) - &
      296.11164021164021164021164021164021d0*q(m,i+0)*q(m,i-1) + &
      131.69570105820105820105820105820106d0*q(m,i+0)*q(m,i-2) - &
      23.087466931216931216931216931216931d0*q(m,i+0)*q(m,i-3) + &
      46.737078373015873015873015873015873d0*q(m,i+1)**2 - &
      19.682539682539682539682539682539683d0*q(m,i+1)*q(m,i+2) + &
      148.02440476190476190476190476190476d0*q(m,i+1)*q(m,i-1) - &
      63.888789682539682539682539682539683d0*q(m,i+1)*q(m,i-2) + &
      10.954083994708994708994708994708995d0*q(m,i+1)*q(m,i-3) + &
      2.2468501984126984126984126984126984d0*q(m,i+2)**2 - &
      28.623115079365079365079365079365079d0*q(m,i+2)*q(m,i-1) + &
      12.059871031746031746031746031746032d0*q(m,i+2)*q(m,i-2) - &
      2.0305886243386243386243386243386243d0*q(m,i+2)*q(m,i-3) + &
      142.15982142857142857142857142857143d0*q(m,i-1)**2 - &
      131.28640873015873015873015873015873d0*q(m,i-1)*q(m,i-2) + &
      23.677116402116402116402116402116402d0*q(m,i-1)*q(m,i-3) + &
      31.620758928571428571428571428571429d0*q(m,i-2)**2 - &
      11.821891534391534391534391534391534d0*q(m,i-2)*q(m,i-3) + &
      1.1543733465608465608465608465608466d0*q(m,i-3)**2
sigma4 = 160.10224041005291005291005291005291d0*q(m,i+0)**2 - &
      75.380224867724867724867724867724868d0*q(m,i+0)*q(m,i+1) - &
      539.22159391534391534391534391534392d0*q(m,i+0)*q(m,i-1) + &
      455.1401455026455026455026455026455d0*q(m,i+0)*q(m,i-2) - &
      194.36564153439153439153439153439153d0*q(m,i+0)*q(m,i-3) + &
      33.622833994708994708994708994708995d0*q(m,i+0)*q(m,i-4) + &
      9.5284474206349206349206349206349206d0*q(m,i+1)**2 + &
      121.87896825396825396825396825396825d0*q(m,i+1)*q(m,i-1) - &
      100.72450396825396825396825396825397d0*q(m,i+1)*q(m,i-2) + &
      42.448528439153439153439153439153439d0*q(m,i+1)*q(m,i-3) - &
      7.2796626984126984126984126984126984d0*q(m,i+1)*q(m,i-4) + &
      468.43759920634920634920634920634921d0*q(m,i-1)**2 - &
      808.85238095238095238095238095238095d0*q(m,i-1)*q(m,i-2) + &
      350.57070105820105820105820105820106d0*q(m,i-1)*q(m,i-3) - &
      61.250892857142857142857142857142857d0*q(m,i-1)*q(m,i-4) + &
      356.2639880952380952380952380952381d0*q(m,i-2)**2 - &
      313.43687169312169312169312169312169d0*q(m,i-2)*q(m,i-3) + &
      55.345634920634920634920634920634921d0*q(m,i-2)*q(m,i-4) + &
      69.857448743386243386243386243386243d0*q(m,i-3)**2 - &
      24.931613756613756613756613756613757d0*q(m,i-3)*q(m,i-4) + &
      2.2468501984126984126984126984126984d0*q(m,i-4)**2
sigma5 = 50.844998346560846560846560846560847d0*q(m,i+0)**2 - &
      392.36494708994708994708994708994709d0*q(m,i+0)*q(m,i-1) + &
      630.01600529100529100529100529100529d0*q(m,i+0)*q(m,i-2) - &
      524.0916335978835978835978835978836d0*q(m,i+0)*q(m,i-3) + &
      223.71172288359788359788359788359788d0*q(m,i+0)*q(m,i-4) - &
      38.96114417989417989417989417989418d0*q(m,i+0)*q(m,i-5) + &
      784.15374503968253968253968253968254d0*q(m,i-1)**2 - &
      2577.4739087301587301587301587301587d0*q(m,i-1)*q(m,i-2) + &
      2173.4595899470899470899470899470899d0*q(m,i-1)*q(m,i-3) - &
      935.90267857142857142857142857142857d0*q(m,i-1)*q(m,i-4) + &
      163.97445436507936507936507936507937d0*q(m,i-1)*q(m,i-5) + &
      2153.152876984126984126984126984127d0*q(m,i-2)**2 - &
      3670.6671957671957671957671957671958d0*q(m,i-2)*q(m,i-3) + &
      1592.2327380952380952380952380952381d0*q(m,i-2)*q(m,i-4) - &
      280.41339285714285714285714285714286d0*q(m,i-2)*q(m,i-5) + &
      1577.0301917989417989417989417989418d0*q(m,i-3)**2 - &
      1376.1660383597883597883597883597884d0*q(m,i-3)*q(m,i-4) + &
      243.40489417989417989417989417989418d0*q(m,i-3)*q(m,i-5) + &
      301.59298115079365079365079365079365d0*q(m,i-4)**2 - &
      107.06170634920634920634920634920635d0*q(m,i-4)*q(m,i-5) + &
      9.5284474206349206349206349206349206d0*q(m,i-5)**2
omega0 = 0.0021645021645021645021645021645021645d0/(1.0e-36 + sigma0)**2
omega1 = 0.064935064935064935064935064935064935d0/(1.0e-36 + sigma1)**2
omega2 = 0.32467532467532467532467532467532468d0/(1.0e-36 + sigma2)**2
omega3 = 0.4329004329004329004329004329004329d0/(1.0e-36 + sigma3)**2
omega4 = 0.16233766233766233766233766233766234d0/(1.0e-36 + sigma4)**2
omega5 = 0.012987012987012987012987012987012987d0/(1.0e-36 + sigma5)**2
omega6 = 0.012987012987012987012987012987012987d0/(1.0e-36 + sigma0)**2
omega7 = 0.16233766233766233766233766233766234d0/(1.0e-36 + sigma1)**2
omega8 = 0.4329004329004329004329004329004329d0/(1.0e-36 + sigma2)**2
omega9 = 0.32467532467532467532467532467532468d0/(1.0e-36 + sigma3)**2
omega10 = 0.064935064935064935064935064935064935d0/(1.0e-36 + sigma4)**2
omega11 = 0.0021645021645021645021645021645021645d0/(1.0e-36 + sigma5)**2
fr0 = 2.45d0*q(m,i+0) - 3.55d0*q(m,i+1) + 3.95d0*q(m,i+2) - &
      2.7166666666666666666666666666666667d0*q(m,i+3) + &
      1.0333333333333333333333333333333333d0*q(m,i+4) - &
      0.16666666666666666666666666666666667d0*q(m,i+5)
fr1 = 1.45d0*q(m,i+0) - 1.05d0*q(m,i+1) + &
      0.61666666666666666666666666666666667d0*q(m,i+2) - &
      0.21666666666666666666666666666666667d0*q(m,i+3) + &
      0.033333333333333333333333333333333333d0*q(m,i+4) + &
      0.16666666666666666666666666666666667d0*q(m,i-1)
fr2 = 0.95d0*q(m,i+0) - 0.38333333333333333333333333333333333d0*q(m,i+1) + &
      0.11666666666666666666666666666666667d0*q(m,i+2) - &
      0.016666666666666666666666666666666667d0*q(m,i+3) + &
      0.36666666666666666666666666666666667d0*q(m,i-1) - &
      0.033333333333333333333333333333333333d0*q(m,i-2)
fr3 = 0.61666666666666666666666666666666667d0*q(m,i+0) - &
      0.13333333333333333333333333333333333d0*q(m,i+1) + &
      0.016666666666666666666666666666666667d0*q(m,i+2) + &
      0.61666666666666666666666666666666667d0*q(m,i-1) - &
      0.13333333333333333333333333333333333d0*q(m,i-2) + &
      0.016666666666666666666666666666666667d0*q(m,i-3)
fr4 = 0.36666666666666666666666666666666667d0*q(m,i+0) - &
      0.033333333333333333333333333333333333d0*q(m,i+1) + 0.95d0*q(m, &
      i-1) - 0.38333333333333333333333333333333333d0*q(m,i-2) + &
      0.11666666666666666666666666666666667d0*q(m,i-3) - &
      0.016666666666666666666666666666666667d0*q(m,i-4)
fr5 = 0.16666666666666666666666666666666667d0*q(m,i+0) + 1.45d0*q(m,i-1) - &
      1.05d0*q(m,i-2) + 0.61666666666666666666666666666666667d0*q(m,i-3 &
      ) - 0.21666666666666666666666666666666667d0*q(m,i-4) + &
      0.033333333333333333333333333333333333d0*q(m,i-5)
fr6 = 0.16666666666666666666666666666666667d0*q(m,i+0) + 1.45d0*q(m,i+1) - &
      1.05d0*q(m,i+2) + 0.61666666666666666666666666666666667d0*q(m,i+3 &
      ) - 0.21666666666666666666666666666666667d0*q(m,i+4) + &
      0.033333333333333333333333333333333333d0*q(m,i+5)
fr7 = 0.36666666666666666666666666666666667d0*q(m,i+0) + 0.95d0*q(m,i+1) - &
      0.38333333333333333333333333333333333d0*q(m,i+2) + &
      0.11666666666666666666666666666666667d0*q(m,i+3) - &
      0.016666666666666666666666666666666667d0*q(m,i+4) - &
      0.033333333333333333333333333333333333d0*q(m,i-1)
fr8 = 0.61666666666666666666666666666666667d0*q(m,i+0) + &
      0.61666666666666666666666666666666667d0*q(m,i+1) - &
      0.13333333333333333333333333333333333d0*q(m,i+2) + &
      0.016666666666666666666666666666666667d0*q(m,i+3) - &
      0.13333333333333333333333333333333333d0*q(m,i-1) + &
      0.016666666666666666666666666666666667d0*q(m,i-2)
fr9 = 0.95d0*q(m,i+0) + 0.36666666666666666666666666666666667d0*q(m,i+1) - &
      0.033333333333333333333333333333333333d0*q(m,i+2) - &
      0.38333333333333333333333333333333333d0*q(m,i-1) + &
      0.11666666666666666666666666666666667d0*q(m,i-2) - &
      0.016666666666666666666666666666666667d0*q(m,i-3)
fr10 = 1.45d0*q(m,i+0) + 0.16666666666666666666666666666666667d0*q(m,i+1) - &
      1.05d0*q(m,i-1) + 0.61666666666666666666666666666666667d0*q(m,i-2 &
      ) - 0.21666666666666666666666666666666667d0*q(m,i-3) + &
      0.033333333333333333333333333333333333d0*q(m,i-4)
fr11 = 2.45d0*q(m,i+0) - 3.55d0*q(m,i-1) + 3.95d0*q(m,i-2) - &
      2.7166666666666666666666666666666667d0*q(m,i-3) + &
      1.0333333333333333333333333333333333d0*q(m,i-4) - &
      0.16666666666666666666666666666666667d0*q(m,i-5)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3 + fr4*omega4 + fr5* &
      omega5)/(omega0 + omega1 + omega2 + omega3 + omega4 + omega5)
fs1 = (fr10*omega10 + fr11*omega11 + fr6*omega6 + fr7*omega7 + fr8*omega8 + &
      fr9*omega9)/(omega10 + omega11 + omega6 + omega7 + omega8 + &
      omega9)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno13(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
sigma4, &
sigma5, &
sigma6, &
omega1, &
omega9, &
omega0, &
omega12, &
omega11, &
omega8, &
omega6, &
omega10, &
omega5, &
omega4, &
omega7, &
omega13, &
omega3, &
omega2, &
fr1, &
fr9, &
fr0, &
fr12, &
fr11, &
fr8, &
fr6, &
fr10, &
fr5, &
fr4, &
fr7, &
fr13, &
fr3, &
fr2, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 119.87696582224360002137779915557693d0*q(m,i+0)**2 - &
      1140.526913830767997434664101330768d0*q(m,i+0)*q(m,i+1) + &
      2345.3074209856501523168189834856502d0*q(m,i+0)*q(m,i+2) - &
      2648.5382691331302442413553524664636d0*q(m,i+0)*q(m,i+3) + &
      1719.4383816337983004649671316337983d0*q(m,i+0)*q(m,i+4) - &
      605.48066052388969055635722302388969d0*q(m,i+0)*q(m,i+5) + &
      90.046109223852279407834963390518946d0*q(m,i+0)*q(m,i+6) + &
      2787.9747163600288600288600288600289d0*q(m,i+1)**2 - &
      11665.897758387445887445887445887446d0*q(m,i+1)*q(m,i+2) + &
      13315.706543811127144460477793811127d0*q(m,i+1)*q(m,i+3) - &
      8706.9379865620490620490620490620491d0*q(m,i+1)*q(m,i+4) + &
      3081.7616946248196248196248196248196d0*q(m,i+1)*q(m,i+5) - &
      460.05501237574154240820907487574154d0*q(m,i+1)*q(m,i+6) + &
      12350.33143037518037518037518037518d0*q(m,i+2)**2 - &
      28424.014557279140612473945807279141d0*q(m,i+2)*q(m,i+3) + &
      18693.118490710678210678210678210678d0*q(m,i+2)*q(m,i+4) - &
      6644.2004865620490620490620490620491d0*q(m,i+2)*q(m,i+5) + &
      995.02402978194644861311527978194645d0*q(m,i+2)*q(m,i+6) + &
      16453.175912230773341884452995564107d0*q(m,i+3)**2 - &
      21738.218260982844316177649510982844d0*q(m,i+3)*q(m,i+4) + &
      7752.8028401074234407567740901074234d0*q(m,i+3)*q(m,i+5) - &
      1164.0901209849820960932072043183154d0*q(m,i+3)*q(m,i+6) + &
      7205.3001803751803751803751803751804d0*q(m,i+4)**2 - &
      5153.4602583874458874458874458874459d0*q(m,i+4)*q(m,i+5) + &
      775.459272837502004168670835337502d0*q(m,i+4)*q(m,i+6) + &
      923.49471636002886002886002886002886d0*q(m,i+5)**2 - &
      278.41256197891614558281224947891615d0*q(m,i+5)*q(m,i+6) + &
      21.014141748169525947303725081502859d0*q(m,i+6)**2
sigma1 = 519.24714691558441558441558441558442d0*q(m,i+0)**2 - &
      2207.33120746151996151996151996152d0*q(m,i+0)*q(m,i+1) + &
      2525.4548462802629469296135962802629d0*q(m,i+0)*q(m,i+2) - &
      1645.2230560064935064935064935064935d0*q(m,i+0)*q(m,i+3) + &
      578.41285203222703222703222703222703d0*q(m,i+0)*q(m,i+4) - &
      85.655853425124258457591790925124259d0*q(m,i+0)*q(m,i+5) - &
      204.15187525052108385441718775052108d0*q(m,i+0)*q(m,i-1) + &
      2394.0559674122174122174122174122174d0*q(m,i+1)**2 - &
      5559.2560696248196248196248196248196d0*q(m,i+1)*q(m,i+2) + &
      3658.6769397847522847522847522847523d0*q(m,i+1)*q(m,i+3) - &
      1295.6110189694564694564694564694565d0*q(m,i+1)*q(m,i+4) + &
      192.8704803992303992303992303992304d0*q(m,i+1)*q(m,i+5) + &
      422.53894104737854737854737854737855d0*q(m,i+1)*q(m,i-1) + &
      3266.8140295147239591684036128480573d0*q(m,i+2)**2 - &
      4339.6665634519801186467853134519801d0*q(m,i+2)*q(m,i+3) + &
      1547.3276857864357864357864357864358d0*q(m,i+2)*q(m,i+4) - &
      231.52206542942654053765164876275987d0*q(m,i+2)*q(m,i+5) - &
      475.9658925899203676981454759232537d0*q(m,i+2)*q(m,i-1) + &
      1452.3453192640692640692640692640693d0*q(m,i+3)**2 - &
      1042.0395407948532948532948532948533d0*q(m,i+3)*q(m,i+4) + &
      156.66178055355138688472021805355139d0*q(m,i+3)*q(m,i+5) + &
      306.89980138688472021805355138688472d0*q(m,i+3)*q(m,i-1) + &
      187.89196173039923039923039923039923d0*q(m,i+4)**2 - &
      56.73922092953342953342953342953343d0*q(m,i+4)*q(m,i+5) - &
      107.13468058561808561808561808561809d0*q(m,i+4)*q(m,i-1) + &
      4.2997281679226123670568115012559457d0*q(m,i+5)**2 + &
      15.785422495457217679439901662123884d0*q(m,i+5)*q(m,i-1) + &
      21.014141748169525947303725081502859d0*q(m,i-1)**2
sigma2 = 616.65434704184704184704184704184704d0*q(m,i+0)**2 - &
      1479.6966560445727112393779060445727d0*q(m,i+0)*q(m,i+1) + &
      986.13700922919672919672919672919673d0*q(m,i+0)*q(m,i+2) - &
      348.91298656204906204906204906204906d0*q(m,i+0)*q(m,i+3) + &
      51.418319905403238736572069905403239d0*q(m,i+0)*q(m,i+4) - &
      537.18711023929773929773929773929774d0*q(m,i+0)*q(m,i-1) + &
      94.932729627625460958794292127625461d0*q(m,i+0)*q(m,i-2) + &
      910.75615914435358879803324247768692d0*q(m,i+1)**2 - &
      1239.850977032227032227032227032227d0*q(m,i+1)*q(m,i+2) + &
      445.83493887285553952220618887285554d0*q(m,i+1)*q(m,i+3) - &
      66.511725923253701031478809256587034d0*q(m,i+1)*q(m,i+4) + &
      626.82259319384319384319384319384319d0*q(m,i+1)*q(m,i-1) - &
      108.1104913553524664635775746886858d0*q(m,i+1)*q(m,i-2) + &
      430.70874518999518999518999518999519d0*q(m,i+2)**2 - &
      315.14127690596440596440596440596441d0*q(m,i+2)*q(m,i+3) + &
      47.667297528860028860028860028860029d0*q(m,i+2)*q(m,i+4) - &
      409.68844952501202501202501202501203d0*q(m,i+2)*q(m,i-1) + &
      69.458906325156325156325156325156325d0*q(m,i+2)*q(m,i-2) + &
      58.628049693362193362193362193362193d0*q(m,i+3)**2 - &
      18.003518769039602372935706269039602d0*q(m,i+3)*q(m,i+4) + &
      142.89354647667147667147667147667148d0*q(m,i+3)*q(m,i-1) - &
      23.926802499198332531665864999198333d0*q(m,i+3)*q(m,i-2) + &
      1.404095451873229651007428785206563d0*q(m,i+4)**2 - &
      20.835537067099567099567099567099567d0*q(m,i+4)*q(m,i-1) + &
      3.4569734213831436053658275880498103d0*q(m,i+4)*q(m,i-2) + &
      121.20286450817700817700817700817701d0*q(m,i-1)**2 - &
      44.410771855459355459355459355459355d0*q(m,i-1)*q(m,i-2) + &
      4.2997281679226123670568115012559457d0*q(m,i-2)**2
sigma3 = 537.03007889744000855111966223077334d0*q(m,i+0)**2 - &
      792.17890913099246432579765913099246d0*q(m,i+0)*q(m,i+1) + &
      302.01719195927529260862594195927529d0*q(m,i+0)*q(m,i+2) - &
      46.86836172572283683394794505905617d0*q(m,i+0)*q(m,i+3) - &
      792.17890913099246432579765913099246d0*q(m,i+0)*q(m,i-1) + &
      302.01719195927529260862594195927529d0*q(m,i+0)*q(m,i-2) - &
      46.86836172572283683394794505905617d0*q(m,i+0)*q(m,i-3) + &
      302.86268037518037518037518037518038d0*q(m,i+1)**2 - &
      238.76963338744588744588744588744589d0*q(m,i+1)*q(m,i+2) + &
      38.136471911576078242744909411576078d0*q(m,i+1)*q(m,i+3) + &
      564.85286571067821067821067821067821d0*q(m,i+1)*q(m,i-1) - &
      209.54111156204906204906204906204906d0*q(m,i+1)*q(m,i-2) + &
      31.774955707872374539041205707872375d0*q(m,i+1)*q(m,i-3) + &
      48.90159136002886002886002886002886d0*q(m,i+2)**2 - &
      16.200362904842071508738175404842072d0*q(m,i+2)*q(m,i+3) - &
      209.54111156204906204906204906204906d0*q(m,i+2)*q(m,i-1) + &
      75.995444624819624819624819624819625d0*q(m,i+2)*q(m,i-2) - &
      11.304711449815616482283148949815616d0*q(m,i+2)*q(m,i-3) + &
      1.404095451873229651007428785206563d0*q(m,i+3)**2 + &
      31.774955707872374539041205707872375d0*q(m,i+3)*q(m,i-1) - &
      11.304711449815616482283148949815616d0*q(m,i+3)*q(m,i-2) + &
      1.6538175571856127411682967238522794d0*q(m,i+3)*q(m,i-3) + &
      302.86268037518037518037518037518038d0*q(m,i-1)**2 - &
      238.76963338744588744588744588744589d0*q(m,i-1)*q(m,i-2) + &
      38.136471911576078242744909411576078d0*q(m,i-1)*q(m,i-3) + &
      48.90159136002886002886002886002886d0*q(m,i-2)**2 - &
      16.200362904842071508738175404842072d0*q(m,i-2)*q(m,i-3) + &
      1.404095451873229651007428785206563d0*q(m,i-3)**2
sigma4 = 616.65434704184704184704184704184704d0*q(m,i+0)**2 - &
      537.18711023929773929773929773929774d0*q(m,i+0)*q(m,i+1) + &
      94.932729627625460958794292127625461d0*q(m,i+0)*q(m,i+2) - &
      1479.6966560445727112393779060445727d0*q(m,i+0)*q(m,i-1) + &
      986.13700922919672919672919672919673d0*q(m,i+0)*q(m,i-2) - &
      348.91298656204906204906204906204906d0*q(m,i+0)*q(m,i-3) + &
      51.418319905403238736572069905403239d0*q(m,i+0)*q(m,i-4) + &
      121.20286450817700817700817700817701d0*q(m,i+1)**2 - &
      44.410771855459355459355459355459355d0*q(m,i+1)*q(m,i+2) + &
      626.82259319384319384319384319384319d0*q(m,i+1)*q(m,i-1) - &
      409.68844952501202501202501202501203d0*q(m,i+1)*q(m,i-2) + &
      142.89354647667147667147667147667148d0*q(m,i+1)*q(m,i-3) - &
      20.835537067099567099567099567099567d0*q(m,i+1)*q(m,i-4) + &
      4.2997281679226123670568115012559457d0*q(m,i+2)**2 - &
      108.1104913553524664635775746886858d0*q(m,i+2)*q(m,i-1) + &
      69.458906325156325156325156325156325d0*q(m,i+2)*q(m,i-2) - &
      23.926802499198332531665864999198333d0*q(m,i+2)*q(m,i-3) + &
      3.4569734213831436053658275880498103d0*q(m,i+2)*q(m,i-4) + &
      910.75615914435358879803324247768692d0*q(m,i-1)**2 - &
      1239.850977032227032227032227032227d0*q(m,i-1)*q(m,i-2) + &
      445.83493887285553952220618887285554d0*q(m,i-1)*q(m,i-3) - &
      66.511725923253701031478809256587034d0*q(m,i-1)*q(m,i-4) + &
      430.70874518999518999518999518999519d0*q(m,i-2)**2 - &
      315.14127690596440596440596440596441d0*q(m,i-2)*q(m,i-3) + &
      47.667297528860028860028860028860029d0*q(m,i-2)*q(m,i-4) + &
      58.628049693362193362193362193362193d0*q(m,i-3)**2 - &
      18.003518769039602372935706269039602d0*q(m,i-3)*q(m,i-4) + &
      1.404095451873229651007428785206563d0*q(m,i-4)**2
sigma5 = 519.24714691558441558441558441558442d0*q(m,i+0)**2 - &
      204.15187525052108385441718775052108d0*q(m,i+0)*q(m,i+1) - &
      2207.33120746151996151996151996152d0*q(m,i+0)*q(m,i-1) + &
      2525.4548462802629469296135962802629d0*q(m,i+0)*q(m,i-2) - &
      1645.2230560064935064935064935064935d0*q(m,i+0)*q(m,i-3) + &
      578.41285203222703222703222703222703d0*q(m,i+0)*q(m,i-4) - &
      85.655853425124258457591790925124259d0*q(m,i+0)*q(m,i-5) + &
      21.014141748169525947303725081502859d0*q(m,i+1)**2 + &
      422.53894104737854737854737854737855d0*q(m,i+1)*q(m,i-1) - &
      475.9658925899203676981454759232537d0*q(m,i+1)*q(m,i-2) + &
      306.89980138688472021805355138688472d0*q(m,i+1)*q(m,i-3) - &
      107.13468058561808561808561808561809d0*q(m,i+1)*q(m,i-4) + &
      15.785422495457217679439901662123884d0*q(m,i+1)*q(m,i-5) + &
      2394.0559674122174122174122174122174d0*q(m,i-1)**2 - &
      5559.2560696248196248196248196248196d0*q(m,i-1)*q(m,i-2) + &
      3658.6769397847522847522847522847523d0*q(m,i-1)*q(m,i-3) - &
      1295.6110189694564694564694564694565d0*q(m,i-1)*q(m,i-4) + &
      192.8704803992303992303992303992304d0*q(m,i-1)*q(m,i-5) + &
      3266.8140295147239591684036128480573d0*q(m,i-2)**2 - &
      4339.6665634519801186467853134519801d0*q(m,i-2)*q(m,i-3) + &
      1547.3276857864357864357864357864358d0*q(m,i-2)*q(m,i-4) - &
      231.52206542942654053765164876275987d0*q(m,i-2)*q(m,i-5) + &
      1452.3453192640692640692640692640693d0*q(m,i-3)**2 - &
      1042.0395407948532948532948532948533d0*q(m,i-3)*q(m,i-4) + &
      156.66178055355138688472021805355139d0*q(m,i-3)*q(m,i-5) + &
      187.89196173039923039923039923039923d0*q(m,i-4)**2 - &
      56.73922092953342953342953342953343d0*q(m,i-4)*q(m,i-5) + &
      4.2997281679226123670568115012559457d0*q(m,i-5)**2
sigma6 = 119.87696582224360002137779915557693d0*q(m,i+0)**2 - &
      1140.526913830767997434664101330768d0*q(m,i+0)*q(m,i-1) + &
      2345.3074209856501523168189834856502d0*q(m,i+0)*q(m,i-2) - &
      2648.5382691331302442413553524664636d0*q(m,i+0)*q(m,i-3) + &
      1719.4383816337983004649671316337983d0*q(m,i+0)*q(m,i-4) - &
      605.48066052388969055635722302388969d0*q(m,i+0)*q(m,i-5) + &
      90.046109223852279407834963390518946d0*q(m,i+0)*q(m,i-6) + &
      2787.9747163600288600288600288600289d0*q(m,i-1)**2 - &
      11665.897758387445887445887445887446d0*q(m,i-1)*q(m,i-2) + &
      13315.706543811127144460477793811127d0*q(m,i-1)*q(m,i-3) - &
      8706.9379865620490620490620490620491d0*q(m,i-1)*q(m,i-4) + &
      3081.7616946248196248196248196248196d0*q(m,i-1)*q(m,i-5) - &
      460.05501237574154240820907487574154d0*q(m,i-1)*q(m,i-6) + &
      12350.33143037518037518037518037518d0*q(m,i-2)**2 - &
      28424.014557279140612473945807279141d0*q(m,i-2)*q(m,i-3) + &
      18693.118490710678210678210678210678d0*q(m,i-2)*q(m,i-4) - &
      6644.2004865620490620490620490620491d0*q(m,i-2)*q(m,i-5) + &
      995.02402978194644861311527978194645d0*q(m,i-2)*q(m,i-6) + &
      16453.175912230773341884452995564107d0*q(m,i-3)**2 - &
      21738.218260982844316177649510982844d0*q(m,i-3)*q(m,i-4) + &
      7752.8028401074234407567740901074234d0*q(m,i-3)*q(m,i-5) - &
      1164.0901209849820960932072043183154d0*q(m,i-3)*q(m,i-6) + &
      7205.3001803751803751803751803751804d0*q(m,i-4)**2 - &
      5153.4602583874458874458874458874459d0*q(m,i-4)*q(m,i-5) + &
      775.459272837502004168670835337502d0*q(m,i-4)*q(m,i-6) + &
      923.49471636002886002886002886002886d0*q(m,i-5)**2 - &
      278.41256197891614558281224947891615d0*q(m,i-5)*q(m,i-6) + &
      21.014141748169525947303725081502859d0*q(m,i-6)**2
omega0 = 0.00058275058275058275058275058275058275d0/(1.0e-36 + sigma0)**2
omega1 = 0.024475524475524475524475524475524476d0/(1.0e-36 + sigma1)**2
omega2 = 0.18356643356643356643356643356643357d0/(1.0e-36 + sigma2)**2
omega3 = 0.40792540792540792540792540792540793d0/(1.0e-36 + sigma3)**2
omega4 = 0.30594405594405594405594405594405594d0/(1.0e-36 + sigma4)**2
omega5 = 0.073426573426573426573426573426573427d0/(1.0e-36 + sigma5)**2
omega6 = 0.0040792540792540792540792540792540793d0/(1.0e-36 + sigma6)**2
omega7 = 0.0040792540792540792540792540792540793d0/(1.0e-36 + sigma0)**2
omega8 = 0.073426573426573426573426573426573427d0/(1.0e-36 + sigma1)**2
omega9 = 0.30594405594405594405594405594405594d0/(1.0e-36 + sigma2)**2
omega10 = 0.40792540792540792540792540792540793d0/(1.0e-36 + sigma3)**2
omega11 = 0.18356643356643356643356643356643357d0/(1.0e-36 + sigma4)**2
omega12 = 0.024475524475524475524475524475524476d0/(1.0e-36 + sigma5)**2
omega13 = 0.00058275058275058275058275058275058275d0/(1.0e-36 + sigma6)**2
fr0 = 2.5928571428571428571428571428571429d0*q(m,i+0) - &
      4.4071428571428571428571428571428571d0*q(m,i+1) + &
      6.0928571428571428571428571428571429d0*q(m,i+2) - &
      5.5738095238095238095238095238095238d0*q(m,i+3) + &
      3.1761904761904761904761904761904762d0*q(m,i+4) - &
      1.0238095238095238095238095238095238d0*q(m,i+5) + &
      0.14285714285714285714285714285714286d0*q(m,i+6)
fr1 = 1.5928571428571428571428571428571429d0*q(m,i+0) - &
      1.4071428571428571428571428571428571d0*q(m,i+1) + &
      1.0928571428571428571428571428571429d0*q(m,i+2) - &
      0.57380952380952380952380952380952381d0*q(m,i+3) + &
      0.17619047619047619047619047619047619d0*q(m,i+4) - &
      0.02380952380952380952380952380952381d0*q(m,i+5) + &
      0.14285714285714285714285714285714286d0*q(m,i-1)
fr2 = 1.0928571428571428571428571428571429d0*q(m,i+0) - &
      0.57380952380952380952380952380952381d0*q(m,i+1) + &
      0.25952380952380952380952380952380952d0*q(m,i+2) - &
      0.07380952380952380952380952380952381d0*q(m,i+3) + &
      0.0095238095238095238095238095238095238d0*q(m,i+4) + &
      0.30952380952380952380952380952380952d0*q(m,i-1) - &
      0.02380952380952380952380952380952381d0*q(m,i-2)
fr3 = 0.75952380952380952380952380952380952d0*q(m,i+0) - &
      0.24047619047619047619047619047619048d0*q(m,i+1) + &
      0.059523809523809523809523809523809524d0*q(m,i+2) - &
      0.0071428571428571428571428571428571429d0*q(m,i+3) + &
      0.50952380952380952380952380952380952d0*q(m,i-1) - &
      0.090476190476190476190476190476190476d0*q(m,i-2) + &
      0.0095238095238095238095238095238095238d0*q(m,i-3)
fr4 = 0.50952380952380952380952380952380952d0*q(m,i+0) - &
      0.090476190476190476190476190476190476d0*q(m,i+1) + &
      0.0095238095238095238095238095238095238d0*q(m,i+2) + &
      0.75952380952380952380952380952380952d0*q(m,i-1) - &
      0.24047619047619047619047619047619048d0*q(m,i-2) + &
      0.059523809523809523809523809523809524d0*q(m,i-3) - &
      0.0071428571428571428571428571428571429d0*q(m,i-4)
fr5 = 0.30952380952380952380952380952380952d0*q(m,i+0) - &
      0.02380952380952380952380952380952381d0*q(m,i+1) + &
      1.0928571428571428571428571428571429d0*q(m,i-1) - &
      0.57380952380952380952380952380952381d0*q(m,i-2) + &
      0.25952380952380952380952380952380952d0*q(m,i-3) - &
      0.07380952380952380952380952380952381d0*q(m,i-4) + &
      0.0095238095238095238095238095238095238d0*q(m,i-5)
fr6 = 0.14285714285714285714285714285714286d0*q(m,i+0) + &
      1.5928571428571428571428571428571429d0*q(m,i-1) - &
      1.4071428571428571428571428571428571d0*q(m,i-2) + &
      1.0928571428571428571428571428571429d0*q(m,i-3) - &
      0.57380952380952380952380952380952381d0*q(m,i-4) + &
      0.17619047619047619047619047619047619d0*q(m,i-5) - &
      0.02380952380952380952380952380952381d0*q(m,i-6)
fr7 = 0.14285714285714285714285714285714286d0*q(m,i+0) + &
      1.5928571428571428571428571428571429d0*q(m,i+1) - &
      1.4071428571428571428571428571428571d0*q(m,i+2) + &
      1.0928571428571428571428571428571429d0*q(m,i+3) - &
      0.57380952380952380952380952380952381d0*q(m,i+4) + &
      0.17619047619047619047619047619047619d0*q(m,i+5) - &
      0.02380952380952380952380952380952381d0*q(m,i+6)
fr8 = 0.30952380952380952380952380952380952d0*q(m,i+0) + &
      1.0928571428571428571428571428571429d0*q(m,i+1) - &
      0.57380952380952380952380952380952381d0*q(m,i+2) + &
      0.25952380952380952380952380952380952d0*q(m,i+3) - &
      0.07380952380952380952380952380952381d0*q(m,i+4) + &
      0.0095238095238095238095238095238095238d0*q(m,i+5) - &
      0.02380952380952380952380952380952381d0*q(m,i-1)
fr9 = 0.50952380952380952380952380952380952d0*q(m,i+0) + &
      0.75952380952380952380952380952380952d0*q(m,i+1) - &
      0.24047619047619047619047619047619048d0*q(m,i+2) + &
      0.059523809523809523809523809523809524d0*q(m,i+3) - &
      0.0071428571428571428571428571428571429d0*q(m,i+4) - &
      0.090476190476190476190476190476190476d0*q(m,i-1) + &
      0.0095238095238095238095238095238095238d0*q(m,i-2)
fr10 = 0.75952380952380952380952380952380952d0*q(m,i+0) + &
      0.50952380952380952380952380952380952d0*q(m,i+1) - &
      0.090476190476190476190476190476190476d0*q(m,i+2) + &
      0.0095238095238095238095238095238095238d0*q(m,i+3) - &
      0.24047619047619047619047619047619048d0*q(m,i-1) + &
      0.059523809523809523809523809523809524d0*q(m,i-2) - &
      0.0071428571428571428571428571428571429d0*q(m,i-3)
fr11 = 1.0928571428571428571428571428571429d0*q(m,i+0) + &
      0.30952380952380952380952380952380952d0*q(m,i+1) - &
      0.02380952380952380952380952380952381d0*q(m,i+2) - &
      0.57380952380952380952380952380952381d0*q(m,i-1) + &
      0.25952380952380952380952380952380952d0*q(m,i-2) - &
      0.07380952380952380952380952380952381d0*q(m,i-3) + &
      0.0095238095238095238095238095238095238d0*q(m,i-4)
fr12 = 1.5928571428571428571428571428571429d0*q(m,i+0) + &
      0.14285714285714285714285714285714286d0*q(m,i+1) - &
      1.4071428571428571428571428571428571d0*q(m,i-1) + &
      1.0928571428571428571428571428571429d0*q(m,i-2) - &
      0.57380952380952380952380952380952381d0*q(m,i-3) + &
      0.17619047619047619047619047619047619d0*q(m,i-4) - &
      0.02380952380952380952380952380952381d0*q(m,i-5)
fr13 = 2.5928571428571428571428571428571429d0*q(m,i+0) - &
      4.4071428571428571428571428571428571d0*q(m,i-1) + &
      6.0928571428571428571428571428571429d0*q(m,i-2) - &
      5.5738095238095238095238095238095238d0*q(m,i-3) + &
      3.1761904761904761904761904761904762d0*q(m,i-4) - &
      1.0238095238095238095238095238095238d0*q(m,i-5) + &
      0.14285714285714285714285714285714286d0*q(m,i-6)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3 + fr4*omega4 + fr5* &
      omega5 + fr6*omega6)/(omega0 + omega1 + omega2 + omega3 + omega4 &
      + omega5 + omega6)
fs1 = (fr10*omega10 + fr11*omega11 + fr12*omega12 + fr13*omega13 + fr7*omega7 &
      + fr8*omega8 + fr9*omega9)/(omega10 + omega11 + omega12 + omega13 &
      + omega7 + omega8 + omega9)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno15(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
sigma4, &
sigma5, &
sigma6, &
sigma7, &
omega1, &
omega10, &
omega0, &
omega13, &
omega15, &
omega7, &
omega9, &
omega6, &
omega11, &
omega5, &
omega12, &
omega4, &
omega8, &
omega14, &
omega3, &
omega2, &
fr1, &
fr10, &
fr0, &
fr13, &
fr15, &
fr7, &
fr9, &
fr6, &
fr11, &
fr5, &
fr12, &
fr4, &
fr8, &
fr14, &
fr3, &
fr2, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 282.83760061297691506024839358172691d0*q(m,i+0)**2 - &
      3217.686587518448629559740670851782d0*q(m,i+0)*q(m,i+1) + &
      8098.1714937959095945207056318167429d0*q(m,i+0)*q(m,i+2) - &
      11602.044745903530625752847975070197d0*q(m,i+0)*q(m,i+3) + &
      10159.093171656179468679468679468679d0*q(m,i+0)*q(m,i+4) - &
      5415.6341682525293636404747515858627d0*q(m,i+0)*q(m,i+5) + &
      1622.8891669858241038796594352149908d0*q(m,i+0)*q(m,i+6) - &
      210.46353198935837824726713615602504d0*q(m,i+0)*q(m,i+7) + &
      9343.0213274278608479997368886257775d0*q(m,i+1)**2 - &
      47645.872787024960636071747182858294d0*q(m,i+1)*q(m,i+2) + &
      68840.129412813427570372014816459261d0*q(m,i+1)*q(m,i+3) - &
      60634.399048328214994881661548328215d0*q(m,i+1)*q(m,i+4) + &
      32462.762767690995989607100718211829d0*q(m,i+1)*q(m,i+5) - &
      9759.9319230314438647771981105314439d0*q(m,i+1)*q(m,i+6) + &
      1268.9555105429228693117582006470895d0*q(m,i+1)*q(m,i+7) + &
      61294.837016677236729320062653395987d0*q(m,i+2)**2 - &
      178245.75997543865599421154976710532d0*q(m,i+2)*q(m,i+3) + &
      157723.97848716179011317900206789096d0*q(m,i+2)*q(m,i+4) - &
      84736.289792452146618813285479952147d0*q(m,i+2)*q(m,i+5) + &
      25544.35012397957623652068096512541d0*q(m,i+2)*q(m,i+6) - &
      3328.2515833759861537639315417093195d0*q(m,i+2)*q(m,i+7) + &
      130199.12498054647577217021661466106d0*q(m,i+3)**2 - &
      231245.30736143357671135448913226691d0*q(m,i+3)*q(m,i+4) + &
      124579.67848041024690330245885801441d0*q(m,i+3)*q(m,i+5) - &
      37637.431432587474254140920807587474d0*q(m,i+3)*q(m,i+6) + &
      4912.4856610466115674449007782341116d0*q(m,i+3)*q(m,i+7) + &
      102966.44021251021034007145118256229d0*q(m,i+4)**2 - &
      111189.45047698186587075475964364853d0*q(m,i+4)*q(m,i+5) + &
      33651.838777203859669137446915224693d0*q(m,i+4)*q(m,i+6) - &
      4398.633974298592354147909703465259d0*q(m,i+4)*q(m,i+7) + &
      30071.07843594807006265339598672932d0*q(m,i+5)**2 - &
      18228.764700605207549651994096438541d0*q(m,i+5)*q(m,i+6) + &
      2385.5410182943663846441624219401997d0*q(m,i+5)*q(m,i+7) + &
      2765.8444413360398603454159009714565d0*q(m,i+6)**2 - &
      724.6388946172140616585061029505474d0*q(m,i+6)*q(m,i+7) + &
      47.502897198625063208396541729875063d0*q(m,i+7)**2
sigma1 = 1639.3147654101139344194899750455306d0*q(m,i+0)**2 - &
      8454.3615524570594015038459482903927d0*q(m,i+0)*q(m,i+1) + &
      12248.796925352007817285595063372841d0*q(m,i+0)*q(m,i+2) - &
      10772.957080735622402289068955735622d0*q(m,i+0)*q(m,i+3) + &
      5746.6594758314280883725328169772614d0*q(m,i+0)*q(m,i+4) - &
      1719.625071179592012925346258679592d0*q(m,i+0)*q(m,i+5) + &
      222.44059555725267530823086378641934d0*q(m,i+0)*q(m,i+6) - &
      549.58282318864263308707753152197597d0*q(m,i+0)*q(m,i-1) + &
      11054.53843594807006265339598672932d0*q(m,i+1)**2 - &
      32362.405476981865870754759643648533d0*q(m,i+1)*q(m,i+2) + &
      28675.002184113950607006162561718117d0*q(m,i+1)*q(m,i+3) - &
      15380.224792452146618813285479952147d0*q(m,i+1)*q(m,i+4) + &
      4621.4027676909959896071007182118293d0*q(m,i+1)*q(m,i+5) - &
      599.69673439009550120661231772342883d0*q(m,i+1)*q(m,i+6) + &
      1391.206732580080670358448136225914d0*q(m,i+1)*q(m,i-1) + &
      23881.833962510210340071451182562294d0*q(m,i+2)**2 - &
      42591.666157729873007650785428563206d0*q(m,i+2)*q(m,i+3) + &
      22956.558487161790113179002067890957d0*q(m,i+2)*q(m,i+4) - &
      6924.034048328214994881661548328215d0*q(m,i+2)*q(m,i+5) + &
      901.15524837575618825618825618825619d0*q(m,i+2)*q(m,i+6) - &
      1992.0729028700209255764811320366876d0*q(m,i+2)*q(m,i-1) + &
      19089.324980546475772170216614661059d0*q(m,i+3)**2 - &
      20664.446179142359697915253470809026d0*q(m,i+3)*q(m,i+4) + &
      6253.5657091097238666683111127555572d0*q(m,i+3)*q(m,i+5) - &
      816.06838346966819189041411263633486d0*q(m,i+3)*q(m,i+6) + &
      1737.9199467608972817306150639483973d0*q(m,i+3)*q(m,i-1) + &
      5612.0232666772367293200626533959867d0*q(m,i+4)**2 - &
      3406.487787024960636071747182858294d0*q(m,i+4)*q(m,i+5) + &
      445.58477421919001780112891224002335d0*q(m,i+4)*q(m,i+6) - &
      921.69051194741472519250297028074806d0*q(m,i+4)*q(m,i-1) + &
      518.20132742786084799973688862577751d0*q(m,i+5)**2 - &
      135.8454499523110634221745332856444d0*q(m,i+5)*q(m,i+6) + &
      274.62122482863715502604391493280382d0*q(m,i+5)*q(m,i-1) + &
      8.9187051103314124147457480790814124d0*q(m,i+6)**2 - &
      35.407460560786949675838564727453616d0*q(m,i+6)*q(m,i-1) + &
      47.502897198625063208396541729875063d0*q(m,i-1)**2
sigma2 = 2403.2428963068663589496922830256164d0*q(m,i+0)**2 - &
      7175.2388643275448831004386559942115d0*q(m,i+0)*q(m,i+1) + &
      6406.9323143222839403394958950514506d0*q(m,i+0)*q(m,i+2) - &
      3435.4282183780725447392114058780725d0*q(m,i+0)*q(m,i+3) + &
      1026.4787350906873476317920762365207d0*q(m,i+0)*q(m,i+4) - &
      132.00759748533359644470755581866693d0*q(m,i+0)*q(m,i+5) - &
      1774.2290524570594015038459482903927d0*q(m,i+0)*q(m,i-1) + &
      277.00689062130641991753102864213975d0*q(m,i+0)*q(m,i-2) + &
      5440.5805361020313277257721702166147d0*q(m,i+1)**2 - &
      9841.5882256311075755520199964644409d0*q(m,i+1)*q(m,i+2) + &
      5330.2740359658024588580144135699691d0*q(m,i+1)*q(m,i+3) - &
      1605.0280992541409208075874742541409d0*q(m,i+1)*q(m,i+4) + &
      207.64347409775795192461859128525795d0*q(m,i+1)*q(m,i+5) + &
      2601.9748449121930024707802485580263d0*q(m,i+1)*q(m,i-1) - &
      399.19823796702268924491146713368936d0*q(m,i+1)*q(m,i-2) + &
      4502.6216168311979943924388368832813d0*q(m,i+2)**2 - &
      4924.833470809026364581920137475693d0*q(m,i+2)*q(m,i+3) + &
      1494.6013697964522617300395078172856d0*q(m,i+2)*q(m,i+4) - &
      194.56028823157295379517601739823962d0*q(m,i+2)*q(m,i+5) - &
      2293.2584001800668467335134001800668d0*q(m,i+2)*q(m,i-1) + &
      347.46346707064154980821647488314155d0*q(m,i+2)*q(m,i-2) + &
      1358.5547322443663589496922830256164d0*q(m,i+3)**2 - &
      830.84331171631866076310520754965199d0*q(m,i+3)*q(m,i+4) + &
      108.83322287990430351541462652573764d0*q(m,i+3)*q(m,i+5) + &
      1217.7148664564280883725328169772614d0*q(m,i+3)*q(m,i-1) - &
      182.82658888744999856110967222078333d0*q(m,i+3)*q(m,i-2) + &
      127.91439503974356404911960467516023d0*q(m,i+4)**2 - &
      33.716884035203479647924092368536813d0*q(m,i+4)*q(m,i+5) - &
      361.18331192033275366608699942033275d0*q(m,i+4)*q(m,i-1) + &
      53.862711959369077424632980188535744d0*q(m,i+4)*q(m,i-2) + &
      2.2348548705827351660684994018327352d0*q(m,i+5)**2 + &
      46.192194846273839329394884950440506d0*q(m,i+5)*q(m,i-1) - &
      6.8538318129915352137574359796582019d0*q(m,i+5)*q(m,i-2) + &
      335.04033977353986034541590097145653d0*q(m,i-1)**2 - &
      107.29182120451564896009340453784898d0*q(m,i-1)*q(m,i-2) + &
      8.9187051103314124147457480790814124d0*q(m,i-2)**2
sigma3 = 2019.3223112756424388368832813277258d0*q(m,i+0)**2 - &
      3827.9346762483915261693039470817249d0*q(m,i+0)*q(m,i+1) + &
      2136.1404624704320884876440431995988d0*q(m,i+0)*q(m,i+2) - &
      653.05988166154832821499488166154833d0*q(m,i+0)*q(m,i+3) + &
      84.702413278754424587757921091254425d0*q(m,i+0)*q(m,i+4) - &
      2499.7582856238411793967349522905078d0*q(m,i+0)*q(m,i-1) + &
      839.56149325324238518682963127407572d0*q(m,i+0)*q(m,i-2) - &
      118.29614801993274215496437718659941d0*q(m,i+0)*q(m,i-3) + &
      1856.3262151143770067381178492289603d0*q(m,i+1)**2 - &
      2115.5956853151992040880929769818659d0*q(m,i+1)*q(m,i+2) + &
      658.56225231960040987818765596543374d0*q(m,i+1)*q(m,i+3) - &
      86.735879060497116052671608227163783d0*q(m,i+1)*q(m,i+4) + &
      2315.1350236201234465123354012242901d0*q(m,i+1)*q(m,i-1) - &
      761.319673328214994881661548328215d0*q(m,i+1)*q(m,i-2) + &
      105.23620778382497132497132497132497d0*q(m,i+1)*q(m,i-3) + &
      615.75035001057006265339598672932006d0*q(m,i+2)**2 - &
      390.98979319780014224458668903113348d0*q(m,i+2)*q(m,i+3) + &
      52.403522014604479882257660035437813d0*q(m,i+2)*q(m,i+4) - &
      1267.3122924521466188132854799521466d0*q(m,i+2)*q(m,i-1) + &
      409.59654373266265627376738487849599d0*q(m,i+2)*q(m,i-2) - &
      55.743457273693384804495915607026718d0*q(m,i+2)*q(m,i-3) + &
      63.350710143910230715786271341826897d0*q(m,i+3)**2 - &
      17.31975771245215689660134104578549d0*q(m,i+3)*q(m,i+4) + &
      381.25560719716882911327355771800216d0*q(m,i+3)*q(m,i-1) - &
      121.46849710551793885127218460551794d0*q(m,i+3)*q(m,i-2) + &
      16.318649872728865784421339976895532d0*q(m,i+3)*q(m,i-3) + &
      1.2100344754107774941108274441607775d0*q(m,i+4)**2 - &
      48.787982185509963287741065518843297d0*q(m,i+4)*q(m,i-1) + &
      15.358408608399059787948676837565726d0*q(m,i+4)*q(m,i-2) - &
      2.0407938941202830091718980607869497d0*q(m,i+4)*q(m,i-3) + &
      793.78510261473672932006265339598673d0*q(m,i-1)**2 - &
      547.06195369162730273841384952496064d0*q(m,i-1)*q(m,i-2) + &
      78.959677906359329970441081552192663d0*q(m,i-1)*q(m,i-3) + &
      97.118762323694181333070221959110848d0*q(m,i-2)**2 - &
      28.903846116332227443338554449665561d0*q(m,i-2)*q(m,i-3) + &
      2.2348548705827351660684994018327352d0*q(m,i-3)**2
sigma4 = 2019.3223112756424388368832813277258d0*q(m,i+0)**2 - &
      2499.7582856238411793967349522905078d0*q(m,i+0)*q(m,i+1) + &
      839.56149325324238518682963127407572d0*q(m,i+0)*q(m,i+2) - &
      118.29614801993274215496437718659941d0*q(m,i+0)*q(m,i+3) - &
      3827.9346762483915261693039470817249d0*q(m,i+0)*q(m,i-1) + &
      2136.1404624704320884876440431995988d0*q(m,i+0)*q(m,i-2) - &
      653.05988166154832821499488166154833d0*q(m,i+0)*q(m,i-3) + &
      84.702413278754424587757921091254425d0*q(m,i+0)*q(m,i-4) + &
      793.78510261473672932006265339598673d0*q(m,i+1)**2 - &
      547.06195369162730273841384952496064d0*q(m,i+1)*q(m,i+2) + &
      78.959677906359329970441081552192663d0*q(m,i+1)*q(m,i+3) + &
      2315.1350236201234465123354012242901d0*q(m,i+1)*q(m,i-1) - &
      1267.3122924521466188132854799521466d0*q(m,i+1)*q(m,i-2) + &
      381.25560719716882911327355771800216d0*q(m,i+1)*q(m,i-3) - &
      48.787982185509963287741065518843297d0*q(m,i+1)*q(m,i-4) + &
      97.118762323694181333070221959110848d0*q(m,i+2)**2 - &
      28.903846116332227443338554449665561d0*q(m,i+2)*q(m,i+3) - &
      761.319673328214994881661548328215d0*q(m,i+2)*q(m,i-1) + &
      409.59654373266265627376738487849599d0*q(m,i+2)*q(m,i-2) - &
      121.46849710551793885127218460551794d0*q(m,i+2)*q(m,i-3) + &
      15.358408608399059787948676837565726d0*q(m,i+2)*q(m,i-4) + &
      2.2348548705827351660684994018327352d0*q(m,i+3)**2 + &
      105.23620778382497132497132497132497d0*q(m,i+3)*q(m,i-1) - &
      55.743457273693384804495915607026718d0*q(m,i+3)*q(m,i-2) + &
      16.318649872728865784421339976895532d0*q(m,i+3)*q(m,i-3) - &
      2.0407938941202830091718980607869497d0*q(m,i+3)*q(m,i-4) + &
      1856.3262151143770067381178492289603d0*q(m,i-1)**2 - &
      2115.5956853151992040880929769818659d0*q(m,i-1)*q(m,i-2) + &
      658.56225231960040987818765596543374d0*q(m,i-1)*q(m,i-3) - &
      86.735879060497116052671608227163783d0*q(m,i-1)*q(m,i-4) + &
      615.75035001057006265339598672932006d0*q(m,i-2)**2 - &
      390.98979319780014224458668903113348d0*q(m,i-2)*q(m,i-3) + &
      52.403522014604479882257660035437813d0*q(m,i-2)*q(m,i-4) + &
      63.350710143910230715786271341826897d0*q(m,i-3)**2 - &
      17.31975771245215689660134104578549d0*q(m,i-3)*q(m,i-4) + &
      1.2100344754107774941108274441607775d0*q(m,i-4)**2
sigma5 = 2403.2428963068663589496922830256164d0*q(m,i+0)**2 - &
      1774.2290524570594015038459482903927d0*q(m,i+0)*q(m,i+1) + &
      277.00689062130641991753102864213975d0*q(m,i+0)*q(m,i+2) - &
      7175.2388643275448831004386559942115d0*q(m,i+0)*q(m,i-1) + &
      6406.9323143222839403394958950514506d0*q(m,i+0)*q(m,i-2) - &
      3435.4282183780725447392114058780725d0*q(m,i+0)*q(m,i-3) + &
      1026.4787350906873476317920762365207d0*q(m,i+0)*q(m,i-4) - &
      132.00759748533359644470755581866693d0*q(m,i+0)*q(m,i-5) + &
      335.04033977353986034541590097145653d0*q(m,i+1)**2 - &
      107.29182120451564896009340453784898d0*q(m,i+1)*q(m,i+2) + &
      2601.9748449121930024707802485580263d0*q(m,i+1)*q(m,i-1) - &
      2293.2584001800668467335134001800668d0*q(m,i+1)*q(m,i-2) + &
      1217.7148664564280883725328169772614d0*q(m,i+1)*q(m,i-3) - &
      361.18331192033275366608699942033275d0*q(m,i+1)*q(m,i-4) + &
      46.192194846273839329394884950440506d0*q(m,i+1)*q(m,i-5) + &
      8.9187051103314124147457480790814124d0*q(m,i+2)**2 - &
      399.19823796702268924491146713368936d0*q(m,i+2)*q(m,i-1) + &
      347.46346707064154980821647488314155d0*q(m,i+2)*q(m,i-2) - &
      182.82658888744999856110967222078333d0*q(m,i+2)*q(m,i-3) + &
      53.862711959369077424632980188535744d0*q(m,i+2)*q(m,i-4) - &
      6.8538318129915352137574359796582019d0*q(m,i+2)*q(m,i-5) + &
      5440.5805361020313277257721702166147d0*q(m,i-1)**2 - &
      9841.5882256311075755520199964644409d0*q(m,i-1)*q(m,i-2) + &
      5330.2740359658024588580144135699691d0*q(m,i-1)*q(m,i-3) - &
      1605.0280992541409208075874742541409d0*q(m,i-1)*q(m,i-4) + &
      207.64347409775795192461859128525795d0*q(m,i-1)*q(m,i-5) + &
      4502.6216168311979943924388368832813d0*q(m,i-2)**2 - &
      4924.833470809026364581920137475693d0*q(m,i-2)*q(m,i-3) + &
      1494.6013697964522617300395078172856d0*q(m,i-2)*q(m,i-4) - &
      194.56028823157295379517601739823962d0*q(m,i-2)*q(m,i-5) + &
      1358.5547322443663589496922830256164d0*q(m,i-3)**2 - &
      830.84331171631866076310520754965199d0*q(m,i-3)*q(m,i-4) + &
      108.83322287990430351541462652573764d0*q(m,i-3)*q(m,i-5) + &
      127.91439503974356404911960467516023d0*q(m,i-4)**2 - &
      33.716884035203479647924092368536813d0*q(m,i-4)*q(m,i-5) + &
      2.2348548705827351660684994018327352d0*q(m,i-5)**2
sigma6 = 1639.3147654101139344194899750455306d0*q(m,i+0)**2 - &
      549.58282318864263308707753152197597d0*q(m,i+0)*q(m,i+1) - &
      8454.3615524570594015038459482903927d0*q(m,i+0)*q(m,i-1) + &
      12248.796925352007817285595063372841d0*q(m,i+0)*q(m,i-2) - &
      10772.957080735622402289068955735622d0*q(m,i+0)*q(m,i-3) + &
      5746.6594758314280883725328169772614d0*q(m,i+0)*q(m,i-4) - &
      1719.625071179592012925346258679592d0*q(m,i+0)*q(m,i-5) + &
      222.44059555725267530823086378641934d0*q(m,i+0)*q(m,i-6) + &
      47.502897198625063208396541729875063d0*q(m,i+1)**2 + &
      1391.206732580080670358448136225914d0*q(m,i+1)*q(m,i-1) - &
      1992.0729028700209255764811320366876d0*q(m,i+1)*q(m,i-2) + &
      1737.9199467608972817306150639483973d0*q(m,i+1)*q(m,i-3) - &
      921.69051194741472519250297028074806d0*q(m,i+1)*q(m,i-4) + &
      274.62122482863715502604391493280382d0*q(m,i+1)*q(m,i-5) - &
      35.407460560786949675838564727453616d0*q(m,i+1)*q(m,i-6) + &
      11054.53843594807006265339598672932d0*q(m,i-1)**2 - &
      32362.405476981865870754759643648533d0*q(m,i-1)*q(m,i-2) + &
      28675.002184113950607006162561718117d0*q(m,i-1)*q(m,i-3) - &
      15380.224792452146618813285479952147d0*q(m,i-1)*q(m,i-4) + &
      4621.4027676909959896071007182118293d0*q(m,i-1)*q(m,i-5) - &
      599.69673439009550120661231772342883d0*q(m,i-1)*q(m,i-6) + &
      23881.833962510210340071451182562294d0*q(m,i-2)**2 - &
      42591.666157729873007650785428563206d0*q(m,i-2)*q(m,i-3) + &
      22956.558487161790113179002067890957d0*q(m,i-2)*q(m,i-4) - &
      6924.034048328214994881661548328215d0*q(m,i-2)*q(m,i-5) + &
      901.15524837575618825618825618825619d0*q(m,i-2)*q(m,i-6) + &
      19089.324980546475772170216614661059d0*q(m,i-3)**2 - &
      20664.446179142359697915253470809026d0*q(m,i-3)*q(m,i-4) + &
      6253.5657091097238666683111127555572d0*q(m,i-3)*q(m,i-5) - &
      816.06838346966819189041411263633486d0*q(m,i-3)*q(m,i-6) + &
      5612.0232666772367293200626533959867d0*q(m,i-4)**2 - &
      3406.487787024960636071747182858294d0*q(m,i-4)*q(m,i-5) + &
      445.58477421919001780112891224002335d0*q(m,i-4)*q(m,i-6) + &
      518.20132742786084799973688862577751d0*q(m,i-5)**2 - &
      135.8454499523110634221745332856444d0*q(m,i-5)*q(m,i-6) + &
      8.9187051103314124147457480790814124d0*q(m,i-6)**2
sigma7 = 282.83760061297691506024839358172691d0*q(m,i+0)**2 - &
      3217.686587518448629559740670851782d0*q(m,i+0)*q(m,i-1) + &
      8098.1714937959095945207056318167429d0*q(m,i+0)*q(m,i-2) - &
      11602.044745903530625752847975070197d0*q(m,i+0)*q(m,i-3) + &
      10159.093171656179468679468679468679d0*q(m,i+0)*q(m,i-4) - &
      5415.6341682525293636404747515858627d0*q(m,i+0)*q(m,i-5) + &
      1622.8891669858241038796594352149908d0*q(m,i+0)*q(m,i-6) - &
      210.46353198935837824726713615602504d0*q(m,i+0)*q(m,i-7) + &
      9343.0213274278608479997368886257775d0*q(m,i-1)**2 - &
      47645.872787024960636071747182858294d0*q(m,i-1)*q(m,i-2) + &
      68840.129412813427570372014816459261d0*q(m,i-1)*q(m,i-3) - &
      60634.399048328214994881661548328215d0*q(m,i-1)*q(m,i-4) + &
      32462.762767690995989607100718211829d0*q(m,i-1)*q(m,i-5) - &
      9759.9319230314438647771981105314439d0*q(m,i-1)*q(m,i-6) + &
      1268.9555105429228693117582006470895d0*q(m,i-1)*q(m,i-7) + &
      61294.837016677236729320062653395987d0*q(m,i-2)**2 - &
      178245.75997543865599421154976710532d0*q(m,i-2)*q(m,i-3) + &
      157723.97848716179011317900206789096d0*q(m,i-2)*q(m,i-4) - &
      84736.289792452146618813285479952147d0*q(m,i-2)*q(m,i-5) + &
      25544.35012397957623652068096512541d0*q(m,i-2)*q(m,i-6) - &
      3328.2515833759861537639315417093195d0*q(m,i-2)*q(m,i-7) + &
      130199.12498054647577217021661466106d0*q(m,i-3)**2 - &
      231245.30736143357671135448913226691d0*q(m,i-3)*q(m,i-4) + &
      124579.67848041024690330245885801441d0*q(m,i-3)*q(m,i-5) - &
      37637.431432587474254140920807587474d0*q(m,i-3)*q(m,i-6) + &
      4912.4856610466115674449007782341116d0*q(m,i-3)*q(m,i-7) + &
      102966.44021251021034007145118256229d0*q(m,i-4)**2 - &
      111189.45047698186587075475964364853d0*q(m,i-4)*q(m,i-5) + &
      33651.838777203859669137446915224693d0*q(m,i-4)*q(m,i-6) - &
      4398.633974298592354147909703465259d0*q(m,i-4)*q(m,i-7) + &
      30071.07843594807006265339598672932d0*q(m,i-5)**2 - &
      18228.764700605207549651994096438541d0*q(m,i-5)*q(m,i-6) + &
      2385.5410182943663846441624219401997d0*q(m,i-5)*q(m,i-7) + &
      2765.8444413360398603454159009714565d0*q(m,i-6)**2 - &
      724.6388946172140616585061029505474d0*q(m,i-6)*q(m,i-7) + &
      47.502897198625063208396541729875063d0*q(m,i-7)**2
omega0 = 0.0001554001554001554001554001554001554d0/(1.0e-36 + sigma0)**2
omega1 = 0.0087024087024087024087024087024087024d0/(1.0e-36 + sigma1)**2
omega2 = 0.091375291375291375291375291375291375d0/(1.0e-36 + sigma2)**2
omega3 = 0.30458430458430458430458430458430458d0/(1.0e-36 + sigma3)**2
omega4 = 0.38073038073038073038073038073038073d0/(1.0e-36 + sigma4)**2
omega5 = 0.18275058275058275058275058275058275d0/(1.0e-36 + sigma5)**2
omega6 = 0.030458430458430458430458430458430458d0/(1.0e-36 + sigma6)**2
omega7 = 0.0012432012432012432012432012432012432d0/(1.0e-36 + sigma7)**2
omega8 = 0.0012432012432012432012432012432012432d0/(1.0e-36 + sigma0)**2
omega9 = 0.030458430458430458430458430458430458d0/(1.0e-36 + sigma1)**2
omega10 = 0.18275058275058275058275058275058275d0/(1.0e-36 + sigma2)**2
omega11 = 0.38073038073038073038073038073038073d0/(1.0e-36 + sigma3)**2
omega12 = 0.30458430458430458430458430458430458d0/(1.0e-36 + sigma4)**2
omega13 = 0.091375291375291375291375291375291375d0/(1.0e-36 + sigma5)**2
omega14 = 0.0087024087024087024087024087024087024d0/(1.0e-36 + sigma6)**2
omega15 = 0.0001554001554001554001554001554001554d0/(1.0e-36 + sigma7)**2
fr0 = 2.7178571428571428571428571428571429d0*q(m,i+0) - &
      5.2821428571428571428571428571428571d0*q(m,i+1) + &
      8.7178571428571428571428571428571429d0*q(m,i+2) - &
      9.9488095238095238095238095238095238d0*q(m,i+3) + &
      7.5511904761904761904761904761904762d0*q(m,i+4) - &
      3.6488095238095238095238095238095238d0*q(m,i+5) + &
      1.0178571428571428571428571428571429d0*q(m,i+6) - 0.125d0*q(m,i+7 &
      )
fr1 = 1.7178571428571428571428571428571429d0*q(m,i+0) - &
      1.7821428571428571428571428571428571d0*q(m,i+1) + &
      1.7178571428571428571428571428571429d0*q(m,i+2) - &
      1.1988095238095238095238095238095238d0*q(m,i+3) + &
      0.55119047619047619047619047619047619d0*q(m,i+4) - &
      0.14880952380952380952380952380952381d0*q(m,i+5) + &
      0.017857142857142857142857142857142857d0*q(m,i+6) + 0.125d0*q(m, &
      i-1)
fr2 = 1.2178571428571428571428571428571429d0*q(m,i+0) - &
      0.78214285714285714285714285714285714d0*q(m,i+1) + &
      0.46785714285714285714285714285714286d0*q(m,i+2) - &
      0.19880952380952380952380952380952381d0*q(m,i+3) + &
      0.05119047619047619047619047619047619d0*q(m,i+4) - &
      0.0059523809523809523809523809523809524d0*q(m,i+5) + &
      0.26785714285714285714285714285714286d0*q(m,i-1) - &
      0.017857142857142857142857142857142857d0*q(m,i-2)
fr3 = 0.88452380952380952380952380952380952d0*q(m,i+0) - &
      0.36547619047619047619047619047619048d0*q(m,i+1) + &
      0.13452380952380952380952380952380952d0*q(m,i+2) - &
      0.032142857142857142857142857142857143d0*q(m,i+3) + &
      0.0035714285714285714285714285714285714d0*q(m,i+4) + &
      0.43452380952380952380952380952380952d0*q(m,i-1) - &
      0.065476190476190476190476190476190476d0*q(m,i-2) + &
      0.0059523809523809523809523809523809524d0*q(m,i-3)
fr4 = 0.63452380952380952380952380952380952d0*q(m,i+0) - &
      0.16547619047619047619047619047619048d0*q(m,i+1) + &
      0.034523809523809523809523809523809524d0*q(m,i+2) - &
      0.0035714285714285714285714285714285714d0*q(m,i+3) + &
      0.63452380952380952380952380952380952d0*q(m,i-1) - &
      0.16547619047619047619047619047619048d0*q(m,i-2) + &
      0.034523809523809523809523809523809524d0*q(m,i-3) - &
      0.0035714285714285714285714285714285714d0*q(m,i-4)
fr5 = 0.43452380952380952380952380952380952d0*q(m,i+0) - &
      0.065476190476190476190476190476190476d0*q(m,i+1) + &
      0.0059523809523809523809523809523809524d0*q(m,i+2) + &
      0.88452380952380952380952380952380952d0*q(m,i-1) - &
      0.36547619047619047619047619047619048d0*q(m,i-2) + &
      0.13452380952380952380952380952380952d0*q(m,i-3) - &
      0.032142857142857142857142857142857143d0*q(m,i-4) + &
      0.0035714285714285714285714285714285714d0*q(m,i-5)
fr6 = 0.26785714285714285714285714285714286d0*q(m,i+0) - &
      0.017857142857142857142857142857142857d0*q(m,i+1) + &
      1.2178571428571428571428571428571429d0*q(m,i-1) - &
      0.78214285714285714285714285714285714d0*q(m,i-2) + &
      0.46785714285714285714285714285714286d0*q(m,i-3) - &
      0.19880952380952380952380952380952381d0*q(m,i-4) + &
      0.05119047619047619047619047619047619d0*q(m,i-5) - &
      0.0059523809523809523809523809523809524d0*q(m,i-6)
fr7 = 0.125d0*q(m,i+0) + 1.7178571428571428571428571428571429d0*q(m,i-1) - &
      1.7821428571428571428571428571428571d0*q(m,i-2) + &
      1.7178571428571428571428571428571429d0*q(m,i-3) - &
      1.1988095238095238095238095238095238d0*q(m,i-4) + &
      0.55119047619047619047619047619047619d0*q(m,i-5) - &
      0.14880952380952380952380952380952381d0*q(m,i-6) + &
      0.017857142857142857142857142857142857d0*q(m,i-7)
fr8 = 0.125d0*q(m,i+0) + 1.7178571428571428571428571428571429d0*q(m,i+1) - &
      1.7821428571428571428571428571428571d0*q(m,i+2) + &
      1.7178571428571428571428571428571429d0*q(m,i+3) - &
      1.1988095238095238095238095238095238d0*q(m,i+4) + &
      0.55119047619047619047619047619047619d0*q(m,i+5) - &
      0.14880952380952380952380952380952381d0*q(m,i+6) + &
      0.017857142857142857142857142857142857d0*q(m,i+7)
fr9 = 0.26785714285714285714285714285714286d0*q(m,i+0) + &
      1.2178571428571428571428571428571429d0*q(m,i+1) - &
      0.78214285714285714285714285714285714d0*q(m,i+2) + &
      0.46785714285714285714285714285714286d0*q(m,i+3) - &
      0.19880952380952380952380952380952381d0*q(m,i+4) + &
      0.05119047619047619047619047619047619d0*q(m,i+5) - &
      0.0059523809523809523809523809523809524d0*q(m,i+6) - &
      0.017857142857142857142857142857142857d0*q(m,i-1)
fr10 = 0.43452380952380952380952380952380952d0*q(m,i+0) + &
      0.88452380952380952380952380952380952d0*q(m,i+1) - &
      0.36547619047619047619047619047619048d0*q(m,i+2) + &
      0.13452380952380952380952380952380952d0*q(m,i+3) - &
      0.032142857142857142857142857142857143d0*q(m,i+4) + &
      0.0035714285714285714285714285714285714d0*q(m,i+5) - &
      0.065476190476190476190476190476190476d0*q(m,i-1) + &
      0.0059523809523809523809523809523809524d0*q(m,i-2)
fr11 = 0.63452380952380952380952380952380952d0*q(m,i+0) + &
      0.63452380952380952380952380952380952d0*q(m,i+1) - &
      0.16547619047619047619047619047619048d0*q(m,i+2) + &
      0.034523809523809523809523809523809524d0*q(m,i+3) - &
      0.0035714285714285714285714285714285714d0*q(m,i+4) - &
      0.16547619047619047619047619047619048d0*q(m,i-1) + &
      0.034523809523809523809523809523809524d0*q(m,i-2) - &
      0.0035714285714285714285714285714285714d0*q(m,i-3)
fr12 = 0.88452380952380952380952380952380952d0*q(m,i+0) + &
      0.43452380952380952380952380952380952d0*q(m,i+1) - &
      0.065476190476190476190476190476190476d0*q(m,i+2) + &
      0.0059523809523809523809523809523809524d0*q(m,i+3) - &
      0.36547619047619047619047619047619048d0*q(m,i-1) + &
      0.13452380952380952380952380952380952d0*q(m,i-2) - &
      0.032142857142857142857142857142857143d0*q(m,i-3) + &
      0.0035714285714285714285714285714285714d0*q(m,i-4)
fr13 = 1.2178571428571428571428571428571429d0*q(m,i+0) + &
      0.26785714285714285714285714285714286d0*q(m,i+1) - &
      0.017857142857142857142857142857142857d0*q(m,i+2) - &
      0.78214285714285714285714285714285714d0*q(m,i-1) + &
      0.46785714285714285714285714285714286d0*q(m,i-2) - &
      0.19880952380952380952380952380952381d0*q(m,i-3) + &
      0.05119047619047619047619047619047619d0*q(m,i-4) - &
      0.0059523809523809523809523809523809524d0*q(m,i-5)
fr14 = 1.7178571428571428571428571428571429d0*q(m,i+0) + 0.125d0*q(m,i+1) - &
      1.7821428571428571428571428571428571d0*q(m,i-1) + &
      1.7178571428571428571428571428571429d0*q(m,i-2) - &
      1.1988095238095238095238095238095238d0*q(m,i-3) + &
      0.55119047619047619047619047619047619d0*q(m,i-4) - &
      0.14880952380952380952380952380952381d0*q(m,i-5) + &
      0.017857142857142857142857142857142857d0*q(m,i-6)
fr15 = 2.7178571428571428571428571428571429d0*q(m,i+0) - &
      5.2821428571428571428571428571428571d0*q(m,i-1) + &
      8.7178571428571428571428571428571429d0*q(m,i-2) - &
      9.9488095238095238095238095238095238d0*q(m,i-3) + &
      7.5511904761904761904761904761904762d0*q(m,i-4) - &
      3.6488095238095238095238095238095238d0*q(m,i-5) + &
      1.0178571428571428571428571428571429d0*q(m,i-6) - 0.125d0*q(m,i-7 &
      )
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3 + fr4*omega4 + fr5* &
      omega5 + fr6*omega6 + fr7*omega7)/(omega0 + omega1 + omega2 + &
      omega3 + omega4 + omega5 + omega6 + omega7)
fs1 = (fr10*omega10 + fr11*omega11 + fr12*omega12 + fr13*omega13 + fr14* &
      omega14 + fr15*omega15 + fr8*omega8 + fr9*omega9)/(omega10 + &
      omega11 + omega12 + omega13 + omega14 + omega15 + omega8 + omega9 &
      )
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine

subroutine weno17(q, ql, qr, num_eqn, maxnx, num_ghost)

  implicit none

  integer,          intent(in)  :: num_eqn, maxnx, num_ghost
  double precision, intent(in)  :: q(num_eqn,maxnx+2*num_ghost)
  double precision, intent(out) :: ql(num_eqn,maxnx+2*num_ghost), qr(num_eqn,maxnx+2*num_ghost)

  integer :: i, m
  double precision :: sigma0, &
sigma1, &
sigma2, &
sigma3, &
sigma4, &
sigma5, &
sigma6, &
sigma7, &
sigma8, &
omega1, &
omega11, &
omega0, &
omega14, &
omega16, &
omega7, &
omega10, &
omega6, &
omega17, &
omega12, &
omega5, &
omega13, &
omega4, &
omega9, &
omega15, &
omega3, &
omega8, &
omega2, &
fr1, &
fr11, &
fr0, &
fr14, &
fr16, &
fr7, &
fr10, &
fr6, &
fr17, &
fr12, &
fr5, &
fr13, &
fr4, &
fr9, &
fr15, &
fr3, &
fr8, &
fr2, &
fs0, &
fs1

  do i = num_ghost, maxnx+num_ghost+1
    do m = 1, num_eqn
      sigma0 = 669.71498110880766304046727327150608d0*q(m,i+0)**2 - &
      8893.7804564128406927679414451901224d0*q(m,i+0)*q(m,i+1) + &
      26542.97482472791651445751974852504d0*q(m,i+0)*q(m,i+2) - &
      46202.756401880865649880200144750409d0*q(m,i+0)*q(m,i+3) + &
      51067.48172473001703739137601571464d0*q(m,i+0)*q(m,i+4) - &
      36585.057650974236271028599070927113d0*q(m,i+0)*q(m,i+5) + &
      16552.001482310528090124650971211818d0*q(m,i+0)*q(m,i+6) - &
      4316.3646381469098276307271016265725d0*q(m,i+0)*q(m,i+7) + &
      496.07115342877547325298648049970801d0*q(m,i+0)*q(m,i+8) + &
      29991.619926849829482931334783186635d0*q(m,i+1)**2 - &
      180813.86130139181867025782369697714d0*q(m,i+1)*q(m,i+2) + &
      316864.9463944537131127739593348059d0*q(m,i+1)*q(m,i+3) - &
      351925.41214019592223130582918942707d0*q(m,i+1)*q(m,i+4) + &
      253037.27436328625659809522243384677d0*q(m,i+1)*q(m,i+5) - &
      114802.39231253987842942869397895853d0*q(m,i+1)*q(m,i+6) + &
      30004.610607492135228577027518826461d0*q(m,i+1)*q(m,i+7) - &
      3454.625008391303881548590543299538d0*q(m,i+1)*q(m,i+8) + &
      274437.46397404212407105925624444143d0*q(m,i+2)**2 - &
      966727.20764007119852027259434666842d0*q(m,i+2)*q(m,i+3) + &
      1077735.7595948131943502313872684243d0*q(m,i+2)*q(m,i+4) - &
      777141.66860592710187617595025002432d0*q(m,i+2)*q(m,i+5) + &
      353390.25560170486877662803588729515d0*q(m,i+2)*q(m,i+6) - &
      92530.842741111307000857265407529958d0*q(m,i+2)*q(m,i+7) + &
      10669.662319171198284128178308072488d0*q(m,i+2)*q(m,i+8) + &
      854591.51248035201145733553140960548d0*q(m,i+3)**2 - &
      1911046.2191646688680832199350717869d0*q(m,i+3)*q(m,i+4) + &
      1381212.3157777061437362363288289214d0*q(m,i+3)*q(m,i+5) - &
      629240.18222321105249345990086730827d0*q(m,i+3)*q(m,i+6) + &
      165006.50792942382273566135999998434d0*q(m,i+3)*q(m,i+7) - &
      19050.429632455717752510080552408595d0*q(m,i+3)*q(m,i+8) + &
      1070854.4744981081750468324542398616d0*q(m,i+4)**2 - &
      1550800.1901523231890708742560594412d0*q(m,i+4)*q(m,i+5) + &
      707565.24879234405854776225146595517d0*q(m,i+4)*q(m,i+6) - &
      185776.15367458745662284022072381861d0*q(m,i+4)*q(m,i+7) + &
      21470.536023671815979190317814656439d0*q(m,i+4)*q(m,i+8) + &
      562311.3282334384312104219511626919d0*q(m,i+5)**2 - &
      513755.44664007119852027259434666842d0*q(m,i+5)*q(m,i+6) + &
      135029.25790062655261894679884097874d0*q(m,i+5)*q(m,i+7) - &
      15619.141459200089635770852702069633d0*q(m,i+5)*q(m,i+8) + &
      117469.12296169644505871357723209575d0*q(m,i+6)**2 - &
      61801.701927494111439217259323079429d0*q(m,i+6)*q(m,i+7) + &
      7153.9713035638953504363557273610184d0*q(m,i+6)*q(m,i+8) + &
      8134.5593947258687875420679653483886d0*q(m,i+7)**2 - &
      1884.432245654463267723849734431745d0*q(m,i+7)*q(m,i+8) + &
      109.19377293294472527276760080992885d0*q(m,i+8)**2
sigma1 = 5049.770207818351150857764614378371d0*q(m,i+0)**2 - &
      30701.158718003370698476518582338688d0*q(m,i+0)*q(m,i+1) + &
      53947.021738782416816477663038509599d0*q(m,i+0)*q(m,i+2) - &
      59895.401389672333166050097267028484d0*q(m,i+0)*q(m,i+3) + &
      42979.169191576600513439137777762116d0*q(m,i+0)*q(m,i+4) - &
      19443.792304768714408264672814937365d0*q(m,i+0)*q(m,i+5) + &
      5065.2630873477348758433414518070603d0*q(m,i+0)*q(m,i+6) - &
      581.22526153480665302755249845196935d0*q(m,i+0)*q(m,i+7) - &
      1469.4167593642295816568303340790113d0*q(m,i+0)*q(m,i-1) + &
      47140.249345859253700688885874071059d0*q(m,i+1)**2 - &
      166921.45580480885284126024866765608d0*q(m,i+1)*q(m,i+2) + &
      186372.63661641813262183632554002924d0*q(m,i+1)*q(m,i+3) - &
      134309.27227838080557987965395372803d0*q(m,i+1)*q(m,i+4) + &
      60963.61982566320210996136922062848d0*q(m,i+1)*q(m,i+5) - &
      15923.184524345433984984249534514085d0*q(m,i+1)*q(m,i+6) + &
      1830.9895489579046333345275144216943d0*q(m,i+1)*q(m,i+7) + &
      4407.3266427807163380906767150153394d0*q(m,i+1)*q(m,i-1) + &
      148657.09097851944972894046968121042d0*q(m,i+2)**2 - &
      333527.45174279386808321993507178692d0*q(m,i+2)*q(m,i+3) + &
      241247.06683538361287203879796472389d0*q(m,i+2)*q(m,i+4) - &
      109824.6748524548796539537280278021d0*q(m,i+2)*q(m,i+5) + &
      28752.761310624219561058185396809735d0*q(m,i+2)*q(m,i+6) - &
      3312.5579082080325673248953672234096d0*q(m,i+2)*q(m,i+7) - &
      7674.8915335635155616967786279955592d0*q(m,i+2)*q(m,i-1) + &
      187797.71787436203307152381226455301d0*q(m,i+3)**2 - &
      272525.22465946053474988660173845359d0*q(m,i+3)*q(m,i+4) + &
      124378.18823678850299220669591039961d0*q(m,i+3)*q(m,i+5) - &
      32630.239253428946922663853880785098d0*q(m,i+3)*q(m,i+6) + &
      3765.6552967786281485024871268257512d0*q(m,i+3)*q(m,i+7) + &
      8466.401146646353016227354851693476d0*q(m,i+3)*q(m,i-1) + &
      99127.274598889820099310840051580792d0*q(m,i+4)**2 - &
      90677.125749253297285704693112100519d0*q(m,i+4)*q(m,i+5) + &
      23831.475738782416816477663038509599d0*q(m,i+4)*q(m,i+6) - &
      2754.3435209973779955592124904294216d0*q(m,i+4)*q(m,i+7) - &
      6046.2947554302547895471175894456318d0*q(m,i+4)*q(m,i-1) + &
      20774.707475488883330318515503700689d0*q(m,i+5)**2 - &
      10936.703307950460645566465672285778d0*q(m,i+5)*q(m,i+6) + &
      1265.660807463256020630359254697879d0*q(m,i+5)*q(m,i+7) + &
      2725.4123935346242100541042339984139d0*q(m,i+5)*q(m,i-1) + &
      1441.285754492576396511581696766882d0*q(m,i+6)**2 - &
      333.96421240655762398487266212133937d0*q(m,i+6)*q(m,i+7) - &
      707.980347608124869202911530953859d0*q(m,i+6)*q(m,i-1) + &
      19.364791404222125121596021066920538d0*q(m,i+7)**2 + &
      81.055667138541787185967080146974327d0*q(m,i+7)*q(m,i-1) + &
      109.19377293294472527276760080992885d0*q(m,i-1)**2
sigma2 = 9222.4304524371857994543179728364914d0*q(m,i+0)**2 - &
      33080.87139933045777953185360592768d0*q(m,i+0)*q(m,i+1) + &
      37137.941709010725214428918132621836d0*q(m,i+0)*q(m,i+2) - &
      26774.815371359200641608049015456423d0*q(m,i+0)*q(m,i+3) + &
      12118.138879482646554405813665072924d0*q(m,i+0)*q(m,i+4) - &
      3149.4331405822064717567363070008573d0*q(m,i+0)*q(m,i+5) + &
      359.9089168343376139341747807356273d0*q(m,i+0)*q(m,i+6) - &
      5868.7702184994024445082646140847199d0*q(m,i+0)*q(m,i-1) + &
      813.03971956918635572736101836630937d0*q(m,i+0)*q(m,i-2) + &
      29975.095381586579358570099310840052d0*q(m,i+1)**2 - &
      67875.812791212077959763144948330134d0*q(m,i+1)*q(m,i+2) + &
      49266.812962891328921421514014106607d0*q(m,i+1)*q(m,i+3) - &
      22417.230698519694468768542842616917d0*q(m,i+1)*q(m,i+4) + &
      5850.7466490005423123809367195610582d0*q(m,i+1)*q(m,i+5) - &
      670.84934475730505409738213971018204d0*q(m,i+1)*q(m,i+6) + &
      10399.3092657059176983118782060581d0*q(m,i+1)*q(m,i-1) - &
      1422.295406951412387093604024820956d0*q(m,i+1)*q(m,i-2) + &
      38710.222877737804676462083869491277d0*q(m,i+2)**2 - &
      56543.44458133553474988660173845359d0*q(m,i+2)*q(m,i+3) + &
      25858.823344813194350231387268424305d0*q(m,i+2)*q(m,i+4) - &
      6776.7160356985677339513318349297185d0*q(m,i+2)*q(m,i+5) + &
      779.59627830144560881994744428606862d0*q(m,i+2)*q(m,i+6) - &
      11568.203205010737046120644004241888d0*q(m,i+2)*q(m,i-1) + &
      1567.369525655942963317301941640566d0*q(m,i+2)*q(m,i-2) + &
      20760.578813685344790668864742938817d0*q(m,i+3)**2 - &
      19076.80052896008740916148323555731d0*q(m,i+3)*q(m,i+4) + &
      5018.7234314907501498109963718429327d0*q(m,i+3)*q(m,i+5) - &
      579.19772397081273982729009184035639d0*q(m,i+3)*q(m,i+6) + &
      8281.8363209582142700528943915187301d0*q(m,i+3)*q(m,i-1) - &
      1114.2721370853473821397101820382244d0*q(m,i+3)*q(m,i-2) + &
      4400.3869833013833303185155037006889d0*q(m,i+4)**2 - &
      2323.5095791695964480356014747549139d0*q(m,i+4)*q(m,i+5) + &
      268.95481083902762556863085963615064d0*q(m,i+4)*q(m,i+6) - &
      3728.0916300001958897461542964188467d0*q(m,i+4)*q(m,i-1) + &
      498.94143491193902486891904881322871d0*q(m,i+4)*q(m,i-2) + &
      307.68806668354074521402563730606059d0*q(m,i+5)**2 - &
      71.429224081019075232038195001157964d0*q(m,i+5)*q(m,i+6) + &
      964.8459393137527644802777077909353d0*q(m,i+5)*q(m,i-1) - &
      128.60417364073698812455426212039969d0*q(m,i+5)*q(m,i-2) + &
      4.1559465755499154970054440953911853d0*q(m,i+6)**2 - &
      109.89763918621443836390926338016285d0*q(m,i+6)*q(m,i-1) + &
      14.602032869440628203855717083230311d0*q(m,i+6)*q(m,i-2) + &
      948.24087242806077544834158590772347d0*q(m,i-1)**2 - &
      267.51057813745646500276129905759535d0*q(m,i-1)*q(m,i-2) + &
      19.364791404222125121596021066920538d0*q(m,i-2)**2
sigma3 = 8314.4404754330299758540499281240022d0*q(m,i+0)**2 - &
      19354.080029830905120256972108823961d0*q(m,i+0)*q(m,i+1) + &
      14276.407921803365958458551051143644d0*q(m,i+0)*q(m,i+2) - &
      6538.5756178869784193858267932342006d0*q(m,i+0)*q(m,i+3) + &
      1704.3786518940608308994552380795767d0*q(m,i+0)*q(m,i+4) - &
      193.98928849903785833018637251441484d0*q(m,i+0)*q(m,i+5) - &
      8815.8124097471244461985202725943467d0*q(m,i+0)*q(m,i-1) + &
      2631.0799292586072926681392289857898d0*q(m,i+0)*q(m,i-2) - &
      338.29010785804818956273982729009184d0*q(m,i+0)*q(m,i-3) + &
      11427.885775596600972758380165787573d0*q(m,i+1)**2 - &
      17079.279952670411293096478281663467d0*q(m,i+1)*q(m,i+2) + &
      7909.6318941959103996141033178070215d0*q(m,i+1)*q(m,i+3) - &
      2081.0954549280650884486863322842159d0*q(m,i+1)*q(m,i+4) + &
      238.70714532360169347603210037072471d0*q(m,i+1)*q(m,i+5) + &
      10104.377650368749905786942823979861d0*q(m,i+1)*q(m,i-1) - &
      2970.4819959333560937396916232895069d0*q(m,i+1)*q(m,i-2) + &
      376.44919228127365114798977232839667d0*q(m,i+1)*q(m,i-3) + &
      6460.8996451861163956071363478770886d0*q(m,i+2)**2 - &
      6051.5210949323096313837054577795319d0*q(m,i+2)*q(m,i+3) + &
      1607.7984936325049998991797933596875d0*q(m,i+2)*q(m,i+4) - &
      185.95413012436212254333947455640577d0*q(m,i+2)*q(m,i+5) - &
      7358.3819820845092835833576574317315d0*q(m,i+2)*q(m,i-1) + &
      2136.8337127406216774603017989261375d0*q(m,i+2)*q(m,i-2) - &
      267.70225873713309642542446775251008d0*q(m,i+2)*q(m,i-3) + &
      1432.3290372172783920469105654290839d0*q(m,i+3)**2 - &
      768.64324445839715350297360879371461d0*q(m,i+3)*q(m,i+4) + &
      89.680315179305403346408637413928419d0*q(m,i+3)*q(m,i+5) + &
      3334.4814552928317395909988502581095d0*q(m,i+3)*q(m,i-1) - &
      958.71308254649218604245059271514298d0*q(m,i+3)*q(m,i-2) + &
      119.00130072157306366962451618536275d0*q(m,i+3)*q(m,i-3) + &
      104.12055500907929396686010442624199d0*q(m,i+4)**2 - &
      24.517595658006351624076491801359526d0*q(m,i+4)*q(m,i+5) - &
      861.61695291686255641282096308551335d0*q(m,i+4)*q(m,i-1) + &
      245.72833501717302147196327090506985d0*q(m,i+4)*q(m,i-2) - &
      30.273342600566290215761115232014703d0*q(m,i+4)*q(m,i-3) + &
      1.4567225739122233831228540223249218d0*q(m,i+5)**2 + &
      97.368500677481352911247091141271035d0*q(m,i+5)*q(m,i-1) - &
      27.586206325685967716390996814277238d0*q(m,i+5)*q(m,i-2) + &
      3.377814278879403714059798715883372d0*q(m,i+5)*q(m,i-3) + &
      2378.032623637031478466663651848837d0*q(m,i-1)**2 - &
      1445.8120231180091464482998874533266d0*q(m,i-1)*q(m,i-2) + &
      189.33051425337947742048271148800249d0*q(m,i-1)*q(m,i-3) + &
      224.57816819879962654433553904453375d0*q(m,i-2)**2 - &
      60.205005490457850742242276633811025d0*q(m,i-2)*q(m,i-3) + &
      4.1559465755499154970054440953911853d0*q(m,i-3)**2
sigma4 = 6998.7177079847182567089974497381905d0*q(m,i+0)**2 - &
      11088.184535039238453590305442157294d0*q(m,i+0)*q(m,i+1) + &
      5386.9907367885029922066959103996141d0*q(m,i+0)*q(m,i+2) - &
      1470.628709860825229542160759091976d0*q(m,i+0)*q(m,i+3) + &
      173.10480012684243421677284111146545d0*q(m,i+0)*q(m,i+4) - &
      11088.184535039238453590305442157294d0*q(m,i+0)*q(m,i-1) + &
      5386.9907367885029922066959103996141d0*q(m,i+0)*q(m,i-2) - &
      1470.628709860825229542160759091976d0*q(m,i+0)*q(m,i-3) + &
      173.10480012684243421677284111146545d0*q(m,i+0)*q(m,i-4) + &
      4477.7130482532460252367659775067182d0*q(m,i+1)**2 - &
      4433.5627943921861745935820009894084d0*q(m,i+1)*q(m,i+2) + &
      1231.8421404854591445199910808376417d0*q(m,i+1)*q(m,i+3) - &
      147.36089173977217545339238460931583d0*q(m,i+1)*q(m,i+4) + &
      8620.4498023975017609276868536127795d0*q(m,i+1)*q(m,i-1) - &
      4116.549957778953728027802101876176d0*q(m,i+1)*q(m,i-2) + &
      1106.327082862976174814799153423492d0*q(m,i+1)*q(m,i-3) - &
      128.38694330227859907092711325515558d0*q(m,i+1)*q(m,i-4) + &
      1119.3871962643462932814784666636518d0*q(m,i+2)**2 - &
      634.28406241474635985217995800006382d0*q(m,i+2)*q(m,i+3) + &
      77.297818995994115868454492793117132d0*q(m,i+2)*q(m,i+4) - &
      4116.549957778953728027802101876176d0*q(m,i+2)*q(m,i-1) + &
      1935.5018239270909988502581095173688d0*q(m,i+2)*q(m,i-2) - &
      512.94321994728583683610138636593663d0*q(m,i+2)*q(m,i-3) + &
      58.775262292891405821300001194181088d0*q(m,i+2)*q(m,i-4) + &
      91.750146552525376103418431460759503d0*q(m,i+3)**2 - &
      22.84319205154061718215157368596522d0*q(m,i+3)*q(m,i+4) + &
      1106.327082862976174814799153423492d0*q(m,i+3)*q(m,i-1) - &
      512.94321994728583683610138636593663d0*q(m,i+3)*q(m,i-2) + &
      134.23337796328665210940343215475491d0*q(m,i+3)*q(m,i-3) - &
      15.20371014237468023843685219346595d0*q(m,i+3)*q(m,i-4) + &
      1.4567225739122233831228540223249218d0*q(m,i+4)**2 - &
      128.38694330227859907092711325515558d0*q(m,i+4)*q(m,i-1) + &
      58.775262292891405821300001194181088d0*q(m,i+4)*q(m,i-2) - &
      15.20371014237468023843685219346595d0*q(m,i+4)*q(m,i-3) + &
      1.7034106724136692721348806004890661d0*q(m,i+4)*q(m,i-4) + &
      4477.7130482532460252367659775067182d0*q(m,i-1)**2 - &
      4433.5627943921861745935820009894084d0*q(m,i-1)*q(m,i-2) + &
      1231.8421404854591445199910808376417d0*q(m,i-1)*q(m,i-3) - &
      147.36089173977217545339238460931583d0*q(m,i-1)*q(m,i-4) + &
      1119.3871962643462932814784666636518d0*q(m,i-2)**2 - &
      634.28406241474635985217995800006382d0*q(m,i-2)*q(m,i-3) + &
      77.297818995994115868454492793117132d0*q(m,i-2)*q(m,i-4) + &
      91.750146552525376103418431460759503d0*q(m,i-3)**2 - &
      22.84319205154061718215157368596522d0*q(m,i-3)*q(m,i-4) + &
      1.4567225739122233831228540223249218d0*q(m,i-4)**2
sigma5 = 8314.4404754330299758540499281240022d0*q(m,i+0)**2 - &
      8815.8124097471244461985202725943467d0*q(m,i+0)*q(m,i+1) + &
      2631.0799292586072926681392289857898d0*q(m,i+0)*q(m,i+2) - &
      338.29010785804818956273982729009184d0*q(m,i+0)*q(m,i+3) - &
      19354.080029830905120256972108823961d0*q(m,i+0)*q(m,i-1) + &
      14276.407921803365958458551051143644d0*q(m,i+0)*q(m,i-2) - &
      6538.5756178869784193858267932342006d0*q(m,i+0)*q(m,i-3) + &
      1704.3786518940608308994552380795767d0*q(m,i+0)*q(m,i-4) - &
      193.98928849903785833018637251441484d0*q(m,i+0)*q(m,i-5) + &
      2378.032623637031478466663651848837d0*q(m,i+1)**2 - &
      1445.8120231180091464482998874533266d0*q(m,i+1)*q(m,i+2) + &
      189.33051425337947742048271148800249d0*q(m,i+1)*q(m,i+3) + &
      10104.377650368749905786942823979861d0*q(m,i+1)*q(m,i-1) - &
      7358.3819820845092835833576574317315d0*q(m,i+1)*q(m,i-2) + &
      3334.4814552928317395909988502581095d0*q(m,i+1)*q(m,i-3) - &
      861.61695291686255641282096308551335d0*q(m,i+1)*q(m,i-4) + &
      97.368500677481352911247091141271035d0*q(m,i+1)*q(m,i-5) + &
      224.57816819879962654433553904453375d0*q(m,i+2)**2 - &
      60.205005490457850742242276633811025d0*q(m,i+2)*q(m,i+3) - &
      2970.4819959333560937396916232895069d0*q(m,i+2)*q(m,i-1) + &
      2136.8337127406216774603017989261375d0*q(m,i+2)*q(m,i-2) - &
      958.71308254649218604245059271514298d0*q(m,i+2)*q(m,i-3) + &
      245.72833501717302147196327090506985d0*q(m,i+2)*q(m,i-4) - &
      27.586206325685967716390996814277238d0*q(m,i+2)*q(m,i-5) + &
      4.1559465755499154970054440953911853d0*q(m,i+3)**2 + &
      376.44919228127365114798977232839667d0*q(m,i+3)*q(m,i-1) - &
      267.70225873713309642542446775251008d0*q(m,i+3)*q(m,i-2) + &
      119.00130072157306366962451618536275d0*q(m,i+3)*q(m,i-3) - &
      30.273342600566290215761115232014703d0*q(m,i+3)*q(m,i-4) + &
      3.377814278879403714059798715883372d0*q(m,i+3)*q(m,i-5) + &
      11427.885775596600972758380165787573d0*q(m,i-1)**2 - &
      17079.279952670411293096478281663467d0*q(m,i-1)*q(m,i-2) + &
      7909.6318941959103996141033178070215d0*q(m,i-1)*q(m,i-3) - &
      2081.0954549280650884486863322842159d0*q(m,i-1)*q(m,i-4) + &
      238.70714532360169347603210037072471d0*q(m,i-1)*q(m,i-5) + &
      6460.8996451861163956071363478770886d0*q(m,i-2)**2 - &
      6051.5210949323096313837054577795319d0*q(m,i-2)*q(m,i-3) + &
      1607.7984936325049998991797933596875d0*q(m,i-2)*q(m,i-4) - &
      185.95413012436212254333947455640577d0*q(m,i-2)*q(m,i-5) + &
      1432.3290372172783920469105654290839d0*q(m,i-3)**2 - &
      768.64324445839715350297360879371461d0*q(m,i-3)*q(m,i-4) + &
      89.680315179305403346408637413928419d0*q(m,i-3)*q(m,i-5) + &
      104.12055500907929396686010442624199d0*q(m,i-4)**2 - &
      24.517595658006351624076491801359526d0*q(m,i-4)*q(m,i-5) + &
      1.4567225739122233831228540223249218d0*q(m,i-5)**2
sigma6 = 9222.4304524371857994543179728364914d0*q(m,i+0)**2 - &
      5868.7702184994024445082646140847199d0*q(m,i+0)*q(m,i+1) + &
      813.03971956918635572736101836630937d0*q(m,i+0)*q(m,i+2) - &
      33080.87139933045777953185360592768d0*q(m,i+0)*q(m,i-1) + &
      37137.941709010725214428918132621836d0*q(m,i+0)*q(m,i-2) - &
      26774.815371359200641608049015456423d0*q(m,i+0)*q(m,i-3) + &
      12118.138879482646554405813665072924d0*q(m,i+0)*q(m,i-4) - &
      3149.4331405822064717567363070008573d0*q(m,i+0)*q(m,i-5) + &
      359.9089168343376139341747807356273d0*q(m,i+0)*q(m,i-6) + &
      948.24087242806077544834158590772347d0*q(m,i+1)**2 - &
      267.51057813745646500276129905759535d0*q(m,i+1)*q(m,i+2) + &
      10399.3092657059176983118782060581d0*q(m,i+1)*q(m,i-1) - &
      11568.203205010737046120644004241888d0*q(m,i+1)*q(m,i-2) + &
      8281.8363209582142700528943915187301d0*q(m,i+1)*q(m,i-3) - &
      3728.0916300001958897461542964188467d0*q(m,i+1)*q(m,i-4) + &
      964.8459393137527644802777077909353d0*q(m,i+1)*q(m,i-5) - &
      109.89763918621443836390926338016285d0*q(m,i+1)*q(m,i-6) + &
      19.364791404222125121596021066920538d0*q(m,i+2)**2 - &
      1422.295406951412387093604024820956d0*q(m,i+2)*q(m,i-1) + &
      1567.369525655942963317301941640566d0*q(m,i+2)*q(m,i-2) - &
      1114.2721370853473821397101820382244d0*q(m,i+2)*q(m,i-3) + &
      498.94143491193902486891904881322871d0*q(m,i+2)*q(m,i-4) - &
      128.60417364073698812455426212039969d0*q(m,i+2)*q(m,i-5) + &
      14.602032869440628203855717083230311d0*q(m,i+2)*q(m,i-6) + &
      29975.095381586579358570099310840052d0*q(m,i-1)**2 - &
      67875.812791212077959763144948330134d0*q(m,i-1)*q(m,i-2) + &
      49266.812962891328921421514014106607d0*q(m,i-1)*q(m,i-3) - &
      22417.230698519694468768542842616917d0*q(m,i-1)*q(m,i-4) + &
      5850.7466490005423123809367195610582d0*q(m,i-1)*q(m,i-5) - &
      670.84934475730505409738213971018204d0*q(m,i-1)*q(m,i-6) + &
      38710.222877737804676462083869491277d0*q(m,i-2)**2 - &
      56543.44458133553474988660173845359d0*q(m,i-2)*q(m,i-3) + &
      25858.823344813194350231387268424305d0*q(m,i-2)*q(m,i-4) - &
      6776.7160356985677339513318349297185d0*q(m,i-2)*q(m,i-5) + &
      779.59627830144560881994744428606862d0*q(m,i-2)*q(m,i-6) + &
      20760.578813685344790668864742938817d0*q(m,i-3)**2 - &
      19076.80052896008740916148323555731d0*q(m,i-3)*q(m,i-4) + &
      5018.7234314907501498109963718429327d0*q(m,i-3)*q(m,i-5) - &
      579.19772397081273982729009184035639d0*q(m,i-3)*q(m,i-6) + &
      4400.3869833013833303185155037006889d0*q(m,i-4)**2 - &
      2323.5095791695964480356014747549139d0*q(m,i-4)*q(m,i-5) + &
      268.95481083902762556863085963615064d0*q(m,i-4)*q(m,i-6) + &
      307.68806668354074521402563730606059d0*q(m,i-5)**2 - &
      71.429224081019075232038195001157964d0*q(m,i-5)*q(m,i-6) + &
      4.1559465755499154970054440953911853d0*q(m,i-6)**2
sigma7 = 5049.770207818351150857764614378371d0*q(m,i+0)**2 - &
      1469.4167593642295816568303340790113d0*q(m,i+0)*q(m,i+1) - &
      30701.158718003370698476518582338688d0*q(m,i+0)*q(m,i-1) + &
      53947.021738782416816477663038509599d0*q(m,i+0)*q(m,i-2) - &
      59895.401389672333166050097267028484d0*q(m,i+0)*q(m,i-3) + &
      42979.169191576600513439137777762116d0*q(m,i+0)*q(m,i-4) - &
      19443.792304768714408264672814937365d0*q(m,i+0)*q(m,i-5) + &
      5065.2630873477348758433414518070603d0*q(m,i+0)*q(m,i-6) - &
      581.22526153480665302755249845196935d0*q(m,i+0)*q(m,i-7) + &
      109.19377293294472527276760080992885d0*q(m,i+1)**2 + &
      4407.3266427807163380906767150153394d0*q(m,i+1)*q(m,i-1) - &
      7674.8915335635155616967786279955592d0*q(m,i+1)*q(m,i-2) + &
      8466.401146646353016227354851693476d0*q(m,i+1)*q(m,i-3) - &
      6046.2947554302547895471175894456318d0*q(m,i+1)*q(m,i-4) + &
      2725.4123935346242100541042339984139d0*q(m,i+1)*q(m,i-5) - &
      707.980347608124869202911530953859d0*q(m,i+1)*q(m,i-6) + &
      81.055667138541787185967080146974327d0*q(m,i+1)*q(m,i-7) + &
      47140.249345859253700688885874071059d0*q(m,i-1)**2 - &
      166921.45580480885284126024866765608d0*q(m,i-1)*q(m,i-2) + &
      186372.63661641813262183632554002924d0*q(m,i-1)*q(m,i-3) - &
      134309.27227838080557987965395372803d0*q(m,i-1)*q(m,i-4) + &
      60963.61982566320210996136922062848d0*q(m,i-1)*q(m,i-5) - &
      15923.184524345433984984249534514085d0*q(m,i-1)*q(m,i-6) + &
      1830.9895489579046333345275144216943d0*q(m,i-1)*q(m,i-7) + &
      148657.09097851944972894046968121042d0*q(m,i-2)**2 - &
      333527.45174279386808321993507178692d0*q(m,i-2)*q(m,i-3) + &
      241247.06683538361287203879796472389d0*q(m,i-2)*q(m,i-4) - &
      109824.6748524548796539537280278021d0*q(m,i-2)*q(m,i-5) + &
      28752.761310624219561058185396809735d0*q(m,i-2)*q(m,i-6) - &
      3312.5579082080325673248953672234096d0*q(m,i-2)*q(m,i-7) + &
      187797.71787436203307152381226455301d0*q(m,i-3)**2 - &
      272525.22465946053474988660173845359d0*q(m,i-3)*q(m,i-4) + &
      124378.18823678850299220669591039961d0*q(m,i-3)*q(m,i-5) - &
      32630.239253428946922663853880785098d0*q(m,i-3)*q(m,i-6) + &
      3765.6552967786281485024871268257512d0*q(m,i-3)*q(m,i-7) + &
      99127.274598889820099310840051580792d0*q(m,i-4)**2 - &
      90677.125749253297285704693112100519d0*q(m,i-4)*q(m,i-5) + &
      23831.475738782416816477663038509599d0*q(m,i-4)*q(m,i-6) - &
      2754.3435209973779955592124904294216d0*q(m,i-4)*q(m,i-7) + &
      20774.707475488883330318515503700689d0*q(m,i-5)**2 - &
      10936.703307950460645566465672285778d0*q(m,i-5)*q(m,i-6) + &
      1265.660807463256020630359254697879d0*q(m,i-5)*q(m,i-7) + &
      1441.285754492576396511581696766882d0*q(m,i-6)**2 - &
      333.96421240655762398487266212133937d0*q(m,i-6)*q(m,i-7) + &
      19.364791404222125121596021066920538d0*q(m,i-7)**2
sigma8 = 669.71498110880766304046727327150608d0*q(m,i+0)**2 - &
      8893.7804564128406927679414451901224d0*q(m,i+0)*q(m,i-1) + &
      26542.97482472791651445751974852504d0*q(m,i+0)*q(m,i-2) - &
      46202.756401880865649880200144750409d0*q(m,i+0)*q(m,i-3) + &
      51067.48172473001703739137601571464d0*q(m,i+0)*q(m,i-4) - &
      36585.057650974236271028599070927113d0*q(m,i+0)*q(m,i-5) + &
      16552.001482310528090124650971211818d0*q(m,i+0)*q(m,i-6) - &
      4316.3646381469098276307271016265725d0*q(m,i+0)*q(m,i-7) + &
      496.07115342877547325298648049970801d0*q(m,i+0)*q(m,i-8) + &
      29991.619926849829482931334783186635d0*q(m,i-1)**2 - &
      180813.86130139181867025782369697714d0*q(m,i-1)*q(m,i-2) + &
      316864.9463944537131127739593348059d0*q(m,i-1)*q(m,i-3) - &
      351925.41214019592223130582918942707d0*q(m,i-1)*q(m,i-4) + &
      253037.27436328625659809522243384677d0*q(m,i-1)*q(m,i-5) - &
      114802.39231253987842942869397895853d0*q(m,i-1)*q(m,i-6) + &
      30004.610607492135228577027518826461d0*q(m,i-1)*q(m,i-7) - &
      3454.625008391303881548590543299538d0*q(m,i-1)*q(m,i-8) + &
      274437.46397404212407105925624444143d0*q(m,i-2)**2 - &
      966727.20764007119852027259434666842d0*q(m,i-2)*q(m,i-3) + &
      1077735.7595948131943502313872684243d0*q(m,i-2)*q(m,i-4) - &
      777141.66860592710187617595025002432d0*q(m,i-2)*q(m,i-5) + &
      353390.25560170486877662803588729515d0*q(m,i-2)*q(m,i-6) - &
      92530.842741111307000857265407529958d0*q(m,i-2)*q(m,i-7) + &
      10669.662319171198284128178308072488d0*q(m,i-2)*q(m,i-8) + &
      854591.51248035201145733553140960548d0*q(m,i-3)**2 - &
      1911046.2191646688680832199350717869d0*q(m,i-3)*q(m,i-4) + &
      1381212.3157777061437362363288289214d0*q(m,i-3)*q(m,i-5) - &
      629240.18222321105249345990086730827d0*q(m,i-3)*q(m,i-6) + &
      165006.50792942382273566135999998434d0*q(m,i-3)*q(m,i-7) - &
      19050.429632455717752510080552408595d0*q(m,i-3)*q(m,i-8) + &
      1070854.4744981081750468324542398616d0*q(m,i-4)**2 - &
      1550800.1901523231890708742560594412d0*q(m,i-4)*q(m,i-5) + &
      707565.24879234405854776225146595517d0*q(m,i-4)*q(m,i-6) - &
      185776.15367458745662284022072381861d0*q(m,i-4)*q(m,i-7) + &
      21470.536023671815979190317814656439d0*q(m,i-4)*q(m,i-8) + &
      562311.3282334384312104219511626919d0*q(m,i-5)**2 - &
      513755.44664007119852027259434666842d0*q(m,i-5)*q(m,i-6) + &
      135029.25790062655261894679884097874d0*q(m,i-5)*q(m,i-7) - &
      15619.141459200089635770852702069633d0*q(m,i-5)*q(m,i-8) + &
      117469.12296169644505871357723209575d0*q(m,i-6)**2 - &
      61801.701927494111439217259323079429d0*q(m,i-6)*q(m,i-7) + &
      7153.9713035638953504363557273610184d0*q(m,i-6)*q(m,i-8) + &
      8134.5593947258687875420679653483886d0*q(m,i-7)**2 - &
      1884.432245654463267723849734431745d0*q(m,i-7)*q(m,i-8) + &
      109.19377293294472527276760080992885d0*q(m,i-8)**2
omega0 = 0.000041135335252982311805841217605923488d0/(1.0e-36 + sigma0)**2
omega1 = 0.0029617441382147264500205676676264912d0/(1.0e-36 + sigma1)**2
omega2 = 0.041464417935006170300287947346770876d0/(1.0e-36 + sigma2)**2
omega3 = 0.19350061703002879473467708761826409d0/(1.0e-36 + sigma3)**2
omega4 = 0.36281365693130399012751953928424517d0/(1.0e-36 + sigma4)**2
omega5 = 0.29025092554504319210201563142739613d0/(1.0e-36 + sigma5)**2
omega6 = 0.096750308515014397367338543809132044d0/(1.0e-36 + sigma6)**2
omega7 = 0.011846976552858905800082270670505965d0/(1.0e-36 + sigma7)**2
omega8 = 0.00037021801727684080625257095845331139d0/(1.0e-36 + sigma8)**2
omega9 = 0.00037021801727684080625257095845331139d0/(1.0e-36 + sigma0)**2
omega10 = 0.011846976552858905800082270670505965d0/(1.0e-36 + sigma1)**2
omega11 = 0.096750308515014397367338543809132044d0/(1.0e-36 + sigma2)**2
omega12 = 0.29025092554504319210201563142739613d0/(1.0e-36 + sigma3)**2
omega13 = 0.36281365693130399012751953928424517d0/(1.0e-36 + sigma4)**2
omega14 = 0.19350061703002879473467708761826409d0/(1.0e-36 + sigma5)**2
omega15 = 0.041464417935006170300287947346770876d0/(1.0e-36 + sigma6)**2
omega16 = 0.0029617441382147264500205676676264912d0/(1.0e-36 + sigma7)**2
omega17 = 0.000041135335252982311805841217605923488d0/(1.0e-36 + sigma8)**2
fr0 = 2.828968253968253968253968253968254d0*q(m,i+0) - &
      6.171031746031746031746031746031746d0*q(m,i+1) + &
      11.828968253968253968253968253968254d0*q(m,i+2) - &
      16.171031746031746031746031746031746d0*q(m,i+3) + &
      15.328968253968253968253968253968254d0*q(m,i+4) - &
      9.871031746031746031746031746031746d0*q(m,i+5) + &
      4.128968253968253968253968253968254d0*q(m,i+6) - &
      1.0138888888888888888888888888888889d0*q(m,i+7) + &
      0.11111111111111111111111111111111111d0*q(m,i+8)
fr1 = 1.828968253968253968253968253968254d0*q(m,i+0) - &
      2.171031746031746031746031746031746d0*q(m,i+1) + &
      2.4956349206349206349206349206349206d0*q(m,i+2) - &
      2.171031746031746031746031746031746d0*q(m,i+3) + &
      1.328968253968253968253968253968254d0*q(m,i+4) - &
      0.5376984126984126984126984126984127d0*q(m,i+5) + &
      0.12896825396825396825396825396825397d0*q(m,i+6) - &
      0.013888888888888888888888888888888889d0*q(m,i+7) + &
      0.11111111111111111111111111111111111d0*q(m,i-1)
fr2 = 1.328968253968253968253968253968254d0*q(m,i+0) - &
      1.0043650793650793650793650793650794d0*q(m,i+1) + &
      0.74563492063492063492063492063492063d0*q(m,i+2) - &
      0.42103174603174603174603174603174603d0*q(m,i+3) + &
      0.1623015873015873015873015873015873d0*q(m,i+4) - &
      0.037698412698412698412698412698412698d0*q(m,i+5) + &
      0.0039682539682539682539682539682539683d0*q(m,i+6) + &
      0.23611111111111111111111111111111111d0*q(m,i-1) - &
      0.013888888888888888888888888888888889d0*q(m,i-2)
fr3 = 0.99563492063492063492063492063492063d0*q(m,i+0) - &
      0.50436507936507936507936507936507937d0*q(m,i+1) + &
      0.24563492063492063492063492063492063d0*q(m,i+2) - &
      0.087698412698412698412698412698412698d0*q(m,i+3) + &
      0.019444444444444444444444444444444444d0*q(m,i+4) - &
      0.0019841269841269841269841269841269841d0*q(m,i+5) + &
      0.37896825396825396825396825396825397d0*q(m,i-1) - &
      0.049603174603174603174603174603174603d0*q(m,i-2) + &
      0.0039682539682539682539682539682539683d0*q(m,i-3)
fr4 = 0.74563492063492063492063492063492063d0*q(m,i+0) - &
      0.25436507936507936507936507936507937d0*q(m,i+1) + &
      0.078968253968253968253968253968253968d0*q(m,i+2) - &
      0.01626984126984126984126984126984127d0*q(m,i+3) + &
      0.0015873015873015873015873015873015873d0*q(m,i+4) + &
      0.54563492063492063492063492063492063d0*q(m,i-1) - &
      0.12103174603174603174603174603174603d0*q(m,i-2) + &
      0.021825396825396825396825396825396825d0*q(m,i-3) - &
      0.0019841269841269841269841269841269841d0*q(m,i-4)
fr5 = 0.54563492063492063492063492063492063d0*q(m,i+0) - &
      0.12103174603174603174603174603174603d0*q(m,i+1) + &
      0.021825396825396825396825396825396825d0*q(m,i+2) - &
      0.0019841269841269841269841269841269841d0*q(m,i+3) + &
      0.74563492063492063492063492063492063d0*q(m,i-1) - &
      0.25436507936507936507936507936507937d0*q(m,i-2) + &
      0.078968253968253968253968253968253968d0*q(m,i-3) - &
      0.01626984126984126984126984126984127d0*q(m,i-4) + &
      0.0015873015873015873015873015873015873d0*q(m,i-5)
fr6 = 0.37896825396825396825396825396825397d0*q(m,i+0) - &
      0.049603174603174603174603174603174603d0*q(m,i+1) + &
      0.0039682539682539682539682539682539683d0*q(m,i+2) + &
      0.99563492063492063492063492063492063d0*q(m,i-1) - &
      0.50436507936507936507936507936507937d0*q(m,i-2) + &
      0.24563492063492063492063492063492063d0*q(m,i-3) - &
      0.087698412698412698412698412698412698d0*q(m,i-4) + &
      0.019444444444444444444444444444444444d0*q(m,i-5) - &
      0.0019841269841269841269841269841269841d0*q(m,i-6)
fr7 = 0.23611111111111111111111111111111111d0*q(m,i+0) - &
      0.013888888888888888888888888888888889d0*q(m,i+1) + &
      1.328968253968253968253968253968254d0*q(m,i-1) - &
      1.0043650793650793650793650793650794d0*q(m,i-2) + &
      0.74563492063492063492063492063492063d0*q(m,i-3) - &
      0.42103174603174603174603174603174603d0*q(m,i-4) + &
      0.1623015873015873015873015873015873d0*q(m,i-5) - &
      0.037698412698412698412698412698412698d0*q(m,i-6) + &
      0.0039682539682539682539682539682539683d0*q(m,i-7)
fr8 = 0.11111111111111111111111111111111111d0*q(m,i+0) + &
      1.828968253968253968253968253968254d0*q(m,i-1) - &
      2.171031746031746031746031746031746d0*q(m,i-2) + &
      2.4956349206349206349206349206349206d0*q(m,i-3) - &
      2.171031746031746031746031746031746d0*q(m,i-4) + &
      1.328968253968253968253968253968254d0*q(m,i-5) - &
      0.5376984126984126984126984126984127d0*q(m,i-6) + &
      0.12896825396825396825396825396825397d0*q(m,i-7) - &
      0.013888888888888888888888888888888889d0*q(m,i-8)
fr9 = 0.11111111111111111111111111111111111d0*q(m,i+0) + &
      1.828968253968253968253968253968254d0*q(m,i+1) - &
      2.171031746031746031746031746031746d0*q(m,i+2) + &
      2.4956349206349206349206349206349206d0*q(m,i+3) - &
      2.171031746031746031746031746031746d0*q(m,i+4) + &
      1.328968253968253968253968253968254d0*q(m,i+5) - &
      0.5376984126984126984126984126984127d0*q(m,i+6) + &
      0.12896825396825396825396825396825397d0*q(m,i+7) - &
      0.013888888888888888888888888888888889d0*q(m,i+8)
fr10 = 0.23611111111111111111111111111111111d0*q(m,i+0) + &
      1.328968253968253968253968253968254d0*q(m,i+1) - &
      1.0043650793650793650793650793650794d0*q(m,i+2) + &
      0.74563492063492063492063492063492063d0*q(m,i+3) - &
      0.42103174603174603174603174603174603d0*q(m,i+4) + &
      0.1623015873015873015873015873015873d0*q(m,i+5) - &
      0.037698412698412698412698412698412698d0*q(m,i+6) + &
      0.0039682539682539682539682539682539683d0*q(m,i+7) - &
      0.013888888888888888888888888888888889d0*q(m,i-1)
fr11 = 0.37896825396825396825396825396825397d0*q(m,i+0) + &
      0.99563492063492063492063492063492063d0*q(m,i+1) - &
      0.50436507936507936507936507936507937d0*q(m,i+2) + &
      0.24563492063492063492063492063492063d0*q(m,i+3) - &
      0.087698412698412698412698412698412698d0*q(m,i+4) + &
      0.019444444444444444444444444444444444d0*q(m,i+5) - &
      0.0019841269841269841269841269841269841d0*q(m,i+6) - &
      0.049603174603174603174603174603174603d0*q(m,i-1) + &
      0.0039682539682539682539682539682539683d0*q(m,i-2)
fr12 = 0.54563492063492063492063492063492063d0*q(m,i+0) + &
      0.74563492063492063492063492063492063d0*q(m,i+1) - &
      0.25436507936507936507936507936507937d0*q(m,i+2) + &
      0.078968253968253968253968253968253968d0*q(m,i+3) - &
      0.01626984126984126984126984126984127d0*q(m,i+4) + &
      0.0015873015873015873015873015873015873d0*q(m,i+5) - &
      0.12103174603174603174603174603174603d0*q(m,i-1) + &
      0.021825396825396825396825396825396825d0*q(m,i-2) - &
      0.0019841269841269841269841269841269841d0*q(m,i-3)
fr13 = 0.74563492063492063492063492063492063d0*q(m,i+0) + &
      0.54563492063492063492063492063492063d0*q(m,i+1) - &
      0.12103174603174603174603174603174603d0*q(m,i+2) + &
      0.021825396825396825396825396825396825d0*q(m,i+3) - &
      0.0019841269841269841269841269841269841d0*q(m,i+4) - &
      0.25436507936507936507936507936507937d0*q(m,i-1) + &
      0.078968253968253968253968253968253968d0*q(m,i-2) - &
      0.01626984126984126984126984126984127d0*q(m,i-3) + &
      0.0015873015873015873015873015873015873d0*q(m,i-4)
fr14 = 0.99563492063492063492063492063492063d0*q(m,i+0) + &
      0.37896825396825396825396825396825397d0*q(m,i+1) - &
      0.049603174603174603174603174603174603d0*q(m,i+2) + &
      0.0039682539682539682539682539682539683d0*q(m,i+3) - &
      0.50436507936507936507936507936507937d0*q(m,i-1) + &
      0.24563492063492063492063492063492063d0*q(m,i-2) - &
      0.087698412698412698412698412698412698d0*q(m,i-3) + &
      0.019444444444444444444444444444444444d0*q(m,i-4) - &
      0.0019841269841269841269841269841269841d0*q(m,i-5)
fr15 = 1.328968253968253968253968253968254d0*q(m,i+0) + &
      0.23611111111111111111111111111111111d0*q(m,i+1) - &
      0.013888888888888888888888888888888889d0*q(m,i+2) - &
      1.0043650793650793650793650793650794d0*q(m,i-1) + &
      0.74563492063492063492063492063492063d0*q(m,i-2) - &
      0.42103174603174603174603174603174603d0*q(m,i-3) + &
      0.1623015873015873015873015873015873d0*q(m,i-4) - &
      0.037698412698412698412698412698412698d0*q(m,i-5) + &
      0.0039682539682539682539682539682539683d0*q(m,i-6)
fr16 = 1.828968253968253968253968253968254d0*q(m,i+0) + &
      0.11111111111111111111111111111111111d0*q(m,i+1) - &
      2.171031746031746031746031746031746d0*q(m,i-1) + &
      2.4956349206349206349206349206349206d0*q(m,i-2) - &
      2.171031746031746031746031746031746d0*q(m,i-3) + &
      1.328968253968253968253968253968254d0*q(m,i-4) - &
      0.5376984126984126984126984126984127d0*q(m,i-5) + &
      0.12896825396825396825396825396825397d0*q(m,i-6) - &
      0.013888888888888888888888888888888889d0*q(m,i-7)
fr17 = 2.828968253968253968253968253968254d0*q(m,i+0) - &
      6.171031746031746031746031746031746d0*q(m,i-1) + &
      11.828968253968253968253968253968254d0*q(m,i-2) - &
      16.171031746031746031746031746031746d0*q(m,i-3) + &
      15.328968253968253968253968253968254d0*q(m,i-4) - &
      9.871031746031746031746031746031746d0*q(m,i-5) + &
      4.128968253968253968253968253968254d0*q(m,i-6) - &
      1.0138888888888888888888888888888889d0*q(m,i-7) + &
      0.11111111111111111111111111111111111d0*q(m,i-8)
fs0 = (fr0*omega0 + fr1*omega1 + fr2*omega2 + fr3*omega3 + fr4*omega4 + fr5* &
      omega5 + fr6*omega6 + fr7*omega7 + fr8*omega8)/(omega0 + omega1 + &
      omega2 + omega3 + omega4 + omega5 + omega6 + omega7 + omega8)
fs1 = (fr10*omega10 + fr11*omega11 + fr12*omega12 + fr13*omega13 + fr14* &
      omega14 + fr15*omega15 + fr16*omega16 + fr17*omega17 + fr9*omega9 &
      )/(omega10 + omega11 + omega12 + omega13 + omega14 + omega15 + &
      omega16 + omega17 + omega9)
ql(m,i) = fs0
qr(m,i) = fs1
    end do
  end do

end subroutine
end module weno
