c
c
c     ==================================================================
      subroutine flux3_dimSplit(ixyz,maxm,meqn,maux, mbc,mx,
     &                 q1d,dtdx1d,aux2,
     &                 faddm,faddp,cfl1d,
     &                 rpn3)
c     ==================================================================
c
c     # clawpack routine ...  modified for AMRCLAW
c
c     # Compute the modification to fluxes f, g and h that are generated by
c     # all interfaces along a 1D slice of the 3D grid.
c     #    ixyz = 1  if it is a slice in x
c     #           2  if it is a slice in y
c     #           3  if it is a slice in z
c     # This value is passed into the Riemann solvers. The flux modifications
c     # go into the arrays fadd, gadd and hadd.  The notation is written
c     # assuming we are solving along a 1D slice in the x-direction.
c
c     # fadd(i,.) modifies F to the left of cell i
c     # gadd(i,.,1,slice) modifies G below cell i (in the z-direction)
c     # gadd(i,.,2,slice) modifies G above cell i
c     #                   The G flux in the surrounding slices may
c     #                   also be updated.
c     #                   slice  =  -1     The slice below in y-direction
c     #                   slice  =   0     The slice used in the 2D method
c     #                   slice  =   1     The slice above in y-direction
c     # hadd(i,.,1,slice) modifies H below cell i (in the y-direction)
c     # hadd(i,.,2,slice) modifies H above cell i
c     #                   The H flux in the surrounding slices may
c     #                   also be updated.
c     #                   slice  =  -1     The slice below in z-direction
c     #                   slice  =   0     The slice used in the 2D method
c     #                   slice  =   1     The slice above in z-direction
c     #
c     # The method used is specified by method(2) and method(3):
c
c        method(2) = 1 No correction waves
c                  = 2 if second order correction terms are to be added, with
c                      a flux limiter as specified by mthlim.  No transverse
c                      propagation of these waves.
c
c         method(3) specify how the transverse wave propagation
c         of the increment wave and the correction wave are performed.
c         Note that method(3) is given by a two digit number, in
c         contrast to what is the case for claw2. It is convenient
c         to define the scheme using the pair (method(2),method(3)).
c
c         method(3) <  0 Gives dimensional splitting using Godunov
c                        splitting, i.e. formally first order
c                        accurate.
c                      0 Gives the Donor cell method. No transverse
c                        propagation of neither the increment wave
c                        nor the correction wave.
c                   = 10 Transverse propagation of the increment wave
c                        as in 2D. Note that method (2,10) is
c                        unconditionally unstable.
c                   = 11 Corner transport upwind of the increment
c                        wave. Note that method (2,11) also is
c                        unconditionally unstable.
c                   = 20 Both the increment wave and the correction
c                        wave propagate as in the 2D case. Only to
c                        be used with method(2) = 2.
c                   = 21 Corner transport upwind of the increment wave,
c                        and the correction wave propagates as in 2D.
c                        Only to be used with method(2) = 2.
c                   = 22 3D propagation of both the increment wave and
c                        the correction wave. Only to be used with
c                        method(2) = 2.
c
c         Recommended settings:   First order schemes:
c                                       (1,10) Stable for CFL < 1/2
c                                       (1,11) Stable for CFL < 1
c                                 Second order schemes:
c                                        (2,20) Stable for CFL < 1/2
c                                        (2,22) Stable for CFL < 1
c
c         WARNING! The schemes (2,10), (2,11) are unconditionally
c                  unstable.
c
c                       ----------------------------------
c
c     Note that if method(6)=1 then the capa array comes into the second
c     order correction terms, and is already included in dtdx1d:
c     If ixyz = 1 then
c        dtdx1d(i) = dt/dx                      if method(6) = 0
c                  = dt/(dx*capa(i,jcom,kcom))  if method(6) = 1
c     If ixyz = 2 then
c        dtdx1d(j) = dt/dy                      if method(6) = 0
c                  = dt/(dy*capa(icom,j,kcom))  if method(6) = 1
c     If ixyz = 3 then
c        dtdx1d(k) = dt/dz                      if method(6) = 0
c                  = dt/(dz*capa(icom,jcom,k))  if method(6) = 1
c
c     Notation:
c        The jump in q (q1d(i,:)-q1d(i-1,:))  is split by rpn3 into
c            amdq =  the left-going flux difference  A^- Delta q
c            apdq = the right-going flux difference  A^+ Delta q
c        Each of these is split by rpt3 into
c            bmasdq = the down-going transverse flux difference B^- A^* Delta q
c            bpasdq =   the up-going transverse flux difference B^+ A^* Delta q
c        where A^* represents either A^- or A^+.
c
c        Finally, each bsasdq is split by rptt3 into :
c            cmbsasdq = C^- B^* A^* Dq
c            cpbsasdq = C^+ B^* A^* Dq
c
c
      use amr_module
      implicit double precision(a-h,o-z)

      external rpn3

      dimension     q1d(meqn,1-mbc:maxm+mbc)
 
      dimension    cqxx(meqn,1-mbc:maxm+mbc)
      dimension   faddm(meqn,1-mbc:maxm+mbc)
      dimension   faddp(meqn,1-mbc:maxm+mbc)
 
c
      dimension dtdx1d(1-mbc:maxm+mbc)
      dimension aux2(maux,1-mbc:maxm+mbc)
c
      dimension    s(mwaves,1-mbc:maxm+mbc)
      dimension  wave(meqn,mwaves,1-mbc:maxm+mbc)
c
      logical limit

      limit = .false.
      do 5 mw=1,mwaves
         if (mthlim(mw) .gt. 0) limit = .true.
 5    continue
c     
c     # initialize flux increments:
c     -----------------------------
c     
      do 10 m=1,meqn
         do 10 i = 1-mbc, mx+mbc
            faddm(m,i) = 0.d0
            faddp(m,i) = 0.d0
 10      continue
c     
c     # local method parameters
         if (method(3) .lt. 0) then
            m3 = -1
            m4 = 0
         else
            m3 = method(3)/10
            m4 = method(3) - 10*m3
         endif
c     
c     -----------------------------------------------------------
c     # solve normal Riemann problem and compute Godunov updates
c     -----------------------------------------------------------
c     
c     # aux2(1-mbc,1,2) is the start of a 1d array now used by rpn3
c     
         if (maux > 0) then
            call rpn3(ixyz,maxm,meqn,mwaves,maux,mbc,mx,q1d,q1d,
     &           aux2(1,1-mbc),aux2(1,1-mbc),
     &           wave,s,faddm,faddp)
!     &           wave,s,amdq,apdq)
         else
            call rpn3(ixyz,maxm,meqn,mwaves,maux,mbc,mx,q1d,q1d,
     &           aux2,aux2,
     &           wave,s,faddm,faddp)
!     &           wave,s,amdq,apdq)
         endif
c     
c     # Set fadd for the donor-cell upwind method (Godunov)
         do 40 i=1,mx+1
         do 40 m=1,meqn
!--            faddp(m,i) = faddp(m,i) - apdq(m,i)
!--            faddm(m,i) = faddm(m,i) + amdq(m,i)
               faddp(m,i) = -faddp(m,i)   ! leave in old code to double check
 40      continue
c     
c     # compute maximum wave speed for checking Courant number:
         cfl1d = 0.d0
         do 50 mw=1,mwaves
         do 50 i=1,mx+1
          !  cfl1d = dmax1(cfl1d,dtdx1d(i)*dabs(s(mw,i))) OLD WAY
 !          # if s>0 use dtdx1d(i) to compute CFL,
 !          # if s<0 use dtdx1d(i-1) to compute CFL:
           cfl1d = dmax1(cfl1d,  dtdx1d(i)*s(mw,i),
     .                          -dtdx1d(i-1)*s(mw,i))

 50      continue
c     
         if (method(2).eq.1) go to 130
c    
c     # modify F fluxes for second order q_{xx} correction terms:
c     -----------------------------------------------------------
c     
c     # apply limiter to waves:
         if (limit) call limiter(maxm,meqn,mwaves,mbc,mx,wave,s,mthlim)
c     
         if (.not. use_fwaves) then

         do 120 i = 1, mx+1
c     
c     # For correction terms below, need average of dtdx in cell
c     # i-1 and i.  (overwriting dtdx1d(i-1) removed, and code below modified to agree 
c     # with classic flux3 by mjb, 12/16/2014.
            dtdxave = 0.5d0 * (dtdx1d(i-1) + dtdx1d(i))
c     
            do 120 m=1,meqn
               cqxx(m,i) = 0.d0
               do 119 mw=1,mwaves
                  cqxx(m,i) = cqxx(m,i) + 0.5d0 * dabs(s(mw,i)) *
     &                 (1.d0 - dabs(s(mw,i))*dtdxave) * wave(m,mw,i)
 119           continue
               faddm(m,i) = faddm(m,i) + cqxx(m,i)
               faddp(m,i) = faddp(m,i) + cqxx(m,i)
 120        continue

         else
            do 122 i = 1, mx+1

            dtdxave = 0.5d0 * (dtdx1d(i-1) + dtdx1d(i)) 
c
            do 122 m=1,meqn
               cqxx(m,i) = 0.d0
               do 121 mw=1,mwaves
                  cqxx(m,i) = cqxx(m,i) + 0.5d0 * dsign(1.d0, s(mw,i)) *
     &                 (1.d0 - dabs(s(mw,i))*dtdxave) * wave(m,mw,i)
 121           continue
               faddm(m,i) = faddm(m,i) + cqxx(m,i)
               faddp(m,i) = faddp(m,i) + cqxx(m,i)
 122        continue
         endif
c     
 130     continue
c     
       !  if( m3 .le. 0) return !left in to double check what this is, but no longer needed.
c     
c     
       return
       end
