import unittest

import numpy

from chainer import cuda
from chainer import gradient_check
from chainer.testing import attr
from chainer import utils

if cuda.available:
    cuda.init()


class TestWalkerAlias(unittest.TestCase):
    def setUp(self):
        self.ps = [5, 3, 4, 1, 2]
        self.sampler = utils.WalkerAlias(self.ps)

    def check_sample(self):
        counts = numpy.zeros(len(self.ps), numpy.float32)
        for _ in range(1000):
            vs = self.sampler.sample((4, 3))
            numpy.add.at(counts, cuda.to_cpu(vs), 1)
        counts /= (1000 * 12)
        counts *= sum(self.ps)
        gradient_check.assert_allclose(self.ps, counts, atol=0.1, rtol=0.1)

    def test_sample_cpu(self):
        self.check_sample()

    @attr.gpu
    def test_sample_gpu(self):
        self.sampler.to_gpu()
        self.check_sample()
