/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: German *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 17:53:12.481915
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 12,  8,  0, 17, 14,  7,  3, 22, 15,  9, 13,  2, 11, /* 4X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 12,  8,  0, 17, 14,  7,  3, 22, 15,  9, 13,  2, 11, /* 6X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 31, 40, 42, 23, 41, 46, 36, 35, 29, 50, 44, 54, 32, 52, 48, /* CX */
   51, 39, 53, 33, 47, 56, 26,SYM, 37, 60, 38, 61, 24, 45, 59, 27, /* DX */
   49, 31, 40, 42, 23, 41, 46, 36, 35, 29, 50, 44, 54, 32, 52, 48, /* EX */
   51, 39, 53, 33, 47, 56, 26,SYM, 37, 62, 38, 63, 24, 45, 59, 55, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 12,  8,  0, 17, 14,  7,  3, 22, 15,  9, 13,  2, 11, /* 4X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 12,  8,  0, 17, 14,  7,  3, 22, 15,  9, 13,  2, 11, /* 6X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 64,SYM,SYM,SYM,SYM,SYM,SYM, 34,SYM, 58,ILL, 43,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 34,SYM, 58,ILL, 43, 55, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 31, 40, 42, 23, 41, 46, 36, 35, 29, 50, 44, 54, 32, 52, 48, /* CX */
   51, 39, 53, 33, 47, 56, 26,SYM, 37, 65, 38, 66, 24, 45, 59, 27, /* DX */
   49, 31, 40, 42, 23, 41, 46, 36, 35, 29, 50, 44, 54, 32, 52, 48, /* EX */
   51, 39, 53, 33, 47, 56, 26,SYM, 37, 67, 38, 68, 24, 45, 59, 55, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1275
 * First 512 sequences: 0.9935270848404182
 * Next 512 sequences (512-1024): 0.006324420473375629
 * Rest: 0.00014849468620618637
 * Negative sequences: TODO
 */
static const PRUint8 GermanLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,2,3,3,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,0,2,2,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,0,0,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,0,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,2,
  3,3,3,3,3,3,3,2,3,3,3,3,2,3,2,3,3,3,2,3,2,2,2,3,3,3,3,0,0,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,2,2,2,3,2,3,2,0,0,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,2,
  3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,2,3,3,2,2,0,2,0,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,3,1,3,3,1,2,
  3,3,2,3,2,3,3,3,3,3,3,3,3,2,2,3,2,2,2,1,3,2,2,2,0,3,2,0,2,2,2,
  3,3,2,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,2,2,2,2,3,3,3,3,0,0,2,1,
  3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,3,3,2,2,3,3,2,2,2,3,3,2,0,1,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,2,3,2,3,2,3,3,3,2,2,2,3,3,3,3,0,2,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,2,3,2,2,2,2,2,2,3,3,3,3,0,0,2,1,
  3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,2,2,3,2,2,2,2,2,3,3,2,2,0,0,2,0,
  3,3,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,3,3,2,2,2,2,3,2,2,2,0,0,2,0,
  3,3,3,3,3,3,2,2,2,2,3,3,2,2,2,2,2,2,2,2,1,0,3,3,3,2,3,0,0,2,0,
  3,2,2,3,2,3,3,2,2,3,3,3,2,3,2,2,3,2,2,3,3,2,2,2,2,3,3,0,0,2,2,
  3,2,2,3,2,3,1,1,2,2,2,3,2,2,2,2,2,2,2,2,0,2,1,2,0,2,3,0,0,2,0,
  3,2,2,3,2,3,2,1,2,2,3,3,2,2,1,2,1,1,2,0,2,2,2,3,3,2,2,0,0,2,0,
  2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,2,2,3,2,0,2,2,0,2,0,0,0,2,0,0,2,
  2,3,3,0,3,1,3,3,3,3,0,0,3,2,3,2,3,2,2,1,1,1,0,0,1,1,0,2,0,0,0,
  3,3,3,3,3,3,3,2,2,3,2,3,3,3,2,3,2,2,3,2,2,2,2,0,2,2,2,1,1,2,1,
  2,3,3,2,3,1,3,3,3,3,0,1,2,3,3,2,2,3,2,2,2,2,0,0,0,0,1,3,0,0,0,
  3,2,2,3,2,2,3,2,2,2,2,2,0,2,2,2,3,2,2,2,2,1,0,0,0,0,0,0,0,0,0,
  3,1,2,3,2,3,3,2,1,2,2,2,2,1,0,2,2,2,3,2,0,2,0,0,0,1,1,0,2,0,1,
  2,3,2,1,2,2,2,2,2,2,1,2,2,2,2,2,2,1,2,0,2,2,2,0,0,0,0,0,0,0,0,
  2,0,0,2,0,2,0,0,0,0,3,1,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,2,
};


const SequenceModel Iso_8859_1GermanModel =
{
  Iso_8859_1_CharToOrderMap,
  GermanLangModel,
  31,
  (float)0.9935270848404182,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Windows_1252GermanModel =
{
  Windows_1252_CharToOrderMap,
  GermanLangModel,
  31,
  (float)0.9935270848404182,
  PR_TRUE,
  "WINDOWS-1252"
};