/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Arabic *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 17:30:56.453428
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_6_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 55, 61, 56, 67, 69, 73, 66, 71, 74, 82, 76, 70, 65, 72, 78, /* 4X */
   59, 92, 68, 53, 60, 75, 79, 77, 95, 86, 91,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 37, 58, 49, 46, 36, 57, 52, 48, 38, 94, 62, 45, 51, 40, 41, /* 6X */
   50, 89, 39, 43, 44, 47, 63, 64, 81, 54, 80,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,ILL,ILL,ILL,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,SYM,ILL,ILL, /* AX */
  ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,ILL,ILL,ILL,SYM, /* BX */
  ILL, 32, 34, 16, 35, 24, 31,  0,  8,  9,  7, 25, 19, 18, 26, 11, /* CX */
   29,  6, 27, 12, 20, 22, 28,SYM, 33, 10, 30,ILL,ILL,ILL,ILL,ILL, /* DX */
   42, 13, 15, 17,  1,  3,  5, 14,  4, 23,  2,SYM,SYM,SYM,SYM,SYM, /* EX */
  SYM,SYM,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1256_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 55, 61, 56, 67, 69, 73, 66, 71, 74, 82, 76, 70, 65, 72, 78, /* 4X */
   59, 92, 68, 53, 60, 75, 79, 77, 95, 86, 91,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 37, 58, 49, 46, 36, 57, 52, 48, 38, 94, 62, 45, 51, 40, 41, /* 6X */
   50, 89, 39, 43, 44, 47, 63, 64, 81, 54, 80,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM, 88,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 98,SYM,102, 90, 99,103, /* 8X */
   84,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 83,SYM,104,SYM,105,SYM,SYM,106, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,107,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  108, 32, 34, 16, 35, 24, 31,  0,  8,  9,  7, 25, 19, 18, 26, 11, /* CX */
   29,  6, 27, 12, 20, 22, 28,SYM, 21, 33, 10, 30, 42, 13, 15, 17, /* DX */
  109,  1,101,  3,  5, 14,  4, 96,110, 85, 87,111, 23,  2, 93,100, /* EX */
  SYM,SYM,SYM,SYM,112,SYM,SYM,SYM,SYM,113,SYM,114, 97,SYM,SYM,115, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1817
 * First 512 sequences: 0.9663689117819652
 * Next 512 sequences (512-1024): 0.03146204168568386
 * Rest: 0.0021690465323509836
 * Negative sequences: TODO
 */
static const PRUint8 ArabicLangModel[] =
{
  2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,1,1,3,3,3,3,2,3,3,
   3,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,
   0,2,3,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,0,3,3,3,3,2,2,3,
   2,2,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,1,3,3,3,2,2,3,2,
   0,2,1,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,
   2,2,2,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
  3,2,3,3,3,2,2,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,2,2,3,2,3,2,2,
   0,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,0,2,2,3,3,1,3,3,
   1,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,3,3,2,3,2,
   0,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,2,2,2,2,2,2,2,2,2,2,
   1,1,2,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,1,0,0,0,1,0,2,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,0,2,0,2,3,2,3,2,0,3,0,3,3,2,0,0,
   0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,2,2,0,0,3,1,3,3,2,0,0,1,2,
   2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,2,2,1,3,0,2,0,0,2,1,0,0,1,1,
   0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  3,3,3,2,3,3,3,3,2,3,3,2,3,2,3,3,2,3,2,2,2,2,3,2,3,1,2,2,3,2,2,2,
   1,3,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,1,3,2,1,2,1,0,2,0,3,2,2,0,2,0,0,0,2,2,3,0,0,
   0,1,0,2,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,0,2,1,2,3,3,2,0,0,0,2,2,2,0,0,
   0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,0,3,3,3,3,3,3,2,0,3,3,2,2,2,3,2,
   0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,2,2,2,2,2,2,1,1,1,1,3,1,3,1,3,2,1,
   0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,2,3,0,3,3,3,2,3,0,3,2,3,2,2,3,2,0,2,0,3,3,2,0,0,
   0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,1,2,1,1,1,0,2,1,2,0,3,0,2,2,2,
   0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,2,3,3,3,2,3,2,2,2,3,3,2,3,2,2,1,2,0,2,0,0,3,1,0,1,2,2,
   0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,2,3,3,3,2,2,2,2,3,2,0,2,1,1,2,1,2,0,0,1,1,0,0,2,2,
   1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,2,3,0,3,2,2,0,1,3,0,0,2,2,2,0,0,2,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,1,3,2,2,2,0,3,3,3,2,2,2,0,2,2,2,2,2,2,1,0,2,2,2,3,3,2,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,2,3,2,1,1,2,2,3,1,1,0,0,0,0,0,2,0,1,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,2,2,1,3,2,2,2,0,0,0,0,0,2,3,3,0,0,1,1,2,2,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,2,3,3,2,2,1,2,2,2,2,2,2,2,0,1,0,2,0,0,2,2,0,0,1,2,
   2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,2,3,2,2,3,3,2,0,2,2,0,1,0,2,1,0,2,0,2,0,0,2,0,0,0,2,1,
   0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,2,2,2,2,2,2,1,0,0,2,3,2,0,3,1,2,0,0,0,1,0,0,1,0,0,0,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,2,3,1,2,2,2,2,0,0,1,1,1,2,2,1,2,0,0,0,2,2,2,0,0,
   0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,3,2,2,2,3,2,2,3,2,3,2,2,2,2,0,2,2,2,2,1,2,1,0,0,1,2,2,2,0,0,
   0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,1,1,1,1,0,0,2,0,2,1,0,0,0,2,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,2,3,2,2,3,2,1,3,1,0,0,2,3,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,3,2,2,1,3,2,2,2,0,0,2,2,2,1,0,0,1,1,1,2,0,1,0,0,2,3,1,0,2,1,1,
   1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,2,2,2,1,2,2,0,1,0,2,2,0,2,2,0,2,0,0,2,1,0,1,0,2,2,0,0,1,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,2,2,1,0,2,2,2,2,1,1,2,2,2,2,0,1,0,0,1,2,0,0,0,2,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,2,2,2,0,0,2,2,2,1,2,1,1,2,2,2,0,2,0,0,0,1,0,0,0,1,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,1,2,2,2,0,2,2,2,2,1,0,2,1,2,2,0,1,0,0,2,2,0,0,0,1,2,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,2,2,0,2,2,2,2,2,0,1,1,1,2,0,2,0,0,0,1,0,0,0,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,2,2,0,2,2,1,2,1,0,2,0,1,2,0,1,0,0,1,1,0,0,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,1,2,2,2,0,2,2,2,2,2,1,2,2,2,2,0,1,0,0,2,1,0,0,0,1,1,
  1,1,1,1,1,1,1,0,1,0,1,0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,
   0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,0,1,2,0,2,2,1,1,1,2,1,1,1,1,0,1,0,0,1,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,2,0,2,0,2,2,1,0,2,2,1,1,1,1,0,2,0,0,1,1,0,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,0,2,0,1,1,2,2,1,1,1,1,1,1,0,2,0,0,1,1,0,0,0,1,1,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,1,2,0,1,1,1,1,1,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,2,2,0,0,2,2,2,1,0,0,1,0,2,1,0,1,0,0,0,1,0,1,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,1,1,0,1,1,1,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,0,2,0,1,2,1,0,2,2,1,0,1,0,0,1,0,0,1,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,1,1,1,2,0,1,0,1,0,1,2,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,0,0,2,0,1,0,0,0,1,0,0,2,1,0,0,1,0,0,0,2,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,1,2,1,1,0,1,1,1,0,2,2,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,2,1,0,0,2,0,0,2,1,0,1,0,1,1,0,0,1,1,2,1,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,0,1,0,1,0,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,2,2,0,0,2,1,2,1,1,0,1,1,1,0,1,0,1,1,1,1,0,1,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,0,1,0,2,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,2,2,0,1,0,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,2,0,1,0,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,1,2,0,2,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,1,1,0,1,0,1,0,0,0,1,2,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,1,1,2,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,1,1,1,1,0,1,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,2,2,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
};


const SequenceModel Iso_8859_6ArabicModel =
{
  Iso_8859_6_CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.9663689117819652,
  PR_FALSE,
  "ISO-8859-6"
};

const SequenceModel Windows_1256ArabicModel =
{
  Windows_1256_CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.9663689117819652,
  PR_FALSE,
  "WINDOWS-1256"
};