# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bpylist2']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'bpylist2',
    'version': '4.1.1',
    'description': 'Parse and generate NSKeyedArchiver archives',
    'long_description': 'bpylist2 |pypi version| |Build Status|\n======================================\n\nThis is a fork of Marketcircle/bpylist. This one is hopefully more responsive to PRs.\n\nImplementation of the `Apple\'s Binary\nPlist <https://developer.apple.com/legacy/library/documentation/Darwin/Reference/ManPages/man5/plist.5.html>`__\nand the NSKeyedArchiver format\n\nUsage\n-----\n\nBinary Plists\n~~~~~~~~~~~~~\n\nFor reading and writing plain PLists please use stdlib `plistlib` library.\n\nKeyedArchives\n~~~~~~~~~~~~~\n\n``NSKeyedArchiver`` is an Apple proprietary serialization format for\nCocoa objects. ``bpylist2`` supports reading and writing\n``NSKeyedArchiver`` compatible archives. The API is similar to the\nbinary plist API.\n\n**Unarchiving an object**\n\n.. code:: python\n\n    from bpylist2 import archiver\n\n    with open(\'my_archived_object\', \'rb\') as f:\n        archiver.unarchive(f.read())\n\n**Archiving an object**\n\n.. code:: python\n\n    from bpylist2 import archiver\n\n    my_object = { \'foo\':\'bar\', \'some_array\': [1,2,3,4] }\n    archiver.archive(my_object)\n\nCustom objects\n^^^^^^^^^^^^^^\n\nIf your archive includes classes that are not "standard" Cocoa classes\n(``NSString``, ``NSNumber``, ``NSDate``, ``NSNull``, ``NSDictionary`` or\n``NSArray``), you register a Python class that the Cocoa class maps to and\nregister it.\n\nThe simplest way to define a class is by providing a python dataclass, for\nexample you define a class with all the fields of the archived object:\n\n.. code:: python\n\n    @dataclasses.dataclass\n    class MyClass(DataclassArchiver):\n        int_field: int = 0\n        str_field: str = ""\n        float_field: float = -1.1\n        list_field: list = dataclasses.field(default_factory=list)\n\nAlternatively you can implement custom unarchiving code.  \n\nThe Python class needs to implement the ``encode_archive`` and\n``decode_archive`` methods.\n\n.. code:: python\n\n    ## Define a Python Class\n\n    from bpylist2 import archiver\n\n    class MyClass:\n        first_property = None\n        second_property = None\n\n        def __init__(self, first_property, second_property):\n            self.first_property = first_property\n            self.second_property = second_property\n\n        def encode_archive(self, archive):\n            archive.encode(\'first_property\', self.first_property)\n            archive.encode(\'second_property\', self.second_property)\n\n        def decode_archive(archive):\n            first = archive.decode(\'first_property\')\n            second = archive.decode(\'second_property\')\n            return MyClass(first, second)\n\nWhen the mapper class is defined, register it with unarchiver:\n\n.. code:: python\n\n    ## Register the class for the Cocoa class \'MyCocoaClass\'\n\n    archiver.update_class_map({ \'MyCocoaClass\': FooArchive })\n\nImplementation Note\n-------------------\n\nThis package requires the version of `plistlib` included in the Python 3.8 \nstandard library.  In order to support Python 3.6 and 3.7, a copy of the \nPython 3.8 `plistlib <https://github.com/python/cpython/blob/e51dd9dad6590bf3a940723fbbaaf4f64a3c9228/Lib/plistlib.py>`__ \nis bundled with `bpylist2` (Specifically, commit `9054967 <https://github.com/python/cpython/commit/90549676e063c2c818cfc14213d3adb7edcc2bd5>`__).  \nThis version will only be used if `bpylist2` detects it is running on Python < 3.8.\n\nHow to publish a new version to PyPI\n------------------------------------\n\n.. code-block:: bash\n\n    $ pip install twine wheel\n    $ python setup.py sdist bdist_wheel\n    $ twine upload dist/*\n\nLicense\n-------\n\nMIT License\n\nCopyright (c) 2017 Marketcircle Inc.\n\nPermission is hereby granted, free of charge, to any person obtaining a\ncopy of this software and associated documentation files (the\n"Software"), to deal in the Software without restriction, including\nwithout limitation the rights to use, copy, modify, merge, publish,\ndistribute, sublicense, and/or sell copies of the Software, and to\npermit persons to whom the Software is furnished to do so, subject to\nthe following conditions:\n\nThe above copyright notice and this permission notice shall be included\nin all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS\nOR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\nIN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\nCLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\nTORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\nSOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n.. |pypi version| image:: https://img.shields.io/pypi/v/bpylist2.svg\n   :target: https://pypi.org/project/bpylist2/\n.. |Build Status| image:: https://travis-ci.org/parabolala/bpylist2.svg?branch=master\n   :target: https://travis-ci.org/parabolala/bpylist2\n',
    'author': 'Jenia Varavva',
    'author_email': 'fuzzy.parabola@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
