/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
367: function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0}),e(1).__exportStar(e(368),_)},
368: function _(t,r,o){Object.defineProperty(o,"__esModule",{value:!0});const n=t(1),_=n.__importStar(t(369));o.LinAlg=_;const e=n.__importStar(t(371));o.Charts=e;const i=n.__importStar(t(374));o.Plotting=i;var a=t(5);o.Document=a.Document;var c=t(158);o.sprintf=c.sprintf,n.__exportStar(t(373),o)},
369: function _(t,_,r){Object.defineProperty(r,"__esModule",{value:!0});const e=t(1);e.__exportStar(t(23),r),e.__exportStar(t(9),r),e.__exportStar(t(25),r),e.__exportStar(t(370),r),e.__exportStar(t(8),r),e.__exportStar(t(16),r)},
370: function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});class n{constructor(e){this.seed=e%2147483647,this.seed<=0&&(this.seed+=2147483646)}integer(){return this.seed=48271*this.seed%2147483647,this.seed}float(){return(this.integer()-1)/2147483646}}s.Random=n,n.__name__="Random",s.random=new n(Date.now())},
371: function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0});const n=e(1).__importStar(e(372)),a=e(9),r=e(8),o=e(158),s=e(373);function i(e){return o.sprintf("#%06x",e)}function d(e="Spectral11"){return r.isArray(e)?e:n[e].map(i)}l.pie=function(e,t={}){const l=[],n=[];for(let t=0;t<Math.min(e.labels.length,e.values.length);t++)e.values[t]>0&&(l.push(e.labels[t]),n.push(e.values[t]));const i=null!=t.start_angle?t.start_angle:0,c=null!=t.end_angle?t.end_angle:i+2*Math.PI,u=Math.abs(c-i),_=a.sum(n),h=n.map(e=>e/_),p=a.cumsum(h).map(e=>i+u*e),g=[i].concat(p.slice(0,-1)),f=a.zip(g,p).map(([e,t])=>(e+t)/2);let m,w;null==t.center?(m=0,w=0):r.isArray(t.center)?(m=t.center[0],w=t.center[1]):(m=t.center.x,w=t.center.y);const b=null!=t.inner_radius?t.inner_radius:0,x=null!=t.outer_radius?t.outer_radius:1,y=d(t.palette),v=[];for(let e=0;e<h.length;e++)v.push(y[e%y.length]);const M=v.map(e=>{return function([e,t,l]){return 1-(.299*e+.587*t+.114*l)/255>=.6}((t=e,[parseInt(t.substr(1,2),16),parseInt(t.substr(3,2),16),parseInt(t.substr(5,2),16)]))?"white":"black";var t}),R=(b+x)/2;let[S,I]=a.unzip(f.map(e=>{return l=e,[(t=R)*Math.cos(l),t*Math.sin(l)];var t,l}));S=S.map(e=>e+m),I=I.map(e=>e+w);const P=f.map(e=>e>=Math.PI/2&&e<=3*Math.PI/2?e+Math.PI:e),z=new s.ColumnDataSource({data:{labels:l,values:n,percentages:h.map(e=>o.sprintf("%.2f%%",100*e)),start_angles:g,end_angles:p,text_angles:P,colors:v,text_colors:M,text_cx:S,text_cy:I}}),A=new s.AnnularWedge({x:m,y:w,inner_radius:b,outer_radius:x,start_angle:{field:"start_angles"},end_angle:{field:"end_angles"},line_color:null,line_width:1,fill_color:{field:"colors"}}),D=new s.AnnularWedge({x:m,y:w,inner_radius:b,outer_radius:x,start_angle:{field:"start_angles"},end_angle:{field:"end_angles"},line_color:null,line_width:1,fill_color:{field:"colors"},fill_alpha:.8}),k=new s.GlyphRenderer({data_source:z,glyph:A,hover_glyph:D}),C=new s.Text({x:{field:"text_cx"},y:{field:"text_cy"},text:{field:t.slice_labels||"labels"},angle:{field:"text_angles"},text_align:"center",text_baseline:"middle",text_color:{field:"text_colors"},text_font_size:"9pt"}),T=new s.GlyphRenderer({data_source:z,glyph:C}),G=new s.DataRange1d({renderers:[k],range_padding:.2}),F=new s.DataRange1d({renderers:[k],range_padding:.2}),H=new s.Plot({x_range:G,y_range:F});null!=t.width&&(H.plot_width=t.width),null!=t.height&&(H.plot_height=t.height),H.add_renderers(k,T);const L=new s.HoverTool({renderers:[k],tooltips:"<div>@labels</div><div><b>@values</b> (@percentages)</div>"});return H.add_tools(L),H},l.bar=function(e,t={}){const l=e[0],n=e.slice(1),r=a.transpose(n),o=r[0].map(e=>e.toString()),i=r.slice(1);let c,u=new s.CategoricalAxis,_=new s.FactorRange({factors:o}),h=new s.CategoricalScale;c=null!=t.axis_number_format?new s.NumeralTickFormatter({format:t.axis_number_format}):new s.BasicTickFormatter;let p=new s.LinearAxis({formatter:c}),g=new s.DataRange1d({start:0}),f=new s.LinearScale;const m=d(t.palette),w=null!=t.stacked&&t.stacked,b=null!=t.orientation?t.orientation:"horizontal",x=[];if(w){const e=[],t=[];for(let n=0;n<i.length;n++){const r=[],d=[];for(let l=0;l<o.length;l++){const a=o[l];0==n?(e.push(0),t.push(i[n][l])):(e[l]+=i[n-1][l],t[l]+=i[n][l]),r.push([a,-.5]),d.push([a,.5])}const c=new s.ColumnDataSource({data:{left:a.copy(e),right:a.copy(t),top:d,bottom:r,labels:o,values:i[n],columns:i[n].map(e=>l[n+1])}}),u=new s.Quad({left:{field:"left"},bottom:{field:"bottom"},right:{field:"right"},top:{field:"top"},line_color:null,fill_color:m[n%m.length]}),_=new s.GlyphRenderer({data_source:c,glyph:u});x.push(_)}}else{const e=1/i.length;for(let t=0;t<i.length;t++){const n=[],a=[],r=[],d=[];for(let l=0;l<o.length;l++){const s=o[l];n.push(0),a.push(i[t][l]),r.push([s,t*e-.5]),d.push([s,(t+1)*e-.5])}const c=new s.ColumnDataSource({data:{left:n,right:a,top:d,bottom:r,labels:o,values:i[t],columns:i[t].map(e=>l[t+1])}}),u=new s.Quad({left:{field:"left"},bottom:{field:"bottom"},right:{field:"right"},top:{field:"top"},line_color:null,fill_color:m[t%m.length]}),_=new s.GlyphRenderer({data_source:c,glyph:u});x.push(_)}}if("vertical"==b){[g,_]=[_,g],[p,u]=[u,p],[f,h]=[h,f];for(const e of x){const t=e.data_source.data;[t.left,t.bottom]=[t.bottom,t.left],[t.right,t.top]=[t.top,t.right]}}const y=new s.Plot({x_range:g,y_range:_,x_scale:f,y_scale:h});let v,M;null!=t.width&&(y.plot_width=t.width),null!=t.height&&(y.plot_height=t.height),y.add_renderers(...x),y.add_layout(u,"left"),y.add_layout(p,"below"),"horizontal"==b?(v="center_right",M="horizontal"):(v="top_center",M="vertical");const R=new s.HoverTool({renderers:x,tooltips:"<div>@labels</div><div>@columns:&nbsp<b>@values</b></div>",point_policy:"snap_to_data",anchor:v,attachment:M});return y.add_tools(R),y}},
372: function _(r,e,a){Object.defineProperty(a,"__esModule",{value:!0}),a.YlGn3=[3253076,11394446,16252089],a.YlGn4=[2327619,7915129,12773017,16777164],a.YlGn5=[26679,3253076,7915129,12773017,16777164],a.YlGn6=[26679,3253076,7915129,11394446,14282915,16777164],a.YlGn7=[23090,2327619,4303709,7915129,11394446,14282915,16777164],a.YlGn8=[23090,2327619,4303709,7915129,11394446,14282915,16252089,16777189],a.YlGn9=[17705,26679,2327619,4303709,7915129,11394446,14282915,16252089,16777189],a.YlGnBu3=[2916280,8375739,15595697],a.YlGnBu4=[2252456,4306628,10607284,16777164],a.YlGnBu5=[2438292,2916280,4306628,10607284,16777164],a.YlGnBu6=[2438292,2916280,4306628,8375739,13101492,16777164],a.YlGnBu7=[797828,2252456,1937856,4306628,8375739,13101492,16777164],a.YlGnBu8=[797828,2252456,1937856,4306628,8375739,13101492,15595697,16777177],a.YlGnBu9=[531800,2438292,2252456,1937856,4306628,8375739,13101492,15595697,16777177],a.GnBu3=[4432586,11066805,14742491],a.GnBu4=[2854078,8113348,12248252,15792616],a.GnBu5=[551084,4432586,8113348,12248252,15792616],a.GnBu6=[551084,4432586,8113348,11066805,13429701,15792616],a.GnBu7=[546974,2854078,5157843,8113348,11066805,13429701,15792616],a.GnBu8=[546974,2854078,5157843,8113348,11066805,13429701,14742491,16252144],a.GnBu9=[540801,551084,2854078,5157843,8113348,11066805,13429701,14742491,16252144],a.BuGn3=[2925151,10082505,15070713],a.BuGn4=[2329413,6734500,11723490,15595771],a.BuGn5=[27948,2925151,6734500,11723490,15595771],a.BuGn6=[27948,2925151,6734500,10082505,13429990,15595771],a.BuGn7=[22564,2329413,4304502,6734500,10082505,13429990,15595771],a.BuGn8=[22564,2329413,4304502,6734500,10082505,13429990,15070713,16252157],a.BuGn9=[17435,27948,2329413,4304502,6734500,10082505,13429990,15070713,16252157],a.PuBuGn3=[1872025,10927579,15524592],a.PuBuGn4=[164234,6793679,12437985,16183287],a.PuBuGn5=[93273,1872025,6793679,12437985,16183287],a.PuBuGn6=[93273,1872025,6793679,10927579,13685222,16183287],a.PuBuGn7=[91216,164234,3576e3,6793679,10927579,13685222,16183287],a.PuBuGn8=[91216,164234,3576e3,6793679,10927579,13685222,15524592,16775163],a.PuBuGn9=[83510,93273,164234,3576e3,6793679,10927579,13685222,15524592,16775163],a.PuBu3=[2854078,10927579,15525874],a.PuBu4=[356528,7645647,12437985,15855350],a.PuBu5=[285325,2854078,7645647,12437985,15855350],a.PuBu6=[285325,2854078,7645647,10927579,13685222,15855350],a.PuBu7=[216699,356528,3576e3,7645647,10927579,13685222,15855350],a.PuBu8=[216699,356528,3576e3,7645647,10927579,13685222,15525874,16775163],a.PuBu9=[145496,285325,356528,3576e3,7645647,10927579,13685222,15525874,16775163],a.BuPu3=[8935079,10403034,14740724],a.BuPu4=[8929693,9213638,11783651,15595771],a.BuPu5=[8458108,8935079,9213638,11783651,15595771],a.BuPu6=[8458108,8935079,9213638,10403034,12571622,15595771],a.BuPu7=[7209323,8929693,9202609,9213638,10403034,12571622,15595771],a.BuPu8=[7209323,8929693,9202609,9213638,10403034,12571622,14740724,16252157],a.BuPu9=[5046347,8458108,8929693,9202609,9213638,10403034,12571622,14740724,16252157],a.RdPu3=[12917642,16424885,16638173],a.RdPu4=[11403646,16214177,16495801,16706530],a.RdPu5=[7995767,12917642,16214177,16495801,16706530],a.RdPu6=[7995767,12917642,16214177,16424885,16565696,16706530],a.RdPu7=[7995767,11403646,14496919,16214177,16424885,16565696,16706530],a.RdPu8=[7995767,11403646,14496919,16214177,16424885,16565696,16638173,16775155],a.RdPu9=[4784234,7995767,11403646,14496919,16214177,16424885,16565696,16638173,16775155],a.PuRd3=[14490743,13210823,15196655],a.PuRd4=[13505110,14640560,14136792,15855350],a.PuRd5=[9961539,14490743,14640560,14136792,15855350],a.PuRd6=[9961539,14490743,14640560,13210823,13941210,15855350],a.PuRd7=[9502783,13505110,15149450,14640560,13210823,13941210,15855350],a.PuRd8=[9502783,13505110,15149450,14640560,13210823,13941210,15196655,16250105],a.PuRd9=[6750239,9961539,13505110,15149450,14640560,13210823,13941210,15196655,16250105],a.OrRd3=[14895667,16628612,16705736],a.OrRd4=[14102559,16551257,16632970,16707801],a.OrRd5=[11730944,14895667,16551257,16632970,16707801],a.OrRd6=[11730944,14895667,16551257,16628612,16635038,16707801],a.OrRd7=[10027008,14102559,15689032,16551257,16628612,16635038,16707801],a.OrRd8=[10027008,14102559,15689032,16551257,16628612,16635038,16705736,16775148],a.OrRd9=[8323072,11730944,14102559,15689032,16551257,16628612,16635038,16705736,16775148],a.YlOrRd3=[15743776,16691788,16772512],a.YlOrRd4=[14883356,16616764,16698460,16777138],a.YlOrRd5=[12386342,15743776,16616764,16698460,16777138],a.YlOrRd6=[12386342,15743776,16616764,16691788,16701814,16777138],a.YlOrRd7=[11599910,14883356,16535082,16616764,16691788,16701814,16777138],a.YlOrRd8=[11599910,14883356,16535082,16616764,16691788,16701814,16772512,16777164],a.YlOrRd9=[8388646,12386342,14883356,16535082,16616764,16691788,16701814,16772512,16777164],a.YlOrBr3=[14245646,16696399,16775100],a.YlOrBr4=[13388802,16685353,16701838,16777172],a.YlOrBr5=[10040324,14245646,16685353,16701838,16777172],a.YlOrBr6=[10040324,14245646,16685353,16696399,16704401,16777172],a.YlOrBr7=[9186564,13388802,15495188,16685353,16696399,16704401,16777172],a.YlOrBr8=[9186564,13388802,15495188,16685353,16696399,16704401,16775100,16777189],a.YlOrBr9=[6694150,10040324,13388802,15495188,16685353,16696399,16704401,16775100,16777189],a.Purples3=[7695281,12369372,15724021],a.Purples4=[6967715,10394312,13355490,15921399],a.Purples5=[5515151,7695281,10394312,13355490,15921399],a.Purples6=[5515151,7695281,10394312,12369372,14342891,15921399],a.Purples7=[4854918,6967715,8420794,10394312,12369372,14342891,15921399],a.Purples8=[4854918,6967715,8420794,10394312,12369372,14342891,15724021,16579581],a.Purples9=[4128893,5515151,6967715,8420794,10394312,12369372,14342891,15724021,16579581],a.Blues3=[3244733,10406625,14609399],a.Blues4=[2191797,7057110,12441575,15725567],a.Blues5=[545180,3244733,7057110,12441575,15725567],a.Blues6=[545180,3244733,7057110,10406625,13032431,15725567],a.Blues7=[542100,2191797,4362950,7057110,10406625,13032431,15725567],a.Blues8=[542100,2191797,4362950,7057110,10406625,13032431,14609399,16251903],a.Blues9=[536683,545180,2191797,4362950,7057110,10406625,13032431,14609399,16251903],a.Greens3=[3253076,10607003,15070688],a.Greens4=[2329413,7652470,12248243,15595753],a.Greens5=[27948,3253076,7652470,12248243,15595753],a.Greens6=[27948,3253076,7652470,10607003,13101504,15595753],a.Greens7=[23090,2329413,4303709,7652470,10607003,13101504,15595753],a.Greens8=[23090,2329413,4303709,7652470,10607003,13101504,15070688,16252149],a.Greens9=[17435,27948,2329413,4303709,7652470,10607003,13101504,15070688,16252149],a.Oranges3=[15095053,16625259,16705230],a.Oranges4=[14239489,16616764,16629381,16707038],a.Oranges5=[10892803,15095053,16616764,16629381,16707038],a.Oranges6=[10892803,15095053,16616764,16625259,16634018,16707038],a.Oranges7=[9186564,14239745,15821075,16616764,16625259,16634018,16707038],a.Oranges8=[9186564,14239745,15821075,16616764,16625259,16634018,16705230,16774635],a.Oranges9=[8333060,10892803,14239745,15821075,16616764,16625259,16634018,16705230,16774635],a.Reds3=[14560550,16552562,16703698],a.Reds4=[13309981,16476746,16559761,16704985],a.Reds5=[10817301,14560550,16476746,16559761,16704985],a.Reds6=[10817301,14560550,16476746,16552562,16563105,16704985],a.Reds7=[10027021,13309981,15678252,16476746,16552562,16563105,16704985],a.Reds8=[10027021,13309981,15678252,16476746,16552562,16563105,16703698,16774640],a.Reds9=[6750221,10817301,13309981,15678252,16476746,16552562,16563105,16703698,16774640],a.Greys3=[6513507,12434877,15790320],a.Greys4=[5395026,9868950,13421772,16250871],a.Greys5=[2434341,6513507,9868950,13421772,16250871],a.Greys6=[2434341,6513507,9868950,12434877,14277081,16250871],a.Greys7=[2434341,5395026,7566195,9868950,12434877,14277081,16250871],a.Greys8=[2434341,5395026,7566195,9868950,12434877,14277081,15790320,16777215],a.Greys9=[0,2434341,5395026,7566195,9868950,12434877,14277081,15790320,16777215],a.Greys10=[0,1842204,3684408,5592405,7434609,9276813,11184810,13027014,14869218,16777215],a.Greys11=[0,1644825,3355443,5000268,6710886,8355711,10066329,11711154,13421772,15066597,16777215],a.Greys256=[0,65793,131586,197379,263172,328965,394758,460551,526344,592137,657930,723723,789516,855309,921102,986895,1052688,1118481,1184274,1250067,1315860,1381653,1447446,1513239,1579032,1644825,1710618,1776411,1842204,1907997,1973790,2039583,2105376,2171169,2236962,2302755,2368548,2434341,2500134,2565927,2631720,2697513,2763306,2829099,2894892,2960685,3026478,3092271,3158064,3223857,3289650,3355443,3421236,3487029,3552822,3618615,3684408,3750201,3815994,3881787,3947580,4013373,4079166,4144959,4210752,4276545,4342338,4408131,4473924,4539717,4605510,4671303,4737096,4802889,4868682,4934475,5000268,5066061,5131854,5197647,5263440,5329233,5395026,5460819,5526612,5592405,5658198,5723991,5789784,5855577,5921370,5987163,6052956,6118749,6184542,6250335,6316128,6381921,6447714,6513507,6579300,6645093,6710886,6776679,6842472,6908265,6974058,7039851,7105644,7171437,7237230,7303023,7368816,7434609,7500402,7566195,7631988,7697781,7763574,7829367,7895160,7960953,8026746,8092539,8158332,8224125,8289918,8355711,8421504,8487297,8553090,8618883,8684676,8750469,8816262,8882055,8947848,9013641,9079434,9145227,9211020,9276813,9342606,9408399,9474192,9539985,9605778,9671571,9737364,9803157,9868950,9934743,10000536,10066329,10132122,10197915,10263708,10329501,10395294,10461087,10526880,10592673,10658466,10724259,10790052,10855845,10921638,10987431,11053224,11119017,11184810,11250603,11316396,11382189,11447982,11513775,11579568,11645361,11711154,11776947,11842740,11908533,11974326,12040119,12105912,12171705,12237498,12303291,12369084,12434877,12500670,12566463,12632256,12698049,12763842,12829635,12895428,12961221,13027014,13092807,13158600,13224393,13290186,13355979,13421772,13487565,13553358,13619151,13684944,13750737,13816530,13882323,13948116,14013909,14079702,14145495,14211288,14277081,14342874,14408667,14474460,14540253,14606046,14671839,14737632,14803425,14869218,14935011,15000804,15066597,15132390,15198183,15263976,15329769,15395562,15461355,15527148,15592941,15658734,15724527,15790320,15856113,15921906,15987699,16053492,16119285,16185078,16250871,16316664,16382457,16448250,16514043,16579836,16645629,16711422,16777215],a.PuOr3=[10063555,16250871,15835968],a.PuOr4=[6175897,11709394,16627811,15098113],a.PuOr5=[6175897,11709394,16250871,16627811,15098113],a.PuOr6=[5515144,10063555,14211819,16703670,15835968,11753478],a.PuOr7=[5515144,10063555,14211819,16250871,16703670,15835968,11753478],a.PuOr8=[5515144,8418220,11709394,14211819,16703670,16627811,14713364,11753478],a.PuOr9=[5515144,8418220,11709394,14211819,16250871,16703670,16627811,14713364,11753478],a.PuOr10=[2949195,5515144,8418220,11709394,14211819,16703670,16627811,14713364,11753478,8338184],a.PuOr11=[2949195,5515144,8418220,11709394,14211819,16250871,16703670,16627811,14713364,11753478,8338184],a.BrBG3=[5944492,16119285,14201701],a.BrBG4=[99697,8441281,14664317,10903834],a.BrBG5=[99697,8441281,16119285,14664317,10903834],a.BrBG6=[91742,5944492,13101797,16181443,14201701,9195786],a.BrBG7=[91742,5944492,13101797,16119285,16181443,14201701,9195786],a.BrBG8=[91742,3512207,8441281,13101797,16181443,14664317,12550445,9195786],a.BrBG9=[91742,3512207,8441281,13101797,16119285,16181443,14664317,12550445,9195786],a.BrBG10=[15408,91742,3512207,8441281,13101797,16181443,14664317,12550445,9195786,5517317],a.BrBG11=[15408,91742,3512207,8441281,13101797,16119285,16181443,14664317,12550445,9195786,5517317],a.PRGn3=[8372091,16250871,11505091],a.PRGn4=[34871,10935200,12756431,8073876],a.PRGn5=[34871,10935200,16250871,12756431,8073876],a.PRGn6=[1800247,8372091,14282963,15193320,11505091,7744131],a.PRGn7=[1800247,8372091,14282963,16250871,15193320,11505091,7744131],a.PRGn8=[1800247,5942881,10935200,14282963,15193320,12756431,10055851,7744131],a.PRGn9=[1800247,5942881,10935200,14282963,16250871,15193320,12756431,10055851,7744131],a.PRGn10=[17435,1800247,5942881,10935200,14282963,15193320,12756431,10055851,7744131,4194379],a.PRGn11=[17435,1800247,5942881,10935200,14282963,16250871,15193320,12756431,10055851,7744131,4194379],a.PiYG3=[10606442,16250871,15311817],a.PiYG4=[5090342,12116358,15840986,13638795],a.PiYG5=[5090342,12116358,16250871,15840986,13638795],a.PiYG6=[5083681,10606442,15136208,16638191,15311817,12917629],a.PiYG7=[5083681,10606442,15136208,16250871,16638191,15311817,12917629],a.PiYG8=[5083681,8371265,12116358,15136208,16638191,15840986,14579630,12917629],a.PiYG9=[5083681,8371265,12116358,15136208,16250871,16638191,15840986,14579630,12917629],a.PiYG10=[2581529,5083681,8371265,12116358,15136208,16638191,15840986,14579630,12917629,9306450],a.PiYG11=[2581529,5083681,8371265,12116358,15136208,16250871,16638191,15840986,14579630,12917629,9306450],a.RdBu3=[6793679,16250871,15698530],a.RdBu4=[356784,9618910,16033154,13238304],a.RdBu5=[356784,9618910,16250871,16033154,13238304],a.RdBu6=[2188972,6793679,13755888,16636871,15698530,11671595],a.RdBu7=[2188972,6793679,13755888,16250871,16636871,15698530,11671595],a.RdBu8=[2188972,4428739,9618910,13755888,16636871,16033154,14049357,11671595],a.RdBu9=[2188972,4428739,9618910,13755888,16250871,16636871,16033154,14049357,11671595],a.RdBu10=[340065,2188972,4428739,9618910,13755888,16636871,16033154,14049357,11671595,6750239],a.RdBu11=[340065,2188972,4428739,9618910,13755888,16250871,16636871,16033154,14049357,11671595,6750239],a.RdGy3=[10066329,16777215,15698530],a.RdGy4=[4210752,12237498,16033154,13238304],a.RdGy5=[4210752,12237498,16777215,16033154,13238304],a.RdGy6=[5066061,10066329,14737632,16636871,15698530,11671595],a.RdGy7=[5066061,10066329,14737632,16777215,16636871,15698530,11671595],a.RdGy8=[5066061,8882055,12237498,14737632,16636871,16033154,14049357,11671595],a.RdGy9=[5066061,8882055,12237498,14737632,16777215,16636871,16033154,14049357,11671595],a.RdGy10=[1710618,5066061,8882055,12237498,14737632,16636871,16033154,14049357,11671595,6750239],a.RdGy11=[1710618,5066061,8882055,12237498,14737632,16777215,16636871,16033154,14049357,11671595,6750239],a.RdYlBu3=[9551835,16777151,16551257],a.RdYlBu4=[2915254,11262441,16625249,14096668],a.RdYlBu5=[2915254,11262441,16777151,16625249,14096668],a.RdYlBu6=[4552116,9551835,14742520,16703632,16551257,14102567],a.RdYlBu7=[4552116,9551835,14742520,16777151,16703632,16551257,14102567],a.RdYlBu8=[4552116,7646673,11262441,14742520,16703632,16625249,16018755,14102567],a.RdYlBu9=[4552116,7646673,11262441,14742520,16777151,16703632,16625249,16018755,14102567],a.RdYlBu10=[3225237,4552116,7646673,11262441,14742520,16703632,16625249,16018755,14102567,10813478],a.RdYlBu11=[3225237,4552116,7646673,11262441,14742520,16777151,16703632,16625249,16018755,14102567,10813478],a.Spectral3=[10081684,16777151,16551257],a.Spectral4=[2851770,11263396,16625249,14096668],a.Spectral5=[2851770,11263396,16777151,16625249,14096668],a.Spectral6=[3311805,10081684,15136152,16703627,16551257,13975119],a.Spectral7=[3311805,10081684,15136152,16777151,16703627,16551257,13975119],a.Spectral8=[3311805,6734501,11263396,15136152,16703627,16625249,16018755,13975119],a.Spectral9=[3311805,6734501,11263396,15136152,16777151,16703627,16625249,16018755,13975119],a.Spectral10=[6180770,3311805,6734501,11263396,15136152,16703627,16625249,16018755,13975119,10355010],a.Spectral11=[6180770,3311805,6734501,11263396,15136152,16777151,16703627,16625249,16018755,13975119,10355010],a.RdYlGn3=[9555808,16777151,16551257],a.RdYlGn4=[1742401,10934634,16625249,14096668],a.RdYlGn5=[1742401,10934634,16777151,16625249,14096668],a.RdYlGn6=[1742928,9555808,14282635,16703627,16551257,14102567],a.RdYlGn7=[1742928,9555808,14282635,16777151,16703627,16551257,14102567],a.RdYlGn8=[1742928,6733155,10934634,14282635,16703627,16625249,16018755,14102567],a.RdYlGn9=[1742928,6733155,10934634,14282635,16777151,16703627,16625249,16018755,14102567],a.RdYlGn10=[26679,1742928,6733155,10934634,14282635,16703627,16625249,16018755,14102567,10813478],a.RdYlGn11=[26679,1742928,6733155,10934634,14282635,16777151,16703627,16625249,16018755,14102567,10813478],a.Inferno3=[3,12203605,16580260],a.Inferno4=[3,7871597,15558693,16580260],a.Inferno5=[3,5574509,12203605,16354313,16580260],a.Inferno6=[3,4262247,9643367,14438457,16491530,16580260],a.Inferno7=[3,3279197,7871597,12203605,15558693,16495384,16580260],a.Inferno8=[3,2558802,6493294,10365283,13780802,16088085,16432933,16580260],a.Inferno9=[3,2034759,5574509,8921450,12203605,14899250,16354313,16304433,16580260],a.Inferno10=[3,1706816,4852586,7871597,10759264,13451847,15558693,16488710,16240442,16580260],a.Inferno11=[3,1444665,4262247,6952814,9643367,12203605,14438457,15889690,16491530,16176450,16580260],a.Inferno256=[3,4,6,65543,65801,65803,131342,131600,197138,262932,262934,328728,394267,460061,525855,591393,657187,722726,854056,919594,985389,1050927,1182258,1247796,1313590,1444665,1510203,1641278,1706816,1838147,1903685,2034759,2100298,2231116,2362190,2493264,2558802,2689876,2820694,2951768,3017306,3148380,3279197,3410271,3475808,3606881,3737954,3869028,3934565,4065638,4196710,4262247,4393576,4524649,4590185,4721514,4852586,4918379,5049451,5180780,5246316,5377644,5443181,5574509,5705581,5771373,5902701,5968238,6099566,6230638,6296430,6427758,6493294,6624622,6690158,6821486,6952814,7018350,7149678,7215214,7346542,7477613,7543405,7674733,7740269,7871597,8002669,8068460,8199532,8265324,8396651,8462187,8593515,8724586,8790378,8921450,8987241,9118313,9249641,9315432,9446504,9512295,9643367,9774694,9840230,9971557,10037348,10168420,10234211,10365283,10496610,10562401,10693473,10759264,10890335,10956127,11087454,11218525,11284316,11415643,11481435,11612506,11678297,11809624,11875159,12006486,12072278,12203605,12269396,12400467,12466258,12532049,12663376,12729167,12860494,12926285,13057612,13123147,13188938,13320265,13386056,13451847,13583430,13649220,13715011,13780802,13912129,13977920,14043711,14109502,14241085,14306875,14372666,14438457,14504504,14570295,14636086,14702132,14833459,14899250,14965297,15031088,15096878,15097389,15163180,15229227,15295018,15361064,15426855,15492902,15558693,15559203,15625250,15691041,15757087,15757342,15823389,15889436,15889690,15955737,15956248,16022038,16088085,16088596,16154642,16154897,16220944,16221454,16287501,16287756,16288267,16354313,16354824,16355336,16421127,16421638,16422150,16422662,16488710,16489222,16489734,16489991,16490503,16491016,16491530,16492043,16492557,16493070,16493584,16494098,16494612,16494870,16495384,16495898,16496412,16496926,16431905,16432419,16432933,16433448,16368426,16368940,16369455,16304433,16304948,16305463,16240442,16240956,16175935,16176450,16111429,16111944,16046923,16047183,15982162,15982678,15983193,15918173,15918688,15853668,15853928,15854444,15854960,15855220,15855737,15856253,15922049,15922309,15988361,16054157,16119953,16186005,16251801,16383133,16448928,16580260],a.Magma3=[3,11875961,16514239],a.Magma4=[3,7413633,15753309,16514239],a.Magma5=[3,5181819,11875961,16483936,16514239],a.Magma6=[3,3870575,9185664,14502248,16621420,16514239],a.Magma7=[3,2822494,7413633,11875961,15753309,16690806,16514239],a.Magma8=[3,2232656,6100862,9907327,13714030,16282972,16693631,16514239],a.Magma9=[3,1773636,5181819,8463745,11875961,15028323,16483936,16695942,16514239],a.Magma10=[3,1511228,4394869,7413633,10366590,13319793,15753309,16552806,16697227,16514239],a.Magma11=[3,1314101,3870575,6494591,9185664,11875961,14502248,16150107,16621420,16633232,16514239],a.Magma256=[3,4,6,65543,65801,65803,131597,131599,197393,262931,263189,328727,394521,460059,525853,591647,657186,722980,788774,854568,920106,985900,1051695,1117233,1183027,1314101,1379896,1445434,1511228,1576767,1708097,1773636,1839174,1970249,2036043,2101581,2232656,2298194,2429269,2494807,2625881,2756956,2822494,2953312,3084386,3149925,3280999,3412072,3477354,3608428,3739502,3870575,3936113,4067186,4198259,4329332,4394869,4525942,4657015,4722808,4853881,4919417,5050746,5181819,5247611,5378684,5444476,5575549,5706877,5772670,5903742,5969534,6100862,6166399,6297727,6363263,6494591,6625920,6691456,6822784,6888576,7019648,7085440,7216769,7282305,7413633,7544705,7610497,7741825,7807361,7938689,8004225,8135553,8266881,8332417,8463745,8529281,8660609,8726145,8857473,8988801,9054337,9185664,9251200,9382528,9513600,9579392,9710464,9776256,9907327,10038655,10104191,10235519,10366590,10432382,10563454,10694782,10760317,10891645,10957181,11088508,11219836,11285371,11416699,11547771,11613562,11744634,11875961,11941497,12072824,12138360,12269687,12401015,12466550,12597877,12728949,12794740,12926068,12991603,13122930,13254258,13319793,13451120,13516912,13648239,13714030,13845101,13910893,14042220,14108011,14239338,14305129,14436457,14502248,14568039,14699366,14765158,14830949,14962276,15028323,15094114,15159906,15225953,15357280,15423072,15489119,15554911,15620958,15621469,15687261,15753309,15819100,15885148,15951196,15951707,16017499,16083547,16084059,16150107,16150619,16216411,16216924,16282972,16283484,16349532,16350045,16350557,16416606,16416862,16417375,16483424,16483936,16484449,16484962,16551011,16551523,16552036,16552549,16552806,16618855,16619368,16619881,16620394,16620907,16621420,16621934,16622191,16622704,16688753,16689267,16689780,16690293,16690806,16691064,16691577,16692091,16692604,16693117,16693631,16694144,16694402,16694915,16695429,16695942,16696456,16696969,16697227,16697741,16698254,16633232,16633746,16634259,16634517,16635031,16635544,16636058,16636572,16637085,16637343,16637857,16638371,16573349,16573862,16574120,16574634,16575148,16575662,16576176,16576689,16576947,16577461,16577975,16512953,16513467,16513725,16514239],a.Plasma3=[788358,13256312,15726625],a.Plasma4=[788358,10164126,15497299,15726625],a.Plasma5=[788358,8127143,13256312,16225089,15726625],a.Plasma6=[788358,6946983,11545231,14705761,16557621,15726625],a.Plasma7=[788358,6029477,10164126,13256312,15497299,16626223,15726625],a.Plasma8=[788358,5374371,8980645,12071561,14309992,15959880,16628523,15726625],a.Plasma9=[788358,4850336,8127143,11018902,13256312,15035228,16225089,16630568,15726625],a.Plasma10=[788358,4522910,7471272,10164126,12334725,14112364,15497299,16424250,16566054,15726625],a.Plasma11=[788358,4195228,6946983,9375139,11545231,13256312,14705761,15827532,16557621,16567333,15726625],a.Plasma256=[788358,1050503,1246857,1377930,1574539,1771148,1902221,2033038,2164111,2295184,2426257,2557330,2688403,2819476,2950292,3081365,3212438,3343511,3409048,3540120,3671193,3802266,3867546,3998619,4129692,4195228,4326301,4457374,4522910,4653727,4784799,4850336,4981409,5112481,5178018,5308834,5374371,5505443,5636515,5702052,5833124,5898405,6029477,6160549,6226086,6357158,6422694,6553767,6619303,6750375,6815911,6946983,7078056,7143592,7274664,7340200,7471272,7536808,7667880,7733672,7864744,7930280,8061608,8127143,8258471,8324007,8455335,8520871,8652198,8717990,8783782,8914853,8980645,9111972,9177764,9309348,9375139,9440931,9572258,9638049,9769377,9835168,9900960,10032287,10098078,10164126,10295453,10361244,10427035,10492827,10624154,10689945,10755736,10821527,10953111,11018902,11084693,11150484,11281811,11347602,11413393,11479184,11545231,11611023,11676814,11808141,11873932,11939723,12005514,12071561,12137352,12203143,12268934,12334725,12400516,12466307,12532098,12598145,12663936,12729728,12795519,12861310,12927101,12992892,13058683,13124730,13190521,13256312,13322103,13387894,13453685,13519477,13585268,13651315,13717106,13717361,13783152,13848943,13914734,13980525,14046573,14112364,14112619,14178410,14244201,14309992,14375783,14441830,14442086,14507877,14573668,14639459,14639714,14705761,14771552,14837344,14903135,14903390,14969437,15035228,15035483,15101274,15167066,15233113,15233368,15299159,15364950,15365205,15431252,15497044,15497299,15563090,15563601,15629392,15695183,15695438,15761485,15761741,15827532,15893579,15893834,15959625,15959880,16025927,16026183,16091974,16092485,16158276,16158531,16159042,16224833,16225089,16291136,16291391,16291902,16357693,16357948,16423995,16424250,16424762,16425017,16491064,16491319,16491574,16557621,16557877,16558388,16558643,16559154,16559409,16625457,16625712,16626223,16626478,16626989,16627245,16627756,16628011,16628523,16628778,16629289,16629801,16630056,16630568,16630823,16631334,16566054,16566566,16567077,16567333,16567845,16502820,16503076,16503588,16438564,16438820,16439332,16374052,16374564,16309540,16310052,16244772,16245285,16180261,16180517,16115494,16116006,16050726,15985702,15986214,15921190,15921446,15856422,15791397,15791651,15726625],a.Viridis3=[4456788,2133900,16639780],a.Viridis4=[4456788,3172237,3520376,16639780],a.Viridis5=[4456788,3887498,2133900,6015074,16639780],a.Viridis6=[4456788,4211591,2717838,2271108,7983441,16639780],a.Viridis7=[4456788,4471170,3172237,2133900,3520376,9295428,16639780],a.Viridis8=[4456788,4600190,3562124,2588302,2007175,4833645,10344762,16639780],a.Viridis9=[4456788,4664186,3887498,2912654,2133900,2600320,6015074,11197234,16639780],a.Viridis10=[4456788,4663159,4082057,3172237,2458254,2006153,3520376,7064921,11722028,16639780],a.Viridis11=[4456788,4727668,4211591,3432077,2717838,2133900,2271108,4374129,7983441,12246567,16639780],a.Viridis256=[4456788,4457045,4457303,4523352,4523610,4524123,4589916,4590430,4590687,4591201,4656994,4657507,4657765,4658278,4658535,4658793,4659306,4725099,4725356,4725870,4726127,4726384,4726897,4727154,4727411,4727668,4662645,4662902,4663159,4663416,4663929,4664186,4664443,4599164,4599676,4599933,4600190,4534911,4535423,4535680,4535937,4470657,4471170,4405891,4406147,4406404,4341124,4341381,4341893,4276614,4276870,4211591,4211847,4146567,4147080,4081800,4082057,4016777,4017033,4017289,3952010,3952266,3887242,3887498,3822219,3822475,3757195,3757451,3692171,3692428,3627148,3627404,3562124,3562380,3497100,3497356,3432077,3432333,3367053,3367309,3302029,3302285,3237005,3237261,3237517,3172237,3172493,3107213,3107469,3042190,3042446,3042702,2977422,2977678,2912398,2912654,2912910,2847630,2847886,2782606,2782862,2783118,2717838,2718094,2652814,2652814,2653070,2587790,2588046,2588302,2523022,2523278,2523534,2458254,2458509,2393229,2393485,2393741,2328461,2328717,2328973,2263437,2263693,2263949,2198669,2198924,2199180,2133900,2134156,2134412,2069132,2069387,2069643,2069899,2070155,2004874,2005130,2005386,2005386,2005641,2005897,2006153,2006408,2006664,2006920,2007175,2072967,2073222,2073478,2139269,2139525,2205317,2205572,2271108,2336899,2337154,2402946,2468737,2534529,2600320,2666111,2731903,2797694,2863485,2929021,3060348,3126139,3191930,3323258,3389049,3520376,3586167,3717494,3783030,3914357,4045684,4111475,4242802,4374129,4505200,4570991,4702318,4833645,4964972,5096043,5227369,5358696,5490023,5621350,5752421,5883748,6015074,6211937,6343008,6474335,6605661,6802524,6933595,7064921,7196248,7392854,7524181,7655508,7852114,7983441,8180303,8311374,8508236,8639307,8836169,8967495,9164102,9295428,9492035,9623361,9819967,9951294,10147900,10344762,10475832,10672695,10869301,11000627,11197234,11394096,11525166,11722028,11918635,12049705,12246567,12443174,12574500,12771106,12967713,13099039,13295646,13492253,13623580,13820187,13951258,14148121,14344728,14475800,14672664,14803736,15000344,15197209,15328281,15524890,15656219,15852828,15983902,16180767,16311841,16442914,16639780],a.Accent3=[8374655,12496596,16629894],a.Accent4=[8374655,12496596,16629894,16777113],a.Accent5=[8374655,12496596,16629894,16777113,3697840],a.Accent6=[8374655,12496596,16629894,16777113,3697840,15729279],a.Accent7=[8374655,12496596,16629894,16777113,3697840,15729279,12540695],a.Accent8=[8374655,12496596,16629894,16777113,3697840,15729279,12540695,6710886],a.Dark2_3=[1810039,14245634,7696563],a.Dark2_4=[1810039,14245634,7696563,15149450],a.Dark2_5=[1810039,14245634,7696563,15149450,6727198],a.Dark2_6=[1810039,14245634,7696563,15149450,6727198,15117058],a.Dark2_7=[1810039,14245634,7696563,15149450,6727198,15117058,10909213],a.Dark2_8=[1810039,14245634,7696563,15149450,6727198,15117058,10909213,6710886],a.Paired3=[10931939,2062516,11722634],a.Paired4=[10931939,2062516,11722634,3383340],a.Paired5=[10931939,2062516,11722634,3383340,16489113],a.Paired6=[10931939,2062516,11722634,3383340,16489113,14883356],a.Paired7=[10931939,2062516,11722634,3383340,16489113,14883356,16629615],a.Paired8=[10931939,2062516,11722634,3383340,16489113,14883356,16629615,16744192],a.Paired9=[10931939,2062516,11722634,3383340,16489113,14883356,16629615,16744192,13284054],a.Paired10=[10931939,2062516,11722634,3383340,16489113,14883356,16629615,16744192,13284054,6962586],a.Paired11=[10931939,2062516,11722634,3383340,16489113,14883356,16629615,16744192,13284054,6962586,16777113],a.Paired12=[10931939,2062516,11722634,3383340,16489113,14883356,16629615,16744192,13284054,6962586,16777113,11622696],a.Pastel1_3=[16495790,11783651,13429701],a.Pastel1_4=[16495790,11783651,13429701,14601188],a.Pastel1_5=[16495790,11783651,13429701,14601188,16701862],a.Pastel1_6=[16495790,11783651,13429701,14601188,16701862,16777164],a.Pastel1_7=[16495790,11783651,13429701,14601188,16701862,16777164,15063229],a.Pastel1_8=[16495790,11783651,13429701,14601188,16701862,16777164,15063229,16636652],a.Pastel1_9=[16495790,11783651,13429701,14601188,16701862,16777164,15063229,16636652,15921906],a.Pastel2_3=[11789005,16633260,13358568],a.Pastel2_4=[11789005,16633260,13358568,16042724],a.Pastel2_5=[11789005,16633260,13358568,16042724,15136201],a.Pastel2_6=[11789005,16633260,13358568,16042724,15136201,16773806],a.Pastel2_7=[11789005,16633260,13358568,16042724,15136201,16773806,15852236],a.Pastel2_8=[11789005,16633260,13358568,16042724,15136201,16773806,15852236,13421772],a.Set1_3=[14948892,3636920,5091146],a.Set1_4=[14948892,3636920,5091146,9981603],a.Set1_5=[14948892,3636920,5091146,9981603,16744192],a.Set1_6=[14948892,3636920,5091146,9981603,16744192,16777011],a.Set1_7=[14948892,3636920,5091146,9981603,16744192,16777011,10901032],a.Set1_8=[14948892,3636920,5091146,9981603,16744192,16777011,10901032,16220607],a.Set1_9=[14948892,3636920,5091146,9981603,16744192,16777011,10901032,16220607,10066329],a.Set2_3=[6734501,16551266,9281739],a.Set2_4=[6734501,16551266,9281739,15174339],a.Set2_5=[6734501,16551266,9281739,15174339,10934356],a.Set2_6=[6734501,16551266,9281739,15174339,10934356,16767279],a.Set2_7=[6734501,16551266,9281739,15174339,10934356,16767279,15058068],a.Set2_8=[6734501,16551266,9281739,15174339,10934356,16767279,15058068,11776947],a.Set3_3=[9294791,16777139,12499674],a.Set3_4=[9294791,16777139,12499674,16482418],a.Set3_5=[9294791,16777139,12499674,16482418,8434131],a.Set3_6=[9294791,16777139,12499674,16482418,8434131,16626786],a.Set3_7=[9294791,16777139,12499674,16482418,8434131,16626786,11787881],a.Set3_8=[9294791,16777139,12499674,16482418,8434131,16626786,11787881,16567781],a.Set3_9=[9294791,16777139,12499674,16482418,8434131,16626786,11787881,16567781,14277081],a.Set3_10=[9294791,16777139,12499674,16482418,8434131,16626786,11787881,16567781,14277081,12353725],a.Set3_11=[9294791,16777139,12499674,16482418,8434131,16626786,11787881,16567781,14277081,12353725,13429701],a.Set3_12=[9294791,16777139,12499674,16482418,8434131,16626786,11787881,16567781,14277081,12353725,13429701,16772463],a.Category10_3=[2062260,16744206,2924588],a.Category10_4=[2062260,16744206,2924588,14034728],a.Category10_5=[2062260,16744206,2924588,14034728,9725885],a.Category10_6=[2062260,16744206,2924588,14034728,9725885,9197131],a.Category10_7=[2062260,16744206,2924588,14034728,9725885,9197131,14907330],a.Category10_8=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711],a.Category10_9=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186],a.Category10_10=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186,1556175],a.Category20_3=[2062260,11454440,16744206],a.Category20_4=[2062260,11454440,16744206,16759672],a.Category20_5=[2062260,11454440,16744206,16759672,2924588],a.Category20_6=[2062260,11454440,16744206,16759672,2924588,10018698],a.Category20_7=[2062260,11454440,16744206,16759672,2924588,10018698,14034728],a.Category20_8=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742],a.Category20_9=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885],a.Category20_10=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861],a.Category20_11=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131],a.Category20_12=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140],a.Category20_13=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330],a.Category20_14=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194],a.Category20_15=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711],a.Category20_16=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807],a.Category20_17=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186],a.Category20_18=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589],a.Category20_19=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175],a.Category20_20=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175,10410725],a.Category20b_3=[3750777,5395619,7040719],a.Category20b_4=[3750777,5395619,7040719,10264286],a.Category20b_5=[3750777,5395619,7040719,10264286,6519097],a.Category20b_6=[3750777,5395619,7040719,10264286,6519097,9216594],a.Category20b_7=[3750777,5395619,7040719,10264286,6519097,9216594,11915115],a.Category20b_8=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636],a.Category20b_9=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993],a.Category20b_10=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809],a.Category20b_11=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514],a.Category20b_12=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932],a.Category20b_13=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169],a.Category20b_14=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490],a.Category20b_15=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643],a.Category20b_16=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372],a.Category20b_17=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683],a.Category20b_18=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324],a.Category20b_19=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509],a.Category20b_20=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509,14589654],a.Category20c_3=[3244733,7057110,10406625],a.Category20c_4=[3244733,7057110,10406625,13032431],a.Category20c_5=[3244733,7057110,10406625,13032431,15095053],a.Category20c_6=[3244733,7057110,10406625,13032431,15095053,16616764],a.Category20c_7=[3244733,7057110,10406625,13032431,15095053,16616764,16625259],a.Category20c_8=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018],a.Category20c_9=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076],a.Category20c_10=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470],a.Category20c_11=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003],a.Category20c_12=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504],a.Category20c_13=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281],a.Category20c_14=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312],a.Category20c_15=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372],a.Category20c_16=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891],a.Category20c_17=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507],a.Category20c_18=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950],a.Category20c_19=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877],a.Category20c_20=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877,14277081],a.Colorblind3=[29362,15113984,15787074],a.Colorblind4=[29362,15113984,15787074,40563],a.Colorblind5=[29362,15113984,15787074,40563,5682409],a.Colorblind6=[29362,15113984,15787074,40563,5682409,13983232],a.Colorblind7=[29362,15113984,15787074,40563,5682409,13983232,13400487],a.Colorblind8=[29362,15113984,15787074,40563,5682409,13983232,13400487,0],a.YlGn={YlGn3:a.YlGn3,YlGn4:a.YlGn4,YlGn5:a.YlGn5,YlGn6:a.YlGn6,YlGn7:a.YlGn7,YlGn8:a.YlGn8,YlGn9:a.YlGn9},a.YlGnBu={YlGnBu3:a.YlGnBu3,YlGnBu4:a.YlGnBu4,YlGnBu5:a.YlGnBu5,YlGnBu6:a.YlGnBu6,YlGnBu7:a.YlGnBu7,YlGnBu8:a.YlGnBu8,YlGnBu9:a.YlGnBu9},a.GnBu={GnBu3:a.GnBu3,GnBu4:a.GnBu4,GnBu5:a.GnBu5,GnBu6:a.GnBu6,GnBu7:a.GnBu7,GnBu8:a.GnBu8,GnBu9:a.GnBu9},a.BuGn={BuGn3:a.BuGn3,BuGn4:a.BuGn4,BuGn5:a.BuGn5,BuGn6:a.BuGn6,BuGn7:a.BuGn7,BuGn8:a.BuGn8,BuGn9:a.BuGn9},a.PuBuGn={PuBuGn3:a.PuBuGn3,PuBuGn4:a.PuBuGn4,PuBuGn5:a.PuBuGn5,PuBuGn6:a.PuBuGn6,PuBuGn7:a.PuBuGn7,PuBuGn8:a.PuBuGn8,PuBuGn9:a.PuBuGn9},a.PuBu={PuBu3:a.PuBu3,PuBu4:a.PuBu4,PuBu5:a.PuBu5,PuBu6:a.PuBu6,PuBu7:a.PuBu7,PuBu8:a.PuBu8,PuBu9:a.PuBu9},a.BuPu={BuPu3:a.BuPu3,BuPu4:a.BuPu4,BuPu5:a.BuPu5,BuPu6:a.BuPu6,BuPu7:a.BuPu7,BuPu8:a.BuPu8,BuPu9:a.BuPu9},a.RdPu={RdPu3:a.RdPu3,RdPu4:a.RdPu4,RdPu5:a.RdPu5,RdPu6:a.RdPu6,RdPu7:a.RdPu7,RdPu8:a.RdPu8,RdPu9:a.RdPu9},a.PuRd={PuRd3:a.PuRd3,PuRd4:a.PuRd4,PuRd5:a.PuRd5,PuRd6:a.PuRd6,PuRd7:a.PuRd7,PuRd8:a.PuRd8,PuRd9:a.PuRd9},a.OrRd={OrRd3:a.OrRd3,OrRd4:a.OrRd4,OrRd5:a.OrRd5,OrRd6:a.OrRd6,OrRd7:a.OrRd7,OrRd8:a.OrRd8,OrRd9:a.OrRd9},a.YlOrRd={YlOrRd3:a.YlOrRd3,YlOrRd4:a.YlOrRd4,YlOrRd5:a.YlOrRd5,YlOrRd6:a.YlOrRd6,YlOrRd7:a.YlOrRd7,YlOrRd8:a.YlOrRd8,YlOrRd9:a.YlOrRd9},a.YlOrBr={YlOrBr3:a.YlOrBr3,YlOrBr4:a.YlOrBr4,YlOrBr5:a.YlOrBr5,YlOrBr6:a.YlOrBr6,YlOrBr7:a.YlOrBr7,YlOrBr8:a.YlOrBr8,YlOrBr9:a.YlOrBr9},a.Purples={Purples3:a.Purples3,Purples4:a.Purples4,Purples5:a.Purples5,Purples6:a.Purples6,Purples7:a.Purples7,Purples8:a.Purples8,Purples9:a.Purples9},a.Blues={Blues3:a.Blues3,Blues4:a.Blues4,Blues5:a.Blues5,Blues6:a.Blues6,Blues7:a.Blues7,Blues8:a.Blues8,Blues9:a.Blues9},a.Greens={Greens3:a.Greens3,Greens4:a.Greens4,Greens5:a.Greens5,Greens6:a.Greens6,Greens7:a.Greens7,Greens8:a.Greens8,Greens9:a.Greens9},a.Oranges={Oranges3:a.Oranges3,Oranges4:a.Oranges4,Oranges5:a.Oranges5,Oranges6:a.Oranges6,Oranges7:a.Oranges7,Oranges8:a.Oranges8,Oranges9:a.Oranges9},a.Reds={Reds3:a.Reds3,Reds4:a.Reds4,Reds5:a.Reds5,Reds6:a.Reds6,Reds7:a.Reds7,Reds8:a.Reds8,Reds9:a.Reds9},a.Greys={Greys3:a.Greys3,Greys4:a.Greys4,Greys5:a.Greys5,Greys6:a.Greys6,Greys7:a.Greys7,Greys8:a.Greys8,Greys9:a.Greys9,Greys10:a.Greys10,Greys11:a.Greys11,Greys256:a.Greys256},a.PuOr={PuOr3:a.PuOr3,PuOr4:a.PuOr4,PuOr5:a.PuOr5,PuOr6:a.PuOr6,PuOr7:a.PuOr7,PuOr8:a.PuOr8,PuOr9:a.PuOr9,PuOr10:a.PuOr10,PuOr11:a.PuOr11},a.BrBG={BrBG3:a.BrBG3,BrBG4:a.BrBG4,BrBG5:a.BrBG5,BrBG6:a.BrBG6,BrBG7:a.BrBG7,BrBG8:a.BrBG8,BrBG9:a.BrBG9,BrBG10:a.BrBG10,BrBG11:a.BrBG11},a.PRGn={PRGn3:a.PRGn3,PRGn4:a.PRGn4,PRGn5:a.PRGn5,PRGn6:a.PRGn6,PRGn7:a.PRGn7,PRGn8:a.PRGn8,PRGn9:a.PRGn9,PRGn10:a.PRGn10,PRGn11:a.PRGn11},a.PiYG={PiYG3:a.PiYG3,PiYG4:a.PiYG4,PiYG5:a.PiYG5,PiYG6:a.PiYG6,PiYG7:a.PiYG7,PiYG8:a.PiYG8,PiYG9:a.PiYG9,PiYG10:a.PiYG10,PiYG11:a.PiYG11},a.RdBu={RdBu3:a.RdBu3,RdBu4:a.RdBu4,RdBu5:a.RdBu5,RdBu6:a.RdBu6,RdBu7:a.RdBu7,RdBu8:a.RdBu8,RdBu9:a.RdBu9,RdBu10:a.RdBu10,RdBu11:a.RdBu11},a.RdGy={RdGy3:a.RdGy3,RdGy4:a.RdGy4,RdGy5:a.RdGy5,RdGy6:a.RdGy6,RdGy7:a.RdGy7,RdGy8:a.RdGy8,RdGy9:a.RdGy9,RdGy10:a.RdGy10,RdGy11:a.RdGy11},a.RdYlBu={RdYlBu3:a.RdYlBu3,RdYlBu4:a.RdYlBu4,RdYlBu5:a.RdYlBu5,RdYlBu6:a.RdYlBu6,RdYlBu7:a.RdYlBu7,RdYlBu8:a.RdYlBu8,RdYlBu9:a.RdYlBu9,RdYlBu10:a.RdYlBu10,RdYlBu11:a.RdYlBu11},a.Spectral={Spectral3:a.Spectral3,Spectral4:a.Spectral4,Spectral5:a.Spectral5,Spectral6:a.Spectral6,Spectral7:a.Spectral7,Spectral8:a.Spectral8,Spectral9:a.Spectral9,Spectral10:a.Spectral10,Spectral11:a.Spectral11},a.RdYlGn={RdYlGn3:a.RdYlGn3,RdYlGn4:a.RdYlGn4,RdYlGn5:a.RdYlGn5,RdYlGn6:a.RdYlGn6,RdYlGn7:a.RdYlGn7,RdYlGn8:a.RdYlGn8,RdYlGn9:a.RdYlGn9,RdYlGn10:a.RdYlGn10,RdYlGn11:a.RdYlGn11},a.Inferno={Inferno3:a.Inferno3,Inferno4:a.Inferno4,Inferno5:a.Inferno5,Inferno6:a.Inferno6,Inferno7:a.Inferno7,Inferno8:a.Inferno8,Inferno9:a.Inferno9,Inferno10:a.Inferno10,Inferno11:a.Inferno11,Inferno256:a.Inferno256},a.Magma={Magma3:a.Magma3,Magma4:a.Magma4,Magma5:a.Magma5,Magma6:a.Magma6,Magma7:a.Magma7,Magma8:a.Magma8,Magma9:a.Magma9,Magma10:a.Magma10,Magma11:a.Magma11,Magma256:a.Magma256},a.Plasma={Plasma3:a.Plasma3,Plasma4:a.Plasma4,Plasma5:a.Plasma5,Plasma6:a.Plasma6,Plasma7:a.Plasma7,Plasma8:a.Plasma8,Plasma9:a.Plasma9,Plasma10:a.Plasma10,Plasma11:a.Plasma11,Plasma256:a.Plasma256},a.Viridis={Viridis3:a.Viridis3,Viridis4:a.Viridis4,Viridis5:a.Viridis5,Viridis6:a.Viridis6,Viridis7:a.Viridis7,Viridis8:a.Viridis8,Viridis9:a.Viridis9,Viridis10:a.Viridis10,Viridis11:a.Viridis11,Viridis256:a.Viridis256},a.Accent={Accent3:a.Accent3,Accent4:a.Accent4,Accent5:a.Accent5,Accent6:a.Accent6,Accent7:a.Accent7,Accent8:a.Accent8},a.Dark2={Dark2_3:a.Dark2_3,Dark2_4:a.Dark2_4,Dark2_5:a.Dark2_5,Dark2_6:a.Dark2_6,Dark2_7:a.Dark2_7,Dark2_8:a.Dark2_8},a.Paired={Paired3:a.Paired3,Paired4:a.Paired4,Paired5:a.Paired5,Paired6:a.Paired6,Paired7:a.Paired7,Paired8:a.Paired8,Paired9:a.Paired9,Paired10:a.Paired10,Paired11:a.Paired11,Paired12:a.Paired12},a.Pastel1={Pastel1_3:a.Pastel1_3,Pastel1_4:a.Pastel1_4,Pastel1_5:a.Pastel1_5,Pastel1_6:a.Pastel1_6,Pastel1_7:a.Pastel1_7,Pastel1_8:a.Pastel1_8,Pastel1_9:a.Pastel1_9},a.Pastel2={Pastel2_3:a.Pastel2_3,Pastel2_4:a.Pastel2_4,Pastel2_5:a.Pastel2_5,Pastel2_6:a.Pastel2_6,Pastel2_7:a.Pastel2_7,Pastel2_8:a.Pastel2_8},a.Set1={Set1_3:a.Set1_3,Set1_4:a.Set1_4,Set1_5:a.Set1_5,Set1_6:a.Set1_6,Set1_7:a.Set1_7,Set1_8:a.Set1_8,Set1_9:a.Set1_9},a.Set2={Set2_3:a.Set2_3,Set2_4:a.Set2_4,Set2_5:a.Set2_5,Set2_6:a.Set2_6,Set2_7:a.Set2_7,Set2_8:a.Set2_8},a.Set3={Set3_3:a.Set3_3,Set3_4:a.Set3_4,Set3_5:a.Set3_5,Set3_6:a.Set3_6,Set3_7:a.Set3_7,Set3_8:a.Set3_8,Set3_9:a.Set3_9,Set3_10:a.Set3_10,Set3_11:a.Set3_11,Set3_12:a.Set3_12},a.Category10={Category10_3:a.Category10_3,Category10_4:a.Category10_4,Category10_5:a.Category10_5,Category10_6:a.Category10_6,Category10_7:a.Category10_7,Category10_8:a.Category10_8,Category10_9:a.Category10_9,Category10_10:a.Category10_10},a.Category20={Category20_3:a.Category20_3,Category20_4:a.Category20_4,Category20_5:a.Category20_5,Category20_6:a.Category20_6,Category20_7:a.Category20_7,Category20_8:a.Category20_8,Category20_9:a.Category20_9,Category20_10:a.Category20_10,Category20_11:a.Category20_11,Category20_12:a.Category20_12,Category20_13:a.Category20_13,Category20_14:a.Category20_14,Category20_15:a.Category20_15,Category20_16:a.Category20_16,Category20_17:a.Category20_17,Category20_18:a.Category20_18,Category20_19:a.Category20_19,Category20_20:a.Category20_20},a.Category20b={Category20b_3:a.Category20b_3,Category20b_4:a.Category20b_4,Category20b_5:a.Category20b_5,Category20b_6:a.Category20b_6,Category20b_7:a.Category20b_7,Category20b_8:a.Category20b_8,Category20b_9:a.Category20b_9,Category20b_10:a.Category20b_10,Category20b_11:a.Category20b_11,Category20b_12:a.Category20b_12,Category20b_13:a.Category20b_13,Category20b_14:a.Category20b_14,Category20b_15:a.Category20b_15,Category20b_16:a.Category20b_16,Category20b_17:a.Category20b_17,Category20b_18:a.Category20b_18,Category20b_19:a.Category20b_19,Category20b_20:a.Category20b_20},a.Category20c={Category20c_3:a.Category20c_3,Category20c_4:a.Category20c_4,Category20c_5:a.Category20c_5,Category20c_6:a.Category20c_6,Category20c_7:a.Category20c_7,Category20c_8:a.Category20c_8,Category20c_9:a.Category20c_9,Category20c_10:a.Category20c_10,Category20c_11:a.Category20c_11,Category20c_12:a.Category20c_12,Category20c_13:a.Category20c_13,Category20c_14:a.Category20c_14,Category20c_15:a.Category20c_15,Category20c_16:a.Category20c_16,Category20c_17:a.Category20c_17,Category20c_18:a.Category20c_18,Category20c_19:a.Category20c_19,Category20c_20:a.Category20c_20},a.Colorblind={Colorblind3:a.Colorblind3,Colorblind4:a.Colorblind4,Colorblind5:a.Colorblind5,Colorblind6:a.Colorblind6,Colorblind7:a.Colorblind7,Colorblind8:a.Colorblind8}},
373: function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0}),e(1).__exportStar(e(27),_)},
374: function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const n=e(1),s=e(5),i=n.__importStar(e(4)),l=n.__importStar(e(373)),a=e(19),o=e(25),_=e(16),c=e(9),u=e(23),h=e(8),g=e(373),d=e(135);var p=e(375);r.gridplot=p.gridplot;var y=e(21);r.color=y.rgb2hex;const x=["pan","wheel_zoom","box_zoom","save","reset","help"];function f(e,t){return void 0===e?t:e}class m extends g.Plot{constructor(e={}){const t=f((e=Object.assign({},e)).tools,x);delete e.tools;const r=f(e.x_axis_type,"auto"),n=f(e.y_axis_type,"auto");delete e.x_axis_type,delete e.y_axis_type;const s=null!=e.x_minor_ticks?e.x_minor_ticks:"auto",i=null!=e.y_minor_ticks?e.y_minor_ticks:"auto";delete e.x_minor_ticks,delete e.y_minor_ticks;const l=null!=e.x_axis_location?e.x_axis_location:"below",a=null!=e.y_axis_location?e.y_axis_location:"left";delete e.x_axis_location,delete e.y_axis_location;const o=null!=e.x_axis_label?e.x_axis_label:"",_=null!=e.y_axis_label?e.y_axis_label:"";delete e.x_axis_label,delete e.y_axis_label;const c=m._get_range(e.x_range),u=m._get_range(e.y_range);delete e.x_range,delete e.y_range;const h=null!=e.x_scale?e.x_scale:m._get_scale(c,r),g=null!=e.y_scale?e.y_scale:m._get_scale(u,n);delete e.x_scale,delete e.y_scale,super(Object.assign(Object.assign({},e),{x_range:c,y_range:u,x_scale:h,y_scale:g})),this._process_axis_and_grid(r,l,s,o,c,0),this._process_axis_and_grid(n,a,i,_,u,1),this.add_tools(...this._process_tools(t))}get xgrid(){return this.center.filter(e=>e instanceof g.Grid&&0==e.dimension)}get ygrid(){return this.center.filter(e=>e instanceof g.Grid&&1==e.dimension)}get xaxis(){return this.below.concat(this.above).filter(e=>e instanceof g.Axis)}get yaxis(){return this.left.concat(this.right).filter(e=>e instanceof g.Axis)}get legend(){const e=this.panels.filter(e=>e instanceof d.Legend);if(0==e.length){const e=new d.Legend;return this.add_layout(e),e}{const[t]=e;return t}}annular_wedge(...e){return this._glyph(l.AnnularWedge,"x,y,inner_radius,outer_radius,start_angle,end_angle",e)}annulus(...e){return this._glyph(l.Annulus,"x,y,inner_radius,outer_radius",e)}arc(...e){return this._glyph(l.Arc,"x,y,radius,start_angle,end_angle",e)}bezier(...e){return this._glyph(l.Bezier,"x0,y0,x1,y1,cx0,cy0,cx1,cy1",e)}circle(...e){return this._glyph(l.Circle,"x,y",e)}ellipse(...e){return this._glyph(l.Ellipse,"x,y,width,height",e)}hbar(...e){return this._glyph(l.HBar,"y,height,right,left",e)}hex_tile(...e){return this._glyph(l.HexTile,"q,r",e)}image(...e){return this._glyph(l.Image,"color_mapper,image,rows,cols,x,y,dw,dh",e)}image_rgba(...e){return this._glyph(l.ImageRGBA,"image,rows,cols,x,y,dw,dh",e)}image_url(...e){return this._glyph(l.ImageURL,"url,x,y,w,h",e)}line(...e){return this._glyph(l.Line,"x,y",e)}multi_line(...e){return this._glyph(l.MultiLine,"xs,ys",e)}multi_polygons(...e){return this._glyph(l.MultiPolygons,"xs,ys",e)}oval(...e){return this._glyph(l.Oval,"x,y,width,height",e)}patch(...e){return this._glyph(l.Patch,"x,y",e)}patches(...e){return this._glyph(l.Patches,"xs,ys",e)}quad(...e){return this._glyph(l.Quad,"left,right,bottom,top",e)}quadratic(...e){return this._glyph(l.Quadratic,"x0,y0,x1,y1,cx,cy",e)}ray(...e){return this._glyph(l.Ray,"x,y,length",e)}rect(...e){return this._glyph(l.Rect,"x,y,width,height",e)}segment(...e){return this._glyph(l.Segment,"x0,y0,x1,y1",e)}step(...e){return this._glyph(l.Step,"x,y,mode",e)}text(...e){return this._glyph(l.Text,"x,y,text",e)}vbar(...e){return this._glyph(l.VBar,"x,width,top,bottom",e)}wedge(...e){return this._glyph(l.Wedge,"x,y,radius,start_angle,end_angle",e)}asterisk(...e){return this._marker(l.Asterisk,e)}circle_cross(...e){return this._marker(l.CircleCross,e)}circle_x(...e){return this._marker(l.CircleX,e)}cross(...e){return this._marker(l.Cross,e)}dash(...e){return this._marker(l.Dash,e)}diamond(...e){return this._marker(l.Diamond,e)}diamond_cross(...e){return this._marker(l.DiamondCross,e)}inverted_triangle(...e){return this._marker(l.InvertedTriangle,e)}square(...e){return this._marker(l.Square,e)}square_cross(...e){return this._marker(l.SquareCross,e)}square_x(...e){return this._marker(l.SquareX,e)}triangle(...e){return this._marker(l.Triangle,e)}x(...e){return this._marker(l.X,e)}scatter(...e){return this._marker(l.Scatter,e)}_pop_visuals(e,t,r="",n={},s={}){const i=function(e){const t=e.split("_",2);return 2==t.length?t:t.concat([""])},l=function(e){const[t,r]=i(e);return c.includes(["line","fill","text","global"],t)&&""!==r};(n=Object.assign({},n)).hasOwnProperty("text_color")||(n.text_color="black");const a={};a.hasOwnProperty("color")||(a.color="#1f77b4"),a.hasOwnProperty("alpha")||(a.alpha=1);const o={},_=new Set;for(const c in e.prototype.props)if(l(c)){const l=i(c)[1];t.hasOwnProperty(r+c)?(o[c]=t[r+c],delete t[r+c]):!e.prototype.props.hasOwnProperty(l)&&t.hasOwnProperty(r+l)?o[c]=t[r+l]:s.hasOwnProperty(l)?o[c]=s[l]:n.hasOwnProperty(c)?o[c]=n[c]:a.hasOwnProperty(l)&&(o[c]=a[l]),e.prototype.props.hasOwnProperty(l)||_.add(l)}return _.forEach((function(e,n,s){delete t[r+n]})),o}_find_uniq_name(e,t){let r=1;for(;;){const n=`${t}__${r}`;if(null==e[n])return n;r+=1}}_fixup_values(e,t,r){for(const n in r){const s=r[n],i=e.prototype.props[n];if(null!=i&&i.type.prototype instanceof a.VectorSpec&&null!=s)if(h.isArray(s)){let e;null!=t[n]?t[n]!==s?(e=this._find_uniq_name(t,n),t[e]=s):e=n:(e=n,t[e]=s),r[n]={field:e}}else(h.isNumber(s)||h.isString(s))&&(r[n]={value:s})}}_glyph(e,t,r){const n=t.split(",");let s;if(0==r.length)s={};else if(1==r.length)s=u.clone(r[0]);else{s=u.clone(r[r.length-1]);for(let e=0;e<n.length;e++){s[n[e]]=r[e]}}const i=null!=s.source?s.source:new l.ColumnDataSource,a=u.clone(i.data);delete s.source;const _=this._process_legend(s.legend,i);delete s.legend;const h=c.some(Object.keys(s),e=>o.startsWith(e,"selection_")),d=c.some(Object.keys(s),e=>o.startsWith(e,"hover_")),p=this._pop_visuals(e,s),y=this._pop_visuals(e,s,"nonselection_",p,{alpha:.1}),x=h?this._pop_visuals(e,s,"selection_",p):{},f=d?this._pop_visuals(e,s,"hover_",p):{};this._fixup_values(e,a,p),this._fixup_values(e,a,y),this._fixup_values(e,a,x),this._fixup_values(e,a,f),this._fixup_values(e,a,s),i.data=a;const m=(e,t,r)=>new e(Object.assign(Object.assign({},t),r)),w=m(e,s,p),b=m(e,s,y),k=h?m(e,s,x):void 0,v=d?m(e,s,f):void 0,S=new g.GlyphRenderer({data_source:i,glyph:w,nonselection_glyph:b,selection_glyph:k,hover_glyph:v});return null!=_&&this._update_legend(_,S),this.add_renderers(S),S}_marker(e,t){return this._glyph(e,"x,y",t)}static _get_range(e){if(null==e)return new l.DataRange1d;if(e instanceof l.Range)return e;if(h.isArray(e)){if(c.every(e,h.isString)){const t=e;return new l.FactorRange({factors:t})}if(2==e.length){const[t,r]=e;return new l.Range1d({start:t,end:r})}}throw new Error(`unable to determine proper range for: '${e}'`)}static _get_scale(e,t){if(e instanceof l.DataRange1d||e instanceof l.Range1d)switch(t){case null:case"auto":case"linear":case"datetime":return new l.LinearScale;case"log":return new l.LogScale}if(e instanceof l.FactorRange)return new l.CategoricalScale;throw new Error(`unable to determine proper scale for: '${e}'`)}_process_axis_and_grid(e,t,r,n,s,i){const a=this._get_axis_class(e,s);if(null!=a){a===l.LogAxis&&(0===i?this.x_scale=new l.LogScale:this.y_scale=new l.LogScale);const e=new a;e.ticker instanceof l.ContinuousTicker&&(e.ticker.num_minor_ticks=this._get_num_minor_ticks(a,r)),0!==n.length&&(e.axis_label=n);const s=new l.Grid({dimension:i,ticker:e.ticker});null!==t&&this.add_layout(e,t),this.add_layout(s)}}_get_axis_class(e,t){switch(e){case null:return null;case"linear":return l.LinearAxis;case"log":return l.LogAxis;case"datetime":return l.DatetimeAxis;case"auto":return t instanceof l.FactorRange?l.CategoricalAxis:l.LinearAxis;default:throw new Error("shouldn't have happened")}}_get_num_minor_ticks(e,t){if(h.isNumber(t)){if(t<=1)throw new Error("num_minor_ticks must be > 1");return t}if(null==t)return 0;if("auto"===t)return e===l.LogAxis?10:5;throw new Error("shouldn't have happened")}_process_tools(e){return h.isString(e)&&(e=e.split(/\s*,\s*/).filter(e=>e.length>0)),e.map(e=>h.isString(e)?g.Tool.from_string(e):e)}_process_legend(e,t){let r=null;return null!=e&&(h.isString(e)?(r={value:e},null!=t.columns()&&c.includes(t.columns(),e)&&(r={field:e})):r=e),r}_update_legend(e,t){const{legend:r}=this;let n=!1;for(const s of r.items)if(null!=s.label&&_.isEqual(s.label,e)){const e=s.label;if("value"in e){s.renderers.push(t),n=!0;break}if("field"in e&&t.data_source==s.renderers[0].data_source){s.renderers.push(t),n=!0;break}}if(!n){const n=new l.LegendItem({label:e,renderers:[t]});r.items.push(n)}}}r.Figure=m,m.__name__="Plot",r.figure=function(e){return new m(e)},r.show=async function(e,t){const r=new s.Document;for(const t of h.isArray(e)?e:[e])r.add_root(t);let n;if(null==t)n=document.body;else if(h.isString(t)){const e=document.querySelector(t);if(!(null!=e&&e instanceof HTMLElement))throw new Error(`'${t}' selector didn't match any elements`);n=e}else if(t instanceof HTMLElement)n=t;else{if(!("undefined"!=typeof $&&t instanceof $))throw new Error("target should be HTMLElement, string selector, $ or null");n=t[0]}const l=await i.add_document_standalone(r,n);return new Promise((t,n)=>{const s=h.isArray(e)?l:l[0];r.is_idle?t(s):r.idle.connect(()=>t(s))})}},
375: function _(o,n,e){Object.defineProperty(e,"__esModule",{value:!0});const t=o(373);function l(o,n){return void 0===o?n:o}e.gridplot=function(o,n={}){const e=l(n.toolbar_location,"above"),i=l(n.merge_tools,!0),r=l(n.sizing_mode,null),s=[],c=[];for(let e=0;e<o.length;e++){const l=o[e];for(let o=0;o<l.length;o++){const r=l[o];null!=r&&(r instanceof t.Plot&&(i&&(s.push(r.toolbar),r.toolbar_location=null),null!=n.plot_width&&(r.plot_width=n.plot_width),null!=n.plot_height&&(r.plot_height=n.plot_height)),c.push([r,e,o]))}}if(!i||null==e)return new t.GridBox({children:c,sizing_mode:r});const d=new t.GridBox({children:c,sizing_mode:r}),u=[];for(const o of s)u.push(...o.tools);const h=new t.ToolbarBox({toolbar:new t.ProxyToolbar({toolbars:s,tools:u}),toolbar_location:e});switch(e){case"above":return new t.Column({children:[h,d],sizing_mode:r});case"below":return new t.Column({children:[d,h],sizing_mode:r});case"left":return new t.Row({children:[h,d],sizing_mode:r});case"right":return new t.Row({children:[d,h],sizing_mode:r});default:throw new Error("unexpected")}}},
}, 367, {"api/main":367,"api/index":368,"api/linalg":369,"core/util/random":370,"api/charts":371,"api/palettes":372,"api/models":373,"api/plotting":374,"api/gridplot":375}, {});
})

