<a href="https://bokeh.org">
  <img src="https://static.bokeh.org/logos/logotype.svg" height="60" alt="Bokeh logotype" />
</a>

----

[Bokeh](https://bokeh.org) is an interactive visualization library for modern web browsers. It provides elegant, concise construction of versatile graphics, and affords high-performance interactivity over large or streaming datasets. Bokeh can help anyone who would like to quickly and easily make interactive plots, dashboards, and data applications.

<table>
<tr>
  <td>Latest Release</td>
  <td>
    <img src="https://badge.fury.io/gh/bokeh%2Fbokeh.svg" alt="Latest release version" />
    <a href="https://badge.fury.io/js/%40bokeh%2Fbokehjs">
      <img src="https://badge.fury.io/js/%40bokeh%2Fbokehjs.svg" alt="npm version">
    </a>
  </td>

  <td>Conda</td>
  <td>
    <a href="https://docs.bokeh.org/en/latest/docs/installation.html">
    <img src="https://pyviz.org/_static/cache/bokeh_conda_downloads_badge.svg"
         alt="Conda downloads per month" />
    </a>
  </td>
</tr>

<tr>
  <td>License</td>
  <td>
    <a href="https://github.com/bokeh/bokeh/blob/master/LICENSE.txt">
    <img src="https://img.shields.io/github/license/bokeh/bokeh.svg"
         alt="Bokeh license (BSD 3-clause)" />
    </a>
  </td>

  <td>PyPI</td>
  <td>
    <a href="https://docs.bokeh.org/en/latest/docs/installation.html">
    <img src="https://img.shields.io/pypi/dm/bokeh.svg"
         alt="PyPI downloads per month" />
    </a>
  </td>
</tr>

<tr>
  <td>Sponsorship</td>
  <td>
    <a href="http://numfocus.org">
    <img src="https://img.shields.io/badge/powered%20by-NumFOCUS-black.svg?style=flat&colorA=5B5B5B&colorB=007D8A"
         alt="Powered by NumFOCUS" />
    </a>
  </td>

  <td>Live Tutorial</td>
  <td>
    <a href="https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb">
    <img src="https://mybinder.org/badge_logo.svg"
         alt="Live Bokeh tutorial notebooks on MyBinder" />
    </a>
  </td>
</tr>

<tr>
  <td>Build Status</td>
  <td>
    <a href="https://github.com/bokeh/bokeh/actions">
    <img src="https://github.com/bokeh/bokeh/workflows/GitHub-CI/badge.svg?branch=master"
         alt="Current github actions build status" />
    </a>
  </td>

  <td>Support</td>
  <td>
    <a href="https://discourse.bokeh.org">
    <img src="https://img.shields.io/discourse/https/discourse.bokeh.org/posts.svg"
         alt="Community Support on discourse.bokeh.org" />
    </a>
  </td>
</tr>

<tr>
  <td>Static Analysis</td>
  <td>
    <a href="https://lgtm.com/projects/g/bokeh/bokeh/context:python">
    <img alt="Language grade: Python" src="https://img.shields.io/lgtm/grade/python/g/bokeh/bokeh.svg?"/>
    </a>
    <a href="https://lgtm.com/projects/g/bokeh/bokeh/context:javascript">
    <img alt="Language grade: JavaScript" src="https://img.shields.io/lgtm/grade/javascript/g/bokeh/bokeh.svg"/>
    </a>
  </td>

  <td>Twitter</td>
  <td>
    <a href="https://twitter.com/bokeh">
    <img src="https://img.shields.io/twitter/follow/bokeh.svg?style=social&label=Follow"
         alt="Follow Bokeh on Twitter" />
    </a>
  </td>
</tr>

</table>

*If you like Bokeh and would like to support our mission, please consider [making a donation](https://numfocus.org/donate-to-bokeh).*

<p>
<table>
<tr>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/image.html">
  <img alt="colormapped image plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/image_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/anscombe.html">
  <img alt="anscombe plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/anscombe_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/stocks.html">
  <img alt="stocks plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/stocks_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/lorenz.html">
  <img alt="lorenz attractor plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/lorenz_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/candlestick.html">
  <img alt="candlestick plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/candlestick_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/color_scatter.html">
  <img alt="scatter plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/scatter_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/iris_splom.html">
  <img alt="SPLOM plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/splom_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/iris.html">
  <img alt="iris dataset plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/iris_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/histogram.html">
  <img alt="histogram plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/histogram_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/periodic.html">
  <img alt="periodic table plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/periodic_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/texas.html">
  <img alt="choropleth plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/choropleth_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/burtin.html">
  <img alt="burtin antibiotic data plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/burtin_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/streamline.html">
  <img alt="streamline plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/streamline_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/image_rgba.html">
  <img alt="RGBA image plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/image_rgba_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/brewer.html">
  <img alt="stacked bars plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/stacked_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/quiver.html">
  <img alt="quiver plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/quiver_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/elements.html">
  <img alt="elements data plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/elements_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/boxplot.html">
  <img alt="boxplot thumbnail" src="https://docs.bokeh.org/en/latest/_images/boxplot_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/categorical.html">
  <img alt="categorical plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/categorical_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/unemployment.html">
  <img alt="unemployment data plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/unemployment_t.png" />
  </a>
  </td>

  <td>
  <a href="https://docs.bokeh.org/en/latest/docs/gallery/les_mis.html">
  <img alt="Les Mis co-occurrence plot thumbnail" src="https://docs.bokeh.org/en/latest/_images/les_mis_t.png" />
  </a>
  </td>

</tr>
</table>
</p>

Installation
------------

The easiest way to install Bokeh is using the [Anaconda Python distribution](https://www.anaconda.com/what-is-anaconda/) and its included *Conda* package management system. To install Bokeh and its required dependencies, enter the following command at a Bash or Windows command prompt:

```
conda install bokeh
```

To install using pip, enter the following command at a Bash or Windows command prompt:
```
pip install bokeh
```

For more information, refer to the [installation documentation](https://docs.bokeh.org/en/latest/docs/user_guide/quickstart.html#quick-installation).

Resources
---------

Once Bokeh is installed, check out the [Getting Started](https://docs.bokeh.org/en/latest/docs/user_guide/quickstart.html#getting-started) section of the [Quickstart guide](https://docs.bokeh.org/en/latest/docs/user_guide/quickstart.html).

Visit the [full documentation site](https://docs.bokeh.org) to view the [User's Guide](https://docs.bokeh.org/en/dev/docs/user_guide.html) or [launch the Bokeh tutorial](https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb) to learn about Bokeh in live Jupyter Notebooks.

Community support is available on the [Project Discourse](https://discourse.bokeh.org).

If you would like to contribute to Bokeh, please review the [Developer Guide](https://docs.bokeh.org/en/latest/docs/dev_guide.html) and say hello on the [Zulip Chat for Developers](https://bokeh.zulipchat.com/).

Follow us
---------

Follow us on Twitter [@bokeh](https://twitter.com/bokeh)

Sponsors
--------

The Bokeh project is grateful for [individual contributions](https://numfocus.org/donate-to-bokeh) as well as sponsorship by the organizations and companies below:

<table>
<tr>
  <td>
    <a href="https://www.numfocus.org/">
    <img src="https://static.bokeh.org/sponsor/numfocus.svg"
         alt="NumFocus Logo" width="200"/>
    </a>
  </td>
  <td>
    <a href="https://www.anaconda.com/">
    <img src="https://static.bokeh.org/sponsor/anaconda.png"
         alt="Anaconda Logo" width="200"/>
    </a>
  </td>
  <td>
    <a href="https://www.nvidia.com">
    <img src="https://static.bokeh.org/sponsor/nvidia.png"
         alt="NVidia Logo" width="200"/>
    </a>
  </td>
  <td>
    <a href="https://developer.nvidia.com/rapids">
    <img src="https://static.bokeh.org/sponsor/rapids.png"
         alt="Rapids Logo" width="200"/>
    </a>
  </td>
</tr>
</table>


<table align="center">
<tr>
  <td>
    <a href="https://www.quansight.com">
    <img src="https://static.bokeh.org/sponsor/quansight.png"
         alt="Quansight Logo" width="100"/>
    </a>
  </td>
  <td>
    <a href="https://www.rexhomes.com/">
    <img src="https://static.bokeh.org/sponsor/rex.jpg"
         alt="Rex Logo" width="100"/>
    </a>
  </td>
</tr>
</table>

If your company uses Bokeh and is able to sponsor the project, please contact <a href="info@bokeh.org">info@bokeh.org</a>

*Bokeh is a Sponsored Project of NumFOCUS, a 501(c)(3) nonprofit charity in the United States. NumFOCUS provides Bokeh with fiscal, legal, and administrative support to help ensure the health and sustainability of the project. Visit [numfocus.org](https://numfocus.org) for more information.*

*Donations to Bokeh are managed by NumFOCUS. For donors in the United States, your gift is tax-deductible to the extent provided by law. As with any donation, you should consult with your tax adviser about your particular tax situation.*

Security
--------

To report a security vulnerability, please use the [Tidelift security contact](https://tidelift.com/security).
Tidelift will coordinate the fix and disclosure.
