/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,e){var i;i=t.Bokeh,function(t,e,n){if(null!=i)return i.register_plugin(t,{"core/menus":400,"models/widgets/abstract_button":401,"models/widgets/abstract_icon":402,"models/widgets/abstract_slider":403,"models/widgets/autocomplete_input":404,"models/widgets/button":405,"models/widgets/checkbox_button_group":406,"models/widgets/checkbox_group":407,"models/widgets/date_picker":408,"models/widgets/date_range_slider":409,"models/widgets/date_slider":410,"models/widgets/div":411,"models/widgets/dropdown":412,"models/widgets/index":413,"models/widgets/input_widget":414,"models/widgets/main":415,"models/widgets/markup":416,"models/widgets/multiselect":417,"models/widgets/panel":418,"models/widgets/paragraph":419,"models/widgets/password_input":420,"models/widgets/pretext":421,"models/widgets/radio_button_group":422,"models/widgets/radio_group":423,"models/widgets/range_slider":424,"models/widgets/selectbox":425,"models/widgets/slider":426,"models/widgets/tabs":427,"models/widgets/text_input":428,"models/widgets/toggle":429,"models/widgets/widget":440},415);throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.")}({400:function(t,e,n){var i=t(19);n.clear_menus=new i.Signal0({},"clear_menus"),document.addEventListener("click",function(){return n.clear_menus.emit()})},401:function(t,e,n){var i=t(391),r=t(15),o=t(5),s=t(4),a=t(440),l=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(t,n),t.prototype.initialize=function(t){n.prototype.initialize.call(this,t),this.icon_views={},this.render()},t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.remove=function(){s.remove_views(this.icon_views),n.prototype.remove.call(this)},t.prototype._render_button=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return o.button.apply(void 0,[{type:"button",disabled:this.model.disabled,class:["bk-bs-btn","bk-bs-btn-"+this.model.button_type]}].concat(t))},t.prototype.render=function(){var e=this;n.prototype.render.call(this),o.empty(this.el),this.buttonEl=this._render_button(this.model.label),this.buttonEl.addEventListener("click",function(t){return e._button_click(t)}),this.el.appendChild(this.buttonEl);var t=this.model.icon;null!=t&&(s.build_views(this.icon_views,[t],{parent:this}),o.prepend(this.buttonEl,this.icon_views[t.id].el,o.nbsp))},t.prototype._button_click=function(t){t.preventDefault(),this.change_input()},t.prototype.change_input=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},t}(a.WidgetView);n.AbstractButtonView=l;var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="AbstractButton",this.define({label:[r.String,"Button"],icon:[r.Instance],button_type:[r.String,"default"],callback:[r.Instance]})},t}(a.Widget);(n.AbstractButton=u).initClass()},402:function(t,e,n){var i=t(391),r=t(440),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e}(r.WidgetView);n.AbstractIconView=o;var s=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="AbstractIcon"},t}(r.Widget);(n.AbstractIcon=s).initClass()},403:function(t,e,n){var i=t(391),f=t(431),r=t(15),m=t(5),v=t(14),g=t(21),y=t(25),o=t(440),s=function(p){function t(){return null!==p&&p.apply(this,arguments)||this}return i.__extends(t,p),t.prototype.initialize=function(t){p.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;p.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){var r=this;if(null==this.sliderEl&&p.prototype.render.call(this),null!=this.model.callback){var t=function(){return r.model.callback.execute(r.model)};switch(this.model.callback_policy){case"continuous":this.callback_wrapper=t;break;case"throttle":this.callback_wrapper=y.throttle(t,this.model.callback_throttle)}}var e,o="bk-noUi-",n=this._calc_to(),i=n.start,s=n.end,a=n.value,l=n.step;if(this.model.tooltips){var u={to:function(t){return r.model.pretty(t)}};e=g.repeat(u,a.length)}else e=!1;if(this.el.classList.add("bk-slider"),null==this.sliderEl){this.sliderEl=m.div(),this.el.appendChild(this.sliderEl),f.create(this.sliderEl,{cssPrefix:o,range:{min:i,max:s},start:a,step:l,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:e,orientation:this.model.orientation,direction:this.model.direction}),this.sliderEl.noUiSlider.on("slide",function(t,e,n){return r._slide(n)}),this.sliderEl.noUiSlider.on("change",function(t,e,n){return r._change(n)});var c=this.sliderEl.querySelector("."+o+"handle");c.setAttribute("tabindex","0"),c.addEventListener("keydown",function(t){var e=r._calc_to().value[0];switch(t.which){case 37:e=Math.max(e-l,i);break;case 39:e=Math.min(e+l,s);break;default:return}var n=r.model.pretty(e);v.logger.debug("[slider keypress] value = "+n),r.model.value=e,r.sliderEl.noUiSlider.set(e),null!=r.valueEl&&(r.valueEl.textContent=n),null!=r.callback_wrapper&&r.callback_wrapper()});var d=function(t,e){var n=r.sliderEl.querySelectorAll("."+o+"handle")[t],i=n.querySelector("."+o+"tooltip");i.style.display=e?"block":""};this.sliderEl.noUiSlider.on("start",function(t,e){return d(e,!0)}),this.sliderEl.noUiSlider.on("end",function(t,e){return d(e,!1)})}else this.sliderEl.noUiSlider.updateOptions({range:{min:i,max:s},start:a,step:l});if(null!=this.titleEl&&this.el.removeChild(this.titleEl),null!=this.valueEl&&this.el.removeChild(this.valueEl),null!=this.model.title&&(0!=this.model.title.length&&(this.titleEl=m.label({},this.model.title+":"),this.el.insertBefore(this.titleEl,this.sliderEl)),this.model.show_value)){var h=a.map(function(t){return r.model.pretty(t)}).join(" .. ");this.valueEl=m.div({class:"bk-slider-value"},h),this.el.insertBefore(this.valueEl,this.sliderEl)}this.model.disabled||(this.sliderEl.querySelector("."+o+"connect").style.backgroundColor=this.model.bar_color),this.model.disabled?this.sliderEl.setAttribute("disabled","true"):this.sliderEl.removeAttribute("disabled")},t.prototype._slide=function(t){var e=this,n=this._calc_from(t),i=t.map(function(t){return e.model.pretty(t)}).join(" .. ");v.logger.debug("[slider slide] value = "+i),null!=this.valueEl&&(this.valueEl.textContent=i),this.model.value=n,null!=this.callback_wrapper&&this.callback_wrapper()},t.prototype._change=function(t){var e=this,n=this._calc_from(t),i=t.map(function(t){return e.model.pretty(t)}).join(" .. ");switch(v.logger.debug("[slider change] value = "+i),null!=this.valueEl&&(this.valueEl.dataset.value=i),this.model.value=n,this.model.callback_policy){case"mouseup":case"throttle":null!=this.model.callback&&this.model.callback.execute(this.model)}},t}(o.WidgetView);n.AbstractSliderView=s;var a=function(n){function t(t){var e=n.call(this,t)||this;return e.connected=!1,e}return i.__extends(t,n),t.initClass=function(){this.prototype.type="AbstractSlider",this.define({title:[r.String,""],show_value:[r.Bool,!0],start:[r.Any],end:[r.Any],value:[r.Any],step:[r.Number,1],format:[r.String],orientation:[r.Orientation,"horizontal"],direction:[r.Any,"ltr"],tooltips:[r.Boolean,!0],callback:[r.Instance],callback_throttle:[r.Number,200],callback_policy:[r.String,"throttle"],bar_color:[r.Color,"#e6e6e6"]})},t.prototype._formatter=function(t,e){return""+t},t.prototype.pretty=function(t){return this._formatter(t,this.format)},t}(o.Widget);(n.AbstractSlider=a).initClass()},404:function(t,e,n){var i=t(391),r=t(428),s=t(5),o=t(400),a=t(15),l=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),o.clear_menus.connect(function(){return t._clear_menu()})},t.prototype.render=function(){var e=this;n.prototype.render.call(this),this.inputEl.classList.add("bk-autocomplete-input"),this.inputEl.addEventListener("keydown",function(t){return e._keydown(t)}),this.inputEl.addEventListener("keyup",function(t){return e._keyup(t)}),this.menuEl=s.ul({class:"bk-bs-dropdown-menu"}),this.menuEl.addEventListener("click",function(t){return e._item_click(t)}),this.el.appendChild(this.menuEl)},t.prototype._render_items=function(t){s.empty(this.menuEl);for(var e=0,n=t;e<n.length;e++){var i=n[e],r=s.li({},s.a({data:{text:i}},i));this.menuEl.appendChild(r)}},t.prototype._open_menu=function(){this.el.classList.add("bk-bs-open")},t.prototype._clear_menu=function(){this.el.classList.remove("bk-bs-open")},t.prototype._item_click=function(t){if(t.preventDefault(),t.target!=t.currentTarget){var e=t.target,n=e.dataset.text;this.model.value=n}},t.prototype._keydown=function(t){},t.prototype._keyup=function(t){switch(t.keyCode){case s.Keys.Enter:console.log("enter");break;case s.Keys.Esc:this._clear_menu();break;case s.Keys.Up:case s.Keys.Down:console.log("up/down");break;default:var e=this.inputEl.value;if(e.length<=1)return void this._clear_menu();for(var n=[],i=0,r=this.model.completions;i<r.length;i++){var o=r[i];-1!=o.indexOf(e)&&n.push(o)}0==n.length?this._clear_menu():(this._render_items(n),this._open_menu())}},t}(r.TextInputView);n.AutocompleteInputView=l;var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="AutocompleteInput",this.prototype.default_view=l,this.define({completions:[a.Array,[]]}),this.internal({active:[a.Boolean,!0]})},t}(r.TextInput);(n.AutocompleteInput=u).initClass()},405:function(t,e,n){var i=t(391),r=t(15),o=t(3),s=t(401),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.change_input=function(){this.model.trigger_event(new o.ButtonClick({})),this.model.clicks=this.model.clicks+1,t.prototype.change_input.call(this)},e}(s.AbstractButtonView);n.ButtonView=a;var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Button",this.prototype.default_view=a,this.define({clicks:[r.Number,0]}),o.register_with_event(o.ButtonClick,this)},t}(s.AbstractButton);(n.Button=l).initClass()},406:function(t,e,n){var i=t(391),l=t(5),r=t(15),u=t(21),o=t(440),s=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(t,n),t.prototype.initialize=function(t){n.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){var i=this;n.prototype.render.call(this),l.empty(this.el);var r=l.div({class:"bk-bs-btn-group"});this.el.appendChild(r);for(var o=this.model.active,s=this.model.labels,t=function(t){var e=l.input({type:"checkbox",value:""+t,checked:t in o});e.addEventListener("change",function(){return i.model.change_input(t)});var n=l.label({class:["bk-bs-btn","bk-bs-btn-"+a.model.button_type]},e,s[t]);u.includes(o,t)&&n.classList.add("bk-bs-active"),r.appendChild(n)},a=this,e=0;e<s.length;e++)t(e)},t}(o.WidgetView);n.CheckboxButtonGroupView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.prototype.change_input=function(e){var t=u.copy(this.active);u.includes(t,e)?u.removeBy(t,function(t){return e==t}):t.push(e),t.sort(),this.active=t,null!=this.callback&&this.callback.execute(this)},t.initClass=function(){this.prototype.type="CheckboxButtonGroup",this.prototype.default_view=s,this.define({active:[r.Array,[]],labels:[r.Array,[]],button_type:[r.String,"default"],callback:[r.Instance]})},t}(o.Widget);(n.CheckboxButtonGroup=a).initClass()},407:function(t,e,n){var i=t(391),u=t(5),r=t(15),c=t(21),o=t(440),s=function(l){function t(){return null!==l&&l.apply(this,arguments)||this}return i.__extends(t,l),t.prototype.initialize=function(t){l.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;l.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){var t=this;l.prototype.render.call(this),u.empty(this.el);for(var e=this.model.active,n=this.model.labels,i=0;i<n.length;i++){var r=n[i],o=u.input({type:"checkbox",value:""+i});o.addEventListener("change",function(){return t.change_input()}),this.model.disabled&&(o.disabled=!0),c.includes(e,i)&&(o.checked=!0);var s=u.label({},o,r);if(this.model.inline)s.classList.add("bk-bs-checkbox-inline"),this.el.appendChild(s);else{var a=u.div({class:"bk-bs-checkbox"},s);this.el.appendChild(a)}}},t.prototype.change_input=function(){for(var t=this.el.querySelectorAll("input"),e=[],n=0;n<t.length;n++){var i=t[n];i.checked&&e.push(n)}this.model.active=e,null!=this.model.callback&&this.model.callback.execute(this.model)},t}(o.WidgetView);n.CheckboxGroupView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="CheckboxGroup",this.prototype.default_view=s,this.define({active:[r.Array,[]],labels:[r.Array,[]],inline:[r.Bool,!1],callback:[r.Instance]})},t}(o.Widget);(n.CheckboxGroup=a).initClass()},408:function(t,e,n){var i=t(391),r=t(414),o=t(5),s=t(15),a=t(432);a.prototype.adjustPosition=function(){if(!this._o.container){this.el.style.position="absolute";var t=this._o.trigger,e=this.el.offsetWidth,n=this.el.offsetHeight,i=window.innerWidth||document.documentElement.clientWidth,r=window.innerHeight||document.documentElement.clientHeight,o=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,s=t.getBoundingClientRect(),a=s.left+window.pageXOffset,l=s.bottom+window.pageYOffset;a-=this.el.parentElement.offsetLeft,l-=this.el.parentElement.offsetTop,(this._o.reposition&&i<a+e||-1<this._o.position.indexOf("right")&&0<a-e+t.offsetWidth)&&(a=a-e+t.offsetWidth),(this._o.reposition&&r+o<l+n||-1<this._o.position.indexOf("top")&&0<l-n-t.offsetHeight)&&(l=l-n-t.offsetHeight),this.el.style.left=a+"px",this.el.style.top=l+"px"}};var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-widget-form-group")},e.prototype.render=function(){var e=this;t.prototype.render.call(this),null!=this._picker&&this._picker.destroy(),o.empty(this.el),this.labelEl=o.label({},this.model.title),this.el.appendChild(this.labelEl),this.inputEl=o.input({type:"text",class:"bk-widget-form-input",disabled:this.model.disabled}),this.el.appendChild(this.inputEl),this._picker=new a({field:this.inputEl,defaultDate:new Date(this.model.value),setDefaultDate:!0,minDate:null!=this.model.min_date?new Date(this.model.min_date):void 0,maxDate:null!=this.model.max_date?new Date(this.model.max_date):void 0,onSelect:function(t){return e._on_select(t)}}),this._root_element.appendChild(this._picker.el)},e.prototype._on_select=function(t){this.model.value=t.toDateString(),this.change_input()},e}(r.InputWidgetView);n.DatePickerView=l;var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="DatePicker",this.prototype.default_view=l,this.define({value:[s.Any,(new Date).toDateString()],min_date:[s.Any],max_date:[s.Any]})},t}(r.InputWidget);(n.DatePicker=u).initClass()},409:function(t,e,n){var i=t(391),r=t(390),o=t(403),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}},e.prototype._calc_from=function(t){return t},e}(o.AbstractSliderView);n.DateRangeSliderView=s;var a=function(n){function t(t){var e=n.call(this,t)||this;return e.behaviour="drag",e.connected=[!1,!0,!1],e}return i.__extends(t,n),t.initClass=function(){this.prototype.type="DateRangeSlider",this.prototype.default_view=s,this.override({format:"%d %b %Y"})},t.prototype._formatter=function(t,e){return r(t,e)},t}(o.AbstractSlider);(n.DateRangeSlider=a).initClass()},410:function(t,e,n){var i=t(391),r=t(390),o=t(403),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}},e.prototype._calc_from=function(t){var e=t[0];return e},e}(o.AbstractSliderView);n.DateSliderView=s;var a=function(n){function t(t){var e=n.call(this,t)||this;return e.behaviour="tap",e.connected=[!0,!1],e}return i.__extends(t,n),t.initClass=function(){this.prototype.type="DateSlider",this.prototype.default_view=s,this.override({format:"%d %b %Y"})},t.prototype._formatter=function(t,e){return r(t,e)},t}(o.AbstractSlider);(n.DateSlider=a).initClass()},411:function(t,e,n){var i=t(391),r=t(416),o=t(5),s=t(15),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.render=function(){e.prototype.render.call(this);var t=o.div();this.model.render_as_text?t.textContent=this.model.text:t.innerHTML=this.model.text,this.markupEl.appendChild(t)},t}(r.MarkupView);n.DivView=a;var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Div",this.prototype.default_view=a,this.define({render_as_text:[s.Bool,!1]})},t}(r.Markup);(n.Div=l).initClass()},412:function(t,e,n){var i=t(391),h=t(5),r=t(400),o=t(15),s=t(401),a=function(d){function t(){return null!==d&&d.apply(this,arguments)||this}return i.__extends(t,d),t.prototype.connect_signals=function(){var t=this;d.prototype.connect_signals.call(this),r.clear_menus.connect(function(){return t._clear_menu()})},t.prototype.render=function(){var e=this;if(d.prototype.render.call(this),this.model.is_split_button){this.el.classList.add("bk-bs-btn-group");var t=this._render_button(h.span({class:"bk-bs-caret"}));t.classList.add("bk-bs-dropdown-toggle"),t.addEventListener("click",function(t){return e._caret_click(t)}),this.el.appendChild(t)}else this.el.classList.add("bk-bs-dropdown"),this.buttonEl.classList.add("bk-bs-dropdown-toggle"),this.buttonEl.appendChild(h.span({class:"bk-bs-caret"}));this.model.active&&this.el.classList.add("bk-bs-open");for(var n=[],i=0,r=this.model.menu;i<r.length;i++){var o=r[i],s=void 0;if(null!=o){var a=o[0],l=o[1],u=h.a({},a);u.dataset.value=l,u.addEventListener("click",function(t){return e._item_click(t)}),s=h.li({},u)}else s=h.li({class:"bk-bs-divider"});n.push(s)}var c=h.ul({class:"bk-bs-dropdown-menu"},n);this.el.appendChild(c)},t.prototype._clear_menu=function(){this.model.active=!1},t.prototype._toggle_menu=function(){var t=this.model.active;r.clear_menus.emit(),t||(this.model.active=!0)},t.prototype._button_click=function(t){t.preventDefault(),t.stopPropagation(),this.model.is_split_button?(this._clear_menu(),this.set_value(this.model.default_value)):this._toggle_menu()},t.prototype._caret_click=function(t){t.preventDefault(),t.stopPropagation(),this._toggle_menu()},t.prototype._item_click=function(t){t.preventDefault(),this._clear_menu(),this.set_value(t.currentTarget.dataset.value)},t.prototype.set_value=function(t){this.buttonEl.value=this.model.value=t,this.change_input()},t}(s.AbstractButtonView);n.DropdownView=a;var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Dropdown",this.prototype.default_view=a,this.define({value:[o.String],default_value:[o.String],menu:[o.Array,[]]}),this.override({label:"Dropdown"}),this.internal({active:[o.Boolean,!1]})},Object.defineProperty(t.prototype,"is_split_button",{get:function(){return null!=this.default_value},enumerable:!0,configurable:!0}),t}(s.AbstractButton);(n.Dropdown=l).initClass()},413:function(t,e,n){var i=t(401);n.AbstractButton=i.AbstractButton;var r=t(402);n.AbstractIcon=r.AbstractIcon;var o=t(404);n.AutocompleteInput=o.AutocompleteInput;var s=t(405);n.Button=s.Button;var a=t(406);n.CheckboxButtonGroup=a.CheckboxButtonGroup;var l=t(407);n.CheckboxGroup=l.CheckboxGroup;var u=t(408);n.DatePicker=u.DatePicker;var c=t(409);n.DateRangeSlider=c.DateRangeSlider;var d=t(410);n.DateSlider=d.DateSlider;var h=t(411);n.Div=h.Div;var p=t(412);n.Dropdown=p.Dropdown;var f=t(414);n.InputWidget=f.InputWidget;var m=t(416);n.Markup=m.Markup;var v=t(417);n.MultiSelect=v.MultiSelect;var g=t(418);n.Panel=g.Panel;var y=t(419);n.Paragraph=y.Paragraph;var b=t(420);n.PasswordInput=b.PasswordInput;var _=t(421);n.PreText=_.PreText;var w=t(422);n.RadioButtonGroup=w.RadioButtonGroup;var x=t(423);n.RadioGroup=x.RadioGroup;var k=t(424);n.RangeSlider=k.RangeSlider;var S=t(425);n.Select=S.Select;var C=t(426);n.Slider=C.Slider;var E=t(427);n.Tabs=E.Tabs;var D=t(428);n.TextInput=D.TextInput;var M=t(429);n.Toggle=M.Toggle;var A=t(440);n.Widget=A.Widget},414:function(t,e,n){var i=t(391),r=t(440),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.change_input=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e}(r.WidgetView);n.InputWidgetView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="InputWidget",this.prototype.default_view=s,this.define({title:[o.String,""],callback:[o.Instance]})},t}(r.Widget);(n.InputWidget=a).initClass()},415:function(t,e,n){var i=t(413);n.Widgets=i;var r=t(0);r.register_models(i)},416:function(t,e,n){var i=t(391),r=t(15),o=t(5),s=t(440),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){e.prototype.render.call(this),o.empty(this.el);var t=i.__assign({width:this.model.width+"px",height:this.model.height+"px"},this.model.style);this.markupEl=o.div({style:t}),this.el.appendChild(this.markupEl)},t}(s.WidgetView);n.MarkupView=a;var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Markup",this.define({text:[r.String,""],style:[r.Any,{}]})},t}(s.Widget);(n.Markup=l).initClass()},417:function(t,e,n){var i=t(391),r=t(5),s=t(44),a=t(29),o=t(15),l=t(414),u=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return i.__extends(t,o),t.prototype.initialize=function(t){o.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;o.prototype.connect_signals.call(this),this.connect(this.model.properties.value.change,function(){return t.render_selection()}),this.connect(this.model.properties.options.change,function(){return t.render()}),this.connect(this.model.properties.name.change,function(){return t.render()}),this.connect(this.model.properties.title.change,function(){return t.render()}),this.connect(this.model.properties.size.change,function(){return t.render()}),this.connect(this.model.properties.disabled.change,function(){return t.render()})},t.prototype.render=function(){var t=this;o.prototype.render.call(this),r.empty(this.el);var e=r.label({for:this.model.id},this.model.title);this.el.appendChild(e);var n=this.model.options.map(function(t){var e,n;return s.isString(t)?e=n=t:(e=t[0],n=t[1]),r.option({value:e},n)});this.selectEl=r.select({multiple:!0,class:"bk-widget-form-input",id:this.model.id,name:this.model.name,disabled:this.model.disabled},n),this.selectEl.addEventListener("change",function(){return t.change_input()}),this.el.appendChild(this.selectEl),this.render_selection()},t.prototype.render_selection=function(){for(var t=new a.Set(this.model.value),e=0,n=Array.from(this.el.querySelectorAll("option"));e<n.length;e++){var i=n[e];i.selected=t.has(i.value)}this.selectEl.size=this.model.size},t.prototype.change_input=function(){for(var t=null!=this.el.querySelector("select:focus"),e=[],n=0,i=Array.from(this.el.querySelectorAll("option"));n<i.length;n++){var r=i[n];r.selected&&e.push(r.value)}this.model.value=e,o.prototype.change_input.call(this),t&&this.selectEl.focus()},t}(l.InputWidgetView);n.MultiSelectView=u;var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="MultiSelect",this.prototype.default_view=u,this.define({value:[o.Array,[]],options:[o.Array,[]],size:[o.Number,4]})},t}(l.InputWidget);(n.MultiSelect=c).initClass()},418:function(t,e,n){var i=t(391),r=t(440),o=t(15),s=t(5),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),s.empty(this.el)},e}(r.WidgetView);n.PanelView=a;var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Panel",this.prototype.default_view=a,this.define({title:[o.String,""],child:[o.Instance],closable:[o.Bool,!1]})},t}(r.Widget);(n.Panel=l).initClass()},419:function(t,e,n){var i=t(391),r=t(416),o=t(5),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.render=function(){e.prototype.render.call(this);var t=o.p({style:{margin:0}},this.model.text);this.markupEl.appendChild(t)},t}(r.MarkupView);n.ParagraphView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Paragraph",this.prototype.default_view=s},t}(r.Markup);(n.Paragraph=a).initClass()},420:function(t,e,n){var i=t(391),r=t(428),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.inputEl.type="password"},e}(r.TextInputView);n.PasswordInputView=o;var s=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="PasswordInput",this.prototype.default_view=o},t}(r.TextInput);(n.PasswordInput=s).initClass()},421:function(t,e,n){var i=t(391),r=t(416),o=t(5),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.render=function(){e.prototype.render.call(this);var t=o.pre({style:{overflow:"auto"}},this.model.text);this.markupEl.appendChild(t)},t}(r.MarkupView);n.PreTextView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="PreText",this.prototype.default_view=s},t}(r.Markup);(n.PreText=a).initClass()},422:function(t,e,n){var i=t(391),c=t(5),d=t(38),r=t(15),o=t(440),s=function(u){function t(){return null!==u&&u.apply(this,arguments)||this}return i.__extends(t,u),t.prototype.initialize=function(t){u.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;u.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){var t=this;u.prototype.render.call(this),c.empty(this.el);var e=c.div({class:"bk-bs-btn-group"});this.el.appendChild(e);for(var n=d.uniqueId(),i=this.model.active,r=this.model.labels,o=0;o<r.length;o++){var s=r[o],a=c.input({type:"radio",name:n,value:""+o,checked:o==i});a.addEventListener("change",function(){return t.change_input()});var l=c.label({class:["bk-bs-btn","bk-bs-btn-"+this.model.button_type]},a,s);o==i&&l.classList.add("bk-bs-active"),e.appendChild(l)}},t.prototype.change_input=function(){for(var t=this.el.querySelectorAll("input"),e=[],n=0;n<t.length;n++){var i=t[n];i.checked&&e.push(n)}this.model.active=e[0],null!=this.model.callback&&this.model.callback.execute(this.model)},t}(o.WidgetView);n.RadioButtonGroupView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="RadioButtonGroup",this.prototype.default_view=s,this.define({active:[r.Any,null],labels:[r.Array,[]],button_type:[r.String,"default"],callback:[r.Instance]})},t}(o.Widget);(n.RadioButtonGroup=a).initClass()},423:function(t,e,n){var i=t(391),c=t(5),d=t(38),r=t(15),o=t(440),s=function(u){function t(){return null!==u&&u.apply(this,arguments)||this}return i.__extends(t,u),t.prototype.initialize=function(t){u.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;u.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.render=function(){var t=this;u.prototype.render.call(this),c.empty(this.el);for(var e=d.uniqueId(),n=this.model.active,i=this.model.labels,r=0;r<i.length;r++){var o=i[r],s=c.input({type:"radio",name:e,value:""+r});s.addEventListener("change",function(){return t.change_input()}),this.model.disabled&&(s.disabled=!0),r==n&&(s.checked=!0);var a=c.label({},s,o);if(this.model.inline)a.classList.add("bk-bs-radio-inline"),this.el.appendChild(a);else{var l=c.div({class:"bk-bs-radio"},a);this.el.appendChild(l)}}},t.prototype.change_input=function(){for(var t=this.el.querySelectorAll("input"),e=[],n=0;n<t.length;n++){var i=t[n];i.checked&&e.push(n)}this.model.active=e[0],null!=this.model.callback&&this.model.callback.execute(this.model)},t}(o.WidgetView);n.RadioGroupView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="RadioGroup",this.prototype.default_view=s,this.define({active:[r.Any,null],labels:[r.Array,[]],inline:[r.Bool,!1],callback:[r.Instance]})},t}(o.Widget);(n.RadioGroup=a).initClass()},424:function(t,e,n){var i=t(391),r=t(361),o=t(403),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}},e.prototype._calc_from=function(t){return t},e}(o.AbstractSliderView);n.RangeSliderView=s;var a=function(n){function t(t){var e=n.call(this,t)||this;return e.behaviour="drag",e.connected=[!1,!0,!1],e}return i.__extends(t,n),t.initClass=function(){this.prototype.type="RangeSlider",this.prototype.default_view=s,this.override({format:"0[.]00"})},t.prototype._formatter=function(t,e){return r.format(t,e)},t}(o.AbstractSlider);(n.RangeSlider=a).initClass()},425:function(t,e,n){var i=t(391),a=t(5),l=t(44),r=t(14),o=t(15),s=t(414),u=function(s){function t(){return null!==s&&s.apply(this,arguments)||this}return i.__extends(t,s),t.prototype.initialize=function(t){s.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;s.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.build_options=function(t){var r=this;return t.map(function(t){var e,n;l.isString(t)?e=n=t:(e=t[0],n=t[1]);var i=r.model.value==e;return a.option({selected:i,value:e},n)})},t.prototype.render=function(){var t=this;s.prototype.render.call(this),a.empty(this.el);var e,n=a.label({for:this.model.id},this.model.title);if(this.el.appendChild(n),l.isArray(this.model.options))e=this.build_options(this.model.options);else{e=[];var i=this.model.options;for(var r in i){var o=i[r];e.push(a.optgroup({label:r},this.build_options(o)))}}this.selectEl=a.select({class:"bk-widget-form-input",id:this.model.id,name:this.model.name,disabled:this.model.disabled},e),this.selectEl.addEventListener("change",function(){return t.change_input()}),this.el.appendChild(this.selectEl)},t.prototype.change_input=function(){var t=this.selectEl.value;r.logger.debug("selectbox: value = "+t),this.model.value=t,s.prototype.change_input.call(this)},t}(s.InputWidgetView);n.SelectView=u;var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Select",this.prototype.default_view=u,this.define({value:[o.String,""],options:[o.Any,[]]})},t}(s.InputWidget);(n.Select=c).initClass()},426:function(t,e,n){var i=t(391),r=t(361),o=t(403),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}},e.prototype._calc_from=function(t){var e=t[0];return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(e):e},e}(o.AbstractSliderView);n.SliderView=s;var a=function(n){function t(t){var e=n.call(this,t)||this;return e.behaviour="tap",e.connected=[!0,!1],e}return i.__extends(t,n),t.initClass=function(){this.prototype.type="Slider",this.prototype.default_view=s,this.override({format:"0[.]00"})},t.prototype._formatter=function(t,e){return r.format(t,e)},t}(o.AbstractSlider);(n.Slider=a).initClass()},427:function(t,e,n){var i=t(391),h=t(5),p=t(21),r=t(15),o=t(440),s=function(d){function t(){return null!==d&&d.apply(this,arguments)||this}return i.__extends(t,d),t.prototype.connect_signals=function(){var t=this;d.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,function(){return t.rebuild_child_views()}),this.connect(this.model.properties.active.change,function(){return t.render()})},t.prototype.render=function(){var r=this;d.prototype.render.call(this),h.empty(this.el);var t=this.model.tabs.length;if(0!=t){this.model.active>=t&&(this.model.active=t-1);var o=this.model.tabs.map(function(t,e){return h.li({},h.span({data:{index:e}},t.title))});o[this.model.active].classList.add("bk-bs-active");var e=h.ul({class:["bk-bs-nav","bk-bs-nav-tabs"]},o);this.el.appendChild(e);var s=this.model.tabs.map(function(t){return h.div({class:"bk-bs-tab-pane"})});s[this.model.active].classList.add("bk-bs-active");var n=h.div({class:"bk-bs-tab-content"},s);this.el.appendChild(n),e.addEventListener("click",function(t){if(t.preventDefault(),t.target!=t.currentTarget){var e=t.target,n=r.model.active,i=parseInt(e.dataset.index);n!=i&&(o[n].classList.remove("bk-bs-active"),s[n].classList.remove("bk-bs-active"),o[i].classList.add("bk-bs-active"),s[i].classList.add("bk-bs-active"),r.model.active=i,null!=r.model.callback&&r.model.callback.execute(r.model))}});for(var i=0,a=p.zip(this.model.children,s);i<a.length;i++){var l=a[i],u=l[0],c=l[1];c.appendChild(this.child_views[u.id].el)}}},t}(o.WidgetView);n.TabsView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Tabs",this.prototype.default_view=s,this.define({tabs:[r.Array,[]],active:[r.Number,0],callback:[r.Instance]})},t.prototype.get_layoutable_children=function(){return this.children},Object.defineProperty(t.prototype,"children",{get:function(){return this.tabs.map(function(t){return t.child})},enumerable:!0,configurable:!0}),t}(o.Widget);(n.Tabs=a).initClass()},428:function(t,e,n){var i=t(391),r=t(14),o=t(15),s=t(5),a=t(414),l=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(t,n),t.prototype.initialize=function(t){n.prototype.initialize.call(this,t),this.render()},t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t.prototype.css_classes=function(){return n.prototype.css_classes.call(this).concat("bk-widget-form-group")},t.prototype.render=function(){var t=this;n.prototype.render.call(this),s.empty(this.el);var e=s.label({for:this.model.id},this.model.title);this.el.appendChild(e),this.inputEl=s.input({type:"text",class:"bk-widget-form-input",id:this.model.id,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.inputEl.addEventListener("change",function(){return t.change_input()}),this.el.appendChild(this.inputEl),this.model.height&&(this.inputEl.style.height=this.model.height-35+"px")},t.prototype.change_input=function(){var t=this.inputEl.value;r.logger.debug("widget/text_input: value = "+t),this.model.value=t,n.prototype.change_input.call(this)},t}(a.InputWidgetView);n.TextInputView=l;var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="TextInput",this.prototype.default_view=l,this.define({value:[o.String,""],placeholder:[o.String,""]})},t}(a.InputWidget);(n.TextInput=u).initClass()},429:function(t,e,n){var i=t(391),r=t(401),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.active&&this.buttonEl.classList.add("bk-bs-active")},e.prototype.change_input=function(){this.model.active=!this.model.active,t.prototype.change_input.call(this)},e}(r.AbstractButtonView);n.ToggleView=s;var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Toggle",this.prototype.default_view=s,this.define({active:[o.Bool,!1]}),this.override({label:"Toggle"})},t}(r.AbstractButton);(n.Toggle=a).initClass()},440:function(t,e,n){var i=t(391),r=t(157),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-widget")},e.prototype.render=function(){this._render_classes(),null!=this.model.height&&(this.el.style.height=this.model.height+"px"),null!=this.model.width&&(this.el.style.width=this.model.width+"px")},e.prototype.get_width=function(){throw new Error("unused")},e.prototype.get_height=function(){throw new Error("unused")},e}(r.LayoutDOMView);n.WidgetView=o;var s=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Widget"},t}(r.LayoutDOM);(n.Widget=s).initClass()},431:function(t,e,n){
/*! nouislider - 10.1.0 - 2017-07-28 17:11:18 */var i;i=function(){"use strict";var $="10.1.0";function Q(t){t.preventDefault()}function r(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function Z(t,e,n){0<n&&(et(t,e),setTimeout(function(){nt(t,e)},n))}function tt(t){return Array.isArray(t)?t:[t]}function e(t){var e=(t=String(t)).split(".");return 1<e.length?e[1].length:0}function et(t,e){t.classList?t.classList.add(e):t.className+=" "+e}function nt(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function it(t){var e=void 0!==window.pageXOffset,n="CSS1Compat"===(t.compatMode||""),i=e?window.pageXOffset:n?t.documentElement.scrollLeft:t.body.scrollLeft,r=e?window.pageYOffset:n?t.documentElement.scrollTop:t.body.scrollTop;return{x:i,y:r}}function c(t,e){return 100/(e-t)}function d(t,e){return 100*e/(t[1]-t[0])}function h(t,e){for(var n=1;t>=e[n];)n+=1;return n}function n(t,e,n){if(n>=t.slice(-1)[0])return 100;var i,r,o,s,a,l,u=h(n,t);return i=t[u-1],r=t[u],o=e[u-1],s=e[u],o+(l=n,d(a=[i,r],a[0]<0?l+Math.abs(a[0]):l-a[0])/c(o,s))}function i(t,e,n,i){if(100===i)return i;var r,o,s,a,l=h(i,t);return n?(r=t[l-1],((o=t[l])-r)/2<i-r?o:r):e[l-1]?t[l-1]+(s=i-t[l-1],a=e[l-1],Math.round(s/a)*a):i}function o(t,e,n){var i;if("number"==typeof e&&(e=[e]),"[object Array]"!==Object.prototype.toString.call(e))throw new Error("noUiSlider ("+$+"): 'range' contains invalid value.");if(!r(i="min"===t?0:"max"===t?100:parseFloat(t))||!r(e[0]))throw new Error("noUiSlider ("+$+"): 'range' value isn't numeric.");n.xPct.push(i),n.xVal.push(e[0]),i?n.xSteps.push(!isNaN(e[1])&&e[1]):isNaN(e[1])||(n.xSteps[0]=e[1]),n.xHighestCompleteStep.push(0)}function s(t,e,n){if(!e)return!0;n.xSteps[t]=d([n.xVal[t],n.xVal[t+1]],e)/c(n.xPct[t],n.xPct[t+1]);var i=(n.xVal[t+1]-n.xVal[t])/n.xNumSteps[t],r=Math.ceil(Number(i.toFixed(3))-1),o=n.xVal[t]+n.xNumSteps[t]*r;n.xHighestCompleteStep[t]=o}function a(t,e,n){this.xPct=[],this.xVal=[],this.xSteps=[n||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var i,r=[];for(i in t)t.hasOwnProperty(i)&&r.push([t[i],i]);for(r.length&&"object"==typeof r[0][0]?r.sort(function(t,e){return t[0][0]-e[0][0]}):r.sort(function(t,e){return t[0]-e[0]}),i=0;i<r.length;i++)o(r[i][1],r[i][0],this);for(this.xNumSteps=this.xSteps.slice(0),i=0;i<this.xNumSteps.length;i++)s(i,this.xNumSteps[i],this)}a.prototype.getMargin=function(t){var e=this.xNumSteps[0];if(e&&t/e%1!=0)throw new Error("noUiSlider ("+$+"): 'limit', 'margin' and 'padding' must be divisible by step.");return 2===this.xPct.length&&d(this.xVal,t)},a.prototype.toStepping=function(t){return t=n(this.xVal,this.xPct,t)},a.prototype.fromStepping=function(t){return function(t,e,n){if(100<=n)return t.slice(-1)[0];var i,r,o,s,a,l=h(n,e);return i=t[l-1],r=t[l],o=e[l-1],s=e[l],a=[i,r],(n-o)*c(o,s)*(a[1]-a[0])/100+a[0]}(this.xVal,this.xPct,t)},a.prototype.getStep=function(t){return t=i(this.xPct,this.xSteps,this.snap,t)},a.prototype.getNearbySteps=function(t){var e=h(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e-0],step:this.xNumSteps[e-0],highestStep:this.xHighestCompleteStep[e-0]}}},a.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(e);return Math.max.apply(null,t)},a.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var l={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number};function u(t){if("object"==typeof(e=t)&&"function"==typeof e.to&&"function"==typeof e.from)return!0;var e;throw new Error("noUiSlider ("+$+"): 'format' requires 'to' and 'from' methods.")}function p(t,e){if(!r(e))throw new Error("noUiSlider ("+$+"): 'step' is not numeric.");t.singleStep=e}function f(t,e){if("object"!=typeof e||Array.isArray(e))throw new Error("noUiSlider ("+$+"): 'range' is not an object.");if(void 0===e.min||void 0===e.max)throw new Error("noUiSlider ("+$+"): Missing 'min' or 'max' in 'range'.");if(e.min===e.max)throw new Error("noUiSlider ("+$+"): 'range' 'min' and 'max' cannot be equal.");t.spectrum=new a(e,t.snap,t.singleStep)}function m(t,e){if(e=tt(e),!Array.isArray(e)||!e.length)throw new Error("noUiSlider ("+$+"): 'start' option is incorrect.");t.handles=e.length,t.start=e}function v(t,e){if("boolean"!=typeof(t.snap=e))throw new Error("noUiSlider ("+$+"): 'snap' option must be a boolean.")}function g(t,e){if("boolean"!=typeof(t.animate=e))throw new Error("noUiSlider ("+$+"): 'animate' option must be a boolean.")}function y(t,e){if("number"!=typeof(t.animationDuration=e))throw new Error("noUiSlider ("+$+"): 'animationDuration' option must be a number.")}function b(t,e){var n,i=[!1];if("lower"===e?e=[!0,!1]:"upper"===e&&(e=[!1,!0]),!0===e||!1===e){for(n=1;n<t.handles;n++)i.push(e);i.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error("noUiSlider ("+$+"): 'connect' option doesn't match handle count.");i=e}t.connect=i}function _(t,e){switch(e){case"horizontal":t.ort=0;break;case"vertical":t.ort=1;break;default:throw new Error("noUiSlider ("+$+"): 'orientation' option is invalid.")}}function w(t,e){if(!r(e))throw new Error("noUiSlider ("+$+"): 'margin' option must be numeric.");if(0!==e&&(t.margin=t.spectrum.getMargin(e),!t.margin))throw new Error("noUiSlider ("+$+"): 'margin' option is only supported on linear sliders.")}function x(t,e){if(!r(e))throw new Error("noUiSlider ("+$+"): 'limit' option must be numeric.");if(t.limit=t.spectrum.getMargin(e),!t.limit||t.handles<2)throw new Error("noUiSlider ("+$+"): 'limit' option is only supported on linear sliders with 2 or more handles.")}function k(t,e){if(!r(e))throw new Error("noUiSlider ("+$+"): 'padding' option must be numeric.");if(0!==e){if(t.padding=t.spectrum.getMargin(e),!t.padding)throw new Error("noUiSlider ("+$+"): 'padding' option is only supported on linear sliders.");if(t.padding<0)throw new Error("noUiSlider ("+$+"): 'padding' option must be a positive number.");if(50<=t.padding)throw new Error("noUiSlider ("+$+"): 'padding' option must be less than half the range.")}}function S(t,e){switch(e){case"ltr":t.dir=0;break;case"rtl":t.dir=1;break;default:throw new Error("noUiSlider ("+$+"): 'direction' option was not recognized.")}}function C(t,e){if("string"!=typeof e)throw new Error("noUiSlider ("+$+"): 'behaviour' must be a string containing options.");var n=0<=e.indexOf("tap"),i=0<=e.indexOf("drag"),r=0<=e.indexOf("fixed"),o=0<=e.indexOf("snap"),s=0<=e.indexOf("hover");if(r){if(2!==t.handles)throw new Error("noUiSlider ("+$+"): 'fixed' behaviour must be used with 2 handles");w(t,t.start[1]-t.start[0])}t.events={tap:n||o,drag:i,fixed:r,snap:o,hover:s}}function E(t,e){if("boolean"!=typeof(t.multitouch=e))throw new Error("noUiSlider ("+$+"): 'multitouch' option must be a boolean.")}function D(t,e){if(!1!==e)if(!0===e){t.tooltips=[];for(var n=0;n<t.handles;n++)t.tooltips.push(!0)}else{if(t.tooltips=tt(e),t.tooltips.length!==t.handles)throw new Error("noUiSlider ("+$+"): must pass a formatter for all handles.");t.tooltips.forEach(function(t){if("boolean"!=typeof t&&("object"!=typeof t||"function"!=typeof t.to))throw new Error("noUiSlider ("+$+"): 'tooltips' must be passed a formatter or 'false'.")})}}function M(t,e){u(t.ariaFormat=e)}function A(t,e){u(t.format=e)}function N(t,e){if(void 0!==e&&"string"!=typeof e&&!1!==e)throw new Error("noUiSlider ("+$+"): 'cssPrefix' must be a string or `false`.");t.cssPrefix=e}function V(t,e){if(void 0!==e&&"object"!=typeof e)throw new Error("noUiSlider ("+$+"): 'cssClasses' must be an object.");if("string"==typeof t.cssPrefix)for(var n in t.cssClasses={},e)e.hasOwnProperty(n)&&(t.cssClasses[n]=t.cssPrefix+e[n]);else t.cssClasses=e}function I(t,e){if(!0!==e&&!1!==e)throw new Error("noUiSlider ("+$+"): 'useRequestAnimationFrame' option should be true (default) or false.");t.useRequestAnimationFrame=e}function rt(e){var n={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:l,format:l},i={step:{r:!1,t:p},start:{r:!0,t:m},connect:{r:!0,t:b},direction:{r:!0,t:S},snap:{r:!1,t:v},animate:{r:!1,t:g},animationDuration:{r:!1,t:y},range:{r:!0,t:f},orientation:{r:!1,t:_},margin:{r:!1,t:w},limit:{r:!1,t:x},padding:{r:!1,t:k},behaviour:{r:!0,t:C},multitouch:{r:!0,t:E},ariaFormat:{r:!1,t:M},format:{r:!1,t:A},tooltips:{r:!1,t:D},cssPrefix:{r:!1,t:N},cssClasses:{r:!1,t:V},useRequestAnimationFrame:{r:!1,t:I}},r={connect:!1,direction:"ltr",behaviour:"tap",multitouch:!1,orientation:"horizontal",cssPrefix:"noUi-",cssClasses:{target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",ltr:"ltr",rtl:"rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},useRequestAnimationFrame:!0};e.format&&!e.ariaFormat&&(e.ariaFormat=e.format),Object.keys(i).forEach(function(t){if(void 0===e[t]&&void 0===r[t]){if(i[t].r)throw new Error("noUiSlider ("+$+"): '"+t+"' is required.");return!0}i[t].t(n,void 0===e[t]?r[t]:e[t])}),n.pips=e.pips;var t=[["left","top"],["right","bottom"]];return n.style=t[n.dir][n.ort],n.styleOposite=t[n.dir?0:1][n.ort],n}function P(t,d,o){var u,l,s,a,h,r,c,e,p=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},n=window.CSS&&CSS.supports&&CSS.supports("touch-action","none"),f=n&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),_=t,m=[],v=[],g=0,w=d.spectrum,y=[],b={},x=t.ownerDocument,k=x.documentElement,S=x.body;function C(t,e){var n=x.createElement("div");return e&&et(n,e),t.appendChild(n),n}function i(t,e){var n=C(t,d.cssClasses.origin),i=C(n,d.cssClasses.handle);return i.setAttribute("data-handle",e),i.setAttribute("tabindex","0"),i.setAttribute("role","slider"),i.setAttribute("aria-orientation",d.ort?"vertical":"horizontal"),0===e?et(i,d.cssClasses.handleLower):e===d.handles-1&&et(i,d.cssClasses.handleUpper),n}function E(t,e){return!!e&&C(t,d.cssClasses.connect)}function D(t,e){return!!d.tooltips[e]&&C(t.firstChild,d.cssClasses.tooltip)}function M(e,i,r){var o=x.createElement("div"),s=[d.cssClasses.valueNormal,d.cssClasses.valueLarge,d.cssClasses.valueSub],a=[d.cssClasses.markerNormal,d.cssClasses.markerLarge,d.cssClasses.markerSub],l=[d.cssClasses.valueHorizontal,d.cssClasses.valueVertical],u=[d.cssClasses.markerHorizontal,d.cssClasses.markerVertical];function c(t,e){var n=e===d.cssClasses.value,i=n?l:u,r=n?s:a;return e+" "+i[d.ort]+" "+r[t]}return et(o,d.cssClasses.pips),et(o,0===d.ort?d.cssClasses.pipsHorizontal:d.cssClasses.pipsVertical),Object.keys(e).forEach(function(t){!function(t,e){e[1]=e[1]&&i?i(e[0],e[1]):e[1];var n=C(o,!1);n.className=c(e[1],d.cssClasses.marker),n.style[d.style]=t+"%",e[1]&&((n=C(o,!1)).className=c(e[1],d.cssClasses.value),n.style[d.style]=t+"%",n.innerText=r.to(e[0]))}(t,e[t])}),o}function A(){var t;h&&((t=h).parentElement.removeChild(t),h=null)}function N(t){A();var p,f,m,e,v,n,i,g,y,b,r=t.mode,o=t.density||1,s=t.filter||!1,a=t.values||!1,l=t.stepped||!1,u=function(t,e,n){if("range"===t||"steps"===t)return w.xVal;if("count"===t){if(!e)throw new Error("noUiSlider ("+$+"): 'values' required for mode 'count'.");var i,r=100/(e-1),o=0;for(e=[];(i=o++*r)<=100;)e.push(i);t="positions"}return"positions"===t?e.map(function(t){return w.fromStepping(n?w.getStep(t):t)}):"values"===t?n?e.map(function(t){return w.fromStepping(w.getStep(w.toStepping(t)))}):e:void 0}(r,a,l),c=(p=o,f=r,m=u,v={},n=w.xVal[0],i=w.xVal[w.xVal.length-1],y=g=!1,b=0,(e=m.slice().sort(function(t,e){return t-e}),m=e.filter(function(t){return!this[t]&&(this[t]=!0)},{}))[0]!==n&&(m.unshift(n),g=!0),m[m.length-1]!==i&&(m.push(i),y=!0),m.forEach(function(t,e){var n,i,r,o,s,a,l,u,c,d=t,h=m[e+1];if("steps"===f&&(n=w.xNumSteps[e]),n||(n=h-d),!1!==d&&void 0!==h)for(n=Math.max(n,1e-7),i=d;i<=h;i=(i+n).toFixed(7)/1){for(l=(s=(o=w.toStepping(i))-b)/p,c=s/(u=Math.round(l)),r=1;r<=u;r+=1)v[(b+r*c).toFixed(5)]=["x",0];a=-1<m.indexOf(i)?1:"steps"===f?2:0,!e&&g&&(a=0),i===h&&y||(v[o.toFixed(5)]=[i,a]),b=o}}),v),d=t.format||{to:Math.round};return h=_.appendChild(M(c,s,d))}function V(){var t=u.getBoundingClientRect(),e="offset"+["Width","Height"][d.ort];return 0===d.ort?t.width||u[e]:t.height||u[e]}function I(i,r,o,s){var e=function(t){return!_.hasAttribute("disabled")&&(e=_,n=d.cssClasses.tap,(e.classList?!e.classList.contains(n):!new RegExp("\\b"+n+"\\b").test(e.className))&&!!(t=function(t,e,n){var i,r,o=0===t.type.indexOf("touch"),s=0===t.type.indexOf("mouse"),a=0===t.type.indexOf("pointer");if(0===t.type.indexOf("MSPointer")&&(a=!0),o&&d.multitouch){var l=function(t){return t.target===n||n.contains(t.target)};if("touchstart"===t.type){var u=Array.prototype.filter.call(t.touches,l);if(1<u.length)return!1;i=u[0].pageX,r=u[0].pageY}else{var c=Array.prototype.find.call(t.changedTouches,l);if(!c)return!1;i=c.pageX,r=c.pageY}}else if(o){if(1<t.touches.length)return!1;i=t.changedTouches[0].pageX,r=t.changedTouches[0].pageY}return e=e||it(x),(s||a)&&(i=t.clientX+e.x,r=t.clientY+e.y),t.pageOffset=e,t.points=[i,r],t.cursor=s||a,t}(t,s.pageOffset,s.target||r))&&!(i===p.start&&void 0!==t.buttons&&1<t.buttons)&&(!s.hover||!t.buttons)&&(f||t.preventDefault(),t.calcPoint=t.points[d.ort],void o(t,s)));var e,n},n=[];return i.split(" ").forEach(function(t){r.addEventListener(t,e,!!f&&{passive:!0}),n.push([t,e])}),n}function P(t){var e,n,i,r,o,s,a=t-(e=u,n=d.ort,i=e.getBoundingClientRect(),r=e.ownerDocument,o=r.documentElement,s=it(r),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(s.x=0),n?i.top+s.y-o.clientTop:i.left+s.x-o.clientLeft),l=100*a/V();return d.dir?100-l:l}function R(t,i,n,e){var r=n.slice(),o=[!t,t],s=[t,!t];e=e.slice(),t&&e.reverse(),1<e.length?e.forEach(function(t,e){var n=z(r,t,r[t]+i,o[e],s[e],!1);!1===n?i=0:(i=n-r[t],r[t]=n)}):o=s=[!0];var a=!1;e.forEach(function(t,e){a=H(t,n[t]+i,o[e],s[e])||a}),a&&e.forEach(function(t){L("update",t),L("slide",t)})}function L(n,i,r){Object.keys(b).forEach(function(t){var e=t.split(".")[0];n===e&&b[t].forEach(function(t){t.call(a,y.map(d.format.to),i,y.slice(),r||!1,m.slice())})})}function T(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&W(t,e)}function O(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return W(t,e);var n=(d.dir?-1:1)*(t.calcPoint-e.startCalcPoint),i=100*n/e.baseSize;R(0<n,i,e.locations,e.handleNumbers)}function W(t,e){e.handle&&(nt(e.handle,d.cssClasses.active),g-=1),e.listeners.forEach(function(t){k.removeEventListener(t[0],t[1])}),0===g&&(nt(_,d.cssClasses.drag),Y(),t.cursor&&(S.style.cursor="",S.removeEventListener("selectstart",Q))),e.handleNumbers.forEach(function(t){L("change",t),L("set",t),L("end",t)})}function B(t,e){var n;if(1===e.handleNumbers.length){var i=l[e.handleNumbers[0]];if(i.hasAttribute("disabled"))return!1;n=i.children[0],g+=1,et(n,d.cssClasses.active)}t.stopPropagation();var r=[],o=I(p.move,k,O,{target:t.target,handle:n,listeners:r,startCalcPoint:t.calcPoint,baseSize:V(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:m.slice()}),s=I(p.end,k,W,{target:t.target,handle:n,listeners:r,handleNumbers:e.handleNumbers}),a=I("mouseout",k,T,{target:t.target,handle:n,listeners:r,handleNumbers:e.handleNumbers});r.push.apply(r,o.concat(s,a)),t.cursor&&(S.style.cursor=getComputedStyle(t.target).cursor,1<l.length&&et(_,d.cssClasses.drag),S.addEventListener("selectstart",Q,!1)),e.handleNumbers.forEach(function(t){L("start",t)})}function U(t){t.stopPropagation();var i,r,o,e=P(t.calcPoint),n=(i=e,o=!(r=100),l.forEach(function(t,e){if(!t.hasAttribute("disabled")){var n=Math.abs(m[e]-i);n<r&&(o=e,r=n)}}),o);if(!1===n)return!1;d.events.snap||Z(_,d.cssClasses.tap,d.animationDuration),H(n,e,!0,!0),Y(),L("slide",n,!0),L("update",n,!0),L("change",n,!0),L("set",n,!0),d.events.snap&&B(t,{handleNumbers:[n]})}function j(t){var e=P(t.calcPoint),n=w.getStep(e),i=w.fromStepping(n);Object.keys(b).forEach(function(t){"hover"===t.split(".")[0]&&b[t].forEach(function(t){t.call(a,i)})})}function z(t,e,n,i,r,o){var s;return 1<l.length&&(i&&0<e&&(n=Math.max(n,t[e-1]+d.margin)),r&&e<l.length-1&&(n=Math.min(n,t[e+1]-d.margin))),1<l.length&&d.limit&&(i&&0<e&&(n=Math.min(n,t[e-1]+d.limit)),r&&e<l.length-1&&(n=Math.max(n,t[e+1]-d.limit))),d.padding&&(0===e&&(n=Math.max(n,d.padding)),e===l.length-1&&(n=Math.min(n,100-d.padding))),n=w.getStep(n),s=n,!((n=Math.max(Math.min(s,100),0))===t[e]&&!o)&&n}function F(t){return t+"%"}function Y(){v.forEach(function(t){var e=50<m[t]?-1:1,n=3+(l.length+e*t);l[t].childNodes[0].style.zIndex=n})}function H(t,e,n,i){return!1!==(e=z(m,t,e,n,i,!1))&&(function(t,e){m[t]=e,y[t]=w.fromStepping(e);var n=function(){l[t].style[d.style]=F(e),q(t),q(t+1)};window.requestAnimationFrame&&d.useRequestAnimationFrame?window.requestAnimationFrame(n):n()}(t,e),!0)}function q(t){if(s[t]){var e=0,n=100;0!==t&&(e=m[t-1]),t!==s.length-1&&(n=m[t]),s[t].style[d.style]=F(e),s[t].style[d.styleOposite]=F(100-n)}}function G(t,e){null!==t&&!1!==t&&("number"==typeof t&&(t=String(t)),!1===(t=d.format.from(t))||isNaN(t)||H(e,w.toStepping(t),!1,!1))}function X(t,e){var n=tt(t),i=void 0===m[0];e=void 0===e||!!e,n.forEach(G),d.animate&&!i&&Z(_,d.cssClasses.tap,d.animationDuration),v.forEach(function(t){H(t,m[t],!0,!1)}),Y(),v.forEach(function(t){L("update",t),null!==n[t]&&e&&L("set",t)})}function K(){var t=y.map(d.format.to);return 1===t.length?t[0]:t}function J(t,e){b[t]=b[t]||[],b[t].push(e),"update"===t.split(".")[0]&&l.forEach(function(t,e){L("update",e)})}if(_.noUiSlider)throw new Error("noUiSlider ("+$+"): Slider was already initialized.");return et(e=_,d.cssClasses.target),0===d.dir?et(e,d.cssClasses.ltr):et(e,d.cssClasses.rtl),0===d.ort?et(e,d.cssClasses.horizontal):et(e,d.cssClasses.vertical),u=C(e,d.cssClasses.base),function(t,e){l=[],(s=[]).push(E(e,t[0]));for(var n=0;n<d.handles;n++)l.push(i(e,n)),v[n]=n,s.push(E(e,t[n+1]))}(d.connect,u),a={destroy:function(){for(var t in d.cssClasses)d.cssClasses.hasOwnProperty(t)&&nt(_,d.cssClasses[t]);for(;_.firstChild;)_.removeChild(_.firstChild);delete _.noUiSlider},steps:function(){return m.map(function(t,e){var n=w.getNearbySteps(t),i=y[e],r=n.thisStep.step,o=null;!1!==r&&i+r>n.stepAfter.startValue&&(r=n.stepAfter.startValue-i),o=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===t?r=null:0===t&&(o=null);var s=w.countStepDecimals();return null!==r&&!1!==r&&(r=Number(r.toFixed(s))),null!==o&&!1!==o&&(o=Number(o.toFixed(s))),[o,r]})},on:J,off:function(t){var i=t&&t.split(".")[0],r=i&&t.substring(i.length);Object.keys(b).forEach(function(t){var e=t.split(".")[0],n=t.substring(e.length);i&&i!==e||r&&r!==n||delete b[t]})},get:K,set:X,reset:function(t){X(d.start,t)},__moveHandles:function(t,e,n){R(t,e,m,n)},options:o,updateOptions:function(e,t){var n=K(),i=["margin","limit","padding","range","animate","snap","step","format"];i.forEach(function(t){void 0!==e[t]&&(o[t]=e[t])});var r=rt(o);i.forEach(function(t){void 0!==e[t]&&(d[t]=r[t])}),w=r.spectrum,d.margin=r.margin,d.limit=r.limit,d.padding=r.padding,d.pips&&N(d.pips),m=[],X(e.start||n,t)},target:_,removePips:A,pips:N},(c=d.events).fixed||l.forEach(function(t,e){I(p.start,t.children[0],B,{handleNumbers:[e]})}),c.tap&&I(p.start,u,U,{}),c.hover&&I(p.move,u,j,{hover:!0}),c.drag&&s.forEach(function(t,e){if(!1!==t&&0!==e&&e!==s.length-1){var n=l[e-1],i=l[e],r=[t];et(t,d.cssClasses.draggable),c.fixed&&(r.push(n.children[0]),r.push(i.children[0])),r.forEach(function(t){I(p.start,t,B,{handles:[n,i],handleNumbers:[e-1,e]})})}}),X(d.start),d.pips&&N(d.pips),d.tooltips&&(r=l.map(D),J("update",function(t,e,n){if(r[e]){var i=t[e];!0!==d.tooltips[e]&&(i=d.tooltips[e].to(n[e])),r[e].innerHTML=i}})),J("update",function(t,e,s,n,a){v.forEach(function(t){var e=l[t],n=z(m,t,0,!0,!0,!0),i=z(m,t,100,!0,!0,!0),r=a[t],o=d.ariaFormat.to(s[t]);e.children[0].setAttribute("aria-valuemin",n.toFixed(1)),e.children[0].setAttribute("aria-valuemax",i.toFixed(1)),e.children[0].setAttribute("aria-valuenow",r.toFixed(1)),e.children[0].setAttribute("aria-valuetext",o)})}),a}return{version:$,create:function(t,e){if(!t||!t.nodeName)throw new Error("noUiSlider ("+$+"): create requires a single element, got: "+t);var n=rt(e),i=P(t,n,e);return t.noUiSlider=i}}},"object"==typeof n?e.exports=i():window.noUiSlider=i()},432:function(i,r,o){
/*!
     * Pikaday
     *
     * Copyright © 2014 David Bushell | BSD & MIT license | https://github.com/dbushell/Pikaday
     */
!function(t,e){"use strict";var n;if("object"==typeof o){try{n=i("moment")}catch(t){}r.exports=e(n)}else t.Pikaday=e(t.moment)}(this,function(n){"use strict";var o="function"==typeof n,s=!!window.addEventListener,c=window.document,u=window.setTimeout,a=function(t,e,n,i){s?t.addEventListener(e,n,!!i):t.attachEvent("on"+e,n)},i=function(t,e,n,i){s?t.removeEventListener(e,n,!!i):t.detachEvent("on"+e,n)},l=function(t,e){return-1!==(" "+t.className+" ").indexOf(" "+e+" ")},g=function(t){return/Array/.test(Object.prototype.toString.call(t))},B=function(t){return/Date/.test(Object.prototype.toString.call(t))&&!isNaN(t.getTime())},U=function(t,e){return[31,(n=t,n%4==0&&n%100!=0||n%400==0?29:28),31,30,31,30,31,31,30,31,30,31][e];var n},j=function(t){B(t)&&t.setHours(0,0,0,0)},z=function(t,e){return t.getTime()===e.getTime()},d=function(t,e,n){var i,r;for(i in e)(r=void 0!==t[i])&&"object"==typeof e[i]&&null!==e[i]&&void 0===e[i].nodeName?B(e[i])?n&&(t[i]=new Date(e[i].getTime())):g(e[i])?n&&(t[i]=e[i].slice(0)):t[i]=d({},e[i],n):!n&&r||(t[i]=e[i]);return t},r=function(t,e,n){var i;c.createEvent?((i=c.createEvent("HTMLEvents")).initEvent(e,!0,!1),i=d(i,n),t.dispatchEvent(i)):c.createEventObject&&(i=c.createEventObject(),i=d(i,n),t.fireEvent("on"+e,i))},e=function(t){return t.month<0&&(t.year-=Math.ceil(Math.abs(t.month)/12),t.month+=12),11<t.month&&(t.year+=Math.floor(Math.abs(t.month)/12),t.month-=12),t},h={field:null,bound:void 0,position:"bottom left",reposition:!0,format:"YYYY-MM-DD",toString:null,parse:null,defaultDate:null,setDefaultDate:!1,firstDay:0,formatStrict:!1,minDate:null,maxDate:null,yearRange:10,showWeekNumber:!1,pickWholeWeek:!1,minYear:0,maxYear:9999,minMonth:void 0,maxMonth:void 0,startRange:null,endRange:null,isRTL:!1,yearSuffix:"",showMonthAfterYear:!1,showDaysInNextAndPreviousMonths:!1,enableSelectionDaysInNextAndPreviousMonths:!1,numberOfMonths:1,mainCalendar:"left",container:void 0,blurFieldOnSelect:!0,i18n:{previousMonth:"Previous Month",nextMonth:"Next Month",months:["January","February","March","April","May","June","July","August","September","October","November","December"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]},theme:null,events:[],onSelect:null,onOpen:null,onClose:null,onDraw:null,keyboardInput:!0},p=function(t,e,n){for(e+=t.firstDay;7<=e;)e-=7;return n?t.i18n.weekdaysShort[e]:t.i18n.weekdays[e]},F=function(t){var e=[],n="false";if(t.isEmpty){if(!t.showDaysInNextAndPreviousMonths)return'<td class="is-empty"></td>';e.push("is-outside-current-month"),t.enableSelectionDaysInNextAndPreviousMonths||e.push("is-selection-disabled")}return t.isDisabled&&e.push("is-disabled"),t.isToday&&e.push("is-today"),t.isSelected&&(e.push("is-selected"),n="true"),t.hasEvent&&e.push("has-event"),t.isInRange&&e.push("is-inrange"),t.isStartRange&&e.push("is-startrange"),t.isEndRange&&e.push("is-endrange"),'<td data-day="'+t.day+'" class="'+e.join(" ")+'" aria-selected="'+n+'"><button class="pika-button pika-day" type="button" data-pika-year="'+t.year+'" data-pika-month="'+t.month+'" data-pika-day="'+t.day+'">'+t.day+"</button></td>"},f=function(t,e,n,i,r,o){var s,a,l,u,c,d=t._o,h=n===d.minYear,p=n===d.maxYear,f='<div id="'+o+'" class="pika-title" role="heading" aria-live="assertive">',m=!0,v=!0;for(l=[],s=0;s<12;s++)l.push('<option value="'+(n===r?s-e:12+s-e)+'"'+(s===i?' selected="selected"':"")+(h&&s<d.minMonth||p&&s>d.maxMonth?'disabled="disabled"':"")+">"+d.i18n.months[s]+"</option>");for(u='<div class="pika-label">'+d.i18n.months[i]+'<select class="pika-select pika-select-month" tabindex="-1">'+l.join("")+"</select></div>",g(d.yearRange)?(s=d.yearRange[0],a=d.yearRange[1]+1):(s=n-d.yearRange,a=1+n+d.yearRange),l=[];s<a&&s<=d.maxYear;s++)s>=d.minYear&&l.push('<option value="'+s+'"'+(s===n?' selected="selected"':"")+">"+s+"</option>");return c='<div class="pika-label">'+n+d.yearSuffix+'<select class="pika-select pika-select-year" tabindex="-1">'+l.join("")+"</select></div>",d.showMonthAfterYear?f+=c+u:f+=u+c,h&&(0===i||d.minMonth>=i)&&(m=!1),p&&(11===i||d.maxMonth<=i)&&(v=!1),0===e&&(f+='<button class="pika-prev'+(m?"":" is-disabled")+'" type="button">'+d.i18n.previousMonth+"</button>"),e===t._o.numberOfMonths-1&&(f+='<button class="pika-next'+(v?"":" is-disabled")+'" type="button">'+d.i18n.nextMonth+"</button>"),f+="</div>"},Y=function(t,e,n){return'<table cellpadding="0" cellspacing="0" class="pika-table" role="grid" aria-labelledby="'+n+'">'+function(t){var e,n=[];for(t.showWeekNumber&&n.push("<th></th>"),e=0;e<7;e++)n.push('<th scope="col"><abbr title="'+p(t,e)+'">'+p(t,e,!0)+"</abbr></th>");return"<thead><tr>"+(t.isRTL?n.reverse():n).join("")+"</tr></thead>"}(t)+"<tbody>"+e.join("")+"</tbody></table>"},t=function(t){var i=this,r=i.config(t);i._onMouseDown=function(t){if(i._v){var e=(t=t||window.event).target||t.srcElement;if(e)if(l(e,"is-disabled")||(!l(e,"pika-button")||l(e,"is-empty")||l(e.parentNode,"is-disabled")?l(e,"pika-prev")?i.prevMonth():l(e,"pika-next")&&i.nextMonth():(i.setDate(new Date(e.getAttribute("data-pika-year"),e.getAttribute("data-pika-month"),e.getAttribute("data-pika-day"))),r.bound&&u(function(){i.hide(),r.blurFieldOnSelect&&r.field&&r.field.blur()},100))),l(e,"pika-select"))i._c=!0;else{if(!t.preventDefault)return t.returnValue=!1;t.preventDefault()}}},i._onChange=function(t){var e=(t=t||window.event).target||t.srcElement;e&&(l(e,"pika-select-month")?i.gotoMonth(e.value):l(e,"pika-select-year")&&i.gotoYear(e.value))},i._onKeyChange=function(t){if(t=t||window.event,i.isVisible())switch(t.keyCode){case 13:case 27:r.field&&r.field.blur();break;case 37:t.preventDefault(),i.adjustDate("subtract",1);break;case 38:i.adjustDate("subtract",7);break;case 39:i.adjustDate("add",1);break;case 40:i.adjustDate("add",7)}},i._onInputChange=function(t){var e;t.firedBy!==i&&(e=r.parse?r.parse(r.field.value,r.format):o?(e=n(r.field.value,r.format,r.formatStrict))&&e.isValid()?e.toDate():null:new Date(Date.parse(r.field.value)),B(e)&&i.setDate(e),i._v||i.show())},i._onInputFocus=function(){i.show()},i._onInputClick=function(){i.show()},i._onInputBlur=function(){var t=c.activeElement;do{if(l(t,"pika-single"))return}while(t=t.parentNode);i._c||(i._b=u(function(){i.hide()},50)),i._c=!1},i._onClick=function(t){var e=(t=t||window.event).target||t.srcElement,n=e;if(e){!s&&l(e,"pika-select")&&(e.onchange||(e.setAttribute("onchange","return;"),a(e,"change",i._onChange)));do{if(l(n,"pika-single")||n===r.trigger)return}while(n=n.parentNode);i._v&&e!==r.trigger&&n!==r.trigger&&i.hide()}},i.el=c.createElement("div"),i.el.className="pika-single"+(r.isRTL?" is-rtl":"")+(r.theme?" "+r.theme:""),a(i.el,"mousedown",i._onMouseDown,!0),a(i.el,"touchend",i._onMouseDown,!0),a(i.el,"change",i._onChange),r.keyboardInput&&a(c,"keydown",i._onKeyChange),r.field&&(r.container?r.container.appendChild(i.el):r.bound?c.body.appendChild(i.el):r.field.parentNode.insertBefore(i.el,r.field.nextSibling),a(r.field,"change",i._onInputChange),r.defaultDate||(o&&r.field.value?r.defaultDate=n(r.field.value,r.format).toDate():r.defaultDate=new Date(Date.parse(r.field.value)),r.setDefaultDate=!0));var e=r.defaultDate;B(e)?r.setDefaultDate?i.setDate(e,!0):i.gotoDate(e):i.gotoDate(new Date),r.bound?(this.hide(),i.el.className+=" is-bound",a(r.trigger,"click",i._onInputClick),a(r.trigger,"focus",i._onInputFocus),a(r.trigger,"blur",i._onInputBlur)):this.show()};return t.prototype={config:function(t){this._o||(this._o=d({},h,!0));var e=d(this._o,t,!0);e.isRTL=!!e.isRTL,e.field=e.field&&e.field.nodeName?e.field:null,e.theme="string"==typeof e.theme&&e.theme?e.theme:null,e.bound=!!(void 0!==e.bound?e.field&&e.bound:e.field),e.trigger=e.trigger&&e.trigger.nodeName?e.trigger:e.field,e.disableWeekends=!!e.disableWeekends,e.disableDayFn="function"==typeof e.disableDayFn?e.disableDayFn:null;var n=parseInt(e.numberOfMonths,10)||1;if(e.numberOfMonths=4<n?4:n,B(e.minDate)||(e.minDate=!1),B(e.maxDate)||(e.maxDate=!1),e.minDate&&e.maxDate&&e.maxDate<e.minDate&&(e.maxDate=e.minDate=!1),e.minDate&&this.setMinDate(e.minDate),e.maxDate&&this.setMaxDate(e.maxDate),g(e.yearRange)){var i=(new Date).getFullYear()-10;e.yearRange[0]=parseInt(e.yearRange[0],10)||i,e.yearRange[1]=parseInt(e.yearRange[1],10)||i}else e.yearRange=Math.abs(parseInt(e.yearRange,10))||h.yearRange,100<e.yearRange&&(e.yearRange=100);return e},toString:function(t){return t=t||this._o.format,B(this._d)?this._o.toString?this._o.toString(this._d,t):o?n(this._d).format(t):this._d.toDateString():""},getMoment:function(){return o?n(this._d):null},setMoment:function(t,e){o&&n.isMoment(t)&&this.setDate(t.toDate(),e)},getDate:function(){return B(this._d)?new Date(this._d.getTime()):null},setDate:function(t,e){if(!t)return this._d=null,this._o.field&&(this._o.field.value="",r(this._o.field,"change",{firedBy:this})),this.draw();if("string"==typeof t&&(t=new Date(Date.parse(t))),B(t)){var n=this._o.minDate,i=this._o.maxDate;B(n)&&t<n?t=n:B(i)&&i<t&&(t=i),this._d=new Date(t.getTime()),j(this._d),this.gotoDate(this._d),this._o.field&&(this._o.field.value=this.toString(),r(this._o.field,"change",{firedBy:this})),e||"function"!=typeof this._o.onSelect||this._o.onSelect.call(this,this.getDate())}},gotoDate:function(t){var e=!0;if(B(t)){if(this.calendars){var n=new Date(this.calendars[0].year,this.calendars[0].month,1),i=new Date(this.calendars[this.calendars.length-1].year,this.calendars[this.calendars.length-1].month,1),r=t.getTime();i.setMonth(i.getMonth()+1),i.setDate(i.getDate()-1),e=r<n.getTime()||i.getTime()<r}e&&(this.calendars=[{month:t.getMonth(),year:t.getFullYear()}],"right"===this._o.mainCalendar&&(this.calendars[0].month+=1-this._o.numberOfMonths)),this.adjustCalendars()}},adjustDate:function(t,e){var n,i=this.getDate()||new Date,r=24*parseInt(e)*60*60*1e3;"add"===t?n=new Date(i.valueOf()+r):"subtract"===t&&(n=new Date(i.valueOf()-r)),this.setDate(n)},adjustCalendars:function(){this.calendars[0]=e(this.calendars[0]);for(var t=1;t<this._o.numberOfMonths;t++)this.calendars[t]=e({month:this.calendars[0].month+t,year:this.calendars[0].year});this.draw()},gotoToday:function(){this.gotoDate(new Date)},gotoMonth:function(t){isNaN(t)||(this.calendars[0].month=parseInt(t,10),this.adjustCalendars())},nextMonth:function(){this.calendars[0].month++,this.adjustCalendars()},prevMonth:function(){this.calendars[0].month--,this.adjustCalendars()},gotoYear:function(t){isNaN(t)||(this.calendars[0].year=parseInt(t,10),this.adjustCalendars())},setMinDate:function(t){t instanceof Date?(j(t),this._o.minDate=t,this._o.minYear=t.getFullYear(),this._o.minMonth=t.getMonth()):(this._o.minDate=h.minDate,this._o.minYear=h.minYear,this._o.minMonth=h.minMonth,this._o.startRange=h.startRange),this.draw()},setMaxDate:function(t){t instanceof Date?(j(t),this._o.maxDate=t,this._o.maxYear=t.getFullYear(),this._o.maxMonth=t.getMonth()):(this._o.maxDate=h.maxDate,this._o.maxYear=h.maxYear,this._o.maxMonth=h.maxMonth,this._o.endRange=h.endRange),this.draw()},setStartRange:function(t){this._o.startRange=t},setEndRange:function(t){this._o.endRange=t},draw:function(t){if(this._v||t){var e,n=this._o,i=n.minYear,r=n.maxYear,o=n.minMonth,s=n.maxMonth,a="";this._y<=i&&(this._y=i,!isNaN(o)&&this._m<o&&(this._m=o)),this._y>=r&&(this._y=r,!isNaN(s)&&this._m>s&&(this._m=s)),e="pika-title-"+Math.random().toString(36).replace(/[^a-z]+/g,"").substr(0,2);for(var l=0;l<n.numberOfMonths;l++)a+='<div class="pika-lendar">'+f(this,l,this.calendars[l].year,this.calendars[l].month,this.calendars[0].year,e)+this.render(this.calendars[l].year,this.calendars[l].month,e)+"</div>";this.el.innerHTML=a,n.bound&&"hidden"!==n.field.type&&u(function(){n.trigger.focus()},1),"function"==typeof this._o.onDraw&&this._o.onDraw(this),n.bound&&n.field.setAttribute("aria-label","Use the arrow keys to pick a date")}},adjustPosition:function(){var t,e,n,i,r,o,s,a,l,u;if(!this._o.container){if(this.el.style.position="absolute",t=this._o.trigger,e=t,n=this.el.offsetWidth,i=this.el.offsetHeight,r=window.innerWidth||c.documentElement.clientWidth,o=window.innerHeight||c.documentElement.clientHeight,s=window.pageYOffset||c.body.scrollTop||c.documentElement.scrollTop,"function"==typeof t.getBoundingClientRect)u=t.getBoundingClientRect(),a=u.left+window.pageXOffset,l=u.bottom+window.pageYOffset;else for(a=e.offsetLeft,l=e.offsetTop+e.offsetHeight;e=e.offsetParent;)a+=e.offsetLeft,l+=e.offsetTop;(this._o.reposition&&r<a+n||-1<this._o.position.indexOf("right")&&0<a-n+t.offsetWidth)&&(a=a-n+t.offsetWidth),(this._o.reposition&&o+s<l+i||-1<this._o.position.indexOf("top")&&0<l-i-t.offsetHeight)&&(l=l-i-t.offsetHeight),this.el.style.left=a+"px",this.el.style.top=l+"px"}},render:function(t,e,n){var i=this._o,r=new Date,o=U(t,e),s=new Date(t,e,1).getDay(),a=[],l=[];j(r),0<i.firstDay&&(s-=i.firstDay)<0&&(s+=7);for(var u=0===e?11:e-1,c=11===e?0:e+1,d=0===e?t-1:t,h=11===e?t+1:t,p=U(d,u),f=o+s,m=f;7<m;)m-=7;f+=7-m;for(var v,g,y,b,_,w,x,k=!1,S=0,C=0;S<f;S++){var E=new Date(t,e,S-s+1),D=!!B(this._d)&&z(E,this._d),M=z(E,r),A=-1!==i.events.indexOf(E.toDateString()),N=S<s||o+s<=S,V=S-s+1,I=e,P=t,R=i.startRange&&z(i.startRange,E),L=i.endRange&&z(i.endRange,E),T=i.startRange&&i.endRange&&i.startRange<E&&E<i.endRange,O=i.minDate&&E<i.minDate||i.maxDate&&E>i.maxDate||i.disableWeekends&&(0===(x=E.getDay())||6===x)||i.disableDayFn&&i.disableDayFn(E);N&&(S<s?(V=p+V,I=u,P=d):(V-=o,I=c,P=h));var W={day:V,month:I,year:P,hasEvent:A,isSelected:D,isToday:M,isDisabled:O,isEmpty:N,isStartRange:R,isEndRange:L,isInRange:T,showDaysInNextAndPreviousMonths:i.showDaysInNextAndPreviousMonths,enableSelectionDaysInNextAndPreviousMonths:i.enableSelectionDaysInNextAndPreviousMonths};i.pickWholeWeek&&D&&(k=!0),l.push(F(W)),7==++C&&(i.showWeekNumber&&l.unshift((y=S-s,b=e,_=t,w=void 0,w=new Date(_,0,1),'<td class="pika-week">'+Math.ceil(((new Date(_,b,y)-w)/864e5+w.getDay()+1)/7)+"</td>")),a.push((v=l,g=i.isRTL,'<tr class="pika-row'+(i.pickWholeWeek?" pick-whole-week":"")+(k?" is-selected":"")+'">'+(g?v.reverse():v).join("")+"</tr>")),C=0,k=!(l=[]))}return Y(i,a,n)},isVisible:function(){return this._v},show:function(){var t,e,n;this.isVisible()||(this._v=!0,this.draw(),t=this.el,e="is-hidden",t.className=(n=(" "+t.className+" ").replace(" "+e+" "," ")).trim?n.trim():n.replace(/^\s+|\s+$/g,""),this._o.bound&&(a(c,"click",this._onClick),this.adjustPosition()),"function"==typeof this._o.onOpen&&this._o.onOpen.call(this))},hide:function(){var t,e,n=this._v;!1!==n&&(this._o.bound&&i(c,"click",this._onClick),this.el.style.position="static",this.el.style.left="auto",this.el.style.top="auto",t=this.el,l(t,e="is-hidden")||(t.className=""===t.className?e:t.className+" "+e),this._v=!1,void 0!==n&&"function"==typeof this._o.onClose&&this._o.onClose.call(this))},destroy:function(){var t=this._o;this.hide(),i(this.el,"mousedown",this._onMouseDown,!0),i(this.el,"touchend",this._onMouseDown,!0),i(this.el,"change",this._onChange),t.keyboardInput&&i(c,"keydown",this._onKeyChange),t.field&&(i(t.field,"change",this._onInputChange),t.bound&&(i(t.trigger,"click",this._onInputClick),i(t.trigger,"focus",this._onInputFocus),i(t.trigger,"blur",this._onInputBlur))),this.el.parentNode&&this.el.parentNode.removeChild(this.el)}},t})}})}(this);
//# sourceMappingURL=bokeh-widgets.min.js.map