"""test utilities"""


import sys
from cStringIO import StringIO
from os.path import dirname, join
from datetime import datetime
from time import time
from logilab.common.testlib import MockConfigParser

from logilab.devtools.vcslib import CheckInInfo
from apycot import transports, NotSupported, ISourceRepository

INPUTS_DIR = join(dirname(__file__), 'inputs')

def input_path(file=''):
    return join(INPUTS_DIR, file)

def access_key(node, key):
    return node[key]

def etree_clean(writer):
    for node in writer._tree.getiterator():
        if node.tag in ('test', 'check') and 'duration' in node.attrib:
            del node.attrib['duration']
        if node.tag in ('testsdata') and 'starttime' in node.attrib:
            del node.attrib['starttime']
def clean(node):
    try:
        del node.attrib['duration']
    except:
        pass
    try:
        del node.attrib['starttime']
    except:
        pass
    for child in node:
        clean(child)


# Mock objects ################################################################ 

class MockTest:
    """fake apycot.Test.Test class"""
    def __init__(self, repo=None):
        self.repo = repo
        self.tmpdir = 'inputs'
        self.environ = {}


class MockRepository:
    """fake apycot.IRepository class"""
    __implements__ = ISourceRepository
    def __init__(self, attrs=None, **kwargs):
        self.__dict__.update(kwargs)

    def checkout_command(self):
        return self.command
    
    def env_path(self):
        return self.path
    
    def representative_attributes(self):
        return {}

    def log_info(self, from_date, to_date):
        """get list of log messages
        
        a log information is a tuple
        (file, revision_info_as_string, added_lines, removed_lines)
        """
        yield CheckInInfo(datetime.fromtimestamp(time()), 'author',
            u"log message", 'r1234', 6, 3, files=('xxx/file', ))
        
    def __repr__(self):
        return '<MockRepository %r>' % self.__dict__
    
class MockWriter:
    """fake apycot.IWriter class, ignore every thing"""
    
    def msg(*args, **kwargs):
        pass
    
    log = notify = line = msg


class MockReporter:
    """fake apycot.IReporter class"""
    def __init__(self, debug=None):
        if debug:
            self.stderr = sys.stderr
        else:
            self.stderr = StringIO()
    def log(self, severity, file, line, msg):
        print >>self.stderr, file, line or '', ':', msg

    def raw(self, name, value):
        print >>self.stderr, name, value

    def notify(self, event, *args, **kwargs):
        print >>self.stderr, event, args, kwargs


class MockTransport(transports.BaseTransport):
    """fake apycot.ITransport"""
    def __init__(self, verbosity=0, url_support=1):
        transports.BaseTransport.__init__(self, verbosity)
        self.url_support = url_support
        self.transported = []
        
    def base_url(self, date=None):
        """return the base transport url
        
        may raise NotSupported
        """
        if self.url_support:
            return 'http://www.logilab.org/'
        raise NotSupported()
    
    def part_stream(self, id):
        """get a stream object to receive the next report
        must be called in an opened transport transaction
        """
        return StringIO()
    def add_part(self, id, stream):
        """transport a report part, caracterized by its identifier and data in a
        file-like objet (it may be a stream created by part_stream)
        """
        self.transported.append((id, stream))

