"""unit tests for the writer module"""

from logilab.common.testlib import TestCase, unittest_main

import unittest
import sys, os, shutil
from cStringIO import StringIO
from utils import clean, etree_clean
from unittest_datamanagers import XMLWriterTC, XMLWriter

from apycot.writer import *
                         

class PipelineTestHelper(PrintWriter, object):
    """make the printwriter / printreader / xmlwriter pipeline 100% compatible
    with the xmlwriter api to make the xmlwriter tests working on the pipeline
    """
    def __init__(self, reader):
        PrintWriter.__init__(self)
        self.reader = reader
        self.buffer = sys.stdout = StringIO()
        
    def flush(self, setendtime):
        self.reader.from_string(self.buffer.getvalue())
        etree_clean(self.reader._writer)
        self.reader._writer.flush(setendtime)
        

    def __getattr__(self, attr):
        if attr == 'current':
            return self.reader._writer.current
        raise AttributeError(attr)

    def _get_tree(self):
        return self.reader._writer._tree
    _tree = property(_get_tree)


    
class WriterPipelineTC(XMLWriterTC):
    data_file = 'tester_data.xml'

    def setUp(self, test=None):
        XMLWriterTC.setUp(self, test)
        self.writer = PipelineTestHelper(PrintReader(self.writer))
        return self.writer
        
        

    def tearDown(self):
        XMLWriterTC.tearDown(self)
        sys.stdout = sys.__stdout__
        

class PrettyPrintWriterTC(TestCase):
    EXPECTED = """********************************************************************************
MYTEST
--------------------------------------------------------------------------------
check1
E:labas:1: erreur ligne 1
E:autrepart:: erreur chaipasou
[SUCCESS]
--------------------------------------------------------------------------------
check2
RAW name=value
[FAILURE]
********************************************************************************
MYOTHERTEST
--------------------------------------------------------------------------------
check1
[SUCCESS]
"""

    def setUp(self):
        self.writer = PrettyPrintWriter()
        self.buffer = sys.stdout = StringIO()
        
    def tearDown(self):
        sys.stdout = sys.__stdout__
        
    def test_base(self):
        writer = self.writer
        writer.notify('open_test', name='mytest')
        writer.notify('open_check', name='check1')
        writer.log(ERROR, 'labas', 1, 'erreur ligne 1')
        writer.log(ERROR, 'autrepart', None, 'erreur chaipasou')
        writer.notify('close_check', status="success")
        writer.notify('open_check', name='check2')
        writer.raw('name', 'value')
        writer.notify('close_check', status="failure")
        writer.notify('close_test')
        writer.notify('open_test', name='myothertest')
        writer.notify('open_check', name='check1')
        writer.notify('close_check', status="success")
        writer.notify('close_test')
        self.assertEqual(self.buffer.getvalue(), self.EXPECTED)        

    def test_msg(self):
        buffer = sys.stderr = StringIO()
        try:
            self.writer.verbosity = 0
            self.writer.msg(1, 'yooo')
            self.assertEqual(buffer.getvalue(), '')
            self.writer.msg(0, 'yooo')
            self.assertEqual(buffer.getvalue(), 'yooo\n')
        finally:
            sys.stderr = sys.__stderr__
        
class PrintWriterTC(PrettyPrintWriterTC):
    EXPECTED = '''NOTIFY|open_test|name=mytest
NOTIFY|open_check|name=check1
LOG|ERROR|labas|1|erreur ligne 1
LOG|ERROR|autrepart||erreur chaipasou
NOTIFY|close_check|status=success
NOTIFY|open_check|name=check2
RAW|name=value
NOTIFY|close_check|status=failure
NOTIFY|close_test
NOTIFY|open_test|name=myothertest
NOTIFY|open_check|name=check1
NOTIFY|close_check|status=success
NOTIFY|close_test
'''
    def setUp(self):
        self.writer = PrintWriter()
        self.buffer = sys.stdout = StringIO()
    
if __name__ == '__main__':
    unittest_main()
