"""
unit tests for checkers
"""

from logilab.common.testlib import unittest_main, TestCase
import unittest
import sys
import os
from os.path import join
zope_path = os.environ.get('SOFTWARE_HOME', '/usr/lib/zope/lib/python')
sys.path.insert(1, zope_path)

from unittest import TestSuite
#from apycot.repositories import FSRepository
from apycot import SUCCESS, FAILURE, PARTIAL, NODATA
from apycot.checkers.chks_python import *
from apycot.checkers.chks_xml import *
from apycot.checkers.chks_rest import *
from apycot.checkers.chks_pkg import *
from apycot.checkers import chks_pt 

from utils import *


class PythonUnitTestCheckerTC(TestCase):

    def setUp(self):
        self.input_dir = "testcase_pkg/tests/"
        self.checker = PythonUnittestChecker()
        self.checker.set_options({'coverage':'0'})
        self.checker._path = self.input_path('')

    def input_path(self, path):
        return join(input_path(self.input_dir),path)

    def test_run_test_result_success(self):
        status, result = self.checker.run_test(self.input_path("unittest_success"),
            MockWriter())
        self.assertEquals(result, (1, 0, 0, 0))
        self.assertIs(status, SUCCESS)
    
    def test_run_test_result_failure(self):
        status, result = self.checker.run_test(self.input_path("unittest_failure"),
            MockWriter())
        self.assertIs(status, FAILURE)
        self.assertEquals(result, (0, 1, 0, 0))
    
    def test_run_test_result_error(self):
        status, result = self.checker.run_test(self.input_path("unittest_errors"),
            MockWriter())
        self.assertIs(status, FAILURE)
        self.assertEquals(result, (0, 0, 1, 0))
    
    def test_run_test_result_skipped(self):
        status, result = self.checker.run_test(self.input_path("unittest_skip"),
            MockWriter())
        self.assertIs(status, PARTIAL)
        self.assertEquals(result, (0, 0, 0, 1))
    
    def test_run_test_result_mixed(self):
        status, result = self.checker.run_test(self.input_path("unittest_mixed"),
            MockWriter())
        self.assertIs(status, FAILURE)
        self.assertEquals(result, (2, 15, 1, 2))
    def test_run_test_result_mixed_std(self):
        status, result = self.checker.run_test(self.input_path("unittest_mixed_std"),
            MockWriter())
        self.assertIs(status, FAILURE)
        self.assertEquals(result, (2, 15, 1, 0))

if __name__ == '__main__':
    unittest_main()
