"""test for apycot.changes module"""

from logilab.common.testlib import TestCase, unittest_main
from shutil import  rmtree
from utils import INPUTS_DIR, input_path
from StringIO import StringIO
import sys
import os
import os.path
import tarfile

from apycot.changes import run_from_config_file

class ChangesTC(TestCase):
    def setUp(self):
        self.cwd = os.getcwd()
        os.chdir(INPUTS_DIR)
        sys.stdout = StringIO()
        sys.stdout.encoding = 'iso-8859-1'
        
    def tearDown(self):
        sys.stdout = sys.__stdout__
        os.chdir(self.cwd)
        
    def test_verb_with_changes(self):
        try:
            hg = tarfile.open("goodpkg.hg.tar")
            for tar_part in hg.getmembers():
                hg.extract(tar_part)
            status = run_from_config_file('tester.ini',
                                          testnames=['goodpkg'],
                                          to_date=[2007, 4, 12, 20],
                                          verbosity=1)
            self.assertEquals(status, 0)
            value = sys.stdout.getvalue().strip()
            self.assertTextEquals(value, '''\
goodpkg
*******
"Sylvain <syt@logilab.fr>": add test
"Sylvain <syt@logilab.fr>": initialize repository''')
        finally:
            hg_path = os.path.join("goodpkg",'.hg')
            if os.path.exists(hg_path):
                rmtree(hg_path)
        
    def test_verb_without_changes(self):
        sys.stdout = StringIO()
        status = run_from_config_file('tester.ini',
                                      testnames=['goodpkg'],
                                      to_date=[2007, 3, 12],
                                      verbosity=1)
        self.assertEquals(status, 1)
        value = sys.stdout.getvalue().strip()
        self.assertEquals(value, 'no changes')

        
    def test_with_changes(self):
        status = run_from_config_file('tester.ini',
                                      testnames=['goodpkg'],
                                      to_date=[2007, 4, 12, 20])
        self.assertEquals(status, 0)
        value = sys.stdout.getvalue().strip()
        self.assertTextEquals(value, '')
        
    def test_without_changes(self):
        status = run_from_config_file('tester.ini',
                                      testnames=['goodpkg'],
                                      to_date=[2007, 3, 12])
        self.assertEquals(status, 1)
        value = sys.stdout.getvalue().strip()
        self.assertEquals(value, '')
            
if __name__ == '__main__':
    unittest_main()
