# Copyright (c) 2003-2007 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""USAGE: runcheck [OPTIONS] <checker> <file>...

Run a file checker on the given files.
Available checkers are %(formatted_file_checkers)s.

OPTIONS:
  --help / -h
  --version / -V
    Display this help message and exit.
"""

import sys
import getopt

from apycot import list_registered, get_registered
from apycot.checkers import AbstractFilteredFileChecker
from apycot.writer import PrettyPrintWriter

def run(args):
    """run a single check on files according to command line arguments
    """
    l_opt = ['help', 'version']
    opts, args = getopt.getopt(args, 'hV', l_opt)
    filecheckers = []
    for checker_name in list_registered('checker'):
        checker = get_registered('checker', checker_name)
        if issubclass(checker, AbstractFilteredFileChecker):
            filecheckers.append(checker_name)
    # required for usage information (look at the docstring)
    formatted_file_checkers = ', '.join(filecheckers)
    for name, value in opts:
        if name in ('h', 'help'):
            print __doc__ % locals()
            return 0
        elif name in ('V', 'version'):
            from apycot.__pkginfo__ import version
            print 'APyCoT version', version
            print 'python', sys.version
            return 0
    if len(args) < 2:
        print __doc__ % locals()
        return 1
    writer = PrettyPrintWriter()
    checker_name = args.pop(0)
    if not checker_name in filecheckers:
        raise Exception('%s is not a file checker' % checker_name)
    checker = get_registered('checker', checker_name)
    for path in args:
        checker.check_file(path, writer)

        
if __name__ == '__main__':
    run(sys.argv[1:])
    
