# Copyright (c) 2003-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""installation / build preprocessor using make
"""


import os
from os.path import abspath

from apycot.preprocessors import BasePreProcessor
from apycot import IPreProcessor, register
from apycot.Test import SetupException
from apycot.utils import EnvironmentTrackerMixin, get_csv
    
class MakeProcessor(EnvironmentTrackerMixin, BasePreProcessor):
    """python make pre-processor
    """
    __implements__ = IPreProcessor
    __name__ = 'make'
    binpath = 'make'
    
    def __init__(self, writer, options):
        EnvironmentTrackerMixin.__init__(self)
        BasePreProcessor.__init__(self, writer, options)
        self._installed = {}
           
    # PreProcessor interface ##################################################

    def check_setup(self, test, checker):
        """setup the test environment"""
        path = test.repo.env_path()
        self.writer.msg(1, 'Run preprocessor %s on %s' % (self.__name__, path))
        # cache to avoid multiple installation of the same module
        if self._installed.has_key(path):
            return self._installed[path]
        make = self.get_option('make', self.binpath)
        target = self.get_option('target', '')
        command = '%s %s' % (make, target)
        directories = get_csv(self.get_option('directories')) or  (path, )
        self._run(command, directories, path)
        
    def check_clean(self, test, checker):
        """clean the test environment"""
        path = test.repo.env_path()
        self.writer.msg(2, 'Run preprocessor %s cleaning on %s' % (
            self.__name__, path))
        target = self.get_option('clean_target', 'clean')
        make = self.get_option('make', self.binpath)
        command = '%s %s' % (make, target)
        directories = get_csv(self.get_option('directories')) or  (path, )
        self._run(command, directories, path)
            
    def dependancy_setup(self, test, path):
        """setup the test environment

        may raise a SetupException
        """
        raise Exception('This preprocessor is not able to handle dependancies')

    def dependancy_clean(self, test, path):
        """clean the test environment"""
        pass

    # private #################################################################
    
    def _run(self, command, directories, base):
        """execute <command> in each directory"""
        cwd = os.getcwd()
        base = abspath(base)
        os.chdir(base)
        try:
            for directory in directories:
                os.chdir(directory)
                self.writer.msg(2, '%r in %s' % (command, os.getcwd()))
                status = os.system(command)
                os.chdir(base)
                if status != 0:
                    raise SetupException('%r exited with status %d in %s' % (
                    command, status, directory or cwd))
        finally:
            os.chdir(cwd)
        
 
register('preprocessor', MakeProcessor)
