# Copyright (c) 2003-2007 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""a contest decorator: add a "contest" check on each test with a set of
raw values to consider (from other checks) and a note calculated from the
selected values, using a specified formula
"""

from apycot import register
from apycot.utils import get_csv
from apycot.decorators import AbstractDecorator
from apycot.interfaces import IDecorator

class ContestDecorator(AbstractDecorator):
    """make a contest between projects by comparing some raw values to give a
    global node to each project.
    """
    
    __name__ = 'contest'
    __implements__ = IDecorator
    required_options = (('fields', 'You must specify a "fields" option on the \
activity decorator'),
                        ('expression', 'You must specify a "expression" option \
on the activity decorator'))
    
    def do_decorate(self, tree, manager):
        """make the specific decoration"""
        fields = get_csv(self.get_option('fields'))
        formula = self.get_option('expression')
        for p_node in tree.getiterator(tag='test'):
            data = {}
            for raw_node in p_node.getiterator(tag='raw'):
                name = raw_node.get('class')
                if name in fields:
                    data[name] = float(raw_node.text)
            try:
                note = max(0, eval(formula, {}, data))
            except NameError:
                note = -1
            node = self.append_check_node(p_node)
            for klass, value in [('fields', ', '.join(fields)),
                                 ('expression', formula)] + data.items():
                raw_node = node.makeelement('raw', {'class': klass})
                node.append(raw_node)
                if not isinstance(value, basestring):
                    value = unicode(value)
                raw_node.text = value
            node.set('status', '%.2f' % note)
            
register('decorator', ContestDecorator)

