# Copyright (c) 2003-2007 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""decorators register

decorators are used by the runreports utility to add some data to the collected
test datas
"""

from time import strftime, strptime, mktime, time, localtime

from apycot.utils import SimpleOptionsManagerMixIn
from apycot import IDecorator


class AbstractDecorator(SimpleOptionsManagerMixIn):
    """base class for decorators"""
    
    __implements__ = IDecorator
    __name__ = None
    
    def __init__(self, next=None):
        """construct a decorator instance by optionaly giving it the chained
        decorator
        """
        SimpleOptionsManagerMixIn.__init__(self)
        self._next = next
        
    def decorate(self, tree, manager):
        """decorate the dom node <tree> corresponding to the test definition
        <test>
        """
        self.check_options()
        self.do_decorate(tree, manager)
        if self._next is not None:
            self._next.decorate(tree, manager)
            
    def do_decorate(self, tree, manager):
        """make the specific decoration, need to be overiden in concret classes
        """
        raise NotImplementedError()

    def append_check_node(self, test_node):
        """create a virtual check node
        """
        check = test_node.makeelement('check', {'name': self.__name__,
                                               'fake': '1'})
        test_node.append(check)
        return check
        
import apycot.decorators.activity
import apycot.decorators.contest
