# Copyright (c) 2003-2005 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""
checker for Page Template files

some code comes from the ZChecker project
"""

from os.path import dirname, join

from apycot import SKIPPED
from apycot import register, IChecker
from apycot.checkers.chks_html import HTMLChecker

class ZPTChecker(HTMLChecker):
    """check syntax of Page Template file
    """
    
    __implements__ = IChecker
    __name__ = 'pt_syntax'

    def __init__(self):
        HTMLChecker.__init__(self, ('.pt', '.zpt', '.cpt'))

    def check_file(self, filepath, writer):
        """check a single file
        return true if the test succeeded, else false.
        """
        data = open(filepath).read()
        zpt = ZopePageTemplate.ZopePageTemplate('test',  text=data)
        status = 1
        for msg in zpt._v_errors:
            # FIXME line no
            writer.log(ERROR, filepath, None, msg)
            status = 0
        for msg in zpt._v_warnings:
            writer.log(WARNING, filepath, None, msg)
        html_status = HTMLChecker.check_file(self, filepath, writer)
        return status and html_status
    
    def version_info(self, writer):
        """hook for checkers to add their version information"""
        HTMLChecker.version_info(self, writer)
        vfile = open(join(dirname(ZopePageTemplate.__file__), 'version.txt'))
        version = vfile.read().strip()
        writer.raw('page_templates_version', version)


try:
    try:
        import Zope2 as Zope
    except ImportError:
        import Zope
    if hasattr(Zope, 'startup'):
        try:
            Zope.startup()
        except: # FIXME: startup doesn't finish correctly, but I don't know why...
            pass
    from Products.PageTemplates import ZopePageTemplate
    register('checker', ZPTChecker)
except ImportError:
    
    from apycot.checkers import AbstractFilteredFileChecker
    
    class DummyZPTChecker(AbstractFilteredFileChecker):
        """check syntax of Page Template file
        """

        __implements__ = IChecker
        __name__ = 'pt_syntax'

        def check_file(self, filepath, writer):
            """check a single file
            return true if the test succeeded, else false.
            """
            writer.log(ERROR, None, None, 'ZopePageTemplate is not available')
            return SKIPPED
            
    register('checker', DummyZPTChecker)
