#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for eos_bgp_global
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type

DOCUMENTATION = """
module: eos_bgp_global
short_description: Manages BGP global resource module
description: This module configures and manages the attributes of BGP global on Arista
  EOS platforms.
version_added: 1.4.0
author: Gomathi Selvi Srinivasan (@GomathiselviS)
notes:
- Tested against Arista EOS 4.24.6F
- This module works with connection C(network_cli). See the L(EOS Platform Options,eos_platform_options).
options:
    config:
      description: A list of configurations for BGP global.
      type: dict
      suboptions:
        as_number:
          description: Autonomous system number.
          type: str
        aggregate_address:
          description: Configure aggregate address.
          type: list
          elements: dict
          suboptions:
            address:
              description: ipv4/ipv6 address prefix.
              type: str
            advertise_only:
              description: Advertise without installing the generated blackhole route in
                  FIB.
              type: bool
            as_set:
              description: Generate autonomous system set path information.
              type: bool
            attribute_map:
              description: Name of the route map used to set the attribute of the
                  aggregate route.
              type: str
            match_map:
              description: Name of the route map used to filter the contributors of the
                  aggregate route.
              type: str
            summary_only:
              description: Filters all more-specific routes from updates.
              type: bool
        bgp_params:
          description: BGP parameters.
          type: dict
          suboptions:
            additional_paths:
              description: BGP additional-paths commands
              type: str
              choices: ['install', 'send', 'receive']
            advertise_inactive:
              description: Advertise BGP routes even if they are inactive in RIB.
              type: bool
            allowas_in:
              description: Allow local-as in updates.
              type: dict
              suboptions:
                set:
                  description: When True, it is set.
                  type: bool
                count:
                  description: Number of local ASNs allowed in a BGP update.
                  type: int
            always_compare_med:
              description: BGP Always Compare MED
              type: bool
            asn:
              description: AS Number notation.
              type: str
              choices: ['asdot', 'asplain']
            auto_local_addr:
              description: Automatically determine the local address to be used
                         for the non-transport AF.
              type: bool
            bestpath:
              description: Select the bestpath selection algorithim for BGP routes.
              type: dict
              suboptions:
                as_path:
                  description: Select the bestpath selection based on as-path.
                  type: str
                  choices: ['ignore', 'multipath_relax']
                ecmp_fast:
                  description: Tie-break BGP paths in a ECMP group based on the order of arrival.
                  type: bool
                med:
                  description: MED attribute
                  type: dict
                  suboptions:
                    confed:
                      description: MED Confed.
                      type: bool
                    missing_as_worst:
                      description: MED missing-as-worst.
                      type: bool
                skip:
                  description: skip one of the tie breaking rules in the bestpath selection.
                  type: bool
                tie_break:
                  description: Configure the tie-break option for BGP bestpath selection.
                  choices: ['cluster_list_length', 'router_id']
                  type: str
            client_to_client:
              description: client to client configuration.
              type: bool
            cluster_id:
              description: Cluster ID of this router acting as a route reflector.
              type: str
            confederation:
              description: confederation.
              type: dict
              suboptions:
                identifier:
                  description: Confederation identifier.
                  type: str
                peers:
                  description: Confederation peers.
                  type: str
            control_plane_filter:
              description: Control plane filter for BGP.
              type: bool
            convergence:
              description: Bgp convergence parameters.
              type: dict
              suboptions:
                slow_peer:
                  description: Maximum amount of time to wait for slow peers to estabilsh session.
                  type: bool
                time:
                  description: time in secs
                  type: int
            default:
              description: Default neighbor configuration commands.
              type: str
              choices: ['ipv4_unicast', 'ipv6_unicast']
            enforce_first_as:
              description: Enforce the First AS for EBGP routes(default).
              type: bool
            host_routes:
              description: BGP host routes configuration.
              type: bool
            labeled_unicast:
              description: Labeled Unicast.
              type: str
              choices: ['ip', 'tunnel']
            listen:
              description: BGP listen.
              type: dict
              suboptions:
                limit:
                  description: Set limit on the number of dynamic BGP peers allowed.
                  type: int
                range:
                  description: Subnet Range to be associated with the peer group.
                  type: dict
                  suboptions:
                    address:
                      description: Address prefix
                      type: str
                    peer_group:
                      description: Name of peer group.
                      type: dict
                      suboptions:
                        name:
                          description: name.
                          type: str
                        peer_filter:
                          description: Name of peer filter.
                          type: str
                        remote_as:
                          description: Neighbor AS number
                          type: str
            log_neighbor_changes:
              description: Log neighbor up/down events.
              type: bool
            missing_policy:
              description: Missing policy override configuration commands.
              type: dict
              suboptions:
                direction:
                  description: Missing policy direction options.
                  type: str
                  choices: ['in', 'out']
                action:
                  description: Missing policy action options.
                  type: str
                  choices: ['deny', 'permit', 'deny-in-out']
            monitoring:
              description: Enable Bgp monitoring for all/specified stations.
              type: bool
            next_hop_unchanged:
              description: Preserve original nexthop while advertising routes to
                     eBGP peers.
              type: bool
            redistribute_internal:
              description: Redistribute internal BGP routes.
              type: bool
            route:
              description: Configure route-map for route installation.
              type: str
            route_reflector:
              description: Configure route reflector options
              type: dict
              suboptions:
                set:
                  description: When True route_reflector is set.
                  type: bool
                preserve:
                  description: preserve route attributes, overwriting route-map changes
                  type: bool
            transport:
              description: Configure transport port for TCP session
              type: int
        default_metric:
          description: Default metric.
          type: int
        distance:
          description: Define an administrative distance.
          type: dict
          suboptions:
            external:
              description: distance for external routes.
              type: int
            internal:
              description: distance for internal routes.
              type: int
            local:
              description: distance for local routes.
              type: int
        graceful_restart:
          description: Enable graceful restart mode.
          type: dict
          suboptions:
            set:
              description: When True, graceful restart is set.
              type: bool
            restart_time:
              description: Set the max time needed to restart and come back up.
              type: int
            stalepath_time:
              description: Set the max time to hold onto restarting peer stale paths.
              type: int
        graceful_restart_helper:
          description: Enable graceful restart helper mode.
          type: bool
        access_group:
          description: ip/ipv6 access list configuration.
          type: list
          elements: dict
          suboptions:
            afi:
              description: Specify ip/ipv6.
              type: str
              choices: ['ipv4', 'ipv6']
            acl_name:
              description: access list name.
              type: str
            direction:
              description: direction of packets.
              type: str
        maximum_paths:
          description: Maximum number of equal cost paths.
          type: dict
          suboptions:
            max_equal_cost_paths:
              description: Value for maximum number of equal cost paths.
              type: int
            max_installed_ecmp_paths:
              description: Value for maximum number of installed ECMP routes.
              type: int
        monitoring:
          description: BGP monitoring protocol configuration.
          type: dict
          suboptions:
            port:
              description: Configure the BGP monitoring protocol port number <1024-65535>.
              type: int
            received:
              description: BGP monitoring protocol received route selection.
              type: str
              choices: ['post_policy', 'pre_policy']
            station:
              description: BGP monitoring station configuration.
              type: str
            timestamp:
              description: BGP monitoring protocol Per-Peer Header timestamp behavior.
              type: str
              choices: ['none', 'send_time']
        neighbor:
          description: Configure routing for a network.
          type: list
          elements: dict
          suboptions:
            neighbor_address:
              type: str
              description: Neighbor address or peer group.
              aliases:
                - peer
            additional_paths:
              description: BGP additional-paths commands.
              type: str
              choices: ['send', 'receive']
            allowas_in:
              description: Allow local-as in updates.
              type: dict
              suboptions:
                set:
                  description: When True, it is set.
                  type: bool
                count:
                  description: Number of local ASNs allowed in a BGP update.
                  type: int
            auto_local_addr:
              description: Automatically determine the local address to be used
                             for the non-transport AF.
              type: bool
            bfd:
              description: Configure BFD fallover for this peer
              type: str
              choices: ['enable', 'c_bit']
            default_originate:
              description: Originate default route to this neighbor.
              type: dict
              suboptions:
                route_map:
                  description: Route map reference.
                  type: str
                always:
                  description: Always originate default route to this neighbor.
                  type: bool
            description:
              description: Text describing the neighbor.
              type: str
            dont_capability_negotiate:
              description: Donot perform Capability Negotiation with this
                             neighbor.
              type: bool
            ebgp_multihop:
              description: Allow BGP connections to indirectly connected
                             external peers.
              type: dict
              suboptions:
                ttl:
                  description: Time-to-live in the range 1-255 hops.
                  type: int
                set:
                  description: If True, ttl is not set.
                  type: bool
            enforce_first_as:
              description: Enforce the First AS for EBGP routes(default).
              type: bool
            export_localpref:
              description: Override localpref when exporting to an internal
                             peer.
              type: int
            fall_over:
              description: Configure BFD protocol options for this peer.
              type: bool
            graceful_restart:
              description: Enable graceful restart mode.
              type: bool
            graceful_restart_helper:
              description: Enable graceful restart helper mode.
              type: bool
            idle_restart_timer:
              description: Neighbor idle restart timer.
              type: int
            import_localpref:
              description: Override localpref when importing from an external
                             peer.
              type: int
            link_bandwidth:
              description: Enable link bandwidth community for routes to this
                             peer.
              type: dict
              suboptions:
                set:
                  description: If True, set link bandwidth
                  type: bool
                auto:
                  description: Enable link bandwidth auto generation for routes from this peer.
                  type: bool
                default:
                  description: Enable link bandwidth default generation for routes from this
                                peer.
                  type: str
                update_delay:
                  description: Delay outbound route updates.
                  type: int
            local_as:
              description: Configure local AS number advertised to peer.
              type: dict
              suboptions:
                as_number:
                  description: AS number.
                  type: str
                fallback:
                  description: Prefer router AS Number over local AS Number.
                  type: bool
            local_v6_addr:
              description: The local IPv6 address of the neighbor in A:B:C:D:E:F:G:H format.
              type: str
            maximum_accepted_routes:
              description: Maximum number of routes accepted from this peer.
              type: dict
              suboptions:
                count:
                  description: Maximum number of accepted routes (0 means unlimited).
                  type: int
                warning_limit:
                  description: Maximum number of accepted routes after which a warning is issued.
                               (0 means never warn)
                  type: int
            maximum_received_routes:
              description: Maximum number of routes received from this peer.
              type: dict
              suboptions:
                count:
                  description: Maximum number of routes (0 means unlimited).
                  type: int
                warning_limit:
                  description: Percentage of maximum-routes at which warning is to be issued.
                  type: dict
                  suboptions:
                    limit_count:
                      description: Number of routes at which to warn.
                      type: int
                    limit_percent:
                      description: Percentage of maximum number of routes at which to warn( 1-100).
                      type: int
                warning_only:
                  description: Only warn, no restart, if max route limit exceeded.
                  type: bool
            metric_out:
              description: MED value to advertise to peer.
              type: int
            monitoring:
              description: Enable BGP Monitoring Protocol for this peer.
              type: bool
            next_hop_self:
              description: Always advertise this router address as the BGP
                             next hop
              type: bool
            next_hop_unchanged:
              description: Preserve original nexthop while advertising routes to
                     eBGP peers.
              type: bool
            next_hop_v6_address:
              description: IPv6 next-hop address for the neighbor
              type: str
            out_delay:
              description: Delay outbound route updates.
              type: int
            encryption_password:
              description: Password to use in computation of MD5 hash.
              type: dict
              suboptions:
                type:
                  description: Encryption type.
                  type: int
                  choices: [0, 7]
                password:
                  description: password (up to 80 chars).
                  type: str
            remote_as:
              description: Neighbor Autonomous System.
              type: str
            remove_private_as:
              description: Remove private AS number from updates to this peer.
              type: dict
              suboptions:
                set:
                  description: If True, set remove_private_as.
                  type: bool
                all:
                  description: Remove private AS number.
                  type: bool
                replace_as:
                  description: Replace private AS number with local AS number.
                  type: bool
            peer_group:
              description: Name of the peer group.
              type: str

            prefix_list:
              description: Prefix list reference.
              type: dict
              suboptions:
                direction:
                  description: Configure an inbound/outbound prefix-list.
                  type: str
                  choices: ['in', 'out']
                name:
                  description: prefix list name.
                  type: str
            route_map:
              description: Route map reference.
              type: dict
              suboptions:
                direction:
                  description: Configure an inbound/outbound route-map.
                  type: str
                  choices: ['in', 'out']
                name:
                  description: Route map name.
                  type: str
            route_reflector_client:
              description: Configure peer as a route reflector client.
              type: bool
            route_to_peer:
              description: Use routing table information to reach the peer.
              type: bool
            send_community:
              description: Send community attribute to this neighbor.
              type: dict
              suboptions:
                set:
                  description: Enable send-community
                  type: bool
                community_attribute:
                  description: Type of community attributes to send to this neighbor.
                  type: str
                sub_attribute:
                  description: Attribute to be sent to the neighbor.
                  type: str
                  choices: ['extended', 'link-bandwidth', 'standard']
                link_bandwidth_attribute:
                  description: cumulative/aggregate attribute to be sent.
                  type: str
                  choices: ['aggregate', 'divide']
                speed:
                  description: Reference link speed in bits/second
                  type: str
                divide:
                  description: link-bandwidth divide attribute.
                  type: str
                  choices: ['equal', 'ratio']
            shutdown:
              description: Administratively shut down this neighbor.
              type: bool
            soft_recognition:
              description: Configure how to handle routes that fail import.
              type: str
              choices: ['all', 'None']
            timers:
              description: Timers.
              type: dict
              suboptions:
                keepalive:
                  description: Keep Alive Interval in secs.
                  type: int
                holdtime:
                  description: Hold time in secs.
                  type: int
            transport:
              description: Configure transport options for TCP session.
              type: dict
              suboptions:
                connection_mode:
                  description: Configure connection-mode for TCP session.
                  type: str
                remote_port:
                  description: Configure BGP peer TCP port to connect to.
                  type: int
            ttl:
              description: BGP ttl security check
              type: int
            update_source:
              description: Specify the local source interface for peer BGP
                             sessions.
              type: str
            weight:
              description: Weight to assign.
              type: int
          aliases:
            - neighbors
        network:
          description: Configure routing for a network.
          type: list
          elements: dict
          suboptions:
            address:
              description: address prefix.
              type: str
            route_map:
              description: Name of route map.
              type: str
          aliases:
            - networks
        redistribute:
          description: Redistribute routes in to BGP.
          type: list
          elements: dict
          suboptions:
            protocol:
              description: Routes to be redistributed.
              type: str
              choices: ['isis', 'ospfv3', 'ospf', 'attached-host', 'connected', 'rip', 'static']
            route_map:
              description: Route map reference.
              type: str
            isis_level:
              description: Applicable for isis routes. Specify isis route level.
              type: str
              choices: ['level-1', 'level-2', 'level-1-2']
            ospf_route:
              description: ospf route options.
              type: str
              choices: ['internal', 'external', 'nssa_external_1', 'nssa_external_2']
        router_id:
          description: Router id.
          type: str
        route_target:
          description: Route target.
          type: dict
          suboptions:
            action:
              description: Route action.
              type: str
              choices: ['both', 'import', 'export']
            target:
              description: Route Target.
              type: str
        shutdown:
          description: When True, shut down BGP.
          type: bool
        timers:
          description: Timers.
          type: dict
          suboptions:
            keepalive:
              description: Keep Alive Interval in secs.
              type: int
            holdtime:
              description: Hold time in secs.
              type: int
        ucmp:
          description: Configure unequal cost multipathing.
          type: dict
          suboptions:
            fec:
              description: Configure UCMP fec utilization threshold.
              type: dict
              suboptions:
                trigger:
                  description: UCMP fec utilization too high threshold.
                  type: int
                clear:
                  description: UCMP FEC utilization Clear thresholds.
                  type: int
            link_bandwidth:
              description: Configure link-bandwidth propagation delay.
              type: dict
              suboptions:
                mode:
                  description: UCMP link bandwidth mode
                  type: str
                  choices: ['encoding_weighted', 'recursive']
                update_delay:
                  description: Link Bandwidth Advertisement delay.
                  type: int
            mode:
              description: UCMP mode.
              type: dict
              suboptions:
                set:
                  description: If True, ucmp mode is set to 1.
                  type: bool
                nexthops:
                  description: Value for total number UCMP nexthops.
                  type: int
        update:
          description: Configure BGP update generation.
          type: dict
          suboptions:
            wait_for:
              description: wait for options before converge or synchronize.
              type: str
              choices: ['wait_for_convergence', 'wait_install']
            batch_size:
              description: batch size for FIB route acknowledgements.
              type: int
        vlan:
          description: Configure MAC VRF BGP for single VLAN support.
          type: int
        vlan_aware_bundle:
          description: Configure MAC VRF BGP for multiple VLAN support.
          type: str
        vrfs:
          description: Configure BGP in a VRF.
          type: list
          elements: dict
          suboptions:
            vrf:
             description: VRF name.
             type: str
            aggregate_address:
              description: Configure aggregate address.
              type: list
              elements: dict
              suboptions:
                address:
                  description: ipv4/ipv6 address prefix.
                  type: str
                advertise_only:
                  description: Advertise without installing the generated blackhole route in
                      FIB.
                  type: bool
                as_set:
                  description: Generate autonomous system set path information.
                  type: bool
                attribute_map:
                  description: Name of the route map used to set the attribute of the
                      aggregate route.
                  type: str
                match_map:
                  description: Name of the route map used to filter the contributors of the
                      aggregate route.
                  type: str
                summary_only:
                  description: Filters all more-specific routes from updates.
                  type: bool
            bgp_params:
              description: BGP parameters.
              type: dict
              suboptions:
                additional_paths:
                  description: BGP additional-paths commands
                  type: str
                  choices: ['install', 'send', 'receive']
                advertise_inactive:
                  description: Advertise BGP routes even if they are inactive in RIB.
                  type: bool
                allowas_in:
                  description: Allow local-as in updates.
                  type: dict
                  suboptions:
                    set:
                      description: When True, it is set.
                      type: bool
                    count:
                      description: Number of local ASNs allowed in a BGP update.
                      type: int
                always_compare_med:
                  description: BGP Always Compare MED
                  type: bool
                asn:
                  description: AS Number notation.
                  type: str
                  choices: ['asdot', 'asplain']
                auto_local_addr:
                  description: Automatically determine the local address to be used
                             for the non-transport AF.
                  type: bool
                bestpath:
                  description: Select the bestpath selection algorithim for BGP routes.
                  type: dict
                  suboptions:
                    as_path:
                      description: Select the bestpath selection based on as-path.
                      type: str
                      choices: ['ignore', 'multipath_relax']
                    ecmp_fast:
                      description: Tie-break BGP paths in a ECMP group based on the order of arrival.
                      type: bool
                    med:
                      description: MED attribute
                      type: dict
                      suboptions:
                        confed:
                          description: MED Confed.
                          type: bool
                        missing_as_worst:
                          description: MED missing-as-worst.
                          type: bool
                    skip:
                      description: skip one of the tie breaking rules in the bestpath selection.
                      type: bool
                    tie_break:
                      description: Configure the tie-break option for BGP bestpath selection.
                      choices: ['cluster_list_length', 'router_id']
                      type: str
                client_to_client:
                  description: client to client configuration.
                  type: bool
                cluster_id:
                  description: Cluster ID of this router acting as a route reflector.
                  type: str
                confederation:
                  description: confederation.
                  type: dict
                  suboptions:
                    identifier:
                      description: Confederation identifier.
                      type: str
                    peers:
                      description: Confederation peers.
                      type: str
                control_plane_filter:
                  description: Control plane filter for BGP.
                  type: bool
                convergence:
                  description: Bgp convergence parameters.
                  type: dict
                  suboptions:
                    slow_peer:
                      description: Maximum amount of time to wait for slow peers to estabilsh session.
                      type: bool
                    time:
                      description: time in secs
                      type: int
                default:
                  description: Default neighbor configuration commands.
                  type: str
                  choices: ['ipv4_unicast', 'ipv6_unicast']
                enforce_first_as:
                  description: Enforce the First AS for EBGP routes(default).
                  type: bool
                host_routes:
                  description: BGP host routes configuration.
                  type: bool
                labeled_unicast:
                  description: Labeled Unicast.
                  type: str
                  choices: ['ip', 'tunnel']
                listen:
                  description: BGP listen.
                  type: dict
                  suboptions:
                    limit:
                      description: Set limit on the number of dynamic BGP peers allowed.
                      type: int
                    range:
                      description: Subnet Range to be associated with the peer group.
                      type: dict
                      suboptions:
                        address:
                          description: Address prefix
                          type: str
                        peer_group:
                          description: Name of peer group.
                          type: dict
                          suboptions:
                            name:
                              description: name.
                              type: str
                            peer_filter:
                              description: Name of peer filter.
                              type: str
                            remote_as:
                              description: Neighbor AS number
                              type: str
                log_neighbor_changes:
                  description: Log neighbor up/down events.
                  type: bool
                missing_policy:
                  description: Missing policy override configuration commands.
                  type: dict
                  suboptions:
                    direction:
                      description: Missing policy direction options.
                      type: str
                      choices: ['in', 'out']
                    action:
                      description: Missing policy action options.
                      type: str
                      choices: ['deny', 'permit', 'deny-in-out']
                monitoring:
                  description: Enable Bgp monitoring for all/specified stations.
                  type: bool
                next_hop_unchanged:
                  description: Preserve original nexthop while advertising routes to
                         eBGP peers.
                  type: bool
                redistribute_internal:
                  description: Redistribute internal BGP routes.
                  type: bool
                route:
                  description: Configure route-map for route installation.
                  type: str
                route_reflector:
                  description: Configure route reflector options
                  type: dict
                  suboptions:
                    set:
                      description: When True route_reflector is set.
                      type: bool
                    preserve:
                      description: preserve route attributes, overwriting route-map changes
                      type: bool
                transport:
                  description: Configure transport port for TCP session
                  type: int
            default_metric:
              description: Default metric.
              type: int
            distance:
              description: Define an administrative distance.
              type: dict
              suboptions:
                external:
                  description: distance for external routes.
                  type: int
                internal:
                  description: distance for internal routes.
                  type: int
                local:
                  description: distance for local routes.
                  type: int
            graceful_restart:
              description: Enable graceful restart mode.
              type: dict
              suboptions:
                set:
                  description: When True, graceful restart is set.
                  type: bool
                restart_time:
                  description: Set the max time needed to restart and come back up.
                  type: int
                stalepath_time:
                  description: Set the max time to hold onto restarting peer stale paths.
                  type: int
            graceful_restart_helper:
              description: Enable graceful restart helper mode.
              type: bool
            access_group:
              description: ip/ipv6 access list configuration.
              type: list
              elements: dict
              suboptions:
                afi:
                  description: Specify ip/ipv6.
                  type: str
                  choices: ['ipv4', 'ipv6']
                acl_name:
                  description: access list name.
                  type: str
                direction:
                  description: direction of packets.
                  type: str
            maximum_paths:
              description: Maximum number of equal cost paths.
              type: dict
              suboptions:
                max_equal_cost_paths:
                  description: Value for maximum number of equal cost paths.
                  type: int
                max_installed_ecmp_paths:
                  description: Value for maximum number of installed ECMP routes.
                  type: int
            neighbor:
              description: Configure routing for a network.
              aliases:
                - neighbors
              type: list
              elements: dict
              suboptions:
                neighbor_address:
                  type: str
                  description: Neighbor address or peer group.
                  aliases: ["peer"]
                additional_paths:
                  description: BGP additional-paths commands.
                  type: str
                  choices: ['send', 'receive']
                allowas_in:
                  description: Allow local-as in updates.
                  type: dict
                  suboptions:
                    set:
                      description: When True, it is set.
                      type: bool
                    count:
                      description: Number of local ASNs allowed in a BGP update.
                      type: int
                auto_local_addr:
                  description: Automatically determine the local address to be used
                                 for the non-transport AF.
                  type: bool
                bfd:
                  description: Configure BFD fallover for this peer
                  type: str
                  choices: ['enable', 'c_bit']
                default_originate:
                  description: Originate default route to this neighbor.
                  type: dict
                  suboptions:
                    route_map:
                      description: Route map reference.
                      type: str
                    always:
                      description: Always originate default route to this neighbor.
                      type: bool
                description:
                  description: Text describing the neighbor.
                  type: str
                dont_capability_negotiate:
                  description: Donot perform Capability Negotiation with this
                                 neighbor.
                  type: bool
                ebgp_multihop:
                  description: Allow BGP connections to indirectly connected
                                 external peers.
                  type: dict
                  suboptions:
                    ttl:
                      description: Time-to-live in the range 1-255 hops.
                      type: int
                    set:
                      description: If True, ttl is not set.
                      type: bool
                enforce_first_as:
                  description: Enforce the First AS for EBGP routes(default).
                  type: bool
                export_localpref:
                  description: Override localpref when exporting to an internal
                                 peer.
                  type: int
                fall_over:
                  description: Configure BFD protocol options for this peer.
                  type: bool
                graceful_restart:
                  description: Enable graceful restart mode.
                  type: bool
                graceful_restart_helper:
                  description: Enable graceful restart helper mode.
                  type: bool
                idle_restart_timer:
                  description: Neighbor idle restart timer.
                  type: int
                import_localpref:
                  description: Override localpref when importing from an external
                                 peer.
                  type: int
                link_bandwidth:
                  description: Enable link bandwidth community for routes to this
                                 peer.
                  type: dict
                  suboptions:
                    set:
                      description: If True, set link bandwidth
                      type: bool
                    auto:
                      description: Enable link bandwidth auto generation for routes from this peer.
                      type: bool
                    default:
                      description: Enable link bandwidth default generation for routes from this
                                    peer.
                      type: str
                    update_delay:
                      description: Delay outbound route updates.
                      type: int
                local_as:
                  description: Configure local AS number advertised to peer.
                  type: dict
                  suboptions:
                    as_number:
                      description: AS number.
                      type: str
                    fallback:
                      description: Prefer router AS Number over local AS Number.
                      type: bool
                local_v6_addr:
                  description: The local IPv6 address of the neighbor in A:B:C:D:E:F:G:H format.
                  type: str
                maximum_accepted_routes:
                  description: Maximum number of routes accepted from this peer.
                  type: dict
                  suboptions:
                    count:
                      description: Maximum number of accepted routes (0 means unlimited).
                      type: int
                    warning_limit:
                      description: Maximum number of accepted routes after which a warning is issued.
                                   (0 means never warn)
                      type: int
                maximum_received_routes:
                  description: Maximum number of routes received from this peer.
                  type: dict
                  suboptions:
                    count:
                      description: Maximum number of routes (0 means unlimited).
                      type: int
                    warning_limit:
                      description: Percentage of maximum-routes at which warning is to be issued.
                      type: dict
                      suboptions:
                        limit_count:
                          description: Number of routes at which to warn.
                          type: int
                        limit_percent:
                          description: Percentage of maximum number of routes at which to warn( 1-100).
                          type: int
                    warning_only:
                      description: Only warn, no restart, if max route limit exceeded.
                      type: bool
                metric_out:
                  description: MED value to advertise to peer.
                  type: int
                monitoring:
                  description: Enable BGP Monitoring Protocol for this peer.
                  type: bool
                next_hop_self:
                  description: Always advertise this router address as the BGP
                                 next hop
                  type: bool
                next_hop_unchanged:
                  description: Preserve original nexthop while advertising routes to
                         eBGP peers.
                  type: bool
                next_hop_v6_address:
                  description: IPv6 next-hop address for the neighbor
                  type: str
                out_delay:
                  description: Delay outbound route updates.
                  type: int
                encryption_password:
                  description: Password to use in computation of MD5 hash.
                  type: dict
                  suboptions:
                    type:
                      description: Encryption type.
                      type: int
                      choices: [0, 7]
                    password:
                      description: password (up to 80 chars).
                      type: str
                remote_as:
                  description: Neighbor Autonomous System.
                  type: str
                remove_private_as:
                  description: Remove private AS number from updates to this peer.
                  type: dict
                  suboptions:
                    set:
                      description: If True, set remove_private_as.
                      type: bool
                    all:
                      description: Remove private AS number.
                      type: bool
                    replace_as:
                      description: Replace private AS number with local AS number.
                      type: bool
                peer_group:
                  description: Name of the peer group.
                  type: str

                prefix_list:
                  description: Prefix list reference.
                  type: dict
                  suboptions:
                    direction:
                      description: Configure an inbound/outbound prefix-list.
                      type: str
                      choices: ['in', 'out']
                    name:
                      description: prefix list name.
                      type: str
                route_map:
                  description: Route map reference.
                  type: dict
                  suboptions:
                    direction:
                      description: Configure an inbound/outbound route-map.
                      type: str
                      choices: ['in', 'out']
                    name:
                      description: Route map name.
                      type: str
                route_reflector_client:
                  description: Configure peer as a route reflector client.
                  type: bool
                route_to_peer:
                  description: Use routing table information to reach the peer.
                  type: bool
                send_community:
                  description: Send community attribute to this neighbor.
                  type: dict
                  suboptions:
                    community_attribute:
                      description: Type of community attributes to send to this neighbor.
                      type: str
                    sub_attribute:
                      description: Attribute to be sent to the neighbor.
                      type: str
                      choices: ['extended', 'link-bandwidth', 'standard']
                    link_bandwidth_attribute:
                      description: cumulative/aggregate attribute to be sent.
                      type: str
                      choices: ['aggregate', 'divide']
                    speed:
                      description: Reference link speed in bits/second
                      type: str
                    divide:
                      description: link-bandwidth divide attribute.
                      type: str
                      choices: ['equal', 'ratio']
                shutdown:
                  description: Administratively shut down this neighbor.
                  type: bool
                soft_recognition:
                  description: Configure how to handle routes that fail import.
                  type: str
                  choices: ['all', 'None']
                timers:
                  description: Timers.
                  type: dict
                  suboptions:
                    keepalive:
                      description: Keep Alive Interval in secs.
                      type: int
                    holdtime:
                      description: Hold time in secs.
                      type: int
                transport:
                  description: Configure transport options for TCP session.
                  type: dict
                  suboptions:
                    connection_mode:
                      description: Configure connection-mode for TCP session.
                      type: str
                    remote_port:
                      description: Configure BGP peer TCP port to connect to.
                      type: int
                ttl:
                  description: BGP ttl security check
                  type: int
                update_source:
                  description: Specify the local source interface for peer BGP
                                 sessions.
                  type: str
                weight:
                  description: Weight to assign.
                  type: int
            network:
              description: Configure routing for a network.
              aliases:
                - networks
              type: list
              elements: dict
              suboptions:
                address:
                  description: address prefix.
                  type: str
                route_map:
                  description: Name of route map.
                  type: str
            redistribute:
              description: Redistribute routes in to BGP.
              type: list
              elements: dict
              suboptions:
                protocol:
                  description: Routes to be redistributed.
                  type: str
                  choices: ['isis', 'ospfv3', 'ospf', 'attached-host', 'connected', 'rip', 'static']
                route_map:
                  description: Route map reference.
                  type: str
                isis_level:
                  description: Applicable for isis routes. Specify isis route level.
                  type: str
                  choices: ['level-1', 'level-2', 'level-1-2']
                ospf_route:
                  description: ospf route options.
                  type: str
                  choices: ['internal', 'external', 'nssa_external_1', 'nssa_external_2']
            route_target:
              description: Route target.
              type: dict
              suboptions:
                action:
                  description: Route action.
                  type: str
                  choices: ['both', 'import', 'export']
                type:
                  description: Type of address fmaily
                  type: str
                  choices: ['evpn', 'vpn-ipv4', 'vpn-ipv6']
                route_map:
                  description: Name of a route map.
                  type: str
                target:
                  description: Route Target.
                  type: str
                imported_route:
                  description: Export routes imported from the same Afi/Safi.
                  type: bool
            router_id:
              description: Router id.
              type: str
            shutdown:
              description: When True, shut down BGP.
              type: bool
            timers:
              description: Timers.
              type: dict
              suboptions:
                keepalive:
                  description: Keep Alive Interval in secs.
                  type: int
                holdtime:
                  description: Hold time in secs.
                  type: int
            ucmp:
              description: Configure unequal cost multipathing.
              type: dict
              suboptions:
                fec:
                  description: Configure UCMP fec utilization threshold.
                  type: dict
                  suboptions:
                    trigger:
                      description: UCMP fec utilization too high threshold.
                      type: int
                    clear:
                      description: UCMP FEC utilization Clear thresholds.
                      type: int
                link_bandwidth:
                  description: Configure link-bandwidth propagation delay.
                  type: dict
                  suboptions:
                    mode:
                      description: UCMP link bandwidth mode
                      type: str
                      choices: ['encoding_weighted', 'recursive', 'update_delay']
                    update_delay:
                      description: Link Bandwidth Advertisement delay.
                      type: int
                mode:
                  description: UCMP mode.
                  type: dict
                  suboptions:
                    set:
                      description: If True, ucmp mode is set to 1.
                      type: bool
                    nexthops:
                      description: Value for total number UCMP nexthops.
                      type: int
            update:
              description: Configure BGP update generation.
              type: dict
              suboptions:
                wait_for:
                  description: wait for options before converge or synchronize.
                  type: str
                  choices: ['wait_for_convergence', 'wait_install']
                batch_size:
                  description: batch size for FIB route acknowledgements.
                  type: int
    running_config:
      description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the EOS device by
        executing the command B(show running-config | section bgp).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result.
      type: str
    state:
      description:
      - The state the configuration should be left in.
      - State I(purged) removes all the BGP configurations from the
        target device. Use caution with this state.('no router bgp <x>')
      - State I(deleted) only removes BGP attributes that this modules
        manages and does not negate the BGP process completely. Thereby, preserving
        address-family related configurations under BGP context.
      - Running states I(deleted) and I(replaced) will result in an error if there
        are address-family configuration lines present under vrf context that is
        is to be removed. Please use the  M(arista.eos.eos_bgp_address_family)
        module for prior cleanup.
      - Refer to examples for more details.
      type: str
      choices: [deleted, merged, purged, replaced, gathered, rendered, parsed]
      default: merged
"""
EXAMPLES = """
# Using merged
# Before state

# veos(config)#show running-config | section bgp
# veos(config)#

  - name: Merge provided configuration with device configuration
    arista.eos.eos_bgp_global:
      config:
        as_number: "100"
        bgp_params:
          host_routes: True
          convergence:
            slow_peer: True
            time: 6
          additional_paths: "send"
          log_neighbor_changes: True
        maximum_paths:
          max_equal_cost_paths: 55
        aggregate_address:
          - address: "1.2.1.0/24"
            as_set: true
            match_map: "match01"
          - address: "5.2.1.0/24"
            attribute_map: "attrmatch01"
            advertise_only: true
        redistribute:
          - protocol: "static"
            route_map: "map_static"
          - protocol: "attached-host"
        distance:
          internal: 50
        neighbor:
          - peer: "10.1.3.2"
            allowas_in:
              set: true
            default_originate:
              always: true
            dont_capability_negotiate: true
            export_localpref: 4000
            maximum_received_routes:
              count: 500
              warning_limit:
                limit_percent: 5
            next_hop_unchanged: true
            prefix_list:
              name: "prefix01"
              direction: "out"
          - neighbor_address: "peer1"
            fall_over: true
            link_bandwidth:
              update_delay: 5
            monitoring: True
            send_community:
              community_attribute: "extended"
              sub_attribute: "link-bandwidth"
              link_bandwidth_attribute: "aggregate"
              speed: "600"
        vlan: 5
      state: merged

# After State:
# veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    distance bgp 50 50 50
#    maximum-paths 55
#    bgp additional-paths send any
#    neighbor peer1 peer group
#    neighbor peer1 link-bandwidth update-delay 5
#    neighbor peer1 fall-over bfd
#    neighbor peer1 monitoring
#    neighbor peer1 send-community extended link-bandwidth aggregate 600
#    neighbor peer1 maximum-routes 12000
#    neighbor 10.1.3.2 export-localpref 4000
#    neighbor 10.1.3.2 next-hop-unchanged
#    neighbor 10.1.3.2 dont-capability-negotiate
#    neighbor 10.1.3.2 allowas-in 3
#    neighbor 10.1.3.2 default-originate always
#    neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#    aggregate-address 1.2.1.0/24 as-set match-map match01
#    aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#    redistribute static route-map map_static
#    redistribute attached-host
#    !
#    vlan 5
#    !
#    address-family ipv4
#       neighbor 10.1.3.2 prefix-list prefix01 out
# veos(config)#
#
# Module Execution:
#
# "after": {
#         "aggregate_address": [
#             {
#                 "address": "1.2.1.0/24",
#                 "as_set": true,
#                 "match_map": "match01"
#             },
#             {
#                 "address": "5.2.1.0/24",
#                 "advertise_only": true,
#                 "attribute_map": "attrmatch01"
#             }
#         ],
#         "as_number": "100",
#         "bgp_params": {
#             "additional_paths": "send",
#             "convergence": {
#                 "slow_peer": true,
#                 "time": 6
#             }
#         },
#         "distance": {
#             "external": 50,
#             "internal": 50,
#             "local": 50
#         },
#         "maximum_paths": {
#             "max_equal_cost_paths": 55
#         },
#         "neighbor": [
#             {
#                 "fall_over": true,
#                 "link_bandwidth": {
#                     "set": true,
#                     "update_delay": 5
#                 },
#                 "maximum_received_routes": {
#                     "count": 12000
#                 },
#                 "monitoring": true,
#                 "peer": "peer1",
#                 "peer_group": "peer1",
#                 "send_community": {
#                     "community_attribute": "extended",
#                     "link_bandwidth_attribute": "aggregate",
#                     "speed": "600",
#                     "sub_attribute": "link-bandwidth"
#                 }
#             },
#             {
#                 "allowas_in": {
#                     "count": 3
#                 },
#                 "default_originate": {
#                     "always": true
#                 },
#                 "dont_capability_negotiate": true,
#                 "export_localpref": 4000,
#                 "maximum_received_routes": {
#                     "count": 500,
#                     "warning_limit": {
#                         "limit_percent": 5
#                     }
#                 },
#                 "next_hop_unchanged": true,
#                 "peer": "10.1.3.2"
#             }
#         ],
#         "redistribute": [
#             {
#                 "protocol": "static",
#                 "route_map": "map_static"
#             },
#             {
#                 "protocol": "attached-host"
#             }
#         ],
#         "vlan": 5
#     },
#     "before": {},
#     "changed": true,
#     "commands": [
#         "router bgp 100",
#         "neighbor 10.1.3.2 allowas-in",
#         "neighbor 10.1.3.2 default-originate always",
#         "neighbor 10.1.3.2 dont-capability-negotiate",
#         "neighbor 10.1.3.2 export-localpref 4000",
#         "neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent",
#         "neighbor 10.1.3.2 next-hop-unchanged",
#         "neighbor 10.1.3.2 prefix-list prefix01 out",
#         "neighbor peer1 fall-over bfd",
#         "neighbor peer1 link-bandwidth update-delay 5",
#         "neighbor peer1 monitoring",
#         "neighbor peer1 send-community extended link-bandwidth aggregate 600",
#         "redistribute static route-map map_static",
#         "redistribute attached-host",
#         "aggregate-address 1.2.1.0/24 as-set match-map match01",
#         "aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only",
#         "bgp host-routes fib direct-install",
#         "bgp convergence slow-peer time 6",
#         "bgp additional-paths send any",
#         "bgp log-neighbor-changes",
#         "maximum-paths 55",
#         "distance bgp 50",
#         "vlan 5"
#     ],

# Using replaced:

# Before state:
# veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    distance bgp 50 50 50
#    maximum-paths 55
#    bgp additional-paths send any
#    neighbor peer1 peer group
#    neighbor peer1 link-bandwidth update-delay 5
#    neighbor peer1 fall-over bfd
#    neighbor peer1 monitoring
#    neighbor peer1 send-community extended link-bandwidth aggregate 600
#    neighbor peer1 maximum-routes 12000
#    neighbor 10.1.3.2 export-localpref 4000
#    neighbor 10.1.3.2 next-hop-unchanged
#    neighbor 10.1.3.2 dont-capability-negotiate
#    neighbor 10.1.3.2 allowas-in 3
#    neighbor 10.1.3.2 default-originate always
#    neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#    aggregate-address 1.2.1.0/24 as-set match-map match01
#    aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#    redistribute static route-map map_static
#    redistribute attached-host
#    !
#    vlan 5
#    !
#    address-family ipv4
#       neighbor 10.1.3.2 prefix-list prefix01 out
#    !
#    vrf vrf01
#       route-target import 54:11
#       neighbor 12.1.3.2 dont-capability-negotiate
#       neighbor 12.1.3.2 allowas-in 3
#       neighbor 12.1.3.2 default-originate always
#       neighbor 12.1.3.2 maximum-routes 12000
# veos(config)#

  - name: replace provided configuration with device configuration
    arista.eos.eos_bgp_global:
      config:
        as_number: "100"
        bgp_params:
          host_routes: True
          convergence:
            slow_peer: True
            time: 6
          additional_paths: "send"
          log_neighbor_changes: True
        vrfs:
          - vrf: "vrf01"
            maximum_paths:
              max_equal_cost_paths: 55
            aggregate_address:
              - address: "1.2.1.0/24"
                as_set: true
                match_map: "match01"
              - address: "5.2.1.0/24"
                attribute_map: "attrmatch01"
                advertise_only: true
            redistribute:
              - protocol: "static"
                route_map: "map_static"
              - protocol: "attached-host"
            distance:
              internal: 50
            neighbor:
              - neighbor_address: "10.1.3.2"
                allowas_in:
                  set: true
                default_originate:
                  always: true
                dont_capability_negotiate: true
                export_localpref: 4000
                maximum_received_routes:
                  count: 500
                  warning_limit:
                    limit_percent: 5
                next_hop_unchanged: true
                prefix_list:
                  name: "prefix01"
                  direction: "out"
              - neighbor_address: "peer1"
                fall_over: true
                link_bandwidth:
                  update_delay: 5
                monitoring: True
                send_community:
                  community_attribute: "extended"
                  sub_attribute: "link-bandwidth"
                  link_bandwidth_attribute: "aggregate"
                  speed: "600"
      state: replaced

# After State:

# veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    bgp additional-paths send any
#    !
#    vrf vrf01
#       distance bgp 50 50 50
#       maximum-paths 55
#       neighbor 10.1.3.2 export-localpref 4000
#       neighbor 10.1.3.2 next-hop-unchanged
#       neighbor 10.1.3.2 dont-capability-negotiate
#       neighbor 10.1.3.2 allowas-in 3
#       neighbor 10.1.3.2 default-originate always
#       neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#       aggregate-address 1.2.1.0/24 as-set match-map match01
#       aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#       redistribute static route-map map_static
#       redistribute attached-host
#       !
#       address-family ipv4
#          neighbor 10.1.3.2 prefix-list prefix01 out
# veos(config)#
#
#
# Module Execution:
#
# "after": {
#         "as_number": "100",
#         "bgp_params": {
#             "additional_paths": "send",
#             "convergence": {
#                 "slow_peer": true,
#                 "time": 6
#             }
#         },
#         "vrfs": [
#             {
#                 "aggregate_address": [
#                     {
#                         "address": "1.2.1.0/24",
#                         "as_set": true,
#                         "match_map": "match01"
#                     },
#                     {
#                         "address": "5.2.1.0/24",
#                         "advertise_only": true,
#                         "attribute_map": "attrmatch01"
#                     }
#                 ],
#                 "distance": {
#                     "external": 50,
#                     "internal": 50,
#                     "local": 50
#                 },
#                 "maximum_paths": {
#                     "max_equal_cost_paths": 55
#                 },
#                 "neighbor": [
#                     {
#                         "allowas_in": {
#                             "count": 3
#                         },
#                         "default_originate": {
#                             "always": true
#                         },
#                         "dont_capability_negotiate": true,
#                         "export_localpref": 4000,
#                         "maximum_received_routes": {
#                             "count": 500,
#                             "warning_limit": {
#                                 "limit_percent": 5
#                             }
#                         },
#                         "next_hop_unchanged": true,
#                         "peer": "10.1.3.2"
#                     }
#                 ],
#                 "redistribute": [
#                     {
#                         "protocol": "static",
#                         "route_map": "map_static"
#                     },
#                     {
#                         "protocol": "attached-host"
#                     }
#                 ],
#                 "vrf": "vrf01"
#             }
#         ]
#     },
#     "before": {
#         "aggregate_address": [
#             {
#                 "address": "1.2.1.0/24",
#                 "as_set": true,
#                 "match_map": "match01"
#             },
#             {
#                 "address": "5.2.1.0/24",
#                 "advertise_only": true,
#                 "attribute_map": "attrmatch01"
#             }
#         ],
#         "as_number": "100",
#         "bgp_params": {
#             "additional_paths": "send",
#             "convergence": {
#                 "slow_peer": true,
#                 "time": 6
#             }
#         },
#         "distance": {
#             "external": 50,
#             "internal": 50,
#             "local": 50
#         },
#         "maximum_paths": {
#             "max_equal_cost_paths": 55
#         },
#         "neighbor": [
#             {
#                 "fall_over": true,
#                 "link_bandwidth": {
#                     "set": true,
#                     "update_delay": 5
#                 },
#                 "maximum_received_routes": {
#                     "count": 12000
#                 },
#                 "monitoring": true,
#                 "peer": "peer1",
#                 "peer_group": "peer1",
#                 "send_community": {
#                     "community_attribute": "extended",
#                     "link_bandwidth_attribute": "aggregate",
#                     "speed": "600",
#                     "sub_attribute": "link-bandwidth"
#                 }
#             },
#             {
#                 "allowas_in": {
#                     "count": 3
#                 },
#                 "default_originate": {
#                     "always": true
#                 },
#                 "dont_capability_negotiate": true,
#                 "export_localpref": 4000,
#                 "maximum_received_routes": {
#                     "count": 500,
#                     "warning_limit": {
#                         "limit_percent": 5
#                     }
#                 },
#                 "next_hop_unchanged": true,
#                 "peer": "10.1.3.2"
#             }
#         ],
#         "redistribute": [
#             {
#                 "protocol": "static",
#                 "route_map": "map_static"
#             },
#             {
#                 "protocol": "attached-host"
#             }
#         ],
#         "vlan": 5,
#         "vrfs": [
#             {
#                 "neighbor": [
#                     {
#                         "allowas_in": {
#                             "count": 3
#                         },
#                         "default_originate": {
#                             "always": true
#                         },
#                         "dont_capability_negotiate": true,
#                         "maximum_received_routes": {
#                             "count": 12000
#                         },
#                         "peer": "12.1.3.2"
#                     }
#                 ],
#                 "route_target": {
#                     "action": "import",
#                     "target": "54:11"
#                 },
#                 "vrf": "vrf01"
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#         "router bgp 100",
#         "vrf vrf01",
#         "no route-target import 54:11",
#         "neighbor 10.1.3.2 allowas-in",
#         "neighbor 10.1.3.2 default-originate always",
#         "neighbor 10.1.3.2 dont-capability-negotiate",
#         "neighbor 10.1.3.2 export-localpref 4000",
#         "neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent",
#         "neighbor 10.1.3.2 next-hop-unchanged",
#         "neighbor 10.1.3.2 prefix-list prefix01 out",
#         "neighbor peer1 fall-over bfd",
#         "neighbor peer1 link-bandwidth update-delay 5",
#         "neighbor peer1 monitoring",
#         "neighbor peer1 send-community extended link-bandwidth aggregate 600",
#         "no neighbor 12.1.3.2",
#         "redistribute static route-map map_static",
#         "redistribute attached-host",
#         "aggregate-address 1.2.1.0/24 as-set match-map match01",
#         "aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only",
#         "maximum-paths 55",
#         "distance bgp 50",
#         "exit",
#         "no neighbor peer1 peer group",
#         "no neighbor peer1 link-bandwidth update-delay 5",
#         "no neighbor peer1 fall-over bfd",
#         "no neighbor peer1 monitoring",
#         "no neighbor peer1 send-community extended link-bandwidth aggregate 600",
#         "no neighbor peer1 maximum-routes 12000",
#         "no neighbor 10.1.3.2",
#         "no redistribute static route-map map_static",
#         "no redistribute attached-host",
#         "no aggregate-address 1.2.1.0/24 as-set match-map match01",
#         "no aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only",
#         "bgp host-routes fib direct-install",
#         "bgp log-neighbor-changes",
#         "no distance bgp 50 50 50",
#         "no maximum-paths 55",
#         "no vlan 5"
#     ],
#

# Using replaced (in presence of address_family under vrf):
# Before State:

#veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    bgp additional-paths send any
#    !
#    vrf vrf01
#       distance bgp 50 50 50
#       maximum-paths 55
#       neighbor 10.1.3.2 export-localpref 4000
#       neighbor 10.1.3.2 next-hop-unchanged
#       neighbor 10.1.3.2 dont-capability-negotiate
#       neighbor 10.1.3.2 allowas-in 3
#       neighbor 10.1.3.2 default-originate always
#       neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#       aggregate-address 1.2.1.0/24 as-set match-map match01
#       aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#       redistribute static route-map map_static
#       redistribute attached-host
#       !
#       address-family ipv4
#          neighbor 10.1.3.2 prefix-list prefix01 out
#       !
#       address-family ipv6
#          redistribute dhcp
# veos(config)#

  - name:  Replace
    arista.eos.eos_bgp_global:
      config:
        as_number: "100"
        graceful_restart:
          set: True
        router_id: "1.1.1.1"
        timers:
          keepalive: 2
          holdtime: 5
        ucmp:
          mode:
            set: True
        vlan_aware_bundle: "bundle1 bundle2 bundle3"
      state: replaced

# Module Execution:

# fatal: [192.168.122.113]: FAILED! => {
#     "changed": false,
#     "invocation": {
#         "module_args": {
#             "config": {
#                 "access_group": null,
#                 "aggregate_address": null,
#                 "as_number": "100",
#                 "bgp_params": null,
#                 "default_metric": null,
#                 "distance": null,
#                 "graceful_restart": {
#                     "restart_time": null,
#                     "set": true,
#                     "stalepath_time": null
#                 },
#                 "graceful_restart_helper": null,
#                 "maximum_paths": null,
#                 "monitoring": null,
#                 "neighbor": null,
#                 "network": null,
#                 "redistribute": null,
#                 "route_target": null,
#                 "router_id": "1.1.1.1",
#                 "shutdown": null,
#                 "timers": {
#                     "holdtime": 5,
#                     "keepalive": 2
#                 },
#                 "ucmp": {
#                     "fec": null,
#                     "link_bandwidth": null,
#                     "mode": {
#                         "nexthops": null,
#                         "set": true
#                     }
#                 },
#                 "update": null,
#                 "vlan": null,
#                 "vlan_aware_bundle": "bundle1 bundle2 bundle3",
#                 "vrfs": null
#             },
#             "running_config": null,
#             "state": "replaced"
#         }
#     },
#     "msg": "Use the _bgp_af module to delete the address_family under vrf, before replacing/deleting the vrf."
# }

# Using deleted:

# Before state:

# veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    bgp additional-paths send any
#    !
#    vrf vrf01
#       distance bgp 50 50 50
#       maximum-paths 55
#       neighbor 10.1.3.2 export-localpref 4000
#       neighbor 10.1.3.2 next-hop-unchanged
#       neighbor 10.1.3.2 dont-capability-negotiate
#       neighbor 10.1.3.2 allowas-in 3
#       neighbor 10.1.3.2 default-originate always
#       neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#       aggregate-address 1.2.1.0/24 as-set match-map match01
#       aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#       redistribute static route-map map_static
#       redistribute attached-host
#       !

  - name: Delete configuration
    arista.eos.eos_bgp_global:
      config:
        as_number: "100"
      state: deleted

# After State:

# veos(config)#show running-config | section bgp
# router bgp 100
#
#
# Module Execution:
#
# "after": {
#         "as_number": "100"
#     },
#     "before": {
#         "as_number": "100",
#         "bgp_params": {
#             "additional_paths": "send",
#             "convergence": {
#                 "slow_peer": true,
#                 "time": 6
#             }
#         },
#         "vrfs": [
#             {
#                 "aggregate_address": [
#                     {
#                         "address": "1.2.1.0/24",
#                         "as_set": true,
#                         "match_map": "match01"
#                     },
#                     {
#                         "address": "5.2.1.0/24",
#                         "advertise_only": true,
#                         "attribute_map": "attrmatch01"
#                     }
#                 ],
#                 "distance": {
#                     "external": 50,
#                     "internal": 50,
#                     "local": 50
#                 },
#                 "maximum_paths": {
#                     "max_equal_cost_paths": 55
#                 },
#                 "neighbor": [
#                     {
#                         "allowas_in": {
#                             "count": 3
#                         },
#                         "default_originate": {
#                             "always": true
#                         },
#                         "dont_capability_negotiate": true,
#                         "export_localpref": 4000,
#                         "maximum_received_routes": {
#                             "count": 500,
#                             "warning_limit": {
#                                 "limit_percent": 5
#                             }
#                         },
#                         "next_hop_unchanged": true,
#                         "peer": "10.1.3.2"
#                     }
#                 ],
#                 "redistribute": [
#                     {
#                         "protocol": "static",
#                         "route_map": "map_static"
#                     },
#                     {
#                         "protocol": "attached-host"
#                     }
#                 ],
#                 "vrf": "vrf01"
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#         "router bgp 100",
#         "no vrf vrf01",
#         "no bgp convergence slow-peer time 6",
#         "no bgp additional-paths send any"
#     ],
#

# Using purged:

# Before state:

# veos(config)#show running-config | section bgp
# router bgp 100
#    bgp convergence slow-peer time 6
#    distance bgp 50 50 50
#    maximum-paths 55
#    bgp additional-paths send any
#    neighbor peer1 peer group
#    neighbor peer1 link-bandwidth update-delay 5
#    neighbor peer1 fall-over bfd
#    neighbor peer1 monitoring
#    neighbor peer1 send-community extended link-bandwidth aggregate 600
#    neighbor peer1 maximum-routes 12000
#    neighbor 10.1.3.2 export-localpref 4000
#    neighbor 10.1.3.2 next-hop-unchanged
#    neighbor 10.1.3.2 dont-capability-negotiate
#    neighbor 10.1.3.2 allowas-in 3
#    neighbor 10.1.3.2 default-originate always
#    neighbor 10.1.3.2 maximum-routes 500 warning-limit 5 percent
#    aggregate-address 1.2.1.0/24 as-set match-map match01
#    aggregate-address 5.2.1.0/24 attribute-map attrmatch01 advertise-only
#    redistribute static route-map map_static
#    redistribute attached-host
#    !
#    vlan 5
#    !
#    address-family ipv4
#       neighbor 10.1.3.2 prefix-list prefix01 out
#    !
#    vrf vrf01
#       route-target import 54:11
#       neighbor 12.1.3.2 dont-capability-negotiate
#       neighbor 12.1.3.2 allowas-in 3
#       neighbor 12.1.3.2 default-originate always
#       neighbor 12.1.3.2 maximum-routes 12000
# veos(config)#

  - name: Purge configuration
    arista.eos.eos_bgp_global:
      config:
        as_number: "100"
      state: purged

# After State:

# veos(config)#show running-config | section bgp
# veos(config)#

# Module Execution:

# "after": {},
#     "before": {
#         "aggregate_address": [
#             {
#                 "address": "1.2.1.0/24",
#                 "as_set": true,
#                 "match_map": "match01"
#             },
#             {
#                 "address": "5.2.1.0/24",
#                 "advertise_only": true,
#                 "attribute_map": "attrmatch01"
#             }
#         ],
#         "as_number": "100",
#         "bgp_params": {
#             "additional_paths": "send",
#             "convergence": {
#                 "slow_peer": true,
#                 "time": 6
#             }
#         },
#         "distance": {
#             "external": 50,
#             "internal": 50,
#             "local": 50
#         },
#         "maximum_paths": {
#             "max_equal_cost_paths": 55
#         },
#         "neighbor": [
#             {
#                 "fall_over": true,
#                 "link_bandwidth": {
#                     "set": true,
#                     "update_delay": 5
#                 },
#                 "maximum_received_routes": {
#                     "count": 12000
#                 },
#                 "monitoring": true,
#                 "peer": "peer1",
#                 "peer_group": "peer1",
#                 "send_community": {
#                     "community_attribute": "extended",
#                     "link_bandwidth_attribute": "aggregate",
#                     "speed": "600",
#                     "sub_attribute": "link-bandwidth"
#                 }
#             },
#             {
#                 "allowas_in": {
#                     "count": 3
#                 },
#                 "default_originate": {
#                     "always": true
#                 },
#                 "dont_capability_negotiate": true,
#                 "export_localpref": 4000,
#                 "maximum_received_routes": {
#                     "count": 500,
#                     "warning_limit": {
#                         "limit_percent": 5
#                     }
#                 },
#                 "next_hop_unchanged": true,
#                 "peer": "10.1.3.2"
#             }
#         ],
#         "redistribute": [
#             {
#                 "protocol": "static",
#                 "route_map": "map_static"
#             },
#             {
#                 "protocol": "attached-host"
#             }
#         ],
#         "vlan": 5,
#         "vrfs": [
#             {
#                 "neighbor": [
#                     {
#                         "allowas_in": {
#                             "count": 3
#                         },
#                         "default_originate": {
#                             "always": true
#                         },
#                         "dont_capability_negotiate": true,
#                         "maximum_received_routes": {
#                             "count": 12000
#                         },
#                         "peer": "12.1.3.2"
#                     }
#                 ],
#                 "route_target": {
#                     "action": "import",
#                     "target": "54:11"
#                 },
#                 "vrf": "vrf01"
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#         "no router bgp 100"
#     ],

"""

from ansible.module_utils.basic import AnsibleModule
from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.bgp_global.bgp_global import (
    Bgp_globalArgs,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.bgp_global.bgp_global import (
    Bgp_global,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(
        argument_spec=Bgp_globalArgs.argument_spec,
        mutually_exclusive=[["config", "running_config"]],
        required_if=[
            ["state", "merged", ["config"]],
            ["state", "replaced", ["config"]],
            ["state", "rendered", ["config"]],
            ["state", "parsed", ["running_config"]],
        ],
        supports_check_mode=True,
    )

    result = Bgp_global(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
