from MMTK import *
from HarmonicOscillatorFF import HarmonicOscillatorForceField
from MMTK.ForceFields.ForceFieldTest import gradientTest, forceConstantTest
from MMTK.Environment import PathIntegrals
from MMTK_PINormalModeIntegrator import PINormalModeIntegrator, PILangevinNormalModeIntegrator
from MMTK.Trajectory import Trajectory, TrajectoryOutput, \
                            RestartTrajectoryOutput, StandardLogOutput

universe = InfiniteUniverse()
universe.atom = Atom('C', position=Vector(0., 0., 1.1), name='C', nbeads=16)
universe.path_integrals = PathIntegrals(50.*Units.K)

ff = HarmonicOscillatorForceField(universe.atom, Vector(0., 0., 1.), 1000.)
universe.setForceField(ff)

universe.initializeVelocitiesToTemperature(50.*Units.K)
integrator = PINormalModeIntegrator(universe, delta_t=1.*Units.fs)
trajectory = Trajectory(universe, "oscillator.nc", "w")
integrator(steps=100,
           actions = [TrajectoryOutput(trajectory, ("time",
                                                    "energy",
                                                    "thermodynamic",
                                                    "auxiliary",
                                                    "configuration"),
                                       0, None, 1)])
trajectory.close()
