from MMTK import *
from HarmonicOscillatorFF import HarmonicOscillatorForceField
from MMTK.ForceFields.ForceFieldTest import gradientTest, forceConstantTest, virialTest
from MMTK_PINormalModeIntegrator import PILangevinNormalModeIntegrator
from MMTK_PICartesianIntegrator import PICartesianIntegrator, PILangevinCartesianIntegrator

from MMTK.Trajectory import Trajectory, TrajectoryOutput
from Scientific import N
from Scientific.Statistics import mean, standardDeviation


# Parameters
temperature = 10.*Units.K  # temperature
nb = 64                 # number of beads
k = 10.                    # force constant
dt = 0.005                 # time step for integration

universe = InfiniteUniverse()
#universe.addObject(Environment.PathIntegrals(temperature))
universe.addObject(Environment.PathIntegrals(temperature, True))

universe.atom1 = Atom('H', position=Vector(0., 0., 0.3))
universe.atom1.setNumberOfBeads(nb)

ff1 = HarmonicOscillatorForceField(universe.atom1, Vector(0., 0., 0.), k)
universe.setForceField(ff1)
universe.initializeVelocitiesToTemperature(temperature)

# Calculate the exact average quantum energy
m1 = universe.atom1.mass()
omega = N.sqrt(k/m1)
beta = 1./(Units.k_B*temperature)
e = 3*Units.hbar*omega*(0.5+1./(N.exp(beta*Units.hbar*omega)-1))
print "Quantum energy:", e/Units.hbar*omega, 1./(beta*Units.hbar*omega)

# Create the integrator
#integrator = PILangevinNormalModeIntegrator(universe, delta_t=dt,
#                                            centroid_friction = 1./Units.ps)

integrator = PILangevinCartesianIntegrator(universe, delta_t=dt,
                                           friction_matrix = N.array([[1./Units.ps]]))

# Equilibration
for i in range(10):
    integrator(steps=100)
    universe.initializeVelocitiesToTemperature(temperature)
integrator(steps=100)

# Production run
trajectory = Trajectory(universe, "harmonic_oscillator.nc", "w")
integrator(steps=15000,
           actions = [TrajectoryOutput(trajectory, ("time", "energy",
                                                    "thermodynamic",
                                                    "auxiliary",
                                                    "configuration"),
                                       0, None, 10)])

# Print averages of the quantu energy estimator
data = trajectory.quantum_energy_primitive
print "Primitive estimator / hw:", mean(data)/Units.hbar*omega, "+/-",  standardDeviation(data)
data = trajectory.quantum_energy_virial
print "Virial estimator / hw:", mean(data)/Units.hbar*omega, "+/-",  standardDeviation(data)
data = trajectory.quantum_energy_centroid_virial
print "Centroid virial estimator / hw:", mean(data)/Units.hbar*omega, "+/-",  standardDeviation(data)
data = trajectory.temperature
print "Temperature:", mean(data), "+/-",  standardDeviation(data)

# Close the trajectory
trajectory.close()
