from MMTK import *
from HarmonicOscillatorFF import HarmonicOscillatorForceField
from MMTK_PINormalModeIntegrator import PILangevinNormalModeIntegrator, PINormalModeIntegrator
from MMTK_PICartesianIntegrator import PILangevinCartesianIntegrator
from MMTK.Trajectory import Trajectory, TrajectoryOutput, \
                            RestartTrajectoryOutput, StandardLogOutput
from Scientific import N
from Scientific.Statistics import mean, standardDeviation

A = N.array([[ 1.550719338686e+2,  2.273560640784e-1,  9.611733109142e+0, -3.036648942289e+1, 1.932451521298e+2],
             [-2.319064721646e-1,  7.167591190312e-5,  6.019918581145e-1, -1.654856441675e-1,  3.536551384867e-1],
             [-1.236339310469e+1, -6.019918581145e-1,  1.133359234692e+0,  4.294545656715e+0, -8.334871768539e+0],
             [-8.649474645630e+0,  1.654856441675e-1, -4.294545656715e+0,  2.223364030834e+1,  9.596401703453e+0],
             [ 1.818036581075e+2, -3.536551384867e-1,  8.334871768539e+0, -9.596401703453e+0,  2.581652200791e+2]])

universe = InfiniteUniverse()

temperature = 30.*Units.K
universe.addObject(Environment.PathIntegrals(temperature, True))

nb = 4
k = 10.
m_h = Atom('h').mass()
omega = N.sqrt(k/m_h)
beta = 1./(Units.k_B*temperature)
e = 3.*Units.hbar*omega*(0.5+1./(N.exp(beta*Units.hbar*omega)-1))

if False:
    plot = []
    for temperature in range(1., 50., 1.):
        beta = 1./(Units.k_B*temperature)
        e = 3.*Units.hbar*omega*(0.5+1./(N.exp(beta*Units.hbar*omega)-1))
        plot.append((temperature, e))
    plot = N.array(plot)
    import pylab
    pylab.plot(plot[:,0], plot[:,1])

if True:
    print e

    universe.h = Atom('H',amber_atom_type="CT",amber_charge=0.,
                      position = Vector(0.01, 0.005, 0.01))
    universe.h.setNumberOfBeads(nb)

    universe.setForceField(HarmonicOscillatorForceField(universe.h,
                                                        Vector(0., 0., 0.), k))

    universe.initializeVelocitiesToTemperature(temperature)

    dt = 0.001
    #integrator = PINormalModeIntegrator(universe, delta_t=dt)
    #integrator = PILangevinNormalModeIntegrator(universe, delta_t=dt,
    #                                            centroid_friction = 1./Units.ps)
    integrator = PILangevinCartesianIntegrator(universe, delta_t=dt,
                                               friction_matrix = 1./Units.ps*A)
    for i in range(10):
        integrator(steps=1000)
        universe.initializeVelocitiesToTemperature(temperature)
    integrator(steps=1000)
    trajectory = Trajectory(universe, "one_h.nc", "w")
    integrator(steps=20000,
               actions = [TrajectoryOutput(trajectory, ("time", "energy", "thermodynamic", "auxiliary",
                                                        "configuration"),
                                           0, None, 1)])

    data = trajectory.quantum_energy_primitive[len(trajectory)/2:]
    print mean(data), standardDeviation(data)
    data = trajectory.quantum_energy_virial[len(trajectory)/2:]
    print mean(data), standardDeviation(data)
    data = trajectory.quantum_energy_centroid_virial[len(trajectory)/2:]
    print mean(data), standardDeviation(data)
    data = trajectory.temperature[len(trajectory)/2:]
    print mean(data), standardDeviation(data)
    trajectory.close()

