/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison LALR(1) parsers in C++

   Copyright (C) 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */


#include "parser.hh"

/* User implementation prologue.  */
#line 115 "parser.yy"

// Work around undefined symbols in C++ parsers generated with Bison 3.0.
// NOTE: This setting should be determined automatically when the parser is
// regenerated.
#if HAVE_BISON30
#define yychar yyla.type
#define yylloc yyla.location
#define yyloc yylhs.location
#endif

#include "lexerdefs.hh"
#include "interpreter.hh"
static int extern_priv;
static void mangle_fname(string& name);


/* Line 317 of lalr1.cc.  */
#line 58 "./parser.cc"

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* FIXME: INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#define YYUSE(e) ((void) (e))

/* A pseudo ostream that takes yydebug_ into account.  */
# define YYCDEBUG							\
  for (bool yydebugcond_ = yydebug_; yydebugcond_; yydebugcond_ = false)	\
    (*yycdebug_)

/* Enable debugging if requested.  */
#if YYDEBUG

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)	\
do {							\
  if (yydebug_)						\
    {							\
      *yycdebug_ << Title << ' ';			\
      yy_symbol_print_ ((Type), (Value), (Location));	\
      *yycdebug_ << std::endl;				\
    }							\
} while (false)

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug_)				\
    yy_reduce_print_ (Rule);		\
} while (false)

# define YY_STACK_PRINT()		\
do {					\
  if (yydebug_)				\
    yystack_print_ ();			\
} while (false)

#else /* !YYDEBUG */

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_REDUCE_PRINT(Rule)
# define YY_STACK_PRINT()

#endif /* !YYDEBUG */

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab

namespace yy
{
#if YYERROR_VERBOSE

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              /* Fall through.  */
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

#endif

  /// Build a parser object.
  parser::parser (interpreter& interp_yyarg)
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
      interp (interp_yyarg)
  {
  }

  parser::~parser ()
  {
  }

#if YYDEBUG
  /*--------------------------------.
  | Print this symbol on YYOUTPUT.  |
  `--------------------------------*/

  inline void
  parser::yy_symbol_value_print_ (int yytype,
			   const semantic_type* yyvaluep, const location_type* yylocationp)
  {
    YYUSE (yylocationp);
    YYUSE (yyvaluep);
    switch (yytype)
      {
        case 39: /* "\"identifier\"" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->sval); };
#line 188 "./parser.cc"
	break;
      case 41: /* "\"string\"" */
#line 216 "parser.yy"
	{ debug_stream() << (yyvaluep->csval); };
#line 193 "./parser.cc"
	break;
      case 42: /* "\"integer\"" */
#line 216 "parser.yy"
	{ debug_stream() << (yyvaluep->ival); };
#line 198 "./parser.cc"
	break;
      case 43: /* "\"bigint\"" */
#line 217 "parser.yy"
	{ char *s = mpz_get_str(NULL, 10, *(yyvaluep->zval));
           debug_stream() << s; free(s); };
#line 204 "./parser.cc"
	break;
      case 44: /* "\"converted bigint\"" */
#line 217 "parser.yy"
	{ char *s = mpz_get_str(NULL, 10, *(yyvaluep->zval));
           debug_stream() << s; free(s); };
#line 210 "./parser.cc"
	break;
      case 45: /* "\"floating point number\"" */
#line 216 "parser.yy"
	{ debug_stream() << (yyvaluep->dval); };
#line 215 "./parser.cc"
	break;
      case 81: /* "fname" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->sval); };
#line 220 "./parser.cc"
	break;
      case 88: /* "name" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->sval); };
#line 225 "./parser.cc"
	break;
      case 93: /* "ctype" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->sval); };
#line 230 "./parser.cc"
	break;
      case 95: /* "optalias" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->sval); };
#line 235 "./parser.cc"
	break;
      case 96: /* "expr" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->xval); };
#line 240 "./parser.cc"
	break;
      case 97: /* "args" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->xlval); };
#line 245 "./parser.cc"
	break;
      case 99: /* "prim" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->xval); };
#line 250 "./parser.cc"
	break;
      case 106: /* "rule" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rlval); };
#line 255 "./parser.cc"
	break;
      case 107: /* "lhs" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->xlval); };
#line 260 "./parser.cc"
	break;
      case 108: /* "rhs" */
#line 213 "parser.yy"
	{ debug_stream() << (yyvaluep->rhsval)->r; };
#line 265 "./parser.cc"
	break;
      case 109: /* "qual_rhs" */
#line 213 "parser.yy"
	{ debug_stream() << (yyvaluep->rhsval)->r; };
#line 270 "./parser.cc"
	break;
      case 110: /* "rules" */
#line 214 "parser.yy"
	{ debug_stream() << (yyvaluep->rinfo)->e; };
#line 275 "./parser.cc"
	break;
      case 111: /* "rulel" */
#line 214 "parser.yy"
	{ debug_stream() << (yyvaluep->rinfo)->e; };
#line 280 "./parser.cc"
	break;
      case 112: /* "pat_rules" */
#line 215 "parser.yy"
	{ debug_stream() << (yyvaluep->prinfo)->rl; };
#line 285 "./parser.cc"
	break;
      case 113: /* "pat_rulel" */
#line 215 "parser.yy"
	{ debug_stream() << (yyvaluep->prinfo)->rl; };
#line 290 "./parser.cc"
	break;
      case 114: /* "simple_rule" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rval); };
#line 295 "./parser.cc"
	break;
      case 115: /* "simple_rules" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rlval); };
#line 300 "./parser.cc"
	break;
      case 116: /* "simple_rulel" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rlval); };
#line 305 "./parser.cc"
	break;
      case 117: /* "type_rule" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rlval); };
#line 310 "./parser.cc"
	break;
      case 118: /* "macro_rule" */
#line 211 "parser.yy"
	{ debug_stream() << *(yyvaluep->rlval); };
#line 315 "./parser.cc"
	break;
       default:
	  break;
      }
  }


  void
  parser::yy_symbol_print_ (int yytype,
			   const semantic_type* yyvaluep, const location_type* yylocationp)
  {
    *yycdebug_ << (yytype < yyntokens_ ? "token" : "nterm")
	       << ' ' << yytname_[yytype] << " ("
	       << *yylocationp << ": ";
    yy_symbol_value_print_ (yytype, yyvaluep, yylocationp);
    *yycdebug_ << ')';
  }
#endif /* ! YYDEBUG */

  void
  parser::yydestruct_ (const char* yymsg,
			   int yytype, semantic_type* yyvaluep, location_type* yylocationp)
  {
    YYUSE (yylocationp);
    YYUSE (yymsg);
    YYUSE (yyvaluep);

    YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

    switch (yytype)
      {
        case 25: /* "\"left outfix operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 350 "./parser.cc"
	break;
      case 26: /* "\"right outfix operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 355 "./parser.cc"
	break;
      case 27: /* "\"infix operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 360 "./parser.cc"
	break;
      case 28: /* "\"infixl operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 365 "./parser.cc"
	break;
      case 29: /* "\"infixr operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 370 "./parser.cc"
	break;
      case 30: /* "\"prefix operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 375 "./parser.cc"
	break;
      case 31: /* "\"postfix operator\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 380 "./parser.cc"
	break;
      case 39: /* "\"identifier\"" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sval); };
#line 385 "./parser.cc"
	break;
      case 41: /* "\"string\"" */
#line 210 "parser.yy"
	{ free((yyvaluep->csval)); };
#line 390 "./parser.cc"
	break;
      case 43: /* "\"bigint\"" */
#line 209 "parser.yy"
	{ mpz_clear(*(yyvaluep->zval)); free((yyvaluep->zval)); };
#line 395 "./parser.cc"
	break;
      case 44: /* "\"converted bigint\"" */
#line 209 "parser.yy"
	{ mpz_clear(*(yyvaluep->zval)); free((yyvaluep->zval)); };
#line 400 "./parser.cc"
	break;
      case 76: /* "fixity" */
#line 203 "parser.yy"
	{ delete (yyvaluep->info); };
#line 405 "./parser.cc"
	break;
      case 79: /* "ids" */
#line 203 "parser.yy"
	{ delete (yyvaluep->slval); };
#line 410 "./parser.cc"
	break;
      case 80: /* "fnames" */
#line 203 "parser.yy"
	{ delete (yyvaluep->slval); };
#line 415 "./parser.cc"
	break;
      case 81: /* "fname" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sval); };
#line 420 "./parser.cc"
	break;
      case 84: /* "name_xsyms_list" */
#line 203 "parser.yy"
	{ delete (yyvaluep->smlval); };
#line 425 "./parser.cc"
	break;
      case 85: /* "name_xsyms" */
#line 203 "parser.yy"
	{ delete (yyvaluep->smval); };
#line 430 "./parser.cc"
	break;
      case 87: /* "xsyms" */
#line 203 "parser.yy"
	{ delete (yyvaluep->ilval); };
#line 435 "./parser.cc"
	break;
      case 88: /* "name" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sval); };
#line 440 "./parser.cc"
	break;
      case 91: /* "opt_ctypes" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sloval); };
#line 445 "./parser.cc"
	break;
      case 92: /* "ctypes" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sloval); };
#line 450 "./parser.cc"
	break;
      case 93: /* "ctype" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sval); };
#line 455 "./parser.cc"
	break;
      case 95: /* "optalias" */
#line 203 "parser.yy"
	{ delete (yyvaluep->sval); };
#line 460 "./parser.cc"
	break;
      case 96: /* "expr" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 465 "./parser.cc"
	break;
      case 97: /* "args" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xlval); };
#line 470 "./parser.cc"
	break;
      case 98: /* "simple" */
#line 203 "parser.yy"
	{ delete (yyvaluep->opstk); };
#line 475 "./parser.cc"
	break;
      case 99: /* "prim" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xval); };
#line 480 "./parser.cc"
	break;
      case 100: /* "comp_clauses" */
#line 203 "parser.yy"
	{ delete (yyvaluep->clauselval); };
#line 485 "./parser.cc"
	break;
      case 101: /* "comp_clause_list" */
#line 203 "parser.yy"
	{ delete (yyvaluep->clauselval); };
#line 490 "./parser.cc"
	break;
      case 103: /* "rows" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xllval); };
#line 495 "./parser.cc"
	break;
      case 104: /* "row_list" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xllval); };
#line 500 "./parser.cc"
	break;
      case 105: /* "row" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xlval); };
#line 505 "./parser.cc"
	break;
      case 106: /* "rule" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rlval); };
#line 510 "./parser.cc"
	break;
      case 107: /* "lhs" */
#line 203 "parser.yy"
	{ delete (yyvaluep->xlval); };
#line 515 "./parser.cc"
	break;
      case 108: /* "rhs" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rhsval); };
#line 520 "./parser.cc"
	break;
      case 109: /* "qual_rhs" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rhsval); };
#line 525 "./parser.cc"
	break;
      case 110: /* "rules" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rinfo); };
#line 530 "./parser.cc"
	break;
      case 111: /* "rulel" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rinfo); };
#line 535 "./parser.cc"
	break;
      case 112: /* "pat_rules" */
#line 203 "parser.yy"
	{ delete (yyvaluep->prinfo); };
#line 540 "./parser.cc"
	break;
      case 113: /* "pat_rulel" */
#line 203 "parser.yy"
	{ delete (yyvaluep->prinfo); };
#line 545 "./parser.cc"
	break;
      case 114: /* "simple_rule" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rval); };
#line 550 "./parser.cc"
	break;
      case 115: /* "simple_rules" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rlval); };
#line 555 "./parser.cc"
	break;
      case 116: /* "simple_rulel" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rlval); };
#line 560 "./parser.cc"
	break;
      case 117: /* "type_rule" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rlval); };
#line 565 "./parser.cc"
	break;
      case 118: /* "macro_rule" */
#line 203 "parser.yy"
	{ delete (yyvaluep->rlval); };
#line 570 "./parser.cc"
	break;

	default:
	  break;
      }
  }

  void
  parser::yypop_ (unsigned int n)
  {
    yystate_stack_.pop (n);
    yysemantic_stack_.pop (n);
    yylocation_stack_.pop (n);
  }

  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }


  int
  parser::parse ()
  {
    /// Look-ahead and look-ahead in internal form.
    int yychar = yyempty_;
    int yytoken = 0;

    /* State.  */
    int yyn;
    int yylen = 0;
    int yystate = 0;

    /* Error handling.  */
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// Semantic value of the look-ahead.
    semantic_type yylval;
    /// Location of the look-ahead.
    location_type yylloc;
    /// The locations where the error started and ended.
    location yyerror_range[2];

    /// $$.
    semantic_type yyval;
    /// @$.
    location_type yyloc;

    int yyresult;

    YYCDEBUG << "Starting parse" << std::endl;


    /* User initialization code.  */
    #line 72 "parser.yy"
{
  static string stdin_source = "<stdin>";
  // Initialize the initial location.
  if (interp.source.empty())
    yylloc.begin.filename = yylloc.end.filename = &stdin_source;
  else
    yylloc.begin.filename = yylloc.end.filename = &interp.source;
}
  /* Line 555 of yacc.c.  */
#line 656 "./parser.cc"
    /* Initialize the stacks.  The initial state will be pushed in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystate_stack_ = state_stack_type (0);
    yysemantic_stack_ = semantic_stack_type (0);
    yylocation_stack_ = location_stack_type (0);
    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yylloc);

    /* New state.  */
  yynewstate:
    yystate_stack_.push (yystate);
    YYCDEBUG << "Entering state " << yystate << std::endl;
    goto yybackup;

    /* Backup.  */
  yybackup:

    /* Try to take a decision without look-ahead.  */
    yyn = yypact_[yystate];
    if (yyn == yypact_ninf_)
      goto yydefault;

    /* Read a look-ahead token.  */
    if (yychar == yyempty_)
      {
	YYCDEBUG << "Reading a token: ";
	yychar = yylex (&yylval, &yylloc, interp);
      }


    /* Convert token to internal form.  */
    if (yychar <= yyeof_)
      {
	yychar = yytoken = yyeof_;
	YYCDEBUG << "Now at end of input." << std::endl;
      }
    else
      {
	yytoken = yytranslate_ (yychar);
	YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
      }

    /* If the proper action on seeing token YYTOKEN is to reduce or to
       detect an error, take that action.  */
    yyn += yytoken;
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yytoken)
      goto yydefault;

    /* Reduce or error.  */
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
	if (yyn == 0 || yyn == yytable_ninf_)
	goto yyerrlab;
	yyn = -yyn;
	goto yyreduce;
      }

    /* Accept?  */
    if (yyn == yyfinal_)
      goto yyacceptlab;

    /* Shift the look-ahead token.  */
    YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

    /* Discard the token being shifted unless it is eof.  */
    if (yychar != yyeof_)
      yychar = yyempty_;

    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yylloc);

    /* Count tokens shifted since error; after three, turn off error
       status.  */
    if (yyerrstatus_)
      --yyerrstatus_;

    yystate = yyn;
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystate];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    /* If YYLEN is nonzero, implement the default value of the action:
       `$$ = $1'.  Otherwise, use the top of the stack.

       Otherwise, the following line sets YYVAL to garbage.
       This behavior is undocumented and Bison
       users should not rely upon it.  */
    if (yylen)
      yyval = yysemantic_stack_[yylen - 1];
    else
      yyval = yysemantic_stack_[0];

    {
      slice<location_type, location_stack_type> slice (yylocation_stack_, yylen);
      YYLLOC_DEFAULT (yyloc, slice, yylen);
    }
    YY_REDUCE_PRINT (yyn);
    switch (yyn)
      {
	  case 5:
#line 236 "parser.yy"
    { interp.nerrs = yyerrstatus_ = 0; interp.declare_op = false;
  interp.symtab.clean_namespaces(); ;}
    break;

  case 8:
#line 246 "parser.yy"
    { interp.nerrs = yyerrstatus_ = 0; interp.declare_op = false;
  interp.symtab.clean_namespaces(); ;}
    break;

  case 9:
#line 251 "parser.yy"
    { interp.line = yylloc.begin.line; interp.column = yylloc.begin.column; ;}
    break;

  case 11:
#line 257 "parser.yy"
    { interp.loc = &yyloc;
  if (!interp.tags) { restricted_action(interp.exec((yysemantic_stack_[(2) - (1)].xval)), delete (yysemantic_stack_[(2) - (1)].xval)); }
  else delete (yysemantic_stack_[(2) - (1)].xval); ;}
    break;

  case 12:
#line 261 "parser.yy"
    { interp.loc = &yyloc;
  if (!interp.tags) { restricted_action(interp.parse((yysemantic_stack_[(3) - (2)].xval)), delete (yysemantic_stack_[(3) - (2)].xval)); }
  else delete (yysemantic_stack_[(3) - (2)].xval);
  // We only parse a single expression in this mode, bail out.
  if (yychar > 0 && interp.nerrs == 0)
    error(yylloc, "syntax error, expected end of file");
  YYACCEPT; ;}
    break;

  case 13:
#line 269 "parser.yy"
    { interp.loc = &yyloc; action(interp.define((yysemantic_stack_[(3) - (2)].rval)), delete (yysemantic_stack_[(3) - (2)].rval)); ;}
    break;

  case 14:
#line 271 "parser.yy"
    { interp.loc = &yyloc; action(interp.define_const((yysemantic_stack_[(3) - (2)].rval)), delete (yysemantic_stack_[(3) - (2)].rval)); ;}
    break;

  case 15:
#line 273 "parser.yy"
    { interp.loc = &yyloc; action(interp.add_macro_rules((yysemantic_stack_[(3) - (2)].rlval)), delete (yysemantic_stack_[(3) - (2)].rlval)); ;}
    break;

  case 16:
#line 275 "parser.yy"
    { expr *id = 0;
  string *s = new string(*(yysemantic_stack_[(2) - (2)].sval));
  try { id = interp.mksym_expr(s); }
  catch (err &e) {
    interp.error(yyloc, e.what());
  }
  if (id && id->is_fun()) {
    // This will promote the symbol to the proper namespace if it hasn't been
    // declared yet.
    interp.checkvars(*id);
    interp.symtab.sym(id->tag()).unresolved = false;
    interp.typeenv[id->tag()];
    (yyval.ival) = id->tag();
  } else {
    error(yylloc, "error in interface declaration (invalid type identifier)");
    (yyval.ival) = 0;
  }
  if (id) delete id;
;}
    break;

  case 17:
#line 294 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(4) - (3)].ival); ;}
    break;

  case 18:
#line 295 "parser.yy"
    { int32_t tag = (yysemantic_stack_[(8) - (3)].ival), count = (yysemantic_stack_[(8) - (6)].ival);
  delete (yysemantic_stack_[(8) - (2)].sval);
  if (tag) interp.finalize_interface_rules(interp.typeenv, tag, count);
;}
    break;

  case 19:
#line 300 "parser.yy"
    { interp.loc = &yyloc;
  action(interp.add_type_rules(interp.typeenv, (yysemantic_stack_[(3) - (2)].rlval)), delete (yysemantic_stack_[(3) - (2)].rlval)); ;}
    break;

  case 20:
#line 303 "parser.yy"
    { interp.loc = &yyloc;
  rulel *rl = 0;
  bool headless = (yysemantic_stack_[(2) - (1)].rlval)->front().lhs.is_null();
  action(interp.add_rules(interp.globenv,
  (rl = interp.default_lhs(interp.last, (yysemantic_stack_[(2) - (1)].rlval))), headless, true),
  if (rl) delete rl); ;}
    break;

  case 21:
#line 310 "parser.yy"
    { if ((yysemantic_stack_[(1) - (1)].info)->special && (yysemantic_stack_[(1) - (1)].info)->fix != nonfix && (yysemantic_stack_[(1) - (1)].info)->fix != outfix &&
      (yysemantic_stack_[(1) - (1)].info)->prec >= PREC_MAX) {
    error(yylloc, "invalid fixity declaration"); (yysemantic_stack_[(1) - (1)].info)->prec = 0;
  } ;}
    break;

  case 22:
#line 315 "parser.yy"
    { interp.declare_op = false;
  action(interp.declare((yysemantic_stack_[(4) - (1)].info)->priv, (yysemantic_stack_[(4) - (1)].info)->prec, (yysemantic_stack_[(4) - (1)].info)->fix, (yysemantic_stack_[(4) - (3)].slval)), );
  if (interp.tags) interp.add_tags((yysemantic_stack_[(4) - (3)].slval));
  delete (yysemantic_stack_[(4) - (3)].slval); delete (yysemantic_stack_[(4) - (1)].info); ;}
    break;

  case 23:
#line 320 "parser.yy"
    { action(interp.run(*(yysemantic_stack_[(3) - (2)].slval)), {}); delete (yysemantic_stack_[(3) - (2)].slval); ;}
    break;

  case 24:
#line 321 "parser.yy"
    { interp.declare_op = false; ;}
    break;

  case 25:
#line 322 "parser.yy"
    { action(interp.run((yysemantic_stack_[(5) - (2)].ival), *(yysemantic_stack_[(5) - (4)].slval)), {}); delete (yysemantic_stack_[(5) - (4)].slval); ;}
    break;

  case 26:
#line 324 "parser.yy"
    { if (interp.active_namespaces.empty()) {
    action(interp.set_namespace((yysemantic_stack_[(4) - (2)].sval), (yysemantic_stack_[(4) - (3)].ival)), );
  } else
    error(yylloc, "namespace declaration is not permitted here");
;}
    break;

  case 27:
#line 330 "parser.yy"
    { if (interp.active_namespaces.empty()) {
    action(interp.clear_namespace((yysemantic_stack_[(3) - (2)].ival)), );
  } else
    error(yylloc, "namespace declaration is not permitted here");
;}
    break;

  case 28:
#line 336 "parser.yy"
    { action(interp.push_namespace(new string(*(yysemantic_stack_[(4) - (2)].sval)), (yysemantic_stack_[(4) - (3)].ival)), ); ;}
    break;

  case 29:
#line 338 "parser.yy"
    { interp.pop_namespace(); delete (yysemantic_stack_[(8) - (2)].sval); ;}
    break;

  case 30:
#line 340 "parser.yy"
    { action(interp.using_namespaces((yysemantic_stack_[(4) - (3)].smlval)), ); ;}
    break;

  case 31:
#line 342 "parser.yy"
    { action(interp.using_namespaces(), ); ;}
    break;

  case 32:
#line 343 "parser.yy"
    { interp.declare_op = false; extern_priv = (yysemantic_stack_[(2) - (1)].ival); ;}
    break;

  case 34:
#line 344 "parser.yy"
    { extern_priv = -1; ;}
    break;

  case 36:
#line 346 "parser.yy"
    { action(interp.inline_code(false, interp.xcode), {}); interp.xcode.clear(); ;}
    break;

  case 37:
#line 347 "parser.yy"
    { interp.declare_op = false; ;}
    break;

  case 38:
#line 348 "parser.yy"
    { action(interp.inline_code((yysemantic_stack_[(3) - (1)].ival), interp.xcode), {}); interp.xcode.clear(); ;}
    break;

  case 39:
#line 356 "parser.yy"
    { (yyval.info) = new sym_info(true, priv_def,(yysemantic_stack_[(2) - (2)].ival),(yysemantic_stack_[(2) - (1)].fix));
			  interp.declare_op = true; ;}
    break;

  case 40:
#line 358 "parser.yy"
    { (yyval.info) = new sym_info(true, priv_def,mpz_get_si(*(yysemantic_stack_[(2) - (2)].zval)),(yysemantic_stack_[(2) - (1)].fix));
			  free((yysemantic_stack_[(2) - (2)].zval)); interp.declare_op = true; ;}
    break;

  case 41:
#line 360 "parser.yy"
    { symbol& sym = interp.symtab.sym((yysemantic_stack_[(4) - (3)].ival));
			  (yyval.info) = new sym_info(true, priv_def,sym.prec,(yysemantic_stack_[(4) - (1)].fix));
			  interp.declare_op = true; ;}
    break;

  case 42:
#line 363 "parser.yy"
    { (yyval.info) = new sym_info(true, priv_def,PREC_MAX,outfix);
			  interp.declare_op = true; ;}
    break;

  case 43:
#line 365 "parser.yy"
    { (yyval.info) = new sym_info(true, priv_def,PREC_MAX,nonfix);
			  interp.declare_op = true; ;}
    break;

  case 44:
#line 367 "parser.yy"
    { (yyval.info) = new sym_info(true, (yysemantic_stack_[(3) - (1)].ival),(yysemantic_stack_[(3) - (3)].ival),(yysemantic_stack_[(3) - (2)].fix));
			  interp.declare_op = true; ;}
    break;

  case 45:
#line 369 "parser.yy"
    { (yyval.info) = new sym_info(true, (yysemantic_stack_[(3) - (1)].ival),mpz_get_si(*(yysemantic_stack_[(3) - (3)].zval)),(yysemantic_stack_[(3) - (2)].fix));
			  free((yysemantic_stack_[(3) - (3)].zval)); interp.declare_op = true; ;}
    break;

  case 46:
#line 371 "parser.yy"
    { symbol& sym = interp.symtab.sym((yysemantic_stack_[(5) - (4)].ival));
			  (yyval.info) = new sym_info(true, (yysemantic_stack_[(5) - (1)].ival),sym.prec,(yysemantic_stack_[(5) - (2)].fix));
			  interp.declare_op = true; ;}
    break;

  case 47:
#line 374 "parser.yy"
    { (yyval.info) = new sym_info(true, (yysemantic_stack_[(2) - (1)].ival),PREC_MAX,outfix); ;}
    break;

  case 48:
#line 375 "parser.yy"
    { (yyval.info) = new sym_info(true, (yysemantic_stack_[(2) - (1)].ival),PREC_MAX,nonfix); ;}
    break;

  case 49:
#line 376 "parser.yy"
    { (yyval.info) = new sym_info(false, (yysemantic_stack_[(1) - (1)].ival),PREC_MAX,infix); ;}
    break;

  case 50:
#line 380 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(1) - (1)].xval)->tag(); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 51:
#line 381 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(1) - (1)].xval)->tag(); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 52:
#line 382 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(1) - (1)].xval)->tag(); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 53:
#line 383 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(1) - (1)].xval)->tag(); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 54:
#line 384 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(1) - (1)].xval)->tag(); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 55:
#line 388 "parser.yy"
    { (yyval.ival) = false; interp.declare_op = true; ;}
    break;

  case 56:
#line 389 "parser.yy"
    { (yyval.ival) = true;  interp.declare_op = true; ;}
    break;

  case 57:
#line 394 "parser.yy"
    { (yyval.slval) = new list<string>; (yyval.slval)->push_back(*(yysemantic_stack_[(1) - (1)].sval)); delete (yysemantic_stack_[(1) - (1)].sval); ;}
    break;

  case 58:
#line 396 "parser.yy"
    { (yyval.slval) = (yysemantic_stack_[(2) - (1)].slval); (yyval.slval)->push_back(*(yysemantic_stack_[(2) - (2)].sval)); delete (yysemantic_stack_[(2) - (2)].sval); ;}
    break;

  case 59:
#line 401 "parser.yy"
    { (yyval.slval) = new list<string>; (yyval.slval)->push_back(*(yysemantic_stack_[(1) - (1)].sval)); delete (yysemantic_stack_[(1) - (1)].sval); ;}
    break;

  case 60:
#line 403 "parser.yy"
    { (yyval.slval) = (yysemantic_stack_[(3) - (1)].slval); (yyval.slval)->push_back(*(yysemantic_stack_[(3) - (3)].sval)); delete (yysemantic_stack_[(3) - (3)].sval); ;}
    break;

  case 61:
#line 407 "parser.yy"
    { (yyval.sval) = (yysemantic_stack_[(1) - (1)].sval); mangle_fname(*(yyval.sval)); ;}
    break;

  case 62:
#line 408 "parser.yy"
    { char *s = fromutf8((yysemantic_stack_[(1) - (1)].csval)); free((yysemantic_stack_[(1) - (1)].csval));
			  (yyval.sval) = new string(s); free(s); ;}
    break;

  case 63:
#line 413 "parser.yy"
    { (yyval.ival) = 0; ;}
    break;

  case 64:
#line 414 "parser.yy"
    { interp.xsym_prefix = 0; ;}
    break;

  case 65:
#line 415 "parser.yy"
    { int32_t g = interp.symtab.sym((yysemantic_stack_[(5) - (3)].ival)).g;
			  if (g != 0 && g == (yysemantic_stack_[(5) - (4)].ival))
			    (yyval.ival) = (yysemantic_stack_[(5) - (3)].ival);
			  else {
			    string msg;
			    if (g == 0) {
			      string id = interp.symtab.sym((yysemantic_stack_[(5) - (3)].ival)).s;
			      msg = "syntax error, unexpected '"+id+
				"', expecting outfix operator";
			    } else {
			      string id = interp.symtab.sym((yysemantic_stack_[(5) - (4)].ival)).s;
			      string rid = interp.symtab.sym(g).s;
			      msg = "syntax error, unexpected '"+id+
				"', expecting '"+rid+"'";
			    }
			    interp.error(yyloc, msg);
			    YYERROR;
			  } ;}
    break;

  case 66:
#line 437 "parser.yy"
    { (yyval.smlval) = new list< pair< string, list<int32_t> > >;
  (yyval.smlval)->push_back(*(yysemantic_stack_[(1) - (1)].smval)); delete (yysemantic_stack_[(1) - (1)].smval); ;}
    break;

  case 67:
#line 440 "parser.yy"
    { (yyval.smlval) = (yysemantic_stack_[(3) - (1)].smlval); (yyval.smlval)->push_back(*(yysemantic_stack_[(3) - (3)].smval)); delete (yysemantic_stack_[(3) - (3)].smval); ;}
    break;

  case 68:
#line 445 "parser.yy"
    { (yyval.smval) = new pair< string, list<int32_t> >(*(yysemantic_stack_[(1) - (1)].sval), list<int32_t>()); delete (yysemantic_stack_[(1) - (1)].sval); ;}
    break;

  case 69:
#line 446 "parser.yy"
    { interp.xsym_prefix = (yysemantic_stack_[(2) - (1)].sval); ;}
    break;

  case 70:
#line 447 "parser.yy"
    { (yyval.smval) = new pair< string, list<int32_t> >(*(yysemantic_stack_[(5) - (1)].sval), *(yysemantic_stack_[(5) - (4)].ilval)); delete (yysemantic_stack_[(5) - (1)].sval); delete (yysemantic_stack_[(5) - (4)].ilval); ;}
    break;

  case 71:
#line 452 "parser.yy"
    { (yyval.ilval) = new list<int32_t>; (yyval.ilval)->push_back((yysemantic_stack_[(1) - (1)].ival)); ;}
    break;

  case 72:
#line 454 "parser.yy"
    { (yyval.ilval) = (yysemantic_stack_[(2) - (1)].ilval); (yyval.ilval)->push_back((yysemantic_stack_[(2) - (2)].ival)); ;}
    break;

  case 73:
#line 459 "parser.yy"
    { (yyval.sval) = (yysemantic_stack_[(1) - (1)].sval); if ((yyval.sval)->compare(0, 2, "::") == 0) (yyval.sval)->erase(0, 2); ;}
    break;

  case 74:
#line 461 "parser.yy"
    { (yyval.sval) = new string((yysemantic_stack_[(1) - (1)].csval)); free((yysemantic_stack_[(1) - (1)].csval));
  if ((yyval.sval)->compare(0, 2, "::") == 0) (yyval.sval)->erase(0, 2); ;}
    break;

  case 77:
#line 472 "parser.yy"
    { action(interp.declare_extern(extern_priv, *(yysemantic_stack_[(6) - (2)].sval), *(yysemantic_stack_[(6) - (1)].sval), (yysemantic_stack_[(6) - (4)].sloval)->second, (yysemantic_stack_[(6) - (4)].sloval)->first,
			       0, *(yysemantic_stack_[(6) - (6)].sval)), {});
  if (interp.tags) interp.add_tags(*(yysemantic_stack_[(6) - (2)].sval), *(yysemantic_stack_[(6) - (6)].sval));
  delete (yysemantic_stack_[(6) - (1)].sval); delete (yysemantic_stack_[(6) - (2)].sval); delete (yysemantic_stack_[(6) - (4)].sloval); delete (yysemantic_stack_[(6) - (6)].sval); ;}
    break;

  case 78:
#line 480 "parser.yy"
    { (yyval.sloval) = new pair < bool, list<string> >; (yyval.sloval)->first = false; ;}
    break;

  case 79:
#line 482 "parser.yy"
    { (yyval.sloval) = new pair < bool, list<string> >; (yyval.sloval)->first = true; ;}
    break;

  case 81:
#line 485 "parser.yy"
    { (yyval.sloval) = (yysemantic_stack_[(3) - (1)].sloval); (yyval.sloval)->first = true; ;}
    break;

  case 82:
#line 490 "parser.yy"
    { (yyval.sloval) = new pair < bool, list<string> >; (yyval.sloval)->second.push_back(*(yysemantic_stack_[(2) - (1)].sval)); delete (yysemantic_stack_[(2) - (1)].sval); ;}
    break;

  case 83:
#line 492 "parser.yy"
    { (yyval.sloval) = (yysemantic_stack_[(4) - (1)].sloval); (yyval.sloval)->second.push_back(*(yysemantic_stack_[(4) - (3)].sval)); delete (yysemantic_stack_[(4) - (3)].sval); ;}
    break;

  case 85:
#line 497 "parser.yy"
    { (yyval.sval) = (yysemantic_stack_[(2) - (1)].sval); *(yyval.sval) += "*"; ;}
    break;

  case 87:
#line 502 "parser.yy"
    { delete (yysemantic_stack_[(1) - (1)].sval); ;}
    break;

  case 88:
#line 506 "parser.yy"
    { (yyval.sval) = new string; ;}
    break;

  case 89:
#line 507 "parser.yy"
    { (yyval.sval) = (yysemantic_stack_[(2) - (2)].sval); ;}
    break;

  case 90:
#line 517 "parser.yy"
    { parser_action((yyval.xval) = interp.mksimple_expr((yysemantic_stack_[(1) - (1)].opstk)), delete (yysemantic_stack_[(1) - (1)].opstk)); ;}
    break;

  case 91:
#line 519 "parser.yy"
    { try { (yyval.xval) = interp.mklambda_expr((yysemantic_stack_[(4) - (2)].xlval), (yysemantic_stack_[(4) - (4)].xval)); }
  catch (err &e) { interp.error(yyloc, e.what()); (yyval.xval) = new dummy_expr; } ;}
    break;

  case 92:
#line 522 "parser.yy"
    { try { (yyval.xval) = interp.mkcase_expr((yysemantic_stack_[(5) - (2)].xval), new rulel((yysemantic_stack_[(5) - (4)].prinfo)->rl)); delete (yysemantic_stack_[(5) - (4)].prinfo); }
  catch (err &e) { interp.error(yyloc, e.what()); delete (yysemantic_stack_[(5) - (4)].prinfo); (yyval.xval) = new dummy_expr; } ;}
    break;

  case 93:
#line 525 "parser.yy"
    { try { (yyval.xval) = interp.mkwhen_expr((yysemantic_stack_[(4) - (1)].xval), (yysemantic_stack_[(4) - (3)].rlval)); }
  catch (err &e) { interp.error(yyloc, e.what()); (yyval.xval) = new dummy_expr; } ;}
    break;

  case 94:
#line 528 "parser.yy"
    { try { (yyval.xval) = interp.mkwith_expr((yysemantic_stack_[(4) - (1)].xval), new env((yysemantic_stack_[(4) - (3)].rinfo)->e)); delete (yysemantic_stack_[(4) - (3)].rinfo); }
  catch (err &e) { interp.error(yyloc, e.what()); delete (yysemantic_stack_[(4) - (3)].rinfo); (yyval.xval) = new dummy_expr; } ;}
    break;

  case 95:
#line 531 "parser.yy"
    { (yyval.xval) = interp.mkcond_expr((yysemantic_stack_[(6) - (2)].xval), (yysemantic_stack_[(6) - (4)].xval), (yysemantic_stack_[(6) - (6)].xval)); ;}
    break;

  case 96:
#line 536 "parser.yy"
    { (yyval.xlval) = new exprl; (yyval.xlval)->push_back(*(yysemantic_stack_[(1) - (1)].xval)); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 97:
#line 538 "parser.yy"
    { (yyval.xlval) = (yysemantic_stack_[(2) - (1)].xlval); (yyval.xlval)->push_back(*(yysemantic_stack_[(2) - (2)].xval)); delete (yysemantic_stack_[(2) - (2)].xval); ;}
    break;

  case 98:
#line 547 "parser.yy"
    { (yyval.opstk) = (new OpStack())->push_arg((yysemantic_stack_[(1) - (1)].xval)); ;}
    break;

  case 99:
#line 548 "parser.yy"
    { (yyval.opstk) = (new OpStack())->push_op((yysemantic_stack_[(1) - (1)].xval)); ;}
    break;

  case 100:
#line 549 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_arg((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 101:
#line 550 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_op((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 102:
#line 551 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_op((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 103:
#line 552 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_op((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 104:
#line 553 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_op((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 105:
#line 554 "parser.yy"
    { (yyval.opstk) = (yysemantic_stack_[(2) - (1)].opstk)->push_op((yysemantic_stack_[(2) - (2)].xval)); ;}
    break;

  case 106:
#line 560 "parser.yy"
    { try { (yyval.xval) = interp.mksym_expr((yysemantic_stack_[(1) - (1)].sval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yyval.xval) = new dummy_expr;
			  } ;}
    break;

  case 107:
#line 565 "parser.yy"
    { try { (yyval.xval) = interp.mksym_expr((yysemantic_stack_[(2) - (1)].sval), (yysemantic_stack_[(2) - (2)].ival)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yyval.xval) = new dummy_expr;
			  } ;}
    break;

  case 108:
#line 570 "parser.yy"
    { try { (yyval.xval) = interp.mkas_expr((yysemantic_stack_[(3) - (1)].sval), (yysemantic_stack_[(3) - (3)].xval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yyval.xval) = (yysemantic_stack_[(3) - (3)].xval);
			  } ;}
    break;

  case 109:
#line 575 "parser.yy"
    { (yyval.xval) = new expr(EXPR::INT, (yysemantic_stack_[(1) - (1)].ival)); ;}
    break;

  case 110:
#line 576 "parser.yy"
    { (yyval.xval) = new expr(EXPR::BIGINT, *(yysemantic_stack_[(1) - (1)].zval), true); free((yysemantic_stack_[(1) - (1)].zval)); ;}
    break;

  case 111:
#line 577 "parser.yy"
    { (yyval.xval) = new expr(EXPR::BIGINT, *(yysemantic_stack_[(1) - (1)].zval)); free((yysemantic_stack_[(1) - (1)].zval)); ;}
    break;

  case 112:
#line 578 "parser.yy"
    { (yyval.xval) = new expr(EXPR::DBL, (yysemantic_stack_[(1) - (1)].dval)); ;}
    break;

  case 113:
#line 579 "parser.yy"
    { (yyval.xval) = new expr(EXPR::STR, (yysemantic_stack_[(1) - (1)].csval)); ;}
    break;

  case 114:
#line 580 "parser.yy"
    { int32_t g = interp.symtab.sym((yysemantic_stack_[(3) - (1)].xval)->tag()).g;
			  assert(g != 0);
			  if (g == (yysemantic_stack_[(3) - (3)].xval)->tag()) {
			    if (interp.symtab.sym((yysemantic_stack_[(3) - (1)].xval)->tag()).ns) {
			      // special namespace bracket
			      delete (yysemantic_stack_[(3) - (1)].xval);
			      (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval);
			      interp.symtab.pop_namespace();
			    } else
			      (yyval.xval) = interp.mkexpr((yysemantic_stack_[(3) - (1)].xval), (yysemantic_stack_[(3) - (2)].xval));
			    delete (yysemantic_stack_[(3) - (3)].xval);
			  } else {
			    string id = interp.symtab.sym((yysemantic_stack_[(3) - (3)].xval)->tag()).s;
			    string rid = interp.symtab.sym(g).s;
			    string msg = "syntax error, unexpected '"+id+
			      "', expecting '"+rid+"'";
			    interp.error(yyloc, msg);
			    YYERROR;
			  } ;}
    break;

  case 115:
#line 599 "parser.yy"
    { (yyval.xval) = new expr(EXPR::MATRIX, (yysemantic_stack_[(3) - (2)].xllval)); ;}
    break;

  case 116:
#line 601 "parser.yy"
    { try { (yyval.xval) = interp.mkmatcomp_expr((yysemantic_stack_[(5) - (2)].xval), (yysemantic_stack_[(5) - (4)].clauselval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yyval.xval) = new dummy_expr;
			  } ;}
    break;

  case 117:
#line 606 "parser.yy"
    { (yyval.xval) = interp.mklist_expr((yysemantic_stack_[(3) - (2)].xval)); ;}
    break;

  case 118:
#line 607 "parser.yy"
    { (yyval.xval) = new expr(interp.symtab.nil_sym().f); ;}
    break;

  case 119:
#line 609 "parser.yy"
    { try { (yyval.xval) = interp.mklistcomp_expr((yysemantic_stack_[(5) - (2)].xval), (yysemantic_stack_[(5) - (4)].clauselval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yyval.xval) = new dummy_expr;
			  } ;}
    break;

  case 120:
#line 614 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval);
			  if ((yyval.xval)->is_pair()) (yyval.xval)->flags() |= EXPR::PAREN; ;}
    break;

  case 121:
#line 616 "parser.yy"
    { (yyval.xval) = new expr(interp.symtab.void_sym().f); ;}
    break;

  case 122:
#line 617 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval); ;}
    break;

  case 123:
#line 618 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval); ;}
    break;

  case 124:
#line 619 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval); ;}
    break;

  case 125:
#line 620 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval); ;}
    break;

  case 126:
#line 621 "parser.yy"
    { (yyval.xval) = (yysemantic_stack_[(3) - (2)].xval); ;}
    break;

  case 127:
#line 622 "parser.yy"
    { int32_t g = interp.symtab.sym((yysemantic_stack_[(4) - (2)].xval)->tag()).g;
			  assert(g != 0);
			  if (g == (yysemantic_stack_[(4) - (3)].xval)->tag()) {
			    (yyval.xval) = (yysemantic_stack_[(4) - (2)].xval);
			    delete (yysemantic_stack_[(4) - (3)].xval);
			  } else {
			    string id = interp.symtab.sym((yysemantic_stack_[(4) - (3)].xval)->tag()).s;
			    string rid = interp.symtab.sym(g).s;
			    string msg = "syntax error, unexpected '"+id+
			      "', expecting '"+rid+"'";
			    interp.error(yyloc, msg);
			    YYERROR;
			  } ;}
    break;

  case 128:
#line 640 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (2)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].opstk), delete (yysemantic_stack_[(4) - (3)].xval)));
  (yyval.xval) = interp.mklsect((yysemantic_stack_[(4) - (3)].xval), x); ;}
    break;

  case 129:
#line 644 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (2)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].opstk), delete (yysemantic_stack_[(4) - (3)].xval)));
  (yyval.xval) = interp.mklsect((yysemantic_stack_[(4) - (3)].xval), x); ;}
    break;

  case 130:
#line 648 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (2)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].opstk), delete (yysemantic_stack_[(4) - (3)].xval)));
  (yyval.xval) = interp.mklsect((yysemantic_stack_[(4) - (3)].xval), x); ;}
    break;

  case 131:
#line 652 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (2)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].opstk), delete (yysemantic_stack_[(4) - (3)].xval)));
  (yyval.xval) = interp.mklsect((yysemantic_stack_[(4) - (3)].xval), x); ;}
    break;

  case 132:
#line 659 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (3)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].xval), delete (yysemantic_stack_[(4) - (3)].opstk)));
  (yyval.xval) = interp.mkrsect((yysemantic_stack_[(4) - (2)].xval), x); ;}
    break;

  case 133:
#line 663 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (3)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].xval), delete (yysemantic_stack_[(4) - (3)].opstk)));
  (yyval.xval) = interp.mkrsect((yysemantic_stack_[(4) - (2)].xval), x); ;}
    break;

  case 134:
#line 667 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(4) - (3)].opstk)),
			 (delete (yysemantic_stack_[(4) - (2)].xval), delete (yysemantic_stack_[(4) - (3)].opstk)));
  (yyval.xval) = interp.mkrsect((yysemantic_stack_[(4) - (2)].xval), x); ;}
    break;

  case 136:
#line 675 "parser.yy"
    { (yyval.clauselval) = (yysemantic_stack_[(2) - (1)].clauselval); ;}
    break;

  case 137:
#line 680 "parser.yy"
    { (yyval.clauselval) = new comp_clause_list; (yyval.clauselval)->push_back(*(yysemantic_stack_[(1) - (1)].clauseval)); delete (yysemantic_stack_[(1) - (1)].clauseval); ;}
    break;

  case 138:
#line 682 "parser.yy"
    { (yyval.clauselval) = (yysemantic_stack_[(3) - (1)].clauselval); (yyval.clauselval)->push_back(*(yysemantic_stack_[(3) - (3)].clauseval)); delete (yysemantic_stack_[(3) - (3)].clauseval); ;}
    break;

  case 139:
#line 687 "parser.yy"
    { (yyval.clauseval) = new comp_clause(*(yysemantic_stack_[(1) - (1)].xval), expr()); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 140:
#line 689 "parser.yy"
    { (yyval.clauseval) = new comp_clause(*(yysemantic_stack_[(3) - (1)].xval), *(yysemantic_stack_[(3) - (3)].xval)); delete (yysemantic_stack_[(3) - (1)].xval); delete (yysemantic_stack_[(3) - (3)].xval); ;}
    break;

  case 142:
#line 694 "parser.yy"
    { (yyval.xllval) = (yysemantic_stack_[(2) - (1)].xllval); ;}
    break;

  case 143:
#line 695 "parser.yy"
    { (yyval.xllval) = new exprll; ;}
    break;

  case 144:
#line 700 "parser.yy"
    { (yyval.xllval) = new exprll; (yyval.xllval)->push_back(*(yysemantic_stack_[(1) - (1)].xlval)); delete (yysemantic_stack_[(1) - (1)].xlval); ;}
    break;

  case 145:
#line 702 "parser.yy"
    { (yyval.xllval) = (yysemantic_stack_[(3) - (1)].xllval); (yyval.xllval)->push_back(*(yysemantic_stack_[(3) - (3)].xlval)); delete (yysemantic_stack_[(3) - (3)].xlval); ;}
    break;

  case 146:
#line 706 "parser.yy"
    { (yyval.xlval) = interp.mkrow_exprl((yysemantic_stack_[(1) - (1)].xval)); ;}
    break;

  case 147:
#line 717 "parser.yy"
    { (yyval.rlval) = new rulel;
  for (exprl::iterator l = (yysemantic_stack_[(3) - (1)].xlval)->begin(), end = (yysemantic_stack_[(3) - (1)].xlval)->end(); l != end; l++)
    (yyval.rlval)->push_back(rule(*l, (yysemantic_stack_[(3) - (3)].rhsval)->rhs(), (yysemantic_stack_[(3) - (3)].rhsval)->qual()));
  delete (yysemantic_stack_[(3) - (1)].xlval); delete (yysemantic_stack_[(3) - (3)].rhsval); ;}
    break;

  case 148:
#line 722 "parser.yy"
    { (yyval.rlval) = new rulel(1, rule(expr(), (yysemantic_stack_[(2) - (2)].rhsval)->rhs(), (yysemantic_stack_[(2) - (2)].rhsval)->qual())); delete (yysemantic_stack_[(2) - (2)].rhsval); ;}
    break;

  case 149:
#line 727 "parser.yy"
    { (yyval.xlval) = new exprl; (yyval.xlval)->push_back(*(yysemantic_stack_[(1) - (1)].xval)); delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 150:
#line 729 "parser.yy"
    { (yyval.xlval) = (yysemantic_stack_[(3) - (1)].xlval); (yyval.xlval)->push_back(*(yysemantic_stack_[(3) - (3)].xval)); delete (yysemantic_stack_[(3) - (3)].xval); ;}
    break;

  case 151:
#line 733 "parser.yy"
    { (yyval.rhsval) = new rhs_info((yysemantic_stack_[(1) - (1)].xval)); ;}
    break;

  case 153:
#line 738 "parser.yy"
    { (yyval.rhsval) = new rhs_info((yysemantic_stack_[(2) - (1)].xval)); ;}
    break;

  case 154:
#line 740 "parser.yy"
    { expr *x; parser_action(x = interp.mksimple_expr((yysemantic_stack_[(3) - (3)].opstk)),
			 (delete (yysemantic_stack_[(3) - (1)].xval), delete (yysemantic_stack_[(3) - (3)].opstk)));
  (yyval.rhsval) = new rhs_info((yysemantic_stack_[(3) - (1)].xval), x); ;}
    break;

  case 155:
#line 744 "parser.yy"
    { (yyval.rhsval) = (yysemantic_stack_[(4) - (1)].rhsval);
  if ((yyval.rhsval)->q) {
    (yyval.rhsval)->r = interp.mkcond1_expr((yyval.rhsval)->q, (yyval.rhsval)->r); (yyval.rhsval)->q = 0;
  }
  try {
    expr *x = interp.mkwhen_expr((yyval.rhsval)->r, (yysemantic_stack_[(4) - (3)].rlval));
    (yyval.rhsval)->r = x;
  } catch (err &e) {
    interp.error(yyloc, e.what());
  }
;}
    break;

  case 156:
#line 756 "parser.yy"
    { (yyval.rhsval) = (yysemantic_stack_[(4) - (1)].rhsval);
  if ((yyval.rhsval)->q) {
    (yyval.rhsval)->r = interp.mkcond1_expr((yyval.rhsval)->q, (yyval.rhsval)->r); (yyval.rhsval)->q = 0;
  }
  try {
    expr *x = interp.mkwith_expr((yyval.rhsval)->r, new env((yysemantic_stack_[(4) - (3)].rinfo)->e)); delete (yysemantic_stack_[(4) - (3)].rinfo);
    (yyval.rhsval)->r = x;
  } catch (err &e) {
    interp.error(yyloc, e.what());
  }
;}
    break;

  case 158:
#line 771 "parser.yy"
    { (yyval.rinfo) = (yysemantic_stack_[(2) - (1)].rinfo); ;}
    break;

  case 159:
#line 776 "parser.yy"
    { (yyval.rinfo) = new rule_info;
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yyval.rinfo)->l, (yysemantic_stack_[(1) - (1)].rlval));
    interp.add_rules((yyval.rinfo)->e, rl);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } ;}
    break;

  case 160:
#line 784 "parser.yy"
    { (yyval.rinfo) = (yysemantic_stack_[(3) - (1)].rinfo);
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yyval.rinfo)->l, (yysemantic_stack_[(3) - (3)].rlval));
    interp.add_rules((yyval.rinfo)->e, rl);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } ;}
    break;

  case 162:
#line 797 "parser.yy"
    { (yyval.prinfo) = (yysemantic_stack_[(2) - (1)].prinfo); ;}
    break;

  case 163:
#line 802 "parser.yy"
    { (yyval.prinfo) = new pat_rule_info;
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yyval.prinfo)->l, (yysemantic_stack_[(1) - (1)].rlval));
    interp.add_rules((yyval.prinfo)->rl, rl, true);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } ;}
    break;

  case 164:
#line 810 "parser.yy"
    { (yyval.prinfo) = (yysemantic_stack_[(3) - (1)].prinfo);
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yyval.prinfo)->l, (yysemantic_stack_[(3) - (3)].rlval));
    interp.add_rules((yyval.prinfo)->rl, rl, true);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } ;}
    break;

  case 165:
#line 824 "parser.yy"
    { (yyval.rval) = new rule(*(yysemantic_stack_[(3) - (1)].xval), *(yysemantic_stack_[(3) - (3)].xval)); delete (yysemantic_stack_[(3) - (1)].xval); delete (yysemantic_stack_[(3) - (3)].xval); ;}
    break;

  case 166:
#line 826 "parser.yy"
    { expr *x = new expr(interp.symtab.anon_sym);
  (yyval.rval) = new rule(*x, *(yysemantic_stack_[(1) - (1)].xval)); delete x; delete (yysemantic_stack_[(1) - (1)].xval); ;}
    break;

  case 168:
#line 832 "parser.yy"
    { (yyval.rlval) = (yysemantic_stack_[(2) - (1)].rlval); ;}
    break;

  case 169:
#line 837 "parser.yy"
    { (yyval.rlval) = new rulel; try { interp.add_simple_rule(*(yyval.rlval), (yysemantic_stack_[(1) - (1)].rval)); }
  catch (err &e) { interp.error(yyloc, e.what()); } ;}
    break;

  case 170:
#line 840 "parser.yy"
    { (yyval.rlval) = (yysemantic_stack_[(3) - (1)].rlval); try { interp.add_simple_rule(*(yyval.rlval), (yysemantic_stack_[(3) - (3)].rval)); }
  catch (err &e) { interp.error(yyloc, e.what()); } ;}
    break;

  case 171:
#line 851 "parser.yy"
    { (yyval.rlval) = new rulel;
  for (exprl::iterator l = (yysemantic_stack_[(1) - (1)].xlval)->begin(), end = (yysemantic_stack_[(1) - (1)].xlval)->end(); l != end; l++) {
    if (l->is_fun()) {
      // Just declare the symbol so that the compiler knows about it.
      // This will promote the symbol to the proper namespace if it hasn't
      // been declared yet.
      interp.checkvars(*l);
      interp.symtab.sym(l->tag()).unresolved = false;
      if ((interp.verbose&verbosity::defs) != 0)
	cout << "type " << *l << ";\n";
      interp.typeenv[l->tag()];
    } else
      // assume rhs = true
      (yyval.rlval)->push_back(rule(*l, expr(EXPR::INT, 1)));
  }
  delete (yysemantic_stack_[(1) - (1)].xlval); ;}
    break;

  case 172:
#line 868 "parser.yy"
    { (yyval.rlval) = new rulel;
  for (exprl::iterator l = (yysemantic_stack_[(3) - (1)].xlval)->begin(), end = (yysemantic_stack_[(3) - (1)].xlval)->end(); l != end; l++)
    (yyval.rlval)->push_back(rule(*l, (yysemantic_stack_[(3) - (3)].rhsval)->rhs(), (yysemantic_stack_[(3) - (3)].rhsval)->qual()));
  delete (yysemantic_stack_[(3) - (1)].xlval); delete (yysemantic_stack_[(3) - (3)].rhsval); ;}
    break;

  case 173:
#line 879 "parser.yy"
    { (yyval.rlval) = new rulel;
  for (exprl::iterator l = (yysemantic_stack_[(3) - (1)].xlval)->begin(), end = (yysemantic_stack_[(3) - (1)].xlval)->end(); l != end; l++)
    (yyval.rlval)->push_back(rule(*l, *(yysemantic_stack_[(3) - (3)].xval)));
  delete (yysemantic_stack_[(3) - (1)].xlval); delete (yysemantic_stack_[(3) - (3)].xval); ;}
    break;

  case 174:
#line 894 "parser.yy"
    { (yyval.ival) = 0; ;}
    break;

  case 175:
#line 896 "parser.yy"
    { interp.loc = &yyloc;
  int32_t tag = (yysemantic_stack_[(2) - (0)].ival), count = 0;
  if (tag) {
    action((interp.add_interface_rule(interp.typeenv, tag, *(yysemantic_stack_[(2) - (2)].xval)), count++), );
  }
  (yyval.ival) = count;
;}
    break;

  case 176:
#line 904 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(4) - (1)].ival)+(yysemantic_stack_[(4) - (3)].ival); delete (yysemantic_stack_[(4) - (2)].xval); ;}
    break;

  case 177:
#line 906 "parser.yy"
    { const symbol &sym = interp.symtab.checksym(*(yysemantic_stack_[(3) - (3)].sval));
  interp.loc = &yyloc;
  int32_t tag = (yysemantic_stack_[(3) - (0)].ival), iface = sym.f, count = 0;
  if (tag) {
    action((count = interp.add_sub_interface(interp.typeenv, tag, iface)), );
  }
  (yyval.ival) = count;
;}
    break;

  case 178:
#line 915 "parser.yy"
    { (yyval.ival) = (yysemantic_stack_[(5) - (1)].ival)+(yysemantic_stack_[(5) - (4)].ival); delete (yysemantic_stack_[(5) - (3)].sval); ;}
    break;


    /* Line 675 of lalr1.cc.  */
#line 1802 "./parser.cc"
	default: break;
      }
    YY_SYMBOL_PRINT ("-> $$ =", yyr1_[yyn], &yyval, &yyloc);

    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();

    yysemantic_stack_.push (yyval);
    yylocation_stack_.push (yyloc);

    /* Shift the result of the reduction.  */
    yyn = yyr1_[yyn];
    yystate = yypgoto_[yyn - yyntokens_] + yystate_stack_[0];
    if (0 <= yystate && yystate <= yylast_
	&& yycheck_[yystate] == yystate_stack_[0])
      yystate = yytable_[yystate];
    else
      yystate = yydefgoto_[yyn - yyntokens_];
    goto yynewstate;

  /*------------------------------------.
  | yyerrlab -- here on detecting error |
  `------------------------------------*/
  yyerrlab:
    /* If not already recovering from an error, report this error.  */
    if (!yyerrstatus_)
      {
	++yynerrs_;
	error (yylloc, yysyntax_error_ (yystate, yytoken));
      }

    yyerror_range[0] = yylloc;
    if (yyerrstatus_ == 3)
      {
	/* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

	if (yychar <= yyeof_)
	  {
	  /* Return failure if at end of input.  */
	  if (yychar == yyeof_)
	    YYABORT;
	  }
	else
	  {
	    yydestruct_ ("Error: discarding", yytoken, &yylval, &yylloc);
	    yychar = yyempty_;
	  }
      }

    /* Else will try to reuse look-ahead token after shifting the error
       token.  */
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;

    yyerror_range[0] = yylocation_stack_[yylen - 1];
    /* Do not reclaim the symbols of the rule which action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    yystate = yystate_stack_[0];
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;	/* Each real token shifted decrements this.  */

    for (;;)
      {
	yyn = yypact_[yystate];
	if (yyn != yypact_ninf_)
	{
	  yyn += yyterror_;
	  if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
	    {
	      yyn = yytable_[yyn];
	      if (0 < yyn)
		break;
	    }
	}

	/* Pop the current state because it cannot handle the error token.  */
	if (yystate_stack_.height () == 1)
	YYABORT;

	yyerror_range[0] = yylocation_stack_[0];
	yydestruct_ ("Error: popping",
		     yystos_[yystate],
		     &yysemantic_stack_[0], &yylocation_stack_[0]);
	yypop_ ();
	yystate = yystate_stack_[0];
	YY_STACK_PRINT ();
      }

    if (yyn == yyfinal_)
      goto yyacceptlab;

    yyerror_range[1] = yylloc;
    // Using YYLLOC is tempting, but would change the location of
    // the look-ahead.  YYLOC is available though.
    YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yyloc);

    /* Shift the error token.  */
    YY_SYMBOL_PRINT ("Shifting", yystos_[yyn],
		   &yysemantic_stack_[0], &yylocation_stack_[0]);

    yystate = yyn;
    goto yynewstate;

    /* Accept.  */
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    /* Abort.  */
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (yychar != yyeof_ && yychar != yyempty_)
      yydestruct_ ("Cleanup: discarding lookahead", yytoken, &yylval, &yylloc);

    /* Do not reclaim the symbols of the rule which action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (yystate_stack_.height () != 1)
      {
	yydestruct_ ("Cleanup: popping",
		   yystos_[yystate_stack_[0]],
		   &yysemantic_stack_[0],
		   &yylocation_stack_[0]);
	yypop_ ();
      }

    return yyresult;
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (int yystate, int tok)
  {
    std::string res;
    YYUSE (yystate);
#if YYERROR_VERBOSE
    int yyn = yypact_[yystate];
    if (yypact_ninf_ < yyn && yyn <= yylast_)
      {
	/* Start YYX at -YYN if negative to avoid negative indexes in
	   YYCHECK.  */
	int yyxbegin = yyn < 0 ? -yyn : 0;

	/* Stay within bounds of both yycheck and yytname.  */
	int yychecklim = yylast_ - yyn + 1;
	int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
	int count = 0;
	for (int x = yyxbegin; x < yyxend; ++x)
	  if (yycheck_[x + yyn] == x && x != yyterror_)
	    ++count;

	// FIXME: This method of building the message is not compatible
	// with internationalization.  It should work like yacc.c does it.
	// That is, first build a string that looks like this:
	// "syntax error, unexpected %s or %s or %s"
	// Then, invoke YY_ on this string.
	// Finally, use the string as a format to output
	// yytname_[tok], etc.
	// Until this gets fixed, this message appears in English only.
	res = "syntax error, unexpected ";
	res += yytnamerr_ (yytname_[tok]);
	if (count < 5)
	  {
	    count = 0;
	    for (int x = yyxbegin; x < yyxend; ++x)
	      if (yycheck_[x + yyn] == x && x != yyterror_)
		{
		  res += (!count++) ? ", expecting " : " or ";
		  res += yytnamerr_ (yytname_[x]);
		}
	  }
      }
    else
#endif
      res = YY_("syntax error");
    return res;
  }


  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
  const short int parser::yypact_ninf_ = -240;
  const short int
  parser::yypact_[] =
  {
       173,   -15,     5,  -240,  -240,  -240,  -240,   305,  -240,  -240,
    -240,  -240,   150,   409,   409,   409,   409,     1,   409,   409,
      10,   103,  -240,   409,  -240,   409,  -240,    61,  -240,  -240,
    -240,  -240,  -240,   341,   409,   677,   409,    59,  -240,  -240,
      86,    50,   107,  -240,    32,   100,  -240,  -240,   237,   199,
     116,    45,    22,    72,    78,   140,    94,  -240,   119,    91,
      38,  -240,  -240,  -240,   138,  -240,  -240,  -240,  -240,   112,
      -6,   130,   145,   110,  -240,   677,   363,   567,   589,   611,
      34,   104,  -240,     4,   545,   218,  -240,   215,   633,  -240,
       2,   144,   139,  -240,  -240,    -1,   169,  -240,  -240,   163,
    -240,   202,   409,   387,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,   409,   409,  -240,  -240,  -240,  -240,  -240,   195,
     409,  -240,   409,  -240,  -240,   409,  -240,   240,   387,   409,
    -240,   152,  -240,   197,   185,  -240,   185,   222,  -240,   -12,
    -240,   158,  -240,    35,  -240,  -240,  -240,   223,  -240,   443,
    -240,   477,  -240,   511,  -240,  -240,  -240,   236,   242,   243,
     244,   655,  -240,   409,   387,   409,  -240,   409,  -240,   409,
     409,  -240,  -240,   -18,  -240,  -240,   237,   130,  -240,  -240,
     258,   249,  -240,   281,   250,  -240,   199,  -240,   199,   199,
    -240,  -240,  -240,   285,   254,   224,  -240,   241,  -240,   226,
    -240,   265,  -240,  -240,  -240,   130,   256,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,  -240,   107,   304,   307,   199,
      36,   262,   274,  -240,   199,  -240,   263,  -240,  -240,   275,
     227,  -240,   409,  -240,   387,  -240,  -240,   387,   409,  -240,
     291,  -240,   282,   247,  -240,   106,  -240,  -240,   409,  -240,
     409,  -240,  -240,  -240,  -240,  -240,    23,  -240,  -240,  -240,
      46,  -240,   276,   317,  -240,  -240,   283,   284,    43,   199,
    -240,   298,   289,   199,  -240,  -240,  -240,   290,  -240,   286,
     133,  -240,  -240,  -240,  -240,   293,  -240,   306,  -240,  -240,
      43,   302,  -240,  -240,  -240,  -240
  };

  /* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
     doesn't specify something else to do.  Zero means the default is an
     error.  */
  const unsigned char
  parser::yydefact_[] =
  {
         0,     0,     9,     5,     1,     3,     4,     0,    56,    55,
      43,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    63,    34,     0,    99,     0,    36,   106,   113,   109,
     111,   110,   112,     0,     0,     0,   143,     0,    10,    21,
      37,   149,    90,    98,     0,     0,    39,    40,     0,   149,
       0,     0,   166,     0,     0,   171,     0,    16,     0,     0,
       0,    61,    62,    24,     0,    59,    73,    74,    64,     0,
      63,     0,     0,     0,   107,     0,     0,     0,     0,     0,
      99,     0,   121,     0,    90,   151,   148,   152,     0,    96,
     146,     0,   141,   144,   118,     0,     0,    48,    47,     0,
      32,     0,     0,     0,    11,   105,   103,   104,   102,   101,
     100,    20,     0,     0,    50,    51,    52,    53,    54,     0,
       0,    15,     0,    14,    13,     0,    19,     0,     0,     0,
      31,     0,    66,    68,     0,    23,     0,     0,    27,     0,
      84,     0,    75,     0,   114,    12,   108,     0,   122,     0,
     123,     0,   124,     0,   125,   126,   120,   105,   103,   104,
     102,     0,   153,     0,     0,     0,    97,     0,   115,   142,
       0,   117,    57,     0,    44,    45,     0,     0,    38,   169,
       0,   167,   159,     0,   157,   147,   150,    41,   173,   165,
     172,    17,   163,     0,   161,     0,    30,     0,    69,     0,
      60,     0,    28,    26,    35,     0,     0,    85,   127,   132,
     133,   134,   128,   129,   130,   131,   154,     0,     0,    91,
     139,     0,   135,   137,   146,   145,     0,    58,    22,     0,
       0,    93,   168,    94,   158,   174,    92,   162,     0,    67,
       0,    25,     0,     0,    76,    78,   155,   156,     0,   116,
     136,   119,    46,    33,   170,   160,     0,   164,    95,    71,
       0,    65,     0,     9,     6,    79,     0,    80,    86,   140,
     138,     0,     0,   175,    72,    70,     8,     0,     7,    88,
       0,    87,    82,   177,    18,     0,    29,     0,    77,    81,
      86,     0,   176,    89,    83,   178
  };

  /* YYPGOTO[NTERM-NUM].  */
  const short int
  parser::yypgoto_[] =
  {
      -240,  -240,  -240,  -211,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,   176,   333,  -240,   229,   220,
     288,  -240,  -240,   164,  -240,  -240,   343,   190,   168,  -240,
    -240,  -239,    84,  -240,    -7,  -240,   -32,   -25,   205,  -240,
     127,  -240,  -240,   209,    -5,   268,   -97,  -240,   217,  -240,
    -240,  -240,   -11,   231,  -240,  -240,  -240,  -240,  -240,  -240
  };

  /* YYDEFGOTO[NTERM-NUM].  */
  const short int
  parser::yydefgoto_[] =
  {
        -1,     2,   263,     6,     7,    38,   127,   235,    96,   134,
     243,   177,    71,   101,    39,   119,    40,   173,    64,    65,
      69,   137,   131,   132,   240,   260,   133,   141,   142,   266,
     267,   143,   282,   288,    49,    88,    42,    43,   221,   222,
     223,    91,    92,    93,   182,    45,    86,    87,   183,   184,
     193,   194,   179,   180,   181,    56,    51,   256,   285,   291
  };

  /* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule which
     number is the opposite.  If zero, do what YYDEFACT says.  */
  const signed char parser::yytable_ninf_ = -50;
  const short int
  parser::yytable_[] =
  {
        41,    84,    44,    53,    54,     4,   268,    52,    52,   202,
      89,    58,    59,     8,     9,   185,    72,   110,    73,   102,
     103,   227,   102,   103,   102,   103,    83,    85,   190,    90,
      95,   228,   264,    60,     3,   271,    18,   203,   272,    19,
      57,   290,   102,   103,    68,   149,   151,   153,    23,    61,
     146,    62,   278,    24,     5,   156,   102,   103,   170,   110,
     171,   167,    27,   166,    28,    29,    30,    31,    32,    72,
     102,   103,    18,    33,   206,    19,   122,    66,    35,    67,
      36,   111,   281,    37,    23,   154,   274,   130,   207,    24,
     248,    97,    98,    99,   121,    52,   207,   275,    27,   104,
      28,    29,    30,    31,    32,    85,   186,    74,   129,    33,
     100,   102,   103,   188,    35,   189,    36,    75,    85,    37,
      94,   123,   195,   192,   110,   -49,   110,   124,   110,   216,
     102,   103,    23,   128,   105,   106,   107,   108,   109,   102,
     103,   265,    66,   126,    67,   140,    27,   145,    28,    29,
      30,    31,    32,    68,   112,   155,    52,    33,   219,   113,
     220,   138,   224,   220,    36,   102,   103,    37,   289,   140,
     120,   144,   140,    -2,     1,   113,    -2,    -2,    -2,    -2,
      -2,    -2,    -2,    -2,    -2,    -2,    -2,   135,   169,    -2,
     136,   110,    46,    47,   125,    -2,    -2,    -2,    -2,   113,
      48,   196,   168,    -2,   197,   174,   175,   204,   172,    -2,
     205,    -2,    -2,   176,    -2,    -2,    -2,    -2,    -2,   102,
     103,   254,    -2,    -2,    61,    52,    62,    -2,    -2,   255,
      -2,   258,   257,    -2,   161,   163,   164,   162,   102,   103,
     178,   269,   238,   220,   102,   103,   187,   198,   262,   273,
      -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,
      -9,   191,   201,    -9,   114,   115,   116,   117,   118,    -9,
      -9,    -9,    -9,   231,   208,   241,   253,    -9,   136,   205,
      66,    50,    67,    -9,    55,    -9,    -9,   212,    -9,    -9,
      -9,    -9,    -9,   213,   214,   215,   233,    -9,   232,   234,
     236,    -9,    -9,   237,    -9,   242,   245,    -9,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,   246,
     249,    19,   247,   250,   251,   276,   252,    20,    21,    22,
      23,   259,   277,   261,   279,    24,   280,   283,   284,   286,
     287,    25,   292,    26,    27,   293,    28,    29,    30,    31,
      32,   295,   229,    63,    18,    33,   200,    19,   139,    34,
      35,   239,    36,   199,    70,    37,    76,   230,    77,    78,
      79,    80,    81,   244,   294,   226,    18,   270,   225,    19,
      27,   218,    28,    29,    30,    31,    32,     0,    23,   147,
       0,    33,    82,    24,   217,     0,    35,     0,    36,     0,
      18,    37,    27,    19,    28,    29,    30,    31,    32,     0,
       0,     0,    23,    33,     0,     0,     0,    24,    35,     0,
      36,     0,    18,    37,     0,    19,    27,     0,    28,    29,
      30,    31,    32,     0,    23,     0,     0,    33,     0,    24,
       0,    34,    35,     0,    36,     0,     0,    37,    27,     0,
      28,    29,    30,    31,    32,     0,     0,     0,     0,    33,
       0,     0,     0,     0,    35,     0,    36,     0,    23,    37,
     105,   106,   107,   108,   109,     0,     0,     0,     0,     0,
       0,     0,    27,     0,    28,    29,    30,    31,    32,     0,
       0,     0,     0,    33,   209,     0,     0,     0,     0,     0,
      36,     0,    23,    37,   105,   106,   107,   108,   109,     0,
       0,     0,     0,     0,     0,     0,    27,     0,    28,    29,
      30,    31,    32,     0,     0,     0,     0,    33,   210,     0,
       0,     0,     0,     0,    36,     0,    23,    37,   105,   106,
     107,   108,   109,     0,     0,     0,     0,     0,     0,     0,
      27,     0,    28,    29,    30,    31,    32,     0,     0,     0,
       0,    33,   211,     0,     0,     0,     0,     0,    36,     0,
      23,    37,   157,   158,   159,   160,   109,     0,     0,     0,
       0,     0,     0,     0,    27,     0,    28,    29,    30,    31,
      32,     0,    23,     0,     0,    33,     0,    24,     0,     0,
       0,     0,    36,     0,     0,    37,    27,     0,    28,    29,
      30,    31,    32,     0,    23,     0,     0,    33,   148,    24,
       0,     0,     0,     0,    36,     0,     0,    37,    27,     0,
      28,    29,    30,    31,    32,     0,    23,     0,     0,    33,
     150,    24,     0,     0,     0,     0,    36,     0,     0,    37,
      27,     0,    28,    29,    30,    31,    32,     0,    23,     0,
       0,    33,   152,     0,     0,   165,     0,     0,    36,     0,
       0,    37,    27,     0,    28,    29,    30,    31,    32,     0,
      23,     0,     0,    33,     0,    24,     0,     0,     0,     0,
      36,     0,     0,    37,    27,     0,    28,    29,    30,    31,
      32,     0,    23,     0,     0,    33,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    37,    27,     0,    28,    29,
      30,    31,    32,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,    36,     0,     0,    37
  };

  /* YYCHECK.  */
  const short int
  parser::yycheck_[] =
  {
         7,    33,     7,    14,    15,     0,   245,    14,    15,    21,
      35,    18,    19,     3,     4,   112,    23,    42,    25,    20,
      21,    39,    20,    21,    20,    21,    33,    34,   125,    36,
      37,    49,   243,    23,    49,    12,    13,    49,    15,    16,
      39,   280,    20,    21,    50,    77,    78,    79,    25,    39,
      75,    41,   263,    30,    49,    51,    20,    21,    59,    84,
      61,    59,    39,    88,    41,    42,    43,    44,    45,    76,
      20,    21,    13,    50,    39,    16,    54,    39,    55,    41,
      57,    49,    39,    60,    25,    51,    40,    49,    53,    30,
      54,     5,     6,     7,    49,   102,    53,    51,    39,    49,
      41,    42,    43,    44,    45,   112,   113,    46,    17,    50,
      24,    20,    21,   120,    55,   122,    57,    56,   125,    60,
      61,    49,   129,   128,   149,    39,   151,    49,   153,   161,
      20,    21,    25,    14,    27,    28,    29,    30,    31,    20,
      21,    35,    39,    49,    41,    39,    39,    37,    41,    42,
      43,    44,    45,    50,    54,    51,   163,    50,   165,    59,
     167,    49,   169,   170,    57,    20,    21,    60,    35,    39,
      54,    26,    39,     0,     1,    59,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    49,    49,    16,
      52,   216,    42,    43,    54,    22,    23,    24,    25,    59,
      50,    49,    58,    30,    52,    42,    43,    49,    39,    36,
      52,    38,    39,    50,    41,    42,    43,    44,    45,    20,
      21,   232,    49,    50,    39,   232,    41,    54,    55,   234,
      57,   238,   237,    60,    16,    20,    21,    19,    20,    21,
      38,   248,    18,   250,    20,    21,    51,    50,     1,   256,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    21,    40,    16,    27,    28,    29,    30,    31,    22,
      23,    24,    25,    15,    51,    49,    49,    30,    52,    52,
      39,    13,    41,    36,    16,    38,    39,    51,    41,    42,
      43,    44,    45,    51,    51,    51,    15,    50,    49,    49,
      15,    54,    55,    49,    57,    40,    50,    60,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    15,
      58,    16,    15,    49,    61,    49,    51,    22,    23,    24,
      25,    40,    15,    51,    51,    30,    52,    39,    49,    49,
      54,    36,    49,    38,    39,    39,    41,    42,    43,    44,
      45,    49,   176,    20,    13,    50,   136,    16,    70,    54,
      55,   197,    57,   134,    21,    60,    25,   177,    27,    28,
      29,    30,    31,   205,   290,   170,    13,   250,   169,    16,
      39,   164,    41,    42,    43,    44,    45,    -1,    25,    26,
      -1,    50,    51,    30,   163,    -1,    55,    -1,    57,    -1,
      13,    60,    39,    16,    41,    42,    43,    44,    45,    -1,
      -1,    -1,    25,    50,    -1,    -1,    -1,    30,    55,    -1,
      57,    -1,    13,    60,    -1,    16,    39,    -1,    41,    42,
      43,    44,    45,    -1,    25,    -1,    -1,    50,    -1,    30,
      -1,    54,    55,    -1,    57,    -1,    -1,    60,    39,    -1,
      41,    42,    43,    44,    45,    -1,    -1,    -1,    -1,    50,
      -1,    -1,    -1,    -1,    55,    -1,    57,    -1,    25,    60,
      27,    28,    29,    30,    31,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    -1,    41,    42,    43,    44,    45,    -1,
      -1,    -1,    -1,    50,    51,    -1,    -1,    -1,    -1,    -1,
      57,    -1,    25,    60,    27,    28,    29,    30,    31,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    -1,    41,    42,
      43,    44,    45,    -1,    -1,    -1,    -1,    50,    51,    -1,
      -1,    -1,    -1,    -1,    57,    -1,    25,    60,    27,    28,
      29,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      39,    -1,    41,    42,    43,    44,    45,    -1,    -1,    -1,
      -1,    50,    51,    -1,    -1,    -1,    -1,    -1,    57,    -1,
      25,    60,    27,    28,    29,    30,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    -1,    41,    42,    43,    44,
      45,    -1,    25,    -1,    -1,    50,    -1,    30,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    60,    39,    -1,    41,    42,
      43,    44,    45,    -1,    25,    -1,    -1,    50,    51,    30,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    60,    39,    -1,
      41,    42,    43,    44,    45,    -1,    25,    -1,    -1,    50,
      51,    30,    -1,    -1,    -1,    -1,    57,    -1,    -1,    60,
      39,    -1,    41,    42,    43,    44,    45,    -1,    25,    -1,
      -1,    50,    51,    -1,    -1,    32,    -1,    -1,    57,    -1,
      -1,    60,    39,    -1,    41,    42,    43,    44,    45,    -1,
      25,    -1,    -1,    50,    -1,    30,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    60,    39,    -1,    41,    42,    43,    44,
      45,    -1,    25,    -1,    -1,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    60,    39,    -1,    41,    42,
      43,    44,    45,    -1,    -1,    -1,    -1,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    60
  };

  /* STOS_[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
  const unsigned char
  parser::yystos_[] =
  {
         0,     1,    63,    49,     0,    49,    65,    66,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    16,
      22,    23,    24,    25,    30,    36,    38,    39,    41,    42,
      43,    44,    45,    50,    54,    55,    57,    60,    67,    76,
      78,    96,    98,    99,   106,   107,    42,    43,    50,    96,
     107,   118,    96,   114,   114,   107,   117,    39,    96,    96,
      23,    39,    41,    78,    80,    81,    39,    41,    50,    82,
      88,    74,    96,    96,    46,    56,    25,    27,    28,    29,
      30,    31,    51,    96,    98,    96,   108,   109,    97,    99,
      96,   103,   104,   105,    61,    96,    70,     5,     6,     7,
      24,    75,    20,    21,    49,    27,    28,    29,    30,    31,
      99,    49,    54,    59,    27,    28,    29,    30,    31,    77,
      54,    49,    54,    49,    49,    54,    49,    68,    14,    17,
      49,    84,    85,    88,    71,    49,    52,    83,    49,    82,
      39,    89,    90,    93,    26,    37,    99,    26,    51,    98,
      51,    98,    51,    98,    51,    51,    51,    27,    28,    29,
      30,    16,    19,    20,    21,    32,    99,    59,    58,    49,
      59,    61,    39,    79,    42,    43,    50,    73,    38,   114,
     115,   116,   106,   110,   111,   108,    96,    51,    96,    96,
     108,    21,   106,   112,   113,    96,    49,    52,    50,    80,
      81,    40,    21,    49,    49,    52,    39,    53,    51,    51,
      51,    51,    51,    51,    51,    51,    98,   115,   110,    96,
      96,   100,   101,   102,    96,   105,   100,    39,    49,    77,
      89,    15,    49,    15,    49,    69,    15,    49,    18,    85,
      86,    49,    40,    72,    90,    50,    15,    15,    54,    58,
      49,    61,    51,    49,   114,   106,   119,   106,    96,    40,
      87,    51,     1,    64,    65,    35,    91,    92,    93,    96,
     102,    12,    15,    96,    40,    51,    49,    15,    65,    51,
      52,    39,    94,    39,    49,   120,    49,    54,    95,    35,
      93,   121,    49,    39,    94,    49
  };

#if YYDEBUG
  /* TOKEN_NUMBER_[YYLEX-NUM] -- Internal symbol number corresponding
     to YYLEX-NUM.  */
  const unsigned short int
  parser::yytoken_number_[] =
  {
         0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,    59,
      40,    41,    44,    42,    61,    92,    64,   123,   125,   124,
      91,    93
  };
#endif

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
  const unsigned char
  parser::yyr1_[] =
  {
         0,    62,    63,    63,    63,    63,    64,    64,    64,    66,
      65,    67,    67,    67,    67,    67,    68,    69,    67,    67,
      67,    70,    67,    67,    71,    67,    67,    67,    72,    67,
      67,    67,    73,    67,    74,    67,    67,    75,    67,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      77,    77,    77,    77,    77,    78,    78,    79,    79,    80,
      80,    81,    81,    82,    83,    82,    84,    84,    85,    86,
      85,    87,    87,    88,    88,    89,    89,    90,    91,    91,
      91,    91,    92,    92,    93,    93,    94,    94,    95,    95,
      96,    96,    96,    96,    96,    96,    97,    97,    98,    98,
      98,    98,    98,    98,    98,    98,    99,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,   100,   100,   101,   101,   102,
     102,   103,   103,   103,   104,   104,   105,   106,   106,   107,
     107,   108,   108,   109,   109,   109,   109,   110,   110,   111,
     111,   112,   112,   113,   113,   114,   114,   115,   115,   116,
     116,   117,   117,   118,   119,   120,   119,   121,   119
  };

  /* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
  const unsigned char
  parser::yyr2_[] =
  {
         0,     2,     0,     2,     2,     2,     1,     2,     2,     0,
       2,     2,     3,     3,     3,     3,     0,     0,     8,     3,
       2,     0,     4,     3,     0,     5,     4,     3,     0,     8,
       4,     3,     0,     5,     0,     4,     1,     0,     3,     2,
       2,     4,     1,     1,     3,     3,     5,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     0,     5,     1,     3,     1,     0,
       5,     1,     2,     1,     1,     1,     3,     6,     0,     1,
       1,     3,     2,     4,     1,     2,     0,     1,     0,     2,
       1,     4,     5,     4,     4,     6,     1,     2,     1,     1,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     1,
       1,     1,     1,     1,     3,     3,     5,     3,     2,     5,
       3,     2,     3,     3,     3,     3,     3,     4,     4,     4,
       4,     4,     4,     4,     4,     1,     2,     1,     3,     1,
       3,     1,     2,     0,     1,     3,     1,     3,     2,     1,
       3,     1,     1,     2,     3,     4,     4,     1,     2,     1,
       3,     1,     2,     1,     3,     3,     1,     1,     2,     1,
       3,     1,     3,     3,     0,     0,     4,     0,     5
  };

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
  /* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
     First, the terminals, then, starting at \a yyntokens_, nonterminals.  */
  const char*
  const parser::yytname_[] =
  {
    "\"end of file\"", "error", "$undefined", "\"private\"", "\"public\"",
  "\"nonfix\"", "\"outfix\"", "\"fixity\"", "\"def\"", "\"const\"",
  "\"let\"", "\"type\"", "\"interface\"", "\"case\"", "\"of\"", "\"end\"",
  "\"if\"", "\"then\"", "\"else\"", "\"otherwise\"", "\"when\"",
  "\"with\"", "\"using\"", "\"namespace\"", "\"extern\"",
  "\"left outfix operator\"", "\"right outfix operator\"",
  "\"infix operator\"", "\"infixl operator\"", "\"infixr operator\"",
  "\"prefix operator\"", "\"postfix operator\"", "\"->\"",
  "\"invalid character\"", "\"bad token\"", "\"...\"", "ESCAPE",
  "\"end of input\"", "\"code section\"", "\"identifier\"", "\"symbol\"",
  "\"string\"", "\"integer\"", "\"bigint\"", "\"converted bigint\"",
  "\"floating point number\"", "\"type tag\"", "\"namespace brackets\"",
  "\"simple expression\"", "';'", "'('", "')'", "','", "'*'", "'='",
  "'\\\\'", "'@'", "'{'", "'}'", "'|'", "'['", "']'", "$accept", "source",
  "items", "item_pos", "@1", "item", "@2", "@3", "@4", "@5", "@6", "@7",
  "@8", "@9", "fixity", "op", "scope", "ids", "fnames", "fname",
  "opt_brackets", "@10", "name_xsyms_list", "name_xsyms", "@11", "xsyms",
  "name", "prototypes", "prototype", "opt_ctypes", "ctypes", "ctype",
  "optname", "optalias", "expr", "args", "simple", "prim", "comp_clauses",
  "comp_clause_list", "comp_clause", "rows", "row_list", "row", "rule",
  "lhs", "rhs", "qual_rhs", "rules", "rulel", "pat_rules", "pat_rulel",
  "simple_rule", "simple_rules", "simple_rulel", "type_rule", "macro_rule",
  "interface_rules", "@12", "@13", 0
  };
#endif

#if YYDEBUG
  /* YYRHS -- A `-1'-separated list of the rules' RHS.  */
  const parser::rhs_number_type
  parser::yyrhs_[] =
  {
        63,     0,    -1,    -1,    63,    49,    -1,    63,    65,    -1,
       1,    49,    -1,    65,    -1,    64,    65,    -1,     1,    49,
      -1,    -1,    66,    67,    -1,    96,    49,    -1,    36,    96,
      37,    -1,    10,   114,    49,    -1,     9,   114,    49,    -1,
       8,   118,    49,    -1,    -1,    -1,    12,    39,    68,    21,
      69,   119,    15,    49,    -1,    11,   117,    49,    -1,   106,
      49,    -1,    -1,    76,    70,    79,    49,    -1,    22,    80,
      49,    -1,    -1,    22,    78,    71,    80,    49,    -1,    23,
      88,    82,    49,    -1,    23,    82,    49,    -1,    -1,    23,
      88,    82,    21,    72,    64,    15,    49,    -1,    22,    23,
      84,    49,    -1,    22,    23,    49,    -1,    -1,    78,    24,
      73,    89,    49,    -1,    -1,    24,    74,    89,    49,    -1,
      38,    -1,    -1,    78,    75,    38,    -1,     7,    42,    -1,
       7,    43,    -1,     7,    50,    77,    51,    -1,     6,    -1,
       5,    -1,    78,     7,    42,    -1,    78,     7,    43,    -1,
      78,     7,    50,    77,    51,    -1,    78,     6,    -1,    78,
       5,    -1,    78,    -1,    27,    -1,    28,    -1,    29,    -1,
      30,    -1,    31,    -1,     4,    -1,     3,    -1,    39,    -1,
      79,    39,    -1,    81,    -1,    80,    52,    81,    -1,    39,
      -1,    41,    -1,    -1,    -1,    50,    83,    40,    40,    51,
      -1,    85,    -1,    84,    52,    85,    -1,    88,    -1,    -1,
      88,    50,    86,    87,    51,    -1,    40,    -1,    87,    40,
      -1,    39,    -1,    41,    -1,    90,    -1,    89,    52,    90,
      -1,    93,    39,    50,    91,    51,    95,    -1,    -1,    35,
      -1,    92,    -1,    92,    52,    35,    -1,    93,    94,    -1,
      92,    52,    93,    94,    -1,    39,    -1,    93,    53,    -1,
      -1,    39,    -1,    -1,    54,    39,    -1,    98,    -1,    55,
      97,    32,    96,    -1,    13,    96,    14,   112,    15,    -1,
      96,    20,   115,    15,    -1,    96,    21,   110,    15,    -1,
      16,    96,    17,    96,    18,    96,    -1,    99,    -1,    97,
      99,    -1,    99,    -1,    30,    -1,    98,    99,    -1,    98,
      31,    -1,    98,    30,    -1,    98,    28,    -1,    98,    29,
      -1,    98,    27,    -1,    39,    -1,    39,    46,    -1,    39,
      56,    99,    -1,    42,    -1,    44,    -1,    43,    -1,    45,
      -1,    41,    -1,    25,    96,    26,    -1,    57,   103,    58,
      -1,    57,    96,    59,   100,    58,    -1,    60,    96,    61,
      -1,    60,    61,    -1,    60,    96,    59,   100,    61,    -1,
      50,    96,    51,    -1,    50,    51,    -1,    50,    27,    51,
      -1,    50,    28,    51,    -1,    50,    29,    51,    -1,    50,
      30,    51,    -1,    50,    31,    51,    -1,    50,    25,    26,
      51,    -1,    50,    98,    27,    51,    -1,    50,    98,    28,
      51,    -1,    50,    98,    29,    51,    -1,    50,    98,    30,
      51,    -1,    50,    27,    98,    51,    -1,    50,    28,    98,
      51,    -1,    50,    29,    98,    51,    -1,   101,    -1,   101,
      49,    -1,   102,    -1,   101,    49,   102,    -1,    96,    -1,
      96,    54,    96,    -1,   104,    -1,   104,    49,    -1,    -1,
     105,    -1,   104,    49,   105,    -1,    96,    -1,   107,    54,
     108,    -1,    54,   108,    -1,    96,    -1,   107,    59,    96,
      -1,    96,    -1,   109,    -1,    96,    19,    -1,    96,    16,
      98,    -1,   109,    20,   115,    15,    -1,   109,    21,   110,
      15,    -1,   111,    -1,   111,    49,    -1,   106,    -1,   111,
      49,   106,    -1,   113,    -1,   113,    49,    -1,   106,    -1,
     113,    49,   106,    -1,    96,    54,    96,    -1,    96,    -1,
     116,    -1,   116,    49,    -1,   114,    -1,   116,    49,   114,
      -1,   107,    -1,   107,    54,   108,    -1,   107,    54,    96,
      -1,    -1,    -1,   119,    96,   120,    49,    -1,    -1,   119,
      12,    39,   121,    49,    -1
  };

  /* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
     YYRHS.  */
  const unsigned short int
  parser::yyprhs_[] =
  {
         0,     0,     3,     4,     7,    10,    13,    15,    18,    21,
      22,    25,    28,    32,    36,    40,    44,    45,    46,    55,
      59,    62,    63,    68,    72,    73,    79,    84,    88,    89,
      98,   103,   107,   108,   114,   115,   120,   122,   123,   127,
     130,   133,   138,   140,   142,   146,   150,   156,   159,   162,
     164,   166,   168,   170,   172,   174,   176,   178,   180,   183,
     185,   189,   191,   193,   194,   195,   201,   203,   207,   209,
     210,   216,   218,   221,   223,   225,   227,   231,   238,   239,
     241,   243,   247,   250,   255,   257,   260,   261,   263,   264,
     267,   269,   274,   280,   285,   290,   297,   299,   302,   304,
     306,   309,   312,   315,   318,   321,   324,   326,   329,   333,
     335,   337,   339,   341,   343,   347,   351,   357,   361,   364,
     370,   374,   377,   381,   385,   389,   393,   397,   402,   407,
     412,   417,   422,   427,   432,   437,   439,   442,   444,   448,
     450,   454,   456,   459,   460,   462,   466,   468,   472,   475,
     477,   481,   483,   485,   488,   492,   497,   502,   504,   507,
     509,   513,   515,   518,   520,   524,   528,   530,   532,   535,
     537,   541,   543,   547,   551,   552,   553,   558,   559
  };

  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
  const unsigned short int
  parser::yyrline_[] =
  {
         0,   231,   231,   233,   234,   235,   243,   244,   245,   251,
     251,   256,   260,   268,   270,   272,   275,   294,   274,   299,
     302,   310,   309,   319,   321,   321,   323,   329,   336,   335,
     339,   341,   343,   343,   344,   344,   345,   347,   347,   356,
     358,   360,   363,   365,   367,   369,   371,   374,   375,   376,
     380,   381,   382,   383,   384,   388,   389,   393,   395,   400,
     402,   407,   408,   413,   414,   414,   436,   439,   444,   446,
     446,   451,   453,   458,   460,   466,   467,   471,   480,   481,
     483,   484,   489,   491,   496,   497,   500,   502,   506,   507,
     516,   518,   521,   524,   527,   530,   535,   537,   547,   548,
     549,   550,   551,   552,   553,   554,   560,   565,   570,   575,
     576,   577,   578,   579,   580,   599,   600,   606,   607,   608,
     614,   616,   617,   618,   619,   620,   621,   622,   639,   643,
     647,   651,   658,   662,   666,   674,   675,   679,   681,   686,
     688,   693,   694,   695,   699,   701,   706,   716,   721,   726,
     728,   733,   734,   738,   739,   743,   755,   770,   771,   775,
     783,   796,   797,   801,   809,   823,   825,   831,   832,   836,
     839,   850,   867,   878,   894,   896,   895,   906,   905
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (state_stack_type::const_iterator i = yystate_stack_.begin ();
	 i != yystate_stack_.end (); ++i)
      *yycdebug_ << ' ' << *i;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    /* Print the symbols being reduced, and their result.  */
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
	       << " (line " << yylno << "), ";
    /* The symbols being reduced.  */
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
		       yyrhs_[yyprhs_[yyrule] + yyi],
		       &(yysemantic_stack_[(yynrhs) - (yyi + 1)]),
		       &(yylocation_stack_[(yynrhs) - (yyi + 1)]));
  }
#endif // YYDEBUG

  /* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
  parser::token_number_type
  parser::yytranslate_ (int t)
  {
    static
    const token_number_type
    translate_table[] =
    {
           0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      50,    51,    53,     2,    52,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    49,
       2,    54,     2,     2,    56,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    60,    55,    61,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    57,    59,    58,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48
    };
    if ((unsigned int) t <= yyuser_token_number_max_)
      return translate_table[t];
    else
      return yyundef_token_;
  }

  const int parser::yyeof_ = 0;
  const int parser::yylast_ = 737;
  const int parser::yynnts_ = 60;
  const int parser::yyempty_ = -2;
  const int parser::yyfinal_ = 4;
  const int parser::yyterror_ = 1;
  const int parser::yyerrcode_ = 256;
  const int parser::yyntokens_ = 62;

  const unsigned int parser::yyuser_token_number_max_ = 303;
  const parser::token_number_type parser::yyundef_token_ = 2;

} // namespace yy

#line 918 "parser.yy"


void
yy::parser::error (const yy::parser::location_type& l,
		   const string& m)
{
  interp.error(l, m);
}

static void mangle_fname(string& name)
{
  size_t pos = name.find("::");
  while (pos != string::npos) {
    name.replace(pos, 2, "/");
    pos = name.find("::", pos);
  }
  name += ".pure";
}

