/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.zutubi.pulse.license.LicenseAnnotationAttributes;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.web.wizard.WizardAction;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicensedInterceptor
implements Interceptor {
    private static final String DEFAULT_MESSAGE = "no.message.found";

    public void init() {
    }

    public void destroy() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object target = invocation.getAction();
        if (target instanceof WizardAction) {
            target = ((WizardAction)((Object)target)).getWizard();
        }
        LicenseAnnotationAttributes attributes = new LicenseAnnotationAttributes();
        Collection<String> instanceAttribs = attributes.getAttributes(target.getClass());
        String methodName = invocation.getProxy().getMethod();
        Method method = null;
        try {
            method = target.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                method = target.getClass().getMethod(this.doXxxMethodName(methodName), new Class[0]);
            }
            catch (NoSuchMethodException nsme2) {
                // empty catch block
            }
        }
        if (method != null) {
            instanceAttribs.addAll(attributes.getAttributes(method));
        }
        if (!this.checkAuthorised(instanceAttribs)) {
            ((ValidationAware)target).addActionError(this.getTextMessage("not.licensed"));
            return "notlicensed";
        }
        return invocation.invoke();
    }

    private boolean checkAuthorised(Collection<String> attribs) throws LicenseException {
        for (String attrib : attribs) {
            if (LicenseHolder.hasAuthorization(attrib)) continue;
            return false;
        }
        return true;
    }

    private String doXxxMethodName(String methodName) {
        return "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    private String getTextMessage(String messageKey) {
        return this.getTextMessage(messageKey, new Object[0]);
    }

    private String getTextMessage(String messageKey, Object[] args) {
        return this.getTextMessage(messageKey, args, ActionContext.getContext().getLocale());
    }

    private String getTextMessage(String messageKey, Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale);
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
    }
}

