/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.wizard;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.wizard.Wizard;
import com.zutubi.pulse.web.wizard.WizardState;
import com.zutubi.pulse.xwork.TextProviderSupport;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class WizardAction
extends ActionSupport {
    private static final Logger LOG = Logger.getLogger(WizardAction.class);
    private String wizardClass;
    private Wizard wizard;
    private String cancel;
    private String next;
    private String previous;
    private String finish;
    private String submit;
    private transient TextProvider textProvider = null;
    private ObjectFactory objectFactory;
    private boolean requiresInitialisation = false;

    public boolean isInitialised() {
        return !this.requiresInitialisation;
    }

    public void setWizardClass(String wizardClass) {
        this.wizardClass = wizardClass;
    }

    public void setCancel(String str) {
        this.cancel = str;
    }

    public void setPrevious(String previous) {
        this.previous = previous;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public boolean isCancelSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("cancel");
        }
        return TextUtils.stringSet((String)this.cancel);
    }

    public boolean isPreviousSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("previous");
        }
        return TextUtils.stringSet((String)this.previous);
    }

    public boolean isNextSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("next");
        }
        return TextUtils.stringSet((String)this.next);
    }

    public boolean isFinishSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("finish");
        }
        return TextUtils.stringSet((String)this.finish);
    }

    public void validate() {
        if (!TextUtils.stringSet((String)this.wizardClass)) {
            this.addActionError("Please specify a wizard class parameter in the xwork.xml action mapping.");
        }
        if (this.isNextSelected() || this.isFinishSelected()) {
            this.getWizard().validate();
        }
    }

    private void initIfRequired() {
        if (this.wizard == null) {
            this.getWizard();
        }
        if (this.requiresInitialisation) {
            this.wizard.initialise();
            this.requiresInitialisation = false;
        }
    }

    public String doInput() {
        try {
            this.initIfRequired();
            return this.getCurrentView();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return "error";
        }
    }

    public String doPrevious() {
        try {
            this.initIfRequired();
            return this.wizard.traverseBackward();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return "error";
        }
    }

    public String doNext() {
        try {
            this.initIfRequired();
            if (this.wizard.hasErrors()) {
                return this.getCurrentView();
            }
            String nextView = this.wizard.traverseForward();
            if (this.wizard.isComplete()) {
                this.removeWizard();
            }
            return nextView;
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return "error";
        }
    }

    public String doCancel() {
        try {
            this.initIfRequired();
            this.getWizard().cancel();
            this.removeWizard();
            return "cancel";
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return "error";
        }
    }

    public String execute() {
        try {
            this.initIfRequired();
            if (this.isCancelSelected()) {
                return this.doCancel();
            }
            if (this.isPreviousSelected()) {
                return this.doPrevious();
            }
            if (this.isNextSelected() || this.isFinishSelected()) {
                return this.doNext();
            }
            return this.getCurrentView();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return "error";
        }
    }

    private void removeWizard() {
        Map session = ActionContext.getContext().getSession();
        session.remove(this.wizardClass);
    }

    private void handleException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        this.addActionError("Unexpected exception: " + e.getClass().getName() + ", " + e.getMessage());
        this.removeWizard();
    }

    public Wizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        try {
            Map session = ActionContext.getContext().getSession();
            if (!session.containsKey(this.wizardClass)) {
                Wizard wizardInstance = (Wizard)this.objectFactory.buildBean(this.wizardClass);
                wizardInstance.setLocaleProvider((LocaleProvider)this);
                this.requiresInitialisation = true;
                session.put(this.wizardClass, wizardInstance);
            }
            this.wizard = (Wizard)session.get(this.wizardClass);
            return this.wizard;
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
            return null;
        }
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public WizardState getCurrentState() {
        return this.getWizard().getCurrentState();
    }

    public String getCurrentView() {
        return this.getWizard().getCurrentState().getView();
    }

    public String getState() {
        return this.getWizard().getCurrentState().getStateName();
    }

    private TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = new TextProviderSupport(this.getWizard().getClass(), (LocaleProvider)this);
        }
        return this.textProvider;
    }

    public String getText(String aTextName) {
        return this.getTextProvider().getText(aTextName);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.getTextProvider().getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, List args) {
        return this.getTextProvider().getText(aTextName, args);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        return this.getTextProvider().getText(aTextName, defaultValue, args);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.getTextProvider().getTexts(aBundleName);
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    public void clearErrors() {
        WizardState currentState = this.getCurrentState();
        if (currentState != null) {
            this.getWizard().clearErrors();
        }
    }
}

