/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.vfs;

import com.zutubi.pulse.util.logging.Logger;
import java.text.Collator;
import java.util.Comparator;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryComparator
implements Comparator<FileObject> {
    private static final Logger LOG = Logger.getLogger(DirectoryComparator.class);
    private Collator c = Collator.getInstance();

    @Override
    public int compare(FileObject o1, FileObject o2) {
        try {
            FileType t1 = o1.getType();
            FileType t2 = o2.getType();
            if ((t1 == FileType.FOLDER || t1 == FileType.IMAGINARY) && t2 != FileType.FOLDER && t2 != FileType.IMAGINARY) {
                return -1;
            }
            if ((t2 == FileType.FOLDER || t2 == FileType.IMAGINARY) && t1 != FileType.FOLDER && t1 != FileType.IMAGINARY) {
                return 1;
            }
            return this.c.compare(o1.getName().getPath(), o2.getName().getPath());
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }
}

