/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user.contact;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.form.MessagesTextProvider;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.ui.FormSupport;
import com.zutubi.pulse.web.ActionSupport;
import com.zutubi.validation.DelegatingValidationContext;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationAware;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationManager;
import com.zutubi.validation.XWorkValidationAdapter;
import com.zutubi.validation.i18n.TextProvider;
import freemarker.template.Configuration;

public abstract class FormAction
extends ActionSupport
implements Validateable {
    private String cancel;
    private String save;
    private String reset;
    private String submit;
    protected ValidationManager validationManager;
    private Configuration configuration;
    private DescriptorFactory descriptorFactory;
    private Object state;

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public void setSave(String save) {
        this.save = save;
    }

    public void setReset(String reset) {
        this.reset = reset;
    }

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public boolean isCancelSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("cancel");
        }
        return TextUtils.stringSet((String)this.cancel);
    }

    public boolean isSaveSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("save");
        }
        return TextUtils.stringSet((String)this.save);
    }

    public boolean isResetSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("reset");
        }
        return TextUtils.stringSet((String)this.reset);
    }

    public void validate(ValidationContext context) {
    }

    protected boolean isSubmitted() {
        return this.isCancelSelected() || this.isSaveSelected() || this.isResetSelected();
    }

    protected FormSupport createFormSupport(Object subject) {
        FormSupport support = new FormSupport();
        support.setConfiguration(this.configuration);
        support.setDescriptorFactory(this.descriptorFactory);
        support.setTextProvider(new MessagesTextProvider(subject));
        return support;
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    public void setFreemarkerConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public Object getState() {
        return this.state;
    }

    public String execute() throws Exception {
        this.state = this.doLoad();
        if (!this.isSubmitted()) {
            return "input";
        }
        if (this.isCancelSelected()) {
            return "cancel";
        }
        if (this.isResetSelected()) {
            return "input";
        }
        com.zutubi.pulse.validation.MessagesTextProvider textProvider = new com.zutubi.pulse.validation.MessagesTextProvider(this.state);
        DelegatingValidationContext ctx = new DelegatingValidationContext((ValidationAware)new XWorkValidationAdapter((com.opensymphony.xwork.ValidationAware)this), (TextProvider)textProvider);
        FormSupport formsupport = this.createFormSupport(this.state);
        formsupport.populateObject(this.state);
        this.validationManager.validate(this.state, (ValidationContext)ctx);
        if (this.hasErrors()) {
            return "input";
        }
        this.validate((ValidationContext)ctx);
        if (this.hasErrors()) {
            return "input";
        }
        this.doSave(this.state);
        return "success";
    }

    public abstract Object doLoad();

    public abstract void doSave(Object var1);
}

