/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.opensymphony.xwork.TextProvider;
import com.zutubi.pulse.condition.NotifyConditionFactory;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.web.user.SubscriptionHelper;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubscriptionActionSupport
extends UserActionSupport {
    protected long id;
    protected long contactPointId;
    protected Map<Long, String> contactPoints;
    protected boolean personal;
    protected User user;
    protected ContactPoint contactPoint;
    protected String template;
    protected SubscriptionHelper helper;
    private NotifyConditionFactory notifyConditionFactory;
    private BuildResultRenderer buildResultRenderer;

    protected SubscriptionActionSupport(boolean personal) {
        this.personal = personal;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getContactPointId() {
        return this.contactPointId;
    }

    public void setContactPointId(long contactPointId) {
        this.contactPointId = contactPointId;
    }

    public Map<Long, String> getContactPoints() {
        if (this.contactPoints == null) {
            this.contactPoints = new LinkedHashMap<Long, String>();
            List<ContactPoint> contactPoints = this.user.getContactPoints();
            Collections.sort(contactPoints, new NamedEntityComparator());
            for (ContactPoint contact : contactPoints) {
                this.contactPoints.put(contact.getId(), contact.getName());
            }
        }
        return this.contactPoints;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Map<String, String> getAvailableTemplates() {
        return this.helper.getAvailableTemplates();
    }

    public String doInput() throws Exception {
        this.user = this.getUser();
        if (this.user == null) {
            this.addUnknownUserActionError();
            return "error";
        }
        Subscription s = this.lookupSubscription();
        if (this.hasErrors()) {
            return "error";
        }
        this.contactPoint = s.getContactPoint();
        this.createHelper();
        return "input";
    }

    protected void createHelper() {
        this.helper = new SubscriptionHelper(this.personal, this.user, this.contactPoint, this.projectManager, this.notifyConditionFactory, (TextProvider)this, this.buildResultRenderer);
    }

    protected boolean lookupUser() {
        this.user = this.getUser();
        if (this.user == null) {
            this.addUnknownUserActionError();
            return true;
        }
        return false;
    }

    protected abstract Subscription lookupSubscription();

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        this.contactPoint = this.user.getContactPoint(this.contactPointId);
        if (this.contactPoint == null) {
            this.addFieldError("contactPointId", "Unknown contact point '" + this.contactPointId + "' for user '" + this.user.getName() + "'");
        }
    }

    public void setNotifyConditionFactory(NotifyConditionFactory notifyConditionFactory) {
        this.notifyConditionFactory = notifyConditionFactory;
    }

    public void setBuildResultRenderer(BuildResultRenderer buildResultRenderer) {
        this.buildResultRenderer = buildResultRenderer;
    }
}

