/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUserSettingsAction
extends UserActionSupport {
    private List<String> defaultActions;
    private String defaultAction;
    private int myBuildsCount;
    private boolean refreshEnabled = false;
    private int refreshInterval;
    private int tailLines;
    private int tailInterval;

    public List<String> getDefaultActions() {
        if (this.defaultActions == null) {
            this.defaultActions = new LinkedList<String>();
            this.defaultActions.add("dashboard");
            this.defaultActions.add("welcome");
            this.defaultActions.add("projects");
        }
        return this.defaultActions;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public int getMyBuildsCount() {
        return this.myBuildsCount;
    }

    public void setMyBuildsCount(int myBuildsCount) {
        this.myBuildsCount = myBuildsCount;
    }

    public boolean getRefreshEnabled() {
        return this.refreshEnabled;
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        this.refreshEnabled = refreshEnabled;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getTailLines() {
        return this.tailLines;
    }

    public void setTailLines(int tailLines) {
        this.tailLines = tailLines;
    }

    public int getTailInterval() {
        return this.tailInterval;
    }

    public void setTailInterval(int tailInterval) {
        this.tailInterval = tailInterval;
    }

    public String doInput() throws Exception {
        User user = this.getUser();
        this.refreshInterval = user.getRefreshInterval();
        boolean bl = this.refreshEnabled = this.refreshInterval != User.REFRESH_DISABLED;
        if (!this.refreshEnabled) {
            this.refreshInterval = 60;
        }
        this.tailLines = user.getTailLines();
        this.tailInterval = user.getTailRefreshInterval();
        this.defaultAction = user.getDefaultAction();
        this.myBuildsCount = user.getMyBuildsCount();
        return super.doInput();
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (this.refreshEnabled && this.refreshInterval <= 0) {
            this.addFieldError("refreshInterval", "refresh interval must be a positive number");
        }
    }

    public String execute() throws Exception {
        User persistentUser = super.getUser();
        if (this.refreshEnabled) {
            persistentUser.setRefreshInterval(this.refreshInterval);
        } else {
            persistentUser.setRefreshInterval(User.REFRESH_DISABLED);
        }
        persistentUser.setTailLines(this.tailLines);
        persistentUser.setTailRefreshInterval(this.tailInterval);
        persistentUser.setDefaultAction(this.defaultAction);
        persistentUser.setMyBuildsCount(this.myBuildsCount);
        this.getUserManager().save(persistentUser);
        return "success";
    }
}

