/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.web.project.ProjectFormHelper;
import com.zutubi.pulse.web.project.ProjectGroupFormHelper;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureDashboardAction
extends UserActionSupport {
    private int buildCount;
    private Map<Long, String> allProjects;
    private boolean showAllProjects;
    private List<Long> projects;
    private Map<Long, String> allGroups;
    private List<Long> shownGroups;
    private boolean showMyChanges = false;
    private boolean showProjectChanges = false;
    private BuildManager buildManager;
    private ProjectFormHelper projectHelper;
    private ProjectGroupFormHelper groupHelper;

    public int getBuildCount() {
        return this.buildCount;
    }

    public void setBuildCount(int buildCount) {
        this.buildCount = buildCount;
    }

    public boolean isShowMyChanges() {
        return this.showMyChanges;
    }

    public void setShowMyChanges(boolean showMyChanges) {
        this.showMyChanges = showMyChanges;
    }

    public boolean isShowProjectChanges() {
        return this.showProjectChanges;
    }

    public void setShowProjectChanges(boolean showProjectChanges) {
        this.showProjectChanges = showProjectChanges;
    }

    public Map<Long, String> getAllProjects() {
        if (this.allProjects == null) {
            this.allProjects = this.getProjectHelper().getAllEntities();
        }
        return this.allProjects;
    }

    public boolean isShowAllProjects() {
        return this.showAllProjects;
    }

    public void setShowAllProjects(boolean showAllProjects) {
        this.showAllProjects = showAllProjects;
    }

    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public Map<Long, String> getAllGroups() {
        if (this.allGroups == null) {
            this.allGroups = this.getGroupHelper().getAllEntities();
        }
        return this.allGroups;
    }

    public List<Long> getShownGroups() {
        return this.shownGroups;
    }

    public void setShownGroups(List<Long> shownGroups) {
        this.shownGroups = shownGroups;
    }

    public String doInput() throws Exception {
        String login = AcegiUtils.getLoggedInUser();
        if (login == null) {
            return "error";
        }
        this.setUserLogin(login);
        User user = this.getUser();
        if (user == null) {
            this.addUnknownUserActionError();
            return "error";
        }
        this.buildCount = user.getDashboardBuildCount();
        this.showAllProjects = user.getShowAllProjects();
        this.projects = this.getProjectHelper().convertToIds(user.getShownProjects());
        this.shownGroups = this.getGroupHelper().convertToIds(user.getShownGroups());
        this.showMyChanges = user.getShowMyChanges();
        this.showProjectChanges = user.getShowProjectChanges();
        return super.doInput();
    }

    public String execute() throws Exception {
        String login = AcegiUtils.getLoggedInUser();
        if (login == null) {
            return "error";
        }
        this.setUserLogin(login);
        User user = this.getUser();
        this.buildManager.cleanupBuilds(user);
        user.setDashboardBuildCount(this.buildCount);
        user.setShowAllProjects(this.showAllProjects);
        if (this.showAllProjects) {
            user.getShownProjects().clear();
        } else {
            this.getProjectHelper().convertFromIds(this.projects, user.getShownProjects());
        }
        this.getGroupHelper().convertFromIds(this.shownGroups, user.getShownGroups());
        user.setShowMyChanges(this.showMyChanges);
        user.setShowProjectChanges(this.showProjectChanges);
        this.getUserManager().save(user);
        return "success";
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public ProjectFormHelper getProjectHelper() {
        if (this.projectHelper == null) {
            this.projectHelper = new ProjectFormHelper(this.projectManager);
        }
        return this.projectHelper;
    }

    public ProjectGroupFormHelper getGroupHelper() {
        if (this.groupHelper == null) {
            this.groupHelper = new ProjectGroupFormHelper(this.projectManager);
        }
        return this.groupHelper;
    }
}

