/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.setup;

import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseDecoder;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.web.setup.SetupActionSupport;

public class SetupLicenseAction
extends SetupActionSupport {
    private LicenseManager licenseManager;
    private String license;

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void validate() {
        String licenseKey = this.license.replaceAll("\n", "");
        LicenseDecoder decoder = new LicenseDecoder();
        try {
            License l = decoder.decode(licenseKey.getBytes());
            if (l == null) {
                this.addFieldError("license", this.getText("license.key.invalid"));
                return;
            }
            if (l.isExpired()) {
                this.addFieldError("license", this.getText("license.key.expired"));
            }
        }
        catch (LicenseException e) {
            this.addFieldError("license", this.getText("license.decode.error"));
        }
    }

    public String execute() throws Exception {
        String licenseKey = this.license.replaceAll("\n", "");
        this.licenseManager.installLicense(licenseKey);
        this.setupManager.requestLicenseComplete();
        return "success";
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

