/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.server;

import com.zutubi.pulse.FatController;
import com.zutubi.pulse.RecipeDispatchRequest;
import com.zutubi.pulse.RecipeQueue;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.web.ActionSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewServerQueuesAction
extends ActionSupport {
    private List<AbstractBuildRequestEvent> buildQueue;
    private List<BuildResult> executingBuilds;
    private List<RecipeDispatchRequest> recipeQueueSnapshot;
    private FatController fatController;
    private RecipeQueue recipeQueue;
    private BuildManager buildManager;
    private UserManager userManager;

    public List<AbstractBuildRequestEvent> getBuildQueue() {
        return this.buildQueue;
    }

    public List<BuildResult> getExecutingBuilds() {
        return this.executingBuilds;
    }

    public boolean getRecipeQueueRunning() {
        return this.recipeQueue.isRunning();
    }

    public List<RecipeDispatchRequest> getRecipeQueueSnapshot() {
        return this.recipeQueueSnapshot;
    }

    public boolean canCancel(BuildResult build) {
        Object principle = this.getPrinciple();
        if (principle != null && principle instanceof String) {
            return this.buildManager.canCancel(build, this.userManager.getUser((String)principle));
        }
        return false;
    }

    public String execute() throws Exception {
        this.recipeQueueSnapshot = this.recipeQueue.takeSnapshot();
        this.buildQueue = new LinkedList<AbstractBuildRequestEvent>();
        this.executingBuilds = new LinkedList<BuildResult>();
        Map<Entity, List<AbstractBuildRequestEvent>> builds = this.fatController.snapshotBuildQueue();
        for (Entity entity : builds.keySet()) {
            List<AbstractBuildRequestEvent> events = builds.get(entity);
            if (events.size() <= 0) continue;
            AbstractBuildRequestEvent active = events.get(0);
            BuildResult result = active.isPersonal() ? this.buildManager.getLatestBuildResult((User)active.getOwner()) : this.buildManager.getLatestBuildResult((Project)active.getOwner());
            if (result != null && !result.completed()) {
                this.executingBuilds.add(result);
            }
            if (events.size() <= 1) continue;
            this.buildQueue.addAll(events.subList(1, events.size()));
        }
        Collections.sort(this.buildQueue, new Comparator<AbstractBuildRequestEvent>(){

            @Override
            public int compare(AbstractBuildRequestEvent o1, AbstractBuildRequestEvent o2) {
                return (int)(o1.getQueued() - o2.getQueued());
            }
        });
        Collections.sort(this.executingBuilds, new Comparator<BuildResult>(){

            @Override
            public int compare(BuildResult o1, BuildResult o2) {
                return (int)(o1.getStamps().getStartTime() - o2.getStamps().getEndTime());
            }
        });
        return "success";
    }

    public void setFatController(FatController fatController) {
        this.fatController = fatController;
    }

    public void setRecipeQueue(RecipeQueue queue) {
        this.recipeQueue = queue;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

